/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.reactnative;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.AsyncProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.javascript.debugger.DebuggableFileFinder;
import com.intellij.javascript.debugger.RemoteDebuggingFileFinder;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.Url;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.debugger.wip.ChromeDebugProcess;
import com.jetbrains.debugger.wip.ChromeLocalVmConnection;
import com.jetbrains.debugger.wip.HttpInetSocketAddress;
import com.jetbrains.debugger.wip.WipMonitoringConnection;
import com.jetbrains.plugins.reactnative.PackagerState;
import com.jetbrains.plugins.reactnative.ReactNativeDebuggerBundle;
import com.jetbrains.plugins.reactnative.ReactNativePackagerKt;
import com.jetbrains.plugins.reactnative.ReactNativePlatform;
import com.jetbrains.plugins.reactnative.ReactNativeProgramRunner;
import com.jetbrains.plugins.reactnative.ReactNativeProgramRunnerKt;
import com.jetbrains.plugins.reactnative.ReactNativeRunConfiguration;
import java.net.InetSocketAddress;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.connection.RemoteVmConnection;
import org.jetbrains.debugger.connection.VmConnection;
import org.jetbrains.wip.WipVm;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u001c2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u001e0\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u001f\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010 \u001a\u0004\u0018\u00010\u00062\u0006\u0010!\u001a\u00020\u0006H\u0002\u00a8\u0006\""}, d2={"Lcom/jetbrains/plugins/reactnative/ReactNativeProgramRunner;", "Lcom/intellij/execution/runners/AsyncProgramRunner;", "Lcom/intellij/execution/configurations/RunnerSettings;", "<init>", "()V", "getRunnerId", "", "canRun", "", "executorId", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "execute", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/execution/ui/RunContentDescriptor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "state", "Lcom/intellij/execution/configurations/RunProfileState;", "runReactNative", "", "configuration", "Lcom/jetbrains/plugins/reactnative/ReactNativeRunConfiguration;", "packagerProcess", "Lcom/intellij/execution/process/ProcessHandler;", "createRunProcess", "Lcom/intellij/execution/process/KillableColoredProcessHandler;", "startDebugProcess", "Ljava/util/concurrent/CompletableFuture;", "enableDebuggingMode", "", "resolveAndroidPackageName", "resolveAndroidPackageNameInManifest", "projectPath", "intellij.javascript.reactNativeDebugger"})
public final class ReactNativeProgramRunner
extends AsyncProgramRunner<RunnerSettings> {
    @NotNull
    public String getRunnerId() {
        return "reactNativeRunner";
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        Intrinsics.checkNotNullParameter((Object)executorId, (String)"executorId");
        Intrinsics.checkNotNullParameter((Object)profile, (String)"profile");
        return profile instanceof ReactNativeRunConfiguration && (Intrinsics.areEqual((Object)executorId, (Object)"Run") || Intrinsics.areEqual((Object)executorId, (Object)"Debug"));
    }

    @NotNull
    protected Promise<RunContentDescriptor> execute(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        FileDocumentManager.getInstance().saveAllDocuments();
        RunProfile runProfile = environment.getRunProfile();
        Intrinsics.checkNotNull((Object)runProfile, (String)"null cannot be cast to non-null type com.jetbrains.plugins.reactnative.ReactNativeRunConfiguration");
        ReactNativeRunConfiguration configuration = (ReactNativeRunConfiguration)runProfile;
        PackagerState startedPackager = ReactNativePackagerKt.findStartedPackager(configuration);
        CompletableFuture<Unit> packagerFuture = null;
        ProcessHandler packagerProcess = null;
        if (startedPackager != null) {
            packagerFuture = startedPackager.getReady();
            packagerProcess = startedPackager.getProcess();
        } else {
            packagerFuture = CompletableFuture.completedFuture(Unit.INSTANCE);
            packagerProcess = null;
        }
        boolean isRun = Intrinsics.areEqual((Object)environment.getExecutor().getId(), (Object)"Run");
        AsyncPromise result = new AsyncPromise();
        ((CompletableFuture)packagerFuture.thenCompose(arg_0 -> ReactNativeProgramRunner.execute$lambda$3(arg_0 -> ReactNativeProgramRunner.execute$lambda$2(isRun, configuration, this, environment, packagerProcess, arg_0), arg_0))).handle((arg_0, arg_1) -> ReactNativeProgramRunner.execute$lambda$5((arg_0, arg_1) -> ReactNativeProgramRunner.execute$lambda$4(result, arg_0, arg_1), arg_0, arg_1));
        return (Promise)result;
    }

    private final void runReactNative(ExecutionEnvironment environment, ReactNativeRunConfiguration configuration, ProcessHandler packagerProcess) {
        KillableColoredProcessHandler runHandler = this.createRunProcess(configuration, environment);
        ConsoleView consoleView = ReactNativeProgramRunnerKt.showHelperProcessRunContent("react-native " + configuration.getPlatform().getCommandLineArgument(), (ProcessHandler)runHandler, environment);
        if (packagerProcess != null && !configuration.isHermesEngine()) {
            AtomicBoolean packagerStartedDebug = new AtomicBoolean(false);
            ProcessAdapter startDebuggerListener = null;
            startDebuggerListener = new ProcessAdapter(packagerStartedDebug, packagerProcess, environment){
                final /* synthetic */ AtomicBoolean $packagerStartedDebug;
                final /* synthetic */ ProcessHandler $packagerProcess;
                final /* synthetic */ ExecutionEnvironment $environment;
                {
                    this.$packagerStartedDebug = $packagerStartedDebug;
                    this.$packagerProcess = $packagerProcess;
                    this.$environment = $environment;
                }

                public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                    String string = event.getText();
                    boolean bl = string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"Starting custom debugger by executing", (boolean)false, (int)2, null) : false;
                    if (bl) {
                        this.$packagerStartedDebug.set(true);
                        this.$packagerProcess.removeProcessListener((ProcessListener)this);
                        Project project = this.$environment.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                        Balloon balloon = ToolWindowManager.Companion.getInstance(project).getToolWindowBalloon("Debug");
                        if (balloon != null) {
                            ApplicationManager.getApplication().invokeLater(() -> runReactNative.1.onTextAvailable$lambda$0(balloon));
                        }
                    }
                }

                private static final void onTextAvailable$lambda$0(Balloon $balloon) {
                    $balloon.hide();
                }
            };
            packagerProcess.addProcessListener((ProcessListener)startDebuggerListener);
            Disposer.register((Disposable)((Disposable)consoleView), () -> ReactNativeProgramRunner.runReactNative$lambda$6(packagerProcess, startDebuggerListener));
            AtomicBoolean appLaunchedMessageReceived = new AtomicBoolean(false);
            runHandler.addProcessListener((ProcessListener)new ProcessAdapter(appLaunchedMessageReceived, packagerStartedDebug, this, configuration, packagerProcess, startDebuggerListener, environment){
                final /* synthetic */ AtomicBoolean $appLaunchedMessageReceived;
                final /* synthetic */ AtomicBoolean $packagerStartedDebug;
                final /* synthetic */ ReactNativeProgramRunner this$0;
                final /* synthetic */ ReactNativeRunConfiguration $configuration;
                final /* synthetic */ ProcessHandler $packagerProcess;
                final /* synthetic */ ProcessAdapter $startDebuggerListener;
                final /* synthetic */ ExecutionEnvironment $environment;
                {
                    this.$appLaunchedMessageReceived = $appLaunchedMessageReceived;
                    this.$packagerStartedDebug = $packagerStartedDebug;
                    this.this$0 = $receiver;
                    this.$configuration = $configuration;
                    this.$packagerProcess = $packagerProcess;
                    this.$startDebuggerListener = $startDebuggerListener;
                    this.$environment = $environment;
                }

                public void onTextAvailable(ProcessEvent event, Key<?> outputType) {
                    block4: {
                        block3: {
                            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                            Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                            String string = event.getText();
                            if (string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"Starting", (boolean)false, (int)2, null) : false) break block3;
                            String string2 = event.getText();
                            boolean bl = string2 != null ? StringsKt.contains$default((CharSequence)string2, (CharSequence)"Launching", (boolean)false, (int)2, null) : false;
                            if (!bl) break block4;
                        }
                        this.$appLaunchedMessageReceived.set(true);
                    }
                }

                public void processTerminated(ProcessEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> runReactNative.3.processTerminated$lambda$0(this.$packagerStartedDebug, this.this$0, this.$configuration), 500L, TimeUnit.MILLISECONDS);
                    String string = this.$appLaunchedMessageReceived.get() ? ReactNativeDebuggerBundle.message("react.native.runner.warning.connection.wait", new Object[0]) : ReactNativeDebuggerBundle.message("react.native.runner.warning.build.failed", new Object[0]);
                    Intrinsics.checkNotNull((Object)string);
                    String message = string;
                    runReactNative.3.processTerminated$scheduleWarning(this.$packagerStartedDebug, this.$packagerProcess, this.$startDebuggerListener, this.$environment, message, 5L);
                }

                private static final void processTerminated$lambda$0(AtomicBoolean $packagerStartedDebug, ReactNativeProgramRunner this$0, ReactNativeRunConfiguration $configuration) {
                    if (!$packagerStartedDebug.get()) {
                        ReactNativeProgramRunner.access$enableDebuggingMode(this$0, $configuration);
                    }
                }

                private static final void processTerminated$scheduleWarning$lambda$2$lambda$1(ExecutionEnvironment $environment, String $message) {
                    Project project = $environment.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                    ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project);
                    MessageType messageType = MessageType.WARNING;
                    Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"WARNING");
                    toolWindowManager.notifyByBalloon("Debug", messageType, $message);
                }

                private static final void processTerminated$scheduleWarning$lambda$2(AtomicBoolean $packagerStartedDebug, ProcessHandler $packagerProcess, ProcessAdapter $startDebuggerListener, ExecutionEnvironment $environment, String $message) {
                    if (!$packagerStartedDebug.get()) {
                        $packagerProcess.removeProcessListener((ProcessListener)$startDebuggerListener);
                        ApplicationManager.getApplication().invokeLater(() -> runReactNative.3.processTerminated$scheduleWarning$lambda$2$lambda$1($environment, $message));
                    }
                }

                private static final void processTerminated$scheduleWarning(AtomicBoolean packagerStartedDebug, ProcessHandler $packagerProcess, ProcessAdapter startDebuggerListener, ExecutionEnvironment $environment, String message, long timeoutSec) {
                    AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> runReactNative.3.processTerminated$scheduleWarning$lambda$2(packagerStartedDebug, $packagerProcess, startDebuggerListener, $environment, message), timeoutSec, TimeUnit.SECONDS);
                }
            });
        }
        runHandler.startNotify();
    }

    private final KillableColoredProcessHandler createRunProcess(ReactNativeRunConfiguration configuration, ExecutionEnvironment environment) {
        GeneralCommandLine runCommandLine = new GeneralCommandLine();
        NodeJsInterpreter nodeJsInterpreter = configuration.getNodePath().resolveNotNull(environment.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)nodeJsInterpreter, (String)"resolveNotNull(...)");
        NodeJsInterpreter interpreter = nodeJsInterpreter;
        NodePackage nodePackage = configuration.getReactNativePackage();
        if (nodePackage == null) {
            throw new ConfigurationException(ReactNativeDebuggerBundle.message("react.native.error.invalid.react.native.path", new Object[0]));
        }
        NodePackage reactNativePackage = nodePackage;
        runCommandLine.addParameter(ReactNativeProgramRunnerKt.reactNativePackageToNodeArgument(reactNativePackage));
        runCommandLine.addParameter(configuration.getPlatform().getCommandLineArgument());
        runCommandLine.getParametersList().addParametersString(configuration.getRunArguments());
        runCommandLine.withWorkDirectory(configuration.getEffectiveWorkingDirectory());
        configuration.getEnvData().configureCommandLine(runCommandLine, true);
        NodeCommandLineUtil.configureUsefulEnvironment((GeneralCommandLine)runCommandLine);
        NodeCommandLineConfigurator.find((NodeJsInterpreter)interpreter).configure(runCommandLine);
        return new KillableColoredProcessHandler(runCommandLine);
    }

    private final CompletableFuture<RunContentDescriptor> startDebugProcess(ReactNativeRunConfiguration configuration, ExecutionEnvironment environment) {
        CompletableFuture<RunContentDescriptor> result = new CompletableFuture<RunContentDescriptor>();
        AppUIUtil.invokeOnEdt(() -> ReactNativeProgramRunner.startDebugProcess$lambda$7(environment, result, configuration));
        return result;
    }

    private final Promise<Object> enableDebuggingMode(ReactNativeRunConfiguration configuration) {
        if (configuration.getPlatform() != ReactNativePlatform.ANDROID) {
            return Promises.resolvedPromise();
        }
        String packageName = this.resolveAndroidPackageName(configuration);
        GeneralCommandLine runCommandLine = new GeneralCommandLine();
        runCommandLine.setExePath("adb");
        String[] stringArray = new String[]{"shell", "am", "broadcast", "-a", packageName + ".RELOAD_APP_ACTION", "--ez", "jsproxy", "true"};
        runCommandLine.addParameters(stringArray);
        AsyncPromise result = new AsyncPromise();
        KillableProcessHandler adbProcessHandler = new KillableProcessHandler(runCommandLine);
        adbProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter((AsyncPromise<Object>)result){
            final /* synthetic */ AsyncPromise<Object> $result;
            {
                this.$result = $result;
            }

            public void processTerminated(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.$result.setResult(null);
            }
        });
        adbProcessHandler.startNotify();
        return (Promise)result;
    }

    private final String resolveAndroidPackageName(ReactNativeRunConfiguration configuration) {
        String effectiveWorkingDirectory = configuration.getEffectiveWorkingDirectory();
        String valueInAndroidXml = this.resolveAndroidPackageNameInManifest(effectiveWorkingDirectory);
        if (valueInAndroidXml != null) {
            return valueInAndroidXml;
        }
        String string = PathUtil.getFileName((String)effectiveWorkingDirectory);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
        String defaultName = string;
        String string2 = "com." + defaultName;
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string3 = string2.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        return string3;
    }

    private final String resolveAndroidPackageNameInManifest(String projectPath) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(projectPath);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile workingDir = virtualFile;
        VirtualFile virtualFile2 = workingDir.findFileByRelativePath("android/app/src/main/AndroidManifest.xml");
        if (virtualFile2 == null) {
            return null;
        }
        VirtualFile manifestFile = virtualFile2;
        String string = VfsUtil.loadText((VirtualFile)manifestFile);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadText(...)");
        String text = string;
        Matcher matcher = Pattern.compile("package=\"([^\"\\n]+)\"").matcher(text);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private static final void execute$lambda$2$lambda$0(ReactNativeProgramRunner this$0, ExecutionEnvironment $environment, ReactNativeRunConfiguration $configuration, ProcessHandler $packagerProcess) {
        this$0.runReactNative($environment, $configuration, $packagerProcess);
    }

    private static final void execute$lambda$2$lambda$1(ReactNativeProgramRunner this$0, ReactNativeRunConfiguration $configuration, ExecutionEnvironment $environment, CompletableFuture $runContentFuture) {
        KillableColoredProcessHandler runHandler = this$0.createRunProcess($configuration, $environment);
        Project project = $environment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ConsoleViewImpl consoleView = new ConsoleViewImpl(project, false);
        consoleView.attachToProcess((ProcessHandler)runHandler);
        RunContentBuilder builder = new RunContentBuilder((ExecutionResult)new DefaultExecutionResult((ExecutionConsole)consoleView, (ProcessHandler)runHandler), $environment);
        $runContentFuture.complete(builder.showRunContent($environment.getContentToReuse()));
    }

    private static final CompletionStage execute$lambda$2(boolean $isRun, ReactNativeRunConfiguration $configuration, ReactNativeProgramRunner this$0, ExecutionEnvironment $environment, ProcessHandler $packagerProcess, Unit it) {
        if (!$isRun && $configuration.getBuildAndLaunch()) {
            ApplicationManager.getApplication().invokeLater(() -> ReactNativeProgramRunner.execute$lambda$2$lambda$0(this$0, $environment, $configuration, $packagerProcess));
        }
        if ($isRun) {
            if (!$configuration.getBuildAndLaunch()) {
                return CompletableFuture.completedFuture(null);
            }
            CompletableFuture runContentFuture = new CompletableFuture();
            ApplicationManager.getApplication().invokeLater(() -> ReactNativeProgramRunner.execute$lambda$2$lambda$1(this$0, $configuration, $environment, runContentFuture));
            return runContentFuture;
        }
        return this$0.startDebugProcess($configuration, $environment);
    }

    private static final CompletionStage execute$lambda$3(Function1 $tmp0, Object p0) {
        return (CompletionStage)$tmp0.invoke(p0);
    }

    private static final Object execute$lambda$4(AsyncPromise $result, RunContentDescriptor r, Throwable t) {
        Object object;
        Throwable throwable = t;
        if (throwable != null) {
            Object object2 = throwable.getCause();
            if (object2 == null || (object2 = ((Throwable)object2).getMessage()) == null) {
                object2 = "Failed to connect to bundler";
            }
            object = $result.setError((String)object2);
        } else {
            $result.setResult((Object)r);
            object = Unit.INSTANCE;
        }
        return object;
    }

    private static final Object execute$lambda$5(Function2 $tmp0, Object p0, Throwable p1) {
        return $tmp0.invoke(p0, (Object)p1);
    }

    private static final void runReactNative$lambda$6(ProcessHandler $packagerProcess, ProcessAdapter $startDebuggerListener) {
        $packagerProcess.removeProcessListener((ProcessListener)$startDebuggerListener);
    }

    private static final void startDebugProcess$lambda$7(ExecutionEnvironment $environment, CompletableFuture $result, ReactNativeRunConfiguration $configuration) {
        XDebugProcessStarter starter2 = new XDebugProcessStarter($configuration){
            final /* synthetic */ ReactNativeRunConfiguration $configuration;
            {
                this.$configuration = $configuration;
            }

            public XDebugProcess start(XDebugSession session) {
                Intrinsics.checkNotNullParameter((Object)session, (String)"session");
                DefaultExecutionResult executionResult = new DefaultExecutionResult();
                if (this.$configuration.isHermesEngine()) {
                    HttpInetSocketAddress address = new HttpInetSocketAddress(this.$configuration.getPackagerHost(), this.$configuration.getPackagerPort());
                    WipMonitoringConnection connection2 = new WipMonitoringConnection();
                    ChromeDebugProcess process = new ChromeDebugProcess(session, (DebuggableFileFinder)new RemoteDebuggingFileFinder(null, null, 3, null), (VmConnection<? extends WipVm>)((VmConnection)connection2), (ExecutionResult)executionResult);
                    RemoteVmConnection.open$default((RemoteVmConnection)connection2, (InetSocketAddress)address, null, (int)2, null);
                    return (XDebugProcess)process;
                }
                Url debugUrl = ReactNativeProgramRunnerKt.chromeDebugUrl(this.$configuration.getPackagerHost(), this.$configuration.getPackagerPort());
                ChromeLocalVmConnection connection3 = new ChromeLocalVmConnection(debugUrl, true, this.$configuration.getBrowser(), session);
                ChromeDebugProcess process = new ChromeDebugProcess(session, (DebuggableFileFinder)new RemoteDebuggingFileFinder(null, null, 3, null), (VmConnection<? extends WipVm>)((VmConnection)connection3), (ExecutionResult)executionResult);
                connection3.connect();
                return (XDebugProcess)process;
            }
        };
        try {
            XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)$environment.getProject()).startSession($environment, starter2);
            Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"startSession(...)");
            XDebugSession startSession = xDebugSession;
            $result.complete(startSession.getRunContentDescriptor());
        }
        catch (Throwable e) {
            $result.completeExceptionally(e);
            throw e;
        }
    }

    public static final /* synthetic */ Promise access$enableDebuggingMode(ReactNativeProgramRunner $this, ReactNativeRunConfiguration configuration) {
        return $this.enableDebuggingMode(configuration);
    }
}

