/*
 * Decompiled with CFR 0.152.
 */
package git4idea.remote;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.fetch.GitFetchSupport;
import git4idea.i18n.GitBundle;
import git4idea.remote.GitConfigureRemotesDialog;
import git4idea.remote.GitConfigureRemotesDialogKt;
import git4idea.remote.GitDefineRemoteDialog;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0000\u001a4\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f\u001a.\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\n2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f\u001a \u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u001a\u0012\u0010\u0016\u001a\u00020\u0011*\b\u0012\u0004\u0012\u00020\n0\tH\u0002\u001a8\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u0011H\u0002\u001ab\u0010\u001e\u001a\u00020\u00032\b\b\u0001\u0010\u001f\u001a\u00020\u00112\b\b\u0001\u0010 \u001a\u00020\u00112\b\b\u0001\u0010!\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f2\u0014\u0010#\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0018\u0018\u00010$0\fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0013\u001a\u00020\u0011*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006%"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "removeRemotes", "", "git", "Lgit4idea/commands/Git;", "repository", "Lgit4idea/repo/GitRepository;", "remotes", "", "Lgit4idea/repo/GitRemote;", "onSuccess", "Lkotlin/Function0;", "editRemote", "remote", "doFetch", "remoteName", "", "remoteUrl", "url", "getUrl", "(Lgit4idea/repo/GitRemote;)Ljava/lang/String;", "toStringRepresentation", "changeRemote", "Lgit4idea/commands/GitCommandResult;", "repo", "oldName", "oldUrl", "newName", "newUrl", "runInModalTask", "title", "errorTitle", "errorMessage", "afterRepoRefresh", "operation", "", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitConfigureRemotesDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitConfigureRemotesDialog.kt\ngit4idea/remote/GitConfigureRemotesDialogKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,332:1\n1#2:333\n1755#3,3:334\n15#4:337\n*S KotlinDebug\n*F\n+ 1 GitConfigureRemotesDialog.kt\ngit4idea/remote/GitConfigureRemotesDialogKt\n*L\n279#1:334,3\n38#1:337\n*E\n"})
public final class GitConfigureRemotesDialogKt {
    @NotNull
    private static final Logger LOG;

    public static final void removeRemotes(@NotNull Git git, @NotNull GitRepository repository, @NotNull Set<GitRemote> remotes, @NotNull Function0<Unit> onSuccess) {
        Intrinsics.checkNotNullParameter((Object)git, (String)"git");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter(remotes, (String)"remotes");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Object[] objectArray = new Object[]{remotes.size(), GitConfigureRemotesDialogKt.toStringRepresentation(remotes)};
        String string = GitBundle.message("remotes.dialog.remove.remote.message", objectArray);
        objectArray = new Object[]{remotes.size()};
        if (Messages.showYesNoDialog((Project)repository.getProject(), (String)string, (String)GitBundle.message("remotes.dialog.remove.remote.title", objectArray), (Icon)Messages.getQuestionIcon()) == 0) {
            Object[] objectArray2 = new Object[]{remotes.size()};
            String string2 = GitBundle.message("remotes.dialog.removing.remote.progress", objectArray2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            objectArray2 = new Object[]{remotes.size()};
            String string3 = GitBundle.message("remotes.dialog.removing.remote.error.title", objectArray2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            objectArray2 = new Object[]{remotes.size(), GitConfigureRemotesDialogKt.toStringRepresentation(remotes)};
            String string4 = GitBundle.message("remotes.dialog.removing.remote.error.message", objectArray2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
            GitConfigureRemotesDialogKt.runInModalTask$default(string2, string3, string4, repository, null, onSuccess, () -> GitConfigureRemotesDialogKt.removeRemotes$lambda$2(remotes, git, repository), 16, null);
        }
    }

    public static /* synthetic */ void removeRemotes$default(Git git, GitRepository gitRepository, Set set, Function0 function0, int n, Object object) {
        if ((n & 8) != 0) {
            function0 = GitConfigureRemotesDialogKt::removeRemotes$lambda$0;
        }
        GitConfigureRemotesDialogKt.removeRemotes(git, gitRepository, set, (Function0<Unit>)function0);
    }

    public static final void editRemote(@NotNull Git git, @NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull Function0<Unit> onSuccess) {
        Intrinsics.checkNotNullParameter((Object)git, (String)"git");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        String string = remote.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String oldName = string;
        String oldUrl = GitConfigureRemotesDialogKt.getUrl(remote);
        GitDefineRemoteDialog dialog = new GitDefineRemoteDialog(repository, git, oldName, oldUrl);
        if (dialog.showAndGet()) {
            String newRemoteName = dialog.getRemoteName();
            String newRemoteUrl = dialog.getRemoteUrl();
            if (Intrinsics.areEqual((Object)newRemoteName, (Object)oldName) && Intrinsics.areEqual((Object)newRemoteUrl, (Object)oldUrl)) {
                return;
            }
            String string2 = GitBundle.message("remotes.changing.remote.progress", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            String string3 = GitBundle.message("remotes.changing.remote.error.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            Object[] objectArray = new Object[]{oldName, newRemoteName, newRemoteUrl};
            String string4 = GitBundle.message("remotes.changing.remote.error.message", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
            GitConfigureRemotesDialogKt.runInModalTask(string2, string3, string4, repository, (Function0<Unit>)((Function0)() -> GitConfigureRemotesDialogKt.editRemote$lambda$4(dialog, repository, newRemoteName, newRemoteUrl)), onSuccess, (Function0<? extends List<? extends GitCommandResult>>)((Function0)() -> GitConfigureRemotesDialogKt.editRemote$lambda$6(git, repository, oldName, oldUrl, newRemoteName, newRemoteUrl)));
        }
    }

    public static /* synthetic */ void editRemote$default(Git git, GitRepository gitRepository, GitRemote gitRemote, Function0 function0, int n, Object object) {
        if ((n & 8) != 0) {
            function0 = GitConfigureRemotesDialogKt::editRemote$lambda$3;
        }
        GitConfigureRemotesDialogKt.editRemote(git, gitRepository, gitRemote, (Function0<Unit>)function0);
    }

    /*
     * Unable to fully structure code
     */
    private static final void doFetch(GitRepository repository, String remoteName, String remoteUrl) {
        block8: {
            v0 = repository.getRemotes();
            Intrinsics.checkNotNullExpressionValue(v0, (String)"getRemotes(...)");
            var4_3 = v0;
            for (T var6_5 : var4_3) {
                block7: {
                    remote = (GitRemote)var6_5;
                    $i$a$-find-GitConfigureRemotesDialogKt$doFetch$remoteToFetch$1 = false;
                    if (!Intrinsics.areEqual((Object)remote.getName(), (Object)remoteName)) ** GOTO lbl-1000
                    v1 = remote.getUrls();
                    Intrinsics.checkNotNullExpressionValue(v1, (String)"getUrls(...)");
                    $this$any$iv = v1;
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v2 = false;
                    } else {
                        for (T element$iv : $this$any$iv) {
                            url = (String)element$iv;
                            $i$a$-any-GitConfigureRemotesDialogKt$doFetch$remoteToFetch$1$1 = false;
                            if (!Intrinsics.areEqual((Object)url, (Object)remoteUrl)) continue;
                            v2 = true;
                            break block7;
                        }
                        v2 = false;
                    }
                }
                if (v2) {
                    v3 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v3 = false;
                }
                if (!v3) continue;
                v4 = var6_5;
                break block8;
            }
            v4 = null;
        }
        remoteToFetch = v4;
        if (remoteToFetch != null) {
            GitFetchSupport.fetchSupport(repository.getProject()).fetch(repository, remoteToFetch).showNotificationIfFailed();
        }
    }

    private static final String getUrl(GitRemote $this$url) {
        List<String> list = $this$url.getUrls();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getUrls(...)");
        String string = (String)CollectionsKt.firstOrNull(list);
        if (string == null) {
            string = "";
        }
        return string;
    }

    private static final String toStringRepresentation(Set<GitRemote> $this$toStringRepresentation) {
        String string;
        if ($this$toStringRepresentation.size() == 1) {
            GitRemote $this$toStringRepresentation_u24lambda_u249 = (GitRemote)CollectionsKt.first((Iterable)$this$toStringRepresentation);
            boolean bl = false;
            string = $this$toStringRepresentation_u24lambda_u249.getName() + " '" + GitConfigureRemotesDialogKt.getUrl($this$toStringRepresentation_u24lambda_u249) + "'";
        } else {
            string = "\n" + CollectionsKt.joinToString$default((Iterable)$this$toStringRepresentation, (CharSequence)"\n", null, null, (int)0, null, GitConfigureRemotesDialogKt::toStringRepresentation$lambda$10, (int)30, null);
        }
        return string;
    }

    private static final GitCommandResult changeRemote(Git git, GitRepository repo2, String oldName, String oldUrl, String newName, String newUrl) {
        GitCommandResult result2 = null;
        if (!Intrinsics.areEqual((Object)newName, (Object)oldName) && !(result2 = git.renameRemote(repo2, oldName, newName)).success()) {
            return result2;
        }
        if (!Intrinsics.areEqual((Object)newUrl, (Object)oldUrl)) {
            result2 = git.setRemoteUrl(repo2, newName, newUrl);
        }
        GitCommandResult gitCommandResult = result2;
        Intrinsics.checkNotNull((Object)gitCommandResult);
        return gitCommandResult;
    }

    private static final void runInModalTask(@Nls(capitalization=Nls.Capitalization.Title) String title, @Nls(capitalization=Nls.Capitalization.Title) String errorTitle, @Nls(capitalization=Nls.Capitalization.Sentence) String errorMessage, GitRepository repository, Function0<Unit> afterRepoRefresh, Function0<Unit> onSuccess, Function0<? extends List<? extends GitCommandResult>> operation) {
        Project project = repository.getProject();
        ProgressManager.getInstance().run((Task)new Task.Modal(title, operation, repository, afterRepoRefresh, onSuccess, errorMessage, errorTitle, project){
            private List<? extends GitCommandResult> results;
            final /* synthetic */ Function0<List<GitCommandResult>> $operation;
            final /* synthetic */ GitRepository $repository;
            final /* synthetic */ Function0<Unit> $afterRepoRefresh;
            final /* synthetic */ Function0<Unit> $onSuccess;
            final /* synthetic */ String $errorMessage;
            final /* synthetic */ String $errorTitle;
            {
                this.$operation = $operation;
                this.$repository = $repository;
                this.$afterRepoRefresh = $afterRepoRefresh;
                this.$onSuccess = $onSuccess;
                this.$errorMessage = $errorMessage;
                this.$errorTitle = $errorTitle;
                super($super_call_param$1, $title, true);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                this.results = (List)this.$operation.invoke();
                this.$repository.update();
                this.$afterRepoRefresh.invoke();
            }

            public void onSuccess() {
                block11: {
                    String string;
                    block10: {
                        boolean bl;
                        block9: {
                            this.$onSuccess.invoke();
                            if (this.results == null) break block10;
                            List<? extends GitCommandResult> list = this.results;
                            Intrinsics.checkNotNull(list);
                            Iterable $this$any$iv = list;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    GitCommandResult it = (GitCommandResult)element$iv;
                                    boolean bl2 = false;
                                    if (!(!it.success())) continue;
                                    bl = true;
                                    break block9;
                                }
                                bl = false;
                            }
                        }
                        if (!bl) break block11;
                    }
                    if (this.results == null) {
                        string = GitBundle.message("remotes.operation.not.executed.message", new Object[0]);
                    } else {
                        List<? extends GitCommandResult> list = this.results;
                        Intrinsics.checkNotNull(list);
                        string = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"<br/>", null, null, (int)0, null, runInModalTask.2::onSuccess$lambda$1, (int)30, null);
                    }
                    String $i$f$any = string;
                    Intrinsics.checkNotNull((Object)$i$f$any);
                    String errorDetails = $i$f$any;
                    Object[] objectArray = new Object[]{this.$errorMessage, this.$repository, errorDetails};
                    String string2 = GitBundle.message("remotes.operation.error.message", objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                    String message = string2;
                    GitConfigureRemotesDialogKt.access$getLOG$p().warn(message);
                    Messages.showErrorDialog((Project)this.myProject, (String)XmlStringUtil.wrapInHtml((CharSequence)message), (String)this.$errorTitle);
                }
            }

            private static final CharSequence onSuccess$lambda$1(GitCommandResult it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string = it.getErrorOutputAsHtmlString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getErrorOutputAsHtmlString(...)");
                return string;
            }
        });
    }

    static /* synthetic */ void runInModalTask$default(String string, String string2, String string3, GitRepository gitRepository, Function0 function0, Function0 function02, Function0 function03, int n, Object object) {
        if ((n & 0x10) != 0) {
            function0 = GitConfigureRemotesDialogKt::runInModalTask$lambda$11;
        }
        GitConfigureRemotesDialogKt.runInModalTask(string, string2, string3, gitRepository, (Function0<Unit>)function0, (Function0<Unit>)function02, (Function0<? extends List<? extends GitCommandResult>>)function03);
    }

    private static final Unit removeRemotes$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final List removeRemotes$lambda$2(Set $remotes, Git $git, GitRepository $repository) {
        ArrayList<GitCommandResult> arrayList;
        ArrayList<GitCommandResult> $this$removeRemotes_u24lambda_u242_u24lambda_u241 = arrayList = new ArrayList<GitCommandResult>();
        boolean bl = false;
        for (GitRemote remote : $remotes) {
            $this$removeRemotes_u24lambda_u242_u24lambda_u241.add($git.removeRemote($repository, remote));
        }
        return arrayList;
    }

    private static final Unit editRemote$lambda$3() {
        return Unit.INSTANCE;
    }

    private static final Unit editRemote$lambda$4(GitDefineRemoteDialog $dialog, GitRepository $repository, String $newRemoteName, String $newRemoteUrl) {
        if ($dialog.getShouldFetch()) {
            GitConfigureRemotesDialogKt.doFetch($repository, $newRemoteName, $newRemoteUrl);
        }
        return Unit.INSTANCE;
    }

    private static final List editRemote$lambda$6(Git $git, GitRepository $repository, String $oldName, String $oldUrl, String $newRemoteName, String $newRemoteUrl) {
        ArrayList<GitCommandResult> arrayList;
        ArrayList<GitCommandResult> $this$editRemote_u24lambda_u246_u24lambda_u245 = arrayList = new ArrayList<GitCommandResult>();
        boolean bl = false;
        $this$editRemote_u24lambda_u246_u24lambda_u245.add(GitConfigureRemotesDialogKt.changeRemote($git, $repository, $oldName, $oldUrl, $newRemoteName, $newRemoteUrl));
        return arrayList;
    }

    private static final CharSequence toStringRepresentation$lambda$10(GitRemote it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName() + " '" + GitConfigureRemotesDialogKt.getUrl(it) + "'";
    }

    private static final Unit runInModalTask$lambda$11() {
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$runInModalTask(String title, String errorTitle, String errorMessage, GitRepository repository, Function0 afterRepoRefresh, Function0 onSuccess, Function0 operation) {
        GitConfigureRemotesDialogKt.runInModalTask(title, errorTitle, errorMessage, repository, (Function0<Unit>)afterRepoRefresh, (Function0<Unit>)onSuccess, (Function0<? extends List<? extends GitCommandResult>>)operation);
    }

    public static final /* synthetic */ String access$getUrl(GitRemote $receiver) {
        return GitConfigureRemotesDialogKt.getUrl($receiver);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ void access$doFetch(GitRepository repository, String remoteName, String remoteUrl) {
        GitConfigureRemotesDialogKt.doFetch(repository, remoteName, remoteUrl);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitConfigureRemotesDialog.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

