/*
 * Decompiled with CFR 0.152.
 */
package git4idea.ui.branch.dashboard;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.ui.FilteringSpeedSearch;
import com.intellij.ui.FilteringTree;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.FList;
import com.intellij.util.ui.tree.TreeUtil;
import git4idea.ui.branch.dashboard.BestMatch;
import git4idea.ui.branch.dashboard.BranchNodeDescriptor;
import git4idea.ui.branch.dashboard.BranchTreeNode;
import git4idea.ui.branch.dashboard.BranchesTreeMatcher;
import git4idea.ui.branch.dashboard.FilteringBranchesTreeBase;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00032\u000e\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00152\u0006\u0010\u0017\u001a\u00020\u000fH\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010\u001a\u001a\u00020\u00122\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0012H\u0016J\b\u0010\u001e\u001a\u00020\u0012H\u0002J\u0012\u0010\u001f\u001a\u00020\u00122\b\u0010 \u001a\u0004\u0018\u00010\u001cH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lgit4idea/ui/branch/dashboard/BranchesFilteringSpeedSearch;", "Lcom/intellij/ui/FilteringSpeedSearch;", "Lgit4idea/ui/branch/dashboard/BranchTreeNode;", "Lgit4idea/ui/branch/dashboard/BranchNodeDescriptor;", "tree", "Lgit4idea/ui/branch/dashboard/FilteringBranchesTreeBase;", "searchTextField", "Lcom/intellij/ui/SearchTextField;", "<init>", "(Lgit4idea/ui/branch/dashboard/FilteringBranchesTreeBase;Lcom/intellij/ui/SearchTextField;)V", "matcher", "Lgit4idea/ui/branch/dashboard/BranchesTreeMatcher;", "bestMatch", "Lgit4idea/ui/branch/dashboard/BestMatch;", "checkMatching", "Lcom/intellij/ui/FilteringTree$Matching;", "node", "onMatchingChecked", "", "userObject", "matchingFragments", "", "Lcom/intellij/openapi/util/TextRange;", "result", "getMatcher", "Lcom/intellij/psi/codeStyle/MinusculeMatcher;", "updatePattern", "string", "", "updateSelection", "scrollToSelected", "onUpdatePattern", "text", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nBranchesTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BranchesTree.kt\ngit4idea/ui/branch/dashboard/BranchesFilteringSpeedSearch\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,518:1\n1#2:519\n*E\n"})
final class BranchesFilteringSpeedSearch
extends FilteringSpeedSearch<BranchTreeNode, BranchNodeDescriptor> {
    @NotNull
    private final FilteringBranchesTreeBase tree;
    @NotNull
    private BranchesTreeMatcher matcher;
    @Nullable
    private BestMatch bestMatch;

    public BranchesFilteringSpeedSearch(@NotNull FilteringBranchesTreeBase tree, @NotNull SearchTextField searchTextField) {
        Intrinsics.checkNotNullParameter((Object)((Object)tree), (String)"tree");
        Intrinsics.checkNotNullParameter((Object)searchTextField, (String)"searchTextField");
        super((FilteringTree)tree, searchTextField);
        this.tree = tree;
        this.matcher = new BranchesTreeMatcher(searchTextField.getText());
    }

    @NotNull
    public FilteringTree.Matching checkMatching(@NotNull BranchTreeNode node) {
        FilteringTree.Matching matching;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        if (node.getNodeDescriptor() instanceof BranchNodeDescriptor.Group) {
            matching = FilteringTree.Matching.NONE;
        } else {
            FilteringTree.Matching matching2 = super.checkMatching((DefaultMutableTreeNode)node);
            matching = matching2;
            Intrinsics.checkNotNullExpressionValue((Object)matching2, (String)"checkMatching(...)");
        }
        return matching;
    }

    protected void onMatchingChecked(@NotNull BranchNodeDescriptor userObject, @Nullable Iterable<? extends TextRange> matchingFragments, @NotNull FilteringTree.Matching result2) {
        Intrinsics.checkNotNullParameter((Object)userObject, (String)"userObject");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        if (result2 == FilteringTree.Matching.NONE) {
            return;
        }
        String string = this.tree.getText(userObject);
        if (string == null) {
            return;
        }
        String text2 = string;
        TextRange textRange = matchingFragments;
        if (textRange == null || (textRange = (TextRange)CollectionsKt.singleOrNull(textRange)) == null) {
            return;
        }
        TextRange singleMatch = textRange;
        int matchingDegree = this.matcher.matchingDegree(text2, false, (FList<? extends TextRange>)FList.singleton((Object)singleMatch));
        BestMatch bestMatch = this.bestMatch;
        if (matchingDegree > (bestMatch != null ? bestMatch.getMatchingDegree() : 0)) {
            DefaultMutableTreeNode defaultMutableTreeNode = this.tree.getSearchModel().getNode((Object)userObject);
            Intrinsics.checkNotNullExpressionValue((Object)defaultMutableTreeNode, (String)"getNode(...)");
            BranchTreeNode node = (BranchTreeNode)defaultMutableTreeNode;
            this.bestMatch = new BestMatch(matchingDegree, node);
        }
    }

    @NotNull
    public MinusculeMatcher getMatcher() {
        return this.matcher;
    }

    public void updatePattern(@Nullable String string) {
        super.updatePattern(string);
        this.onUpdatePattern(string);
    }

    public void updateSelection() {
        BestMatch bestMatch = this.bestMatch;
        if (bestMatch == null) {
            super.updateSelection();
        } else {
            int selectionMatchingDegree;
            BranchTreeNode branchTreeNode = (BranchTreeNode)this.getSelection();
            String selectionText = this.tree.getText(branchTreeNode != null ? branchTreeNode.getNodeDescriptor() : null);
            int n = selectionMatchingDegree = selectionText != null ? this.matcher.matchingDegree(selectionText) : Integer.MIN_VALUE;
            if (selectionMatchingDegree < bestMatch.getMatchingDegree()) {
                this.select(bestMatch.getNode());
            }
        }
        CharSequence charSequence = this.getEnteredPrefix();
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            this.scrollToSelected();
        }
    }

    private final void scrollToSelected() {
        block0: {
            Tree tree = this.tree.getTree();
            Intrinsics.checkNotNullExpressionValue((Object)tree, (String)"getTree(...)");
            Tree innerTree = tree;
            TreePath treePath = innerTree.getSelectionPath();
            if (treePath == null) break block0;
            TreePath it = treePath;
            boolean bl = false;
            TreeUtil.scrollToVisible((JTree)((JTree)innerTree), (TreePath)it, (boolean)false);
        }
    }

    protected void onUpdatePattern(@Nullable String text2) {
        this.matcher = new BranchesTreeMatcher(text2);
        this.bestMatch = null;
    }
}

