/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.languagetool.LinguServices;
import org.languagetool.rules.Rule;

public class UserConfig {
    private static boolean abTestEnabled = false;
    private final List<String> userSpecificSpellerWords;
    private final Set<String> acceptedPhrases;
    private final List<Rule> userSpecificRules;
    private final int maxSpellingSuggestions;
    private final Long userDictCacheSize;
    private final String userDictName;
    private final Long premiumUid;
    private final Map<String, Object[]> configurableRuleValues = new HashMap<String, Object[]>();
    private final LinguServices linguServices;
    private final boolean filterDictionaryMatches;
    private final boolean hidePremiumMatches;
    private final Long textSessionId;
    private final List<String> abTest;
    private final String preferredLanguages;
    private boolean trustedSource;

    public static void enableABTests() {
        abTestEnabled = true;
    }

    public static boolean hasABTestsEnabled() {
        return abTestEnabled;
    }

    public UserConfig() {
        this(new ArrayList<String>(), new HashMap<String, Object[]>());
    }

    public UserConfig(List<String> userSpecificSpellerWords) {
        this(userSpecificSpellerWords, new HashMap<String, Object[]>());
    }

    public UserConfig(Map<String, Object[]> ruleValues) {
        this(new ArrayList<String>(), Objects.requireNonNull(ruleValues));
    }

    public UserConfig(Map<String, Object[]> ruleValues, LinguServices linguServices) {
        this(new ArrayList<String>(), Objects.requireNonNull(ruleValues), 0, 0L, null, 0L, linguServices);
    }

    public UserConfig(List<String> userSpecificSpellerWords, Map<String, Object[]> ruleValues) {
        this(userSpecificSpellerWords, ruleValues, 0, null, null, null, null);
    }

    public UserConfig(List<String> userSpecificSpellerWords, Map<String, Object[]> ruleValues, int maxSpellingSuggestions, Long premiumUid, String userDictName, Long userDictCacheSize, LinguServices linguServices) {
        this(userSpecificSpellerWords, Collections.emptyList(), ruleValues, maxSpellingSuggestions, premiumUid, userDictName, userDictCacheSize, linguServices, false, null, null, false, null, false);
    }

    public UserConfig(List<String> userSpecificSpellerWords, List<Rule> userSpecificRules, Map<String, Object[]> ruleValues, int maxSpellingSuggestions, Long premiumUid, String userDictName, Long userDictCacheSize, LinguServices linguServices, boolean filterDictionaryMatches, @Nullable List<String> abTest, @Nullable Long textSessionId, boolean hidePremiumMatches, List<String> preferredLanguages) {
        this(userSpecificSpellerWords, userSpecificRules, ruleValues, maxSpellingSuggestions, premiumUid, userDictName, userDictCacheSize, linguServices, filterDictionaryMatches, abTest, textSessionId, hidePremiumMatches, preferredLanguages, false);
    }

    public UserConfig(List<String> userSpecificSpellerWords, List<Rule> userSpecificRules, Map<String, Object[]> ruleValues, int maxSpellingSuggestions, Long premiumUid, String userDictName, Long userDictCacheSize, LinguServices linguServices, boolean filterDictionaryMatches, @Nullable List<String> abTest, @Nullable Long textSessionId, boolean hidePremiumMatches, List<String> preferredLanguages, boolean trustedSource) {
        this.userSpecificSpellerWords = Objects.requireNonNull(userSpecificSpellerWords);
        this.userSpecificRules = Objects.requireNonNull(userSpecificRules);
        for (Map.Entry<String, Object[]> entry2 : ruleValues.entrySet()) {
            this.configurableRuleValues.put(entry2.getKey(), entry2.getValue());
        }
        this.maxSpellingSuggestions = maxSpellingSuggestions;
        this.premiumUid = premiumUid;
        this.userDictName = userDictName == null ? "default" : userDictName;
        this.userDictCacheSize = userDictCacheSize;
        this.linguServices = linguServices;
        this.filterDictionaryMatches = filterDictionaryMatches;
        this.abTest = abTest;
        this.textSessionId = textSessionId;
        this.hidePremiumMatches = hidePremiumMatches;
        this.acceptedPhrases = this.buildAcceptedPhrases();
        this.preferredLanguages = this.removeAllButMainLanguagesAndSort(preferredLanguages);
        this.trustedSource = trustedSource;
    }

    private String removeAllButMainLanguagesAndSort(List<String> preferredLanguages) {
        ArrayList<String> cleanLangList = preferredLanguages != null ? new ArrayList<String>(preferredLanguages) : Collections.emptyList();
        cleanLangList.removeIf(language -> !language.equals("de") && !language.equals("en") && !language.equals("es") && !language.equals("fr") && !language.equals("nl") && !language.equals("pt"));
        Collections.sort(cleanLangList);
        return cleanLangList.size() >= 2 ? String.join((CharSequence)",", cleanLangList) : "";
    }

    @NotNull
    public List<String> getAcceptedWords() {
        return this.userSpecificSpellerWords;
    }

    private Set<String> buildAcceptedPhrases() {
        HashSet<String> phrases = new HashSet<String>();
        for (String wordOrPhrase : this.userSpecificSpellerWords) {
            if (!wordOrPhrase.contains(" ")) continue;
            phrases.add(wordOrPhrase);
        }
        return phrases;
    }

    @NotNull
    public Set<String> getAcceptedPhrases() {
        return this.acceptedPhrases;
    }

    @NotNull
    public List<Rule> getRules() {
        return this.userSpecificRules;
    }

    public int getMaxSpellingSuggestions() {
        return this.maxSpellingSuggestions;
    }

    public Map<String, Object[]> getConfigValues() {
        return this.configurableRuleValues;
    }

    public void insertConfigValues(Map<String, Object[]> ruleValues) {
        for (Map.Entry<String, Object[]> entry2 : ruleValues.entrySet()) {
            this.configurableRuleValues.put(entry2.getKey(), entry2.getValue());
        }
    }

    public Object[] getConfigValueByID(String ruleID) {
        if (this.configurableRuleValues.containsKey(ruleID)) {
            return this.configurableRuleValues.get(ruleID);
        }
        return null;
    }

    public boolean hasLinguServices() {
        return this.linguServices != null;
    }

    public LinguServices getLinguServices() {
        return this.linguServices;
    }

    public Long getUserDictCacheSize() {
        return this.userDictCacheSize;
    }

    public String getUserDictName() {
        return this.userDictName;
    }

    public Long getPremiumUid() {
        return this.premiumUid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserConfig other = (UserConfig)o;
        return new EqualsBuilder().append(this.configurableRuleValues, other.configurableRuleValues).append(this.userSpecificRules.stream().mapToLong(k -> k.getId().hashCode()).sum(), other.userSpecificRules.stream().mapToLong(k -> k.getId().hashCode()).sum()).append((Object)this.premiumUid, (Object)other.premiumUid).append((Object)this.userDictName, (Object)other.userDictName).append(this.userSpecificSpellerWords, other.userSpecificSpellerWords).append(this.filterDictionaryMatches, other.filterDictionaryMatches).append(this.abTest, other.abTest).append(this.hidePremiumMatches, other.hidePremiumMatches).append((Object)this.preferredLanguages, (Object)other.preferredLanguages).append(this.trustedSource, other.trustedSource).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(3, 11).append(this.maxSpellingSuggestions).append(this.userSpecificRules.stream().mapToLong(k -> k.getId().hashCode()).sum()).append((Object)this.premiumUid).append((Object)this.userDictName).append((Object)this.userDictCacheSize).append(this.configurableRuleValues).append(this.abTest).append(this.filterDictionaryMatches).append(this.hidePremiumMatches).append((Object)this.preferredLanguages).append(this.trustedSource).toHashCode();
    }

    public String toString() {
        return "UserConfig{dictionarySize=" + this.userSpecificSpellerWords.size() + ", maxSpellingSuggestions=" + this.maxSpellingSuggestions + ", userDictName='" + this.userDictName + '\'' + ", configurableRuleValues=" + this.configurableRuleValues + ", linguServices=" + this.linguServices + ", filterDictionaryMatches=" + this.filterDictionaryMatches + ", textSessionId=" + this.textSessionId + ", hidePremiumMatches=" + this.hidePremiumMatches + ", abTest='" + this.abTest + '\'' + '}';
    }

    public Long getTextSessionId() {
        return this.textSessionId;
    }

    public List<String> getAbTest() {
        return this.abTest;
    }

    public boolean filterDictionaryMatches() {
        return this.filterDictionaryMatches;
    }

    public boolean getHidePremiumMatches() {
        return this.hidePremiumMatches;
    }

    @NotNull
    public List<String> getPreferredLanguages() {
        return Arrays.asList(this.preferredLanguages.split(","));
    }

    public boolean isTrustedSource() {
        return this.trustedSource;
    }
}

