/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.convert;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import com.thaiopensource.relaxng.edit.SchemaCollection;
import com.thaiopensource.relaxng.input.InputFailedException;
import com.thaiopensource.relaxng.input.InputFormat;
import com.thaiopensource.relaxng.input.MultiInputFormat;
import com.thaiopensource.relaxng.input.dtd.DtdInputFormat;
import com.thaiopensource.relaxng.input.parse.compact.CompactParseInputFormat;
import com.thaiopensource.relaxng.input.parse.sax.SAXParseInputFormat;
import com.thaiopensource.relaxng.input.xml.XmlInputFormat;
import com.thaiopensource.relaxng.output.LocalOutputDirectory;
import com.thaiopensource.relaxng.output.OutputDirectory;
import com.thaiopensource.relaxng.output.OutputFailedException;
import com.thaiopensource.relaxng.output.OutputFormat;
import com.thaiopensource.relaxng.output.dtd.DtdOutputFormat;
import com.thaiopensource.relaxng.output.rnc.RncOutputFormat;
import com.thaiopensource.relaxng.output.rng.RngOutputFormat;
import com.thaiopensource.relaxng.output.xsd.XsdOutputFormat;
import com.thaiopensource.relaxng.translate.util.InvalidParamsException;
import com.thaiopensource.util.UriOrFile;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import javax.swing.Icon;
import org.intellij.plugins.relaxNG.RelaxngBundle;
import org.intellij.plugins.relaxNG.convert.ConvertSchemaSettings;
import org.intellij.plugins.relaxNG.convert.IdeaErrorHandler;
import org.intellij.plugins.relaxNG.convert.SchemaType;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class IdeaDriver {
    private static final int DEFAULT_LINE_LENGTH = 72;
    private static final int DEFAULT_INDENT = 2;
    private final ConvertSchemaSettings settings;
    private final Project myProject;

    public IdeaDriver(ConvertSchemaSettings settings, Project project2) {
        this.settings = settings;
        this.myProject = project2;
    }

    public void convert(SchemaType inputType, IdeaErrorHandler errorHandler, VirtualFile ... inputFiles) {
        if (inputFiles.length == 0) {
            throw new IllegalArgumentException();
        }
        try {
            String name;
            int ext;
            SchemaCollection sc;
            InputFormat inFormat = IdeaDriver.getInputFormat(inputType);
            if (inputFiles.length > 1 && !(inFormat instanceof MultiInputFormat)) {
                throw new IllegalArgumentException();
            }
            VirtualFile inputFile = inputFiles[0];
            SchemaType type = this.settings.getOutputType();
            String outputType = StringUtil.toLowerCase((String)type.toString());
            ArrayList<CallSite> inputParams = new ArrayList<CallSite>();
            if (inputType != SchemaType.DTD) {
                Charset charset = inputFile.getCharset();
                inputParams.add((CallSite)((Object)("encoding=" + charset.name())));
            }
            ArrayList outputParams = new ArrayList();
            this.settings.addAdvancedSettings(inputParams, outputParams);
            String input2 = inputFile.getPath();
            String uri = UriOrFile.toUri(input2);
            try {
                if (inFormat instanceof MultiInputFormat) {
                    MultiInputFormat format = (MultiInputFormat)inFormat;
                    String[] uris = new String[inputFiles.length];
                    for (int i = 0; i < inputFiles.length; ++i) {
                        uris[i] = UriOrFile.toUri(inputFiles[i].getPath());
                    }
                    sc = format.load(uris, ArrayUtilRt.toStringArray(inputParams), outputType, (ErrorHandler)errorHandler);
                } else {
                    sc = inFormat.load(uri, ArrayUtilRt.toStringArray(inputParams), outputType, errorHandler);
                }
            }
            catch (IOException e) {
                errorHandler.fatalError(new SAXParseException(e.getMessage(), null, uri, -1, -1, e));
                return;
            }
            File destination = new File(this.settings.getOutputDestination());
            final File outputFile = destination.isDirectory() ? new File(destination, ((ext = (name = new File(input2).getName()).lastIndexOf(46)) > 0 ? name.substring(0, ext) : name) + "." + outputType) : destination;
            try {
                int indent = this.settings.getIndent();
                int length = this.settings.getLineLength();
                LocalOutputDirectory od = new LocalOutputDirectory(sc.getMainUri(), outputFile, "." + outputType, this.settings.getOutputEncoding(), length > 0 ? length : 72, indent > 0 ? indent : 2){

                    @Override
                    public OutputDirectory.Stream open(String sourceUri, String encoding) throws IOException {
                        String s = this.reference(null, sourceUri);
                        File file = new File(outputFile.getParentFile(), s);
                        if (file.exists()) {
                            String msg = RelaxngBundle.message("relaxng.convert-schema.dialog.file-exists.message", file.getAbsolutePath());
                            int choice = Messages.showYesNoDialog((Project)IdeaDriver.this.myProject, (String)msg, (String)RelaxngBundle.message("relaxng.convert-schema.dialog.file-exists.title", new Object[0]), (Icon)Messages.getWarningIcon());
                            if (choice == 0) {
                                return super.open(sourceUri, encoding);
                            }
                            if (choice == 1) {
                                throw new CanceledException();
                            }
                        }
                        return super.open(sourceUri, encoding);
                    }
                };
                OutputFormat of = IdeaDriver.getOutputFormat(this.settings.getOutputType());
                of.output(sc, od, ArrayUtilRt.toStringArray(outputParams), StringUtil.toLowerCase((String)inputType.toString()), errorHandler);
            }
            catch (IOException e) {
                errorHandler.fatalError(new SAXParseException(e.getMessage(), null, UriOrFile.fileToUri(outputFile), -1, -1, e));
            }
        }
        catch (CanceledException inFormat) {
        }
        catch (SAXParseException e) {
            errorHandler.error(e);
        }
        catch (MalformedURLException e) {
            Logger.getInstance((String)this.getClass().getName()).error((Throwable)e);
        }
        catch (InputFailedException | OutputFailedException | InvalidParamsException exception) {
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    private static OutputFormat getOutputFormat(SchemaType outputType) {
        return switch (outputType) {
            case SchemaType.DTD -> new DtdOutputFormat();
            case SchemaType.RNC -> new RncOutputFormat();
            case SchemaType.RNG -> new RngOutputFormat();
            case SchemaType.XSD -> new XsdOutputFormat();
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("Unsupported output type: " + String.valueOf((Object)outputType)));
                }
                yield null;
            }
        };
    }

    private static InputFormat getInputFormat(SchemaType type) {
        return switch (type) {
            case SchemaType.DTD -> new DtdInputFormat();
            case SchemaType.RNC -> new CompactParseInputFormat();
            case SchemaType.RNG -> new SAXParseInputFormat();
            case SchemaType.XML -> new XmlInputFormat();
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)("Unsupported input type: " + String.valueOf((Object)type)));
                }
                yield null;
            }
        };
    }

    private static class CanceledException
    extends RuntimeException {
        private CanceledException() {
        }
    }
}

