/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.adapters;

import com.intellij.lang.puppet.PuppetBundle;
import com.intellij.lang.puppet.project.PuppetEntity;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PuppetDependencyManagerAdapter {
    private static final ExtensionPointName<PuppetDependencyManagerAdapter> EP_NAME = ExtensionPointName.create((String)"com.intellij.puppet.dependencyManagerAdapter");

    public abstract boolean isApplicable(@NotNull PuppetEntity var1);

    protected abstract void installDependencies(@NotNull PuppetEntity var1, @NotNull ProgressIndicator var2);

    public final void installDependencies(final @Nullable PuppetEntity puppetEntity) {
        if (puppetEntity == null) {
            return;
        }
        Project project = puppetEntity.getProject();
        new Task.Backgroundable(project, PuppetBundle.message("puppet.installing.dependencies", puppetEntity.getDescriptiveName(), puppetEntity.getName()), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                PuppetDependencyManagerAdapter.this.installDependencies(puppetEntity, indicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/lang/puppet/adapters/PuppetDependencyManagerAdapter$1", "run"));
            }
        }.queue();
    }

    @RequiresReadLock
    protected void doPostInstallationWork(@NotNull PuppetEntity puppetEntity, @Nullable Runnable additionalRunnable) {
        if (puppetEntity == null) {
            PuppetDependencyManagerAdapter.$$$reportNull$$$0(0);
        }
        ThreadingAssertions.softAssertReadAccess();
        Project project = puppetEntity.getProject();
        if (project.isDisposed()) {
            return;
        }
        VirtualFile entityRoot = puppetEntity.getRoot();
        if (!entityRoot.isValid()) {
            return;
        }
        entityRoot.refresh(true, true);
    }

    @NotNull
    public static List<PuppetDependencyManagerAdapter> getExtensions() {
        List list = EP_NAME.getExtensionList();
        if (list == null) {
            PuppetDependencyManagerAdapter.$$$reportNull$$$0(1);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "puppetEntity";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/adapters/PuppetDependencyManagerAdapter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/adapters/PuppetDependencyManagerAdapter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "doPostInstallationWork";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

