/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.console;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.console.HeadlessDebuggerTree;
import com.intellij.javascript.debugger.console.Node;
import com.intellij.javascript.debugger.console.PrintableEntity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeListener;
import com.intellij.xdebugger.impl.ui.tree.nodes.RestorableStateNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueTextRendererImpl;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.debugger.VariableView;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001BA\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\n\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0003H\u0016J\u0014\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00190\u0018H\u0016R\u0017\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006#"}, d2={"Lcom/intellij/javascript/debugger/console/TreeRoot;", "Lcom/intellij/javascript/debugger/console/Node;", "text", "", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "variableView", "Lorg/jetbrains/debugger/VariableView;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "coloredText", "Lcom/intellij/ui/SimpleColoredText;", "<init>", "(Ljava/lang/String;Lcom/intellij/execution/ui/ConsoleViewContentType;Lorg/jetbrains/debugger/VariableView;Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;Lcom/intellij/openapi/Disposable;Lcom/intellij/ui/SimpleColoredText;)V", "getIcon", "Ljavax/swing/Icon;", "hasIcon", "", "getRoot", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XDebuggerTreeNode;", "getJSType", "getJSProps", "", "", "loadPromise", "Lorg/jetbrains/concurrency/AsyncPromise;", "Lcom/intellij/javascript/debugger/console/PrintableEntity;", "getLoadPromise", "()Lorg/jetbrains/concurrency/AsyncPromise;", "rootNode", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl;", "getRootNode", "()Lcom/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl;", "intellij.javascript.debugger"})
public final class TreeRoot
extends Node {
    @NotNull
    private final AsyncPromise<PrintableEntity> loadPromise;
    @NotNull
    private final XValueNodeImpl rootNode;

    public TreeRoot(@NlsSafe @NotNull String text, @NotNull ConsoleViewContentType contentType, @NotNull VariableView variableView, @NotNull JavaScriptDebugProcess<?> debugProcess, @NotNull Disposable parentDisposable, @Nullable SimpleColoredText coloredText) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)variableView, (String)"variableView");
        Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        super(text, contentType, coloredText);
        this.loadPromise = new AsyncPromise();
        this.setColoredText(new SimpleColoredText(text, SimpleTextAttributes.REGULAR_ATTRIBUTES));
        Project project = debugProcess.getSession().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        final HeadlessDebuggerTree tree = new HeadlessDebuggerTree(project, debugProcess.getEditorsProvider(), debugProcess.getSession().getCurrentPosition(), "XDebugger.Inspect.Tree.Popup");
        Disposer.register((Disposable)parentDisposable, (Disposable)((Disposable)tree));
        this.rootNode = new XValueNodeImpl((XDebuggerTree)tree, null, text, (XValue)variableView);
        ApplicationManager.getApplication().invokeLater(() -> TreeRoot._init_$lambda$0(tree, this));
        tree.expandNodesOnLoad(arg_0 -> TreeRoot._init_$lambda$2(arg_0 -> TreeRoot._init_$lambda$1(this, arg_0), arg_0));
        tree.addTreeListener(new XDebuggerTreeListener(){

            public void nodeLoaded(RestorableStateNode node, String name) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                if (Intrinsics.areEqual((Object)node, (Object)this.getRootNode())) {
                    SimpleColoredText nodeText = new SimpleColoredText();
                    XValueTextRendererImpl renderer = new XValueTextRendererImpl((ColoredTextContainer)nodeText);
                    XValuePresentation xValuePresentation = this.getRootNode().getValuePresentation();
                    Intrinsics.checkNotNull((Object)xValuePresentation);
                    xValuePresentation.renderValue((XValuePresentation.XValueTextRenderer)renderer);
                    this.setColoredText(nodeText);
                    tree.removeTreeListener(this);
                    this.getLoadPromise().setResult((Object)this);
                }
            }
        });
    }

    public /* synthetic */ TreeRoot(String string, ConsoleViewContentType consoleViewContentType, VariableView variableView, JavaScriptDebugProcess javaScriptDebugProcess, Disposable disposable, SimpleColoredText simpleColoredText, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            simpleColoredText = null;
        }
        this(string, consoleViewContentType, variableView, javaScriptDebugProcess, disposable, simpleColoredText);
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return null;
    }

    @Override
    public boolean hasIcon() {
        return false;
    }

    @NotNull
    public final XDebuggerTreeNode getRoot() {
        return (XDebuggerTreeNode)this.rootNode;
    }

    @Override
    @NotNull
    public String getJSType() {
        return "tree";
    }

    @Override
    @NotNull
    public Map<String, Object> getJSProps() {
        Map<String, Object> jsProps = super.getJSProps();
        jsProps.put("styleClasses", CollectionsKt.emptyList());
        return jsProps;
    }

    @NotNull
    public final AsyncPromise<PrintableEntity> getLoadPromise() {
        return this.loadPromise;
    }

    @NotNull
    public final XValueNodeImpl getRootNode() {
        return this.rootNode;
    }

    private static final void _init_$lambda$0(HeadlessDebuggerTree $tree, TreeRoot this$0) {
        $tree.setRoot((XDebuggerTreeNode)this$0.rootNode, false);
        $tree.setSelectionRow(0);
    }

    private static final boolean _init_$lambda$1(TreeRoot this$0, TreeNode node) {
        return node == this$0.rootNode;
    }

    private static final boolean _init_$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

