/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.resolve;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.typescript.resolve.TypeScriptAugmentationUtil;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.AdditionalIndexableFileSet;
import com.intellij.util.indexing.AdditionalIndexedRootsScope;
import com.intellij.util.indexing.IndexableFileSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class JSFileReferenceCache {
    private static final ModulesProvider allModulesProvider = new ModulesProvider((Key<Supplier<Map<String, CachedValue<Collection<PsiElement>>>>>)Key.create((String)"module.ref.map.key"), (context2, ref2) -> JSFileReferencesUtil.INSTANCE.calculateMainModules((PsiElement)context2, (String)ref2));
    private static final ModulesProvider noMergeModulesProvider = new ModulesProvider((Key<Supplier<Map<String, CachedValue<Collection<PsiElement>>>>>)Key.create((String)"no.merged.module.ref.map.key"), (context2, ref2) -> JSFileReferencesUtil.getMostPriorityModulesNoMerge(context2, ref2));
    @NotNull
    private final NotNullLazyValue<GlobalSearchScope> myIndexedFilesInProjectScope;

    public static JSFileReferenceCache getInstance(@NotNull Project project) {
        if (project == null) {
            JSFileReferenceCache.$$$reportNull$$$0(0);
        }
        return (JSFileReferenceCache)project.getService(JSFileReferenceCache.class);
    }

    public JSFileReferenceCache(@NotNull Project project) {
        if (project == null) {
            JSFileReferenceCache.$$$reportNull$$$0(1);
        }
        this.myIndexedFilesInProjectScope = NotNullLazyValue.lazy(() -> new AdditionalIndexedRootsScope(GlobalSearchScope.allScope((Project)project), (IndexableFileSet)new AdditionalIndexableFileSet(project)));
    }

    @NotNull
    Collection<PsiElement> resolveModuleReferences(@NotNull PsiElement referenceOwner, boolean includeUnindexedFiles) {
        String referenceText;
        if (referenceOwner == null) {
            JSFileReferenceCache.$$$reportNull$$$0(2);
        }
        if (StringUtil.isEmpty((String)(referenceText = JSFileReferencesUtil.getReferenceModuleText(referenceOwner)))) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                JSFileReferenceCache.$$$reportNull$$$0(3);
            }
            return list;
        }
        Collection<PsiElement> collection = this.resolveModuleReference(referenceOwner, referenceText, includeUnindexedFiles);
        if (collection == null) {
            JSFileReferenceCache.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    public Collection<PsiElement> resolveModuleReference(@Nullable PsiElement context2, @NotNull String referenceText, boolean includeUnindexedFiles) {
        if (referenceText == null) {
            JSFileReferenceCache.$$$reportNull$$$0(5);
        }
        return this.resolveModules(allModulesProvider, context2, referenceText, includeUnindexedFiles);
    }

    @NotNull
    public Collection<PsiElement> resolveModuleReferenceWithoutMerge(@Nullable PsiElement context2, @NotNull String referenceText, boolean includeUnindexedFiles) {
        if (referenceText == null) {
            JSFileReferenceCache.$$$reportNull$$$0(6);
        }
        return this.resolveModules(noMergeModulesProvider, context2, referenceText, includeUnindexedFiles);
    }

    @NotNull
    private Collection<PsiElement> resolveModules(@NotNull ModulesProvider provider, @Nullable PsiElement element, @NotNull String referenceText, boolean includeUnindexedFiles) {
        List result2;
        if (provider == null) {
            JSFileReferenceCache.$$$reportNull$$$0(7);
        }
        if (referenceText == null) {
            JSFileReferenceCache.$$$reportNull$$$0(8);
        }
        if (element == null || StringUtil.isEmpty((String)referenceText)) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                JSFileReferenceCache.$$$reportNull$$$0(9);
            }
            return list;
        }
        PsiElement moduleContext = JSFileReferenceCache.getModuleContext(element);
        if (moduleContext == null) {
            Set<PsiElement> set = Collections.emptySet();
            if (set == null) {
                JSFileReferenceCache.$$$reportNull$$$0(10);
            }
            return set;
        }
        String unquotedRef = JSStringUtil.unquoteStringLiteralValue(referenceText);
        VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)moduleContext);
        Collection<Object> collection = result2 = file == null ? provider.getSupplier().apply(moduleContext, unquotedRef) : JSFileReferenceCache.getCachedModules(provider, moduleContext, unquotedRef);
        if (!includeUnindexedFiles) {
            result2 = ContainerUtil.filter(result2, it -> !this.isUnindexedJSFile(it.getContainingFile()));
        }
        List list = result2;
        if (list == null) {
            JSFileReferenceCache.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Nullable
    public static PsiElement getModuleContext(@NotNull PsiElement moduleReference) {
        if (moduleReference == null) {
            JSFileReferenceCache.$$$reportNull$$$0(12);
        }
        if (TypeScriptAugmentationUtil.isExternalModuleAugmentation(moduleReference)) {
            return CompletionUtil.getOriginalOrSelf((PsiElement)moduleReference);
        }
        PsiFile containingFile = moduleReference.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        PsiFile file = containingFile.getOriginalFile();
        if (file instanceof JSFile) {
            return file;
        }
        PsiElement module = ES6PsiUtil.findExternalModule(moduleReference);
        if (module != null) {
            return module instanceof PsiFile ? ((PsiFile)module).getOriginalFile() : module;
        }
        return file;
    }

    @NotNull
    private static Collection<PsiElement> getCachedModules(@NotNull ModulesProvider provider, @NotNull PsiElement element, @NotNull String unquotedRef) {
        Map<String, CachedValue<Collection<PsiElement>>> map2;
        CachedValue<Collection<PsiElement>> value;
        if (provider == null) {
            JSFileReferenceCache.$$$reportNull$$$0(13);
        }
        if (element == null) {
            JSFileReferenceCache.$$$reportNull$$$0(14);
        }
        if (unquotedRef == null) {
            JSFileReferenceCache.$$$reportNull$$$0(15);
        }
        if ((value = (map2 = JSFileReferenceCache.getModulesFileMap(provider.getKey(), element)).get(unquotedRef)) != null) {
            Collection collection = (Collection)value.getValue();
            if (collection == null) {
                JSFileReferenceCache.$$$reportNull$$$0(16);
            }
            return collection;
        }
        value = JSFileReferenceCache.createModulesCachedValueForText(element, unquotedRef, provider);
        CachedValue<Collection<PsiElement>> prev = map2.putIfAbsent(unquotedRef, value);
        if (prev != null) {
            value = prev;
        }
        Collection collection = (Collection)value.getValue();
        if (collection == null) {
            JSFileReferenceCache.$$$reportNull$$$0(17);
        }
        return collection;
    }

    @NotNull
    private static CachedValue<Collection<PsiElement>> createModulesCachedValueForText(@NotNull PsiElement context2, @NotNull String unquotedRef, @NotNull ModulesProvider provider) {
        if (context2 == null) {
            JSFileReferenceCache.$$$reportNull$$$0(18);
        }
        if (unquotedRef == null) {
            JSFileReferenceCache.$$$reportNull$$$0(19);
        }
        if (provider == null) {
            JSFileReferenceCache.$$$reportNull$$$0(20);
        }
        Project project = context2.getProject();
        CachedValue cachedValue = CachedValuesManager.getManager((Project)project).createCachedValue(() -> {
            Collection<PsiElement> allResolveResults = provider.getSupplier().apply(context2, unquotedRef);
            HashSet deps = new HashSet(JSFileReferencesUtil.INSTANCE.getAllDependencies(context2, unquotedRef));
            deps.addAll(allResolveResults);
            return CachedValueProvider.Result.create(allResolveResults, deps);
        }, false);
        if (cachedValue == null) {
            JSFileReferenceCache.$$$reportNull$$$0(21);
        }
        return cachedValue;
    }

    @NotNull
    private static Map<String, CachedValue<Collection<PsiElement>>> getModulesFileMap(@NotNull Key<Supplier<Map<String, CachedValue<Collection<PsiElement>>>>> key, @NotNull PsiElement context2) {
        Supplier data;
        ConcurrentHashMap<String, CachedValue<Collection<PsiElement>>> result2;
        if (key == null) {
            JSFileReferenceCache.$$$reportNull$$$0(22);
        }
        if (context2 == null) {
            JSFileReferenceCache.$$$reportNull$$$0(23);
        }
        if ((result2 = (ConcurrentHashMap<String, CachedValue<Collection<PsiElement>>>)SoftReference.deref((Supplier)(data = (Supplier)context2.getUserData(key)))) != null) {
            ConcurrentHashMap<String, CachedValue<Collection<PsiElement>>> concurrentHashMap = result2;
            if (concurrentHashMap == null) {
                JSFileReferenceCache.$$$reportNull$$$0(24);
            }
            return concurrentHashMap;
        }
        result2 = new ConcurrentHashMap<String, CachedValue<Collection<PsiElement>>>();
        context2.putUserData(key, JSFileReferencesUtil.INSTANCE.createSoftRef(result2));
        ConcurrentHashMap<String, CachedValue<Collection<PsiElement>>> concurrentHashMap = result2;
        if (concurrentHashMap == null) {
            JSFileReferenceCache.$$$reportNull$$$0(25);
        }
        return concurrentHashMap;
    }

    public boolean isUnindexedJSFile(@Nullable PsiFile file) {
        if (file == null) {
            return false;
        }
        Boolean value = (Boolean)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            boolean isJSFile = JavaScriptIndex.getFileTypesToIndexJS().contains(file.getFileType());
            if (!isJSFile) {
                return CachedValueProvider.Result.create((Object)false, (Object[])new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS});
            }
            VirtualFile virtualFile = file.getVirtualFile();
            boolean isIndexed = virtualFile != null && JavaScriptIndex.isAcceptableFile(virtualFile) && ((GlobalSearchScope)this.myIndexedFilesInProjectScope.getValue()).contains(virtualFile);
            return CachedValueProvider.Result.create((Object)(!isIndexed ? 1 : 0), (Object[])new Object[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS, file});
        });
        return Boolean.TRUE.equals(value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 9, 10, 11, 16, 17, 21, 24, 25 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceOwner";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 21: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/resolve/JSFileReferenceCache";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceText";
                break;
            }
            case 7: 
            case 13: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleReference";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unquotedRef";
                break;
            }
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/resolve/JSFileReferenceCache";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveModuleReferences";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveModules";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedModules";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createModulesCachedValueForText";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getModulesFileMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveModuleReferences";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 21: 
            case 24: 
            case 25: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveModuleReference";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveModuleReferenceWithoutMerge";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resolveModules";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getModuleContext";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCachedModules";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createModulesCachedValueForText";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getModulesFileMap";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 9, 10, 11, 16, 17, 21, 24, 25 -> new IllegalStateException(string);
        };
    }

    private static class ModulesProvider {
        @NotNull
        private final Key<Supplier<Map<String, CachedValue<Collection<PsiElement>>>>> myKey;
        @NotNull
        private final BiFunction<PsiElement, String, Collection<PsiElement>> mySupplier;

        private ModulesProvider(@NotNull Key<Supplier<Map<String, CachedValue<Collection<PsiElement>>>>> key, @NotNull BiFunction<PsiElement, String, Collection<PsiElement>> supplier) {
            if (key == null) {
                ModulesProvider.$$$reportNull$$$0(0);
            }
            if (supplier == null) {
                ModulesProvider.$$$reportNull$$$0(1);
            }
            this.myKey = key;
            this.mySupplier = supplier;
        }

        @NotNull
        private Key<Supplier<Map<String, CachedValue<Collection<PsiElement>>>>> getKey() {
            Key<Supplier<Map<String, CachedValue<Collection<PsiElement>>>>> key = this.myKey;
            if (key == null) {
                ModulesProvider.$$$reportNull$$$0(2);
            }
            return key;
        }

        @NotNull
        private BiFunction<PsiElement, String, Collection<PsiElement>> getSupplier() {
            BiFunction<PsiElement, String, Collection<PsiElement>> biFunction = this.mySupplier;
            if (biFunction == null) {
                ModulesProvider.$$$reportNull$$$0(3);
            }
            return biFunction;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "supplier";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/ecmascript6/resolve/JSFileReferenceCache$ModulesProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/ecmascript6/resolve/JSFileReferenceCache$ModulesProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKey";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSupplier";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

