/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptModuleDeclarationsProcessor;
import com.intellij.lang.javascript.ecmascript6.TypeScriptStrictKindAwareProcessor;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSModuleStatusOwner;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGlobalModuleExportDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImplicitModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSQualifiedNameResolver;
import com.intellij.lang.javascript.psi.resolve.accessibility.TypeScriptModuleAccessibilityChecker;
import com.intellij.lang.javascript.psi.resolve.processors.JSResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.TypeScriptLocalClassIndex;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.lang.javascript.psi.util.JSTreeUtil;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptAugmentationUtil;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.Processor;
import com.intellij.util.Processors;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class TypeScriptQualifiedNameResolver
extends JSQualifiedNameResolver {
    @NotNull
    private final StrictKind myStrictKind;
    private final boolean myIncludeAugmentations;
    private final boolean myCheckLocalClasses;

    public TypeScriptQualifiedNameResolver(@NotNull PsiElement context2) {
        if (context2 == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(0);
        }
        this(context2, StrictKind.OBJECTS, true);
    }

    public TypeScriptQualifiedNameResolver(@NotNull PsiElement context2, boolean acceptObjectScopes) {
        if (context2 == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(1);
        }
        this(context2, acceptObjectScopes ? StrictKind.OBJECTS_WITH_FIELDS : StrictKind.OBJECTS, true);
    }

    public TypeScriptQualifiedNameResolver(@NotNull PsiElement context2, @NotNull StrictKind strictKind, boolean includeAugmentations) {
        if (context2 == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(2);
        }
        if (strictKind == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(3);
        }
        this(context2, strictKind, includeAugmentations, true);
    }

    public TypeScriptQualifiedNameResolver(@NotNull PsiElement context2, @NotNull StrictKind strictKind, boolean includeAugmentations, boolean checkLocalClasses) {
        if (context2 == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(4);
        }
        if (strictKind == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(5);
        }
        super(context2, strictKind == StrictKind.OBJECTS_WITH_FIELDS);
        this.myStrictKind = strictKind;
        this.myIncludeAugmentations = includeAugmentations;
        this.myCheckLocalClasses = checkLocalClasses;
    }

    @Override
    @NotNull
    protected TypeScriptQualifiedNameResolver createNestedResolver(@NotNull PsiElement newContext) {
        if (newContext == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(6);
        }
        StrictKind newStrictKind = this.myStrictKind == StrictKind.TYPES ? StrictKind.CONTAINERS_AND_TYPES : this.myStrictKind;
        return new TypeScriptQualifiedNameResolver(newContext, newStrictKind, this.myIncludeAugmentations);
    }

    @Override
    protected boolean isStrictTypeContext() {
        return this.myStrictKind == StrictKind.CONTAINERS_AND_TYPES || this.myStrictKind == StrictKind.TYPES || this.myStrictKind == StrictKind.TYPES_CONTAINER;
    }

    @Override
    @NotNull
    protected final Collection<PsiElement> getTopLevelForModulePrefix(@NotNull String name) {
        if (name == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(7);
        }
        SmartList result2 = new SmartList();
        PsiElement externalModule = ES6PsiUtil.findExternalModule(this.myContext, false);
        if (externalModule instanceof TypeScriptModule && TypeScriptAugmentationUtil.isExternalModuleAugmentation(externalModule) && name.equals(((TypeScriptModule)externalModule).getQualifiedName())) {
            result2.addAll(TypeScriptAugmentationUtil.resolveAugmentation(externalModule));
            result2.add(externalModule);
            SmartList smartList = result2;
            if (smartList == null) {
                TypeScriptQualifiedNameResolver.$$$reportNull$$$0(8);
            }
            return smartList;
        }
        TypeScriptStrictKindAwareProcessor processor = new TypeScriptStrictKindAwareProcessor(name, this.myStrictKind);
        TypeScriptQualifiedNameResolver.processMergedAndGlobalElements(processor, name, this.myContext, true);
        result2.addAll(processor.getResults());
        SmartList smartList = result2;
        if (smartList == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(9);
        }
        return smartList;
    }

    @Override
    @NotNull
    protected final Collection<PsiElement> getTopLevelElementsWalkUp(@NotNull String name, boolean isContainer) {
        TypeScriptModule tsModule;
        List localClasses;
        if (name == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(10);
        }
        PsiElement source = this.myContext;
        JSElement exportScope = ES6PsiUtil.getNonStrictExportScope(source);
        if (this.myCheckLocalClasses && !(localClasses = (List)AstLoadingFilter.forceAllowTreeLoading((PsiFile)source.getContainingFile(), () -> TypeScriptQualifiedNameResolver.getLocalClassesIfExists(name, source, (PsiElement)exportScope))).isEmpty()) {
            List list = localClasses;
            if (list == null) {
                TypeScriptQualifiedNameResolver.$$$reportNull$$$0(11);
            }
            return list;
        }
        boolean isParentExternalFileModule = TypeScriptQualifiedNameResolver.isExternalFileModule((PsiElement)exportScope);
        boolean isExportedTSModule = exportScope instanceof TypeScriptModule && (tsModule = (TypeScriptModule)exportScope).isExportedWithDefault();
        StrictKind kind = this.isStrictTypeContext() && isContainer ? StrictKind.TYPES_CONTAINER : this.myStrictKind;
        TypeScriptModuleDeclarationsProcessor processor = this.createWalkUpTopElementsProcessor(name, kind);
        LinkedHashSet<PsiElement> result2 = new LinkedHashSet<PsiElement>();
        JSElement module = exportScope;
        while (module != null) {
            boolean fromModuleAugmentation;
            JSElement originalCurrentModule = module;
            boolean bl = fromModuleAugmentation = module instanceof TypeScriptModule && ((TypeScriptModule)module).isAugmentation() && !((TypeScriptModule)module).isGlobalScopeAugmentation();
            if (fromModuleAugmentation) {
                JSElement sourceModule = module;
                module = TypeScriptQualifiedNameResolver.getOriginalModuleForAugmentation(module);
                Collection<JSElement> candidates = TypeScriptQualifiedNameResolver.substituteModuleWithExportAssignment(module);
                for (JSElement candidate : candidates) {
                    TypeScriptQualifiedNameResolver.processES6DeclarationsInScope(candidate, processor, false);
                }
                if (processor.getResults().isEmpty()) {
                    List<PsiElement> augmentations = TypeScriptAugmentationUtil.getAugmentations((PsiElement)sourceModule, ContainerUtil.createMaybeSingletonList((Object)module));
                    for (PsiElement augmentation : augmentations) {
                        TypeScriptQualifiedNameResolver.processES6DeclarationsInScope((JSElement)augmentation, processor, true);
                    }
                }
            } else {
                TypeScriptQualifiedNameResolver.processES6DeclarationsInScope(module, processor, false);
            }
            List<PsiElement> possibleResults = processor.getResults();
            if (!possibleResults.isEmpty()) {
                boolean requireMergeElementsFromAugmentation;
                Collection<PsiElement> localElements = TypeScriptQualifiedNameResolver.getIfLocalElements((PsiElement)module, possibleResults);
                if (!ContainerUtil.isEmpty(localElements)) {
                    Collection<PsiElement> collection = localElements;
                    if (collection == null) {
                        TypeScriptQualifiedNameResolver.$$$reportNull$$$0(12);
                    }
                    return collection;
                }
                boolean bl2 = requireMergeElementsFromAugmentation = isParentExternalFileModule || fromModuleAugmentation || isExportedTSModule;
                if (isParentExternalFileModule || fromModuleAugmentation) {
                    TypeScriptQualifiedNameResolver.addMergedElementsFromAugmentations((PsiElement)module, possibleResults, source, processor);
                }
                if (isExportedTSModule) {
                    TypeScriptQualifiedNameResolver.addMergedElementsFromAugmentations((PsiElement)module.getContainingFile(), possibleResults, source, processor);
                }
                if (requireMergeElementsFromAugmentation) {
                    result2.addAll(processor.getResults());
                    this.addAugmentationsForModuleResults(source, result2);
                    LinkedHashSet<PsiElement> linkedHashSet = result2;
                    if (linkedHashSet == null) {
                        TypeScriptQualifiedNameResolver.$$$reportNull$$$0(13);
                    }
                    return linkedHashSet;
                }
            }
            String qName = TypeScriptQualifiedNameResolver.getQualifiedNameForModule(name, (PsiElement)module);
            result2.addAll(processor.getResults());
            TypeScriptStrictKindAwareProcessor mergeProcessor = new TypeScriptStrictKindAwareProcessor(name, kind);
            TypeScriptQualifiedNameResolver.processMergedAndGlobalElements(mergeProcessor, qName, source, false);
            result2.addAll(mergeProcessor.getResults());
            this.addAugmentationsForModuleResults(source, result2);
            if (!result2.isEmpty()) {
                LinkedHashSet<PsiElement> linkedHashSet = result2;
                if (linkedHashSet == null) {
                    TypeScriptQualifiedNameResolver.$$$reportNull$$$0(14);
                }
                return linkedHashSet;
            }
            module = ES6PsiUtil.getExportScope((PsiElement)originalCurrentModule);
        }
        List<PsiElement> list = Collections.emptyList();
        if (list == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(15);
        }
        return list;
    }

    @NotNull
    private static JSElement getOriginalModuleForAugmentation(@NotNull JSElement startModule) {
        if (startModule == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(16);
        }
        Collection<PsiElement> elements = TypeScriptAugmentationUtil.resolveAugmentation((PsiElement)startModule);
        JSElement jSElement = StreamEx.of(elements).select(JSElement.class).findAny().orElse(startModule);
        if (jSElement == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(17);
        }
        return jSElement;
    }

    @NotNull
    private static Collection<JSElement> substituteModuleWithExportAssignment(@NotNull JSElement element) {
        TypeScriptExportAssignment assignment;
        if (element == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(18);
        }
        if ((assignment = TypeScriptPsiUtil.findExportAssignment((PsiElement)element)) == null) {
            List<JSElement> list = Collections.singletonList(element);
            if (list == null) {
                TypeScriptQualifiedNameResolver.$$$reportNull$$$0(19);
            }
            return list;
        }
        String reference = assignment.getInitializerReference();
        if (reference == null) {
            List<JSElement> list = Collections.singletonList(element);
            if (list == null) {
                TypeScriptQualifiedNameResolver.$$$reportNull$$$0(20);
            }
            return list;
        }
        List<PsiElement> resolved = JSStubBasedPsiTreeUtil.resolveLocallyWithMergedResults(reference, (PsiElement)assignment);
        SmartList objects = new SmartList();
        if (!resolved.isEmpty()) {
            for (PsiElement psiElement : resolved) {
                if (!(psiElement instanceof TypeScriptModule)) continue;
                objects.add((Object)((JSElement)psiElement));
            }
        }
        Object object = !objects.isEmpty() ? objects : Collections.singletonList(element);
        if (object == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(21);
        }
        return object;
    }

    @NotNull
    protected TypeScriptModuleDeclarationsProcessor createWalkUpTopElementsProcessor(@NotNull String name, @NotNull StrictKind kind) {
        if (name == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(22);
        }
        if (kind == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(23);
        }
        return new TypeScriptModuleDeclarationsProcessor(name, kind, false);
    }

    @NotNull
    private static Collection<PsiElement> getIfLocalElements(@NotNull PsiElement module, @NotNull List<PsiElement> possibleResults) {
        if (module == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(24);
        }
        if (possibleResults == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(25);
        }
        if (possibleResults.isEmpty()) {
            List<PsiElement> list = possibleResults;
            if (list == null) {
                TypeScriptQualifiedNameResolver.$$$reportNull$$$0(26);
            }
            return list;
        }
        SmartList notPublic = new SmartList();
        for (PsiElement element : possibleResults) {
            JSAttributeList list;
            if (!(element instanceof JSAttributeListOwner) || (list = ((JSAttributeListOwner)element).getAttributeList()) == null || list.getAccessType() == JSAttributeList.AccessType.PUBLIC || TypeScriptQualifiedNameResolver.isRealModuleOfImplicitModule(module, element)) continue;
            notPublic.add(element);
        }
        SmartList smartList = notPublic;
        if (smartList == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(27);
        }
        return smartList;
    }

    private static boolean isExternalFileModule(PsiElement module) {
        return module instanceof JSModuleStatusOwner && ((JSModuleStatusOwner)module).isCommonJSModule() || ES6PsiUtil.isEmbeddedModule(module);
    }

    @NotNull
    private static List<PsiElement> getLocalClassesIfExists(@NotNull String name, @NotNull PsiElement source, @Nullable PsiElement module) {
        if (name == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(28);
        }
        if (source == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(29);
        }
        if (module == source || TypeScriptQualifiedNameResolver.isAmbientModule(module)) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                TypeScriptQualifiedNameResolver.$$$reportNull$$$0(30);
            }
            return list;
        }
        PsiElement parent = source.getParent();
        if (module == parent) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                TypeScriptQualifiedNameResolver.$$$reportNull$$$0(31);
            }
            return list;
        }
        Collection<JSQualifiedNamedElement> elements = TypeScriptQualifiedNameResolver.getLocalClassesForName(name, source);
        if (elements.isEmpty()) {
            List<PsiElement> list = Collections.emptyList();
            if (list == null) {
                TypeScriptQualifiedNameResolver.$$$reportNull$$$0(32);
            }
            return list;
        }
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        for (PsiElement currentParent = source; currentParent != module && currentParent != null && !TypeScriptPsiUtil.isTopLevelContainerMember(currentParent); currentParent = currentParent.getParent()) {
            if (currentParent instanceof JSClass && StringUtil.equals((CharSequence)((JSClass)currentParent).getName(), (CharSequence)name)) {
                result2.add(currentParent);
            } else if (currentParent instanceof JSElement && TypeScriptQualifiedNameResolver.isClassScopeElement(currentParent)) {
                for (PsiElement element : JSTreeUtil.findNamedElementsInScope(currentParent, name)) {
                    if (!(element instanceof JSClass)) continue;
                    result2.add(element);
                }
            }
            if (result2.isEmpty()) continue;
            ArrayList<PsiElement> arrayList = result2;
            if (arrayList == null) {
                TypeScriptQualifiedNameResolver.$$$reportNull$$$0(33);
            }
            return arrayList;
        }
        List<PsiElement> list = Collections.emptyList();
        if (list == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(34);
        }
        return list;
    }

    @NotNull
    public static Collection<JSQualifiedNamedElement> getLocalClassesForName(@NotNull String name, @NotNull PsiElement source) {
        if (name == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(35);
        }
        if (source == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(36);
        }
        if (!TypeScriptUtil.isLocalClassPossible(source)) {
            List<JSQualifiedNamedElement> list = Collections.emptyList();
            if (list == null) {
                TypeScriptQualifiedNameResolver.$$$reportNull$$$0(37);
            }
            return list;
        }
        SmartList result2 = new SmartList();
        Processor processor = Processors.cancelableCollectProcessor((Collection)result2);
        JSStubBasedPsiTreeUtil.processElementsForFile(TypeScriptLocalClassIndex.KEY, name, source.getProject(), source.getContainingFile(), JSQualifiedNamedElement.class, processor);
        SmartList smartList = result2;
        if (smartList == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(38);
        }
        return smartList;
    }

    @Override
    public final @Unmodifiable @NotNull Collection<PsiElement> postProcessResults(@NotNull Collection<PsiElement> elements) {
        if (elements == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(39);
        }
        Collection<PsiElement> results = super.postProcessResults(elements);
        boolean checkType = this.myStrictKind == StrictKind.TYPES;
        List list = ContainerUtil.filter(results, el -> (!checkType || TypeScriptPsiUtil.isNamedTypeDefinition(el)) && TypeScriptQualifiedNameResolver.checkModulesAccess(this.myContext, el));
        if (list == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(40);
        }
        return list;
    }

    private static boolean isAmbientModule(@Nullable PsiElement module) {
        VirtualFile file;
        if (module instanceof TypeScriptModule && TypeScriptPsiUtil.isAmbientDeclaration(module)) {
            return true;
        }
        return module instanceof JSFile && (file = PsiUtilCore.getVirtualFile((PsiElement)module)) != null && TypeScriptUtil.isDefinitionFile(file);
    }

    private static boolean isClassScopeElement(PsiElement currentParent) {
        return currentParent instanceof JSBlockStatement || currentParent instanceof TypeScriptModule || currentParent instanceof JSFile || currentParent instanceof TypeScriptFunction && !(currentParent instanceof TypeScriptTypeMember);
    }

    private static void processMergedAndGlobalElements(@NotNull JSResolveProcessor processor, @NotNull String qName, @NotNull PsiElement currentSource, boolean modulesOnly) {
        if (processor == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(41);
        }
        if (qName == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(42);
        }
        if (currentSource == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(43);
        }
        Collection<JSQualifiedNamedElement> elementsByQName = TypeScriptClassResolver.getInstance().findElementsByQNameFilteredByConfig(qName, currentSource);
        Condition condition = element -> TypeScriptQualifiedNameResolver.isAcceptableMergeSymbol(element, currentSource, modulesOnly);
        List filteredElements = ContainerUtil.filter(elementsByQName, (Condition)condition);
        for (JSQualifiedNamedElement element2 : filteredElements) {
            processor.execute((PsiElement)element2, ResolveState.initial());
        }
    }

    private static void addMergedElementsFromAugmentations(@NotNull PsiElement externalModule, @NotNull Collection<? extends PsiElement> possibleResults, @NotNull PsiElement realPlace, @NotNull PsiScopeProcessor processor) {
        if (externalModule == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(44);
        }
        if (possibleResults == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(45);
        }
        if (realPlace == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(46);
        }
        if (processor == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(47);
        }
        boolean needAugmentations = false;
        for (PsiElement psiElement : possibleResults) {
            if (!ES6ImportHandler.isExported(psiElement)) continue;
            needAugmentations = true;
            break;
        }
        if (!needAugmentations) {
            return;
        }
        List<PsiElement> augmentations = TypeScriptAugmentationUtil.getAugmentations(realPlace, ContainerUtil.createMaybeSingletonList((Object)externalModule));
        for (PsiElement augmentation : augmentations) {
            TypeScriptQualifiedNameResolver.processES6DeclarationsInScope((JSElement)augmentation, processor, false);
        }
    }

    private static boolean isAcceptableMergeSymbol(@NotNull JSQualifiedNamedElement element, @NotNull PsiElement currentSource, boolean modulesOnly) {
        if (element == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(48);
        }
        if (currentSource == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(49);
        }
        if (element instanceof TypeScriptGlobalModuleExportDeclaration) {
            return true;
        }
        if (modulesOnly && !(element instanceof TypeScriptModule)) {
            return false;
        }
        if (!ES6PsiUtil.isElementCanBeExported((PsiElement)element)) {
            return false;
        }
        if (element instanceof JSClass && !element.isNamespaceExplicitlyDeclared()) {
            return false;
        }
        PsiElement externalModule = ES6PsiUtil.findExternalModule((PsiElement)element);
        if (externalModule == null) {
            return TypeScriptQualifiedNameResolver.checkModulesAccess(currentSource, (PsiElement)element);
        }
        PsiElement externalSourceModule = ES6PsiUtil.findExternalModule(currentSource);
        if (!(TypeScriptQualifiedNameResolver.externalModulesEqual(externalModule, externalSourceModule) || TypeScriptQualifiedNameResolver.checkAugmentationAccess((PsiElement)element, externalModule, currentSource) || TypeScriptQualifiedNameResolver.checkGlobalAugmentation((PsiElement)element))) {
            return false;
        }
        return TypeScriptQualifiedNameResolver.checkModulesAccess(currentSource, (PsiElement)element) && ES6ImportHandler.isExported((PsiElement)element);
    }

    private static boolean checkGlobalAugmentation(@NotNull PsiElement element) {
        if (element == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(50);
        }
        JSElement scope2 = ES6PsiUtil.getExportScope(element);
        while (scope2 instanceof TypeScriptModule && !((TypeScriptModule)scope2).isGlobalScopeAugmentation()) {
            scope2 = ES6PsiUtil.getExportScope((PsiElement)scope2);
        }
        return scope2 instanceof TypeScriptModule && ((TypeScriptModule)scope2).isGlobalScopeAugmentation();
    }

    private static boolean externalModulesEqual(@Nullable PsiElement module, @Nullable PsiElement sourceModule) {
        if (module == sourceModule) {
            return true;
        }
        if (module == null) {
            return false;
        }
        if (module.isEquivalentTo(sourceModule)) {
            return true;
        }
        if (module instanceof TypeScriptModule && sourceModule instanceof TypeScriptModule) {
            String qName = ((TypeScriptModule)module).getQualifiedName();
            return qName != null && qName.equals(((TypeScriptModule)sourceModule).getQualifiedName());
        }
        return false;
    }

    private void addAugmentationsForModuleResults(@NotNull PsiElement currentSource, @NotNull Collection<PsiElement> result2) {
        Collection<PsiElement> externalModules;
        if (currentSource == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(51);
        }
        if (result2 == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(52);
        }
        if (!this.myIncludeAugmentations) {
            return;
        }
        if (!result2.isEmpty() && !(externalModules = TypeScriptQualifiedNameResolver.getExternalModules(result2)).isEmpty()) {
            result2.addAll(TypeScriptAugmentationUtil.getAugmentations(currentSource, externalModules));
        }
    }

    @NotNull
    private static Collection<PsiElement> getExternalModules(@NotNull Collection<PsiElement> result2) {
        if (result2 == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(53);
        }
        SmartList modules = new SmartList();
        for (PsiElement element : result2) {
            Collection<JSElement> elements;
            PsiElement external;
            if (ES6PsiUtil.isExternalModule(element)) {
                modules.add(element);
                continue;
            }
            if (!(element instanceof TypeScriptModule) || !((TypeScriptModule)element).isInternal() || !((external = ES6PsiUtil.findExternalModule(element)) instanceof JSElement) || !(elements = TypeScriptQualifiedNameResolver.substituteModuleWithExportAssignment((JSElement)external)).contains(element)) continue;
            modules.add(external);
        }
        SmartList smartList = modules;
        if (smartList == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(54);
        }
        return smartList;
    }

    private static String getQualifiedNameForModule(@NotNull String name, PsiElement module) {
        if (name == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(55);
        }
        return module instanceof TypeScriptModule && !((TypeScriptModule)module).isGlobalScopeAugmentation() ? ((TypeScriptModule)module).getQualifiedName() + "." + name : name;
    }

    private static boolean isRealModuleOfImplicitModule(PsiElement module, PsiElement element) {
        return module instanceof TypeScriptImplicitModule && ((TypeScriptImplicitModule)module).getRealModule() == element;
    }

    public static boolean checkAugmentationAccess(@NotNull PsiElement element, @NotNull PsiElement module, @Nullable PsiElement source) {
        Object sourceContainer;
        if (element == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(56);
        }
        if (module == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(57);
        }
        if (TypeScriptPsiUtil.isAugmentationModule(element)) {
            return true;
        }
        if (source instanceof TypeScriptModule) {
            sourceContainer = source;
        } else {
            JSElement jSElement = sourceContainer = source == null ? null : ES6PsiUtil.getExportScope(source);
        }
        return module.isEquivalentTo(sourceContainer) || module instanceof JSQualifiedNamedElement && sourceContainer instanceof JSQualifiedNamedElement && StringUtil.equals((CharSequence)((JSQualifiedNamedElement)module).getQualifiedName(), (CharSequence)((JSQualifiedNamedElement)sourceContainer).getQualifiedName()) || TypeScriptPsiUtil.isAugmentationModule(element);
    }

    public static boolean checkModulesAccess(@NotNull PsiElement source, @NotNull PsiElement element) {
        if (source == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(58);
        }
        if (element == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(59);
        }
        return TypeScriptModuleAccessibilityChecker.INSTANCE.check(source, element) == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9, 11, 12, 13, 14, 15, 17, 19, 20, 21, 26, 27, 30, 31, 32, 33, 34, 37, 38, 40, 54 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strictKind";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newContext";
                break;
            }
            case 7: 
            case 10: 
            case 22: 
            case 28: 
            case 35: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 40: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startModule";
                break;
            }
            case 18: 
            case 48: 
            case 50: 
            case 56: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 24: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 25: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleResults";
                break;
            }
            case 29: 
            case 36: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 41: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 43: 
            case 49: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSource";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalModule";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "realPlace";
                break;
            }
            case 52: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelForModulePrefix";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopLevelElementsWalkUp";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalModuleForAugmentation";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteModuleWithExportAssignment";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getIfLocalElements";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalClassesIfExists";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalClassesForName";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "postProcessResults";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalModules";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createNestedResolver";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelForModulePrefix";
                break;
            }
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 37: 
            case 38: 
            case 40: 
            case 54: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelElementsWalkUp";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getOriginalModuleForAugmentation";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "substituteModuleWithExportAssignment";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createWalkUpTopElementsProcessor";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getIfLocalElements";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getLocalClassesIfExists";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getLocalClassesForName";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "postProcessResults";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "processMergedAndGlobalElements";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "addMergedElementsFromAugmentations";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableMergeSymbol";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "checkGlobalAugmentation";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "addAugmentationsForModuleResults";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getExternalModules";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNameForModule";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "checkAugmentationAccess";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "checkModulesAccess";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 9, 11, 12, 13, 14, 15, 17, 19, 20, 21, 26, 27, 30, 31, 32, 33, 34, 37, 38, 40, 54 -> new IllegalStateException(string);
        };
    }

    public static enum StrictKind {
        OBJECTS_WITH_FIELDS,
        OBJECTS,
        CONTAINERS_AND_TYPES,
        TYPES,
        TYPES_CONTAINER;

    }
}

