/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.findUsages;

import com.intellij.ide.actions.QualifiedNameProvider;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.dialects.JSDialectSpecificHandlersFactory;
import com.intellij.lang.javascript.flex.FlexSupportLoader;
import com.intellij.lang.javascript.flex.ImportUtils;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class JSQualifiedNameProvider
implements QualifiedNameProvider {
    public PsiElement adjustElementToCopy(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            JSQualifiedNameProvider.$$$reportNull$$$0(0);
        }
        if ((parent = element.getParent()) instanceof JSQualifiedNamedElement && ((JSQualifiedNamedElement)parent).findNameIdentifier() == element.getNode()) {
            return parent;
        }
        if (element instanceof JSReferenceExpression) {
            return element;
        }
        return null;
    }

    public String getQualifiedName(@NotNull PsiElement element) {
        PsiElement resolved;
        if (element == null) {
            JSQualifiedNameProvider.$$$reportNull$$$0(1);
        }
        if (element instanceof JSReferenceExpression && (resolved = ((JSReferenceExpression)element).resolve()) instanceof JSElementBase) {
            element = resolved;
        }
        if (element instanceof JSElementBase) {
            PsiElement parent = JSResolveUtil.findParent(element);
            if (parent instanceof JSClass) {
                String parentQName = ((JSClass)parent).getQualifiedName();
                if (JSResolveUtil.isConstructorFunction(element)) {
                    return parentQName;
                }
                return parentQName + "." + ((JSElementBase)element).getName();
            }
            JSNamespace namespace = JSNamedTypeFactory.buildProvidedNamespace((JSElementBase)element, true);
            JSQualifiedName qualifiedName = namespace != null ? namespace.getQualifiedName() : null;
            return qualifiedName != null ? qualifiedName.getQualifiedName() : null;
        }
        return null;
    }

    public PsiElement qualifiedNameToElement(@NotNull String fqn, @NotNull Project project) {
        int i;
        if (fqn == null) {
            JSQualifiedNameProvider.$$$reportNull$$$0(2);
        }
        if (project == null) {
            JSQualifiedNameProvider.$$$reportNull$$$0(3);
        }
        if (DumbService.isDumb((Project)project)) {
            return null;
        }
        GlobalSearchScope searchScope = GlobalSearchScope.allScope((Project)project);
        JSClassResolver resolver = JSDialectSpecificHandlersFactory.forLanguage((Language)FlexSupportLoader.ECMA_SCRIPT_L4).getClassResolver();
        PsiElement element = resolver.findClassByQName(fqn, searchScope);
        if (element == null && (i = fqn.lastIndexOf(46)) != -1 && (element = resolver.findClassByQName(fqn.substring(0, i), searchScope)) instanceof JSClass) {
            SinkResolveProcessor<ResolveResultSink> processor = new SinkResolveProcessor<ResolveResultSink>(fqn.substring(i + 1), element, new ResolveResultSink(element, fqn.substring(i + 1)));
            element.processDeclarations(processor, ResolveState.initial(), element, element);
            return processor.getResult();
        }
        return element;
    }

    public void insertQualifiedName(@NotNull String fqn, @NotNull PsiElement element, @NotNull Editor editor, @NotNull Project project) {
        PsiElement context2;
        if (fqn == null) {
            JSQualifiedNameProvider.$$$reportNull$$$0(4);
        }
        if (element == null) {
            JSQualifiedNameProvider.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            JSQualifiedNameProvider.$$$reportNull$$$0(6);
        }
        if (project == null) {
            JSQualifiedNameProvider.$$$reportNull$$$0(7);
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        String shortName = fqn.substring(fqn.lastIndexOf(46) + 1);
        boolean useShortName = false;
        boolean doQualify = element instanceof JSQualifiedNamedElement && !shortName.equals(fqn) && !(JSResolveUtil.findParent(element) instanceof JSClass);
        boolean adequatePlace = false;
        if (doQualify && file != null && (adequatePlace = JSQualifiedNameProvider.canQualifyInContext(context2 = InjectedLanguageUtil.findElementAtNoCommit((PsiFile)file, (int)editor.getCaretModel().getOffset()))) && !JSResolveUtil.shortReferenceIsAmbiguousOrUnequal(shortName, context2, fqn, true)) {
            useShortName = true;
        }
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)(useShortName ? shortName : fqn));
        if (doQualify && adequatePlace) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            PsiElement at = InjectedLanguageUtil.findElementAtNoCommit((PsiFile)file, (int)(editor.getCaretModel().getOffset() - 1));
            JSReferenceExpression expr = (JSReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)at, JSReferenceExpression.class);
            if (expr != null) {
                ImportUtils.doImport((PsiElement)expr, fqn, true);
            }
        }
    }

    private static boolean canQualifyInContext(PsiElement context2) {
        if (context2 == null) {
            return false;
        }
        PsiElement parent = context2.getParent();
        return !(parent instanceof JSLiteralExpression) && !(parent instanceof PsiComment) && parent.getContainingFile().getLanguage().isKindOf((Language)FlexSupportLoader.ECMA_SCRIPT_L4);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fqn";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/findUsages/JSQualifiedNameProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustElementToCopy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getQualifiedName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "qualifiedNameToElement";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "insertQualifiedName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

