/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.findUsages;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.presentable.JSFormatUtil;
import com.intellij.lang.javascript.presentable.JSNamedElementPresenter;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSInheritanceUtil;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSSuperMemberUtil {
    private JSSuperMemberUtil() {
    }

    @Nullable
    public static JSQualifiedNamedElement checkSuperMember(JSQualifiedNamedElement method, @NlsContexts.DialogTitle String actionTitle, String questionText) {
        JSQualifiedNamedElement jSQualifiedNamedElement;
        if (method == null) {
            return null;
        }
        JSFindSuperMemberResult elementOrMessage = JSSuperMemberUtil.computeCancellable(method.getProject(), () -> JSSuperMemberUtil.findElementOrMessageToShow(method, questionText));
        if (elementOrMessage instanceof MessageToShow) {
            MessageToShow messageToShow = (MessageToShow)elementOrMessage;
            int choice = Messages.showYesNoCancelDialog((Project)method.getProject(), (String)messageToShow.message, (String)actionTitle, (Icon)Messages.getQuestionIcon());
            return switch (choice) {
                case 0 -> (JSQualifiedNamedElement)ObjectUtils.tryCast((Object)messageToShow.item, JSQualifiedNamedElement.class);
                case 1 -> method;
                default -> null;
            };
        }
        if (elementOrMessage instanceof Method) {
            Method methodResult = (Method)elementOrMessage;
            jSQualifiedNamedElement = methodResult.method;
        } else {
            jSQualifiedNamedElement = method;
        }
        return jSQualifiedNamedElement;
    }

    private static <T> T computeCancellable(@NotNull Project project, @NotNull Supplier<T> computable) {
        if (project == null) {
            JSSuperMemberUtil.$$$reportNull$$$0(0);
        }
        if (computable == null) {
            JSSuperMemberUtil.$$$reportNull$$$0(1);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            return (T)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ReadAction.compute(() -> JSSuperMemberUtil.lambda$computeCancellable$1((Supplier)computable)), JavaScriptBundle.message("progress.title.detect.overridden.methods", new Object[0]), true, project);
        }
        return computable.get();
    }

    @NotNull
    private static JSFindSuperMemberResult findElementOrMessageToShow(@NotNull JSQualifiedNamedElement method, String questionText) {
        JSClass jsClass;
        if (method == null) {
            JSSuperMemberUtil.$$$reportNull$$$0(2);
        }
        if ((jsClass = JSResolveUtil.getClassOfContext((PsiElement)method)) == null) {
            return new Method(method);
        }
        Map<JSClass, JSPsiElementBase> map2 = JSInheritanceUtil.findDeclaringClassesMap(method);
        if (map2.isEmpty()) {
            return new Method(method);
        }
        if (map2.size() != 1 && DialectDetector.isTypeScript((PsiElement)method)) {
            Method method2 = Method.EMPTY;
            if (method2 == null) {
                JSSuperMemberUtil.$$$reportNull$$$0(3);
            }
            return method2;
        }
        Map.Entry item = (Map.Entry)ContainerUtil.getFirstItem(map2.entrySet());
        assert (item != null);
        JSClass baseClass = (JSClass)item.getKey();
        if (baseClass != null && jsClass != baseClass) {
            String desc = method instanceof JSFunction ? JSFormatUtil.formatMethod((JSFunction)method, 257, 2) : method.getName();
            String methodDesc = "'" + desc + "'";
            String message = JavaScriptBundle.message(baseClass.isInterface() ? "find.usages.of.base.interface" : "find.usages.of.base.class", methodDesc, new JSNamedElementPresenter(jsClass).describeWithQualifiedName(), new JSNamedElementPresenter(baseClass).describeWithQualifiedName(), questionText);
            return new MessageToShow(StringUtil.escapeXmlEntities((String)message).replaceAll("&#39;", "'"), (JSPsiElementBase)item.getValue());
        }
        return new Method(method);
    }

    private static /* synthetic */ Object lambda$computeCancellable$1(Supplier computable) throws RuntimeException {
        return computable.get();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/findUsages/JSSuperMemberUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/findUsages/JSSuperMemberUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findElementOrMessageToShow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeCancellable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findElementOrMessageToShow";
                break;
            }
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static interface JSFindSuperMemberResult {
    }

    private record MessageToShow(@NotNull @NlsContexts.DialogMessage String message, @NotNull JSPsiElementBase item) implements JSFindSuperMemberResult
    {
        @NotNull
        private final @NlsContexts.DialogMessage String message;
        @NotNull
        private final JSPsiElementBase item;

        private MessageToShow(@NotNull @NlsContexts.DialogMessage String message, @NotNull JSPsiElementBase item) {
            if (message == null) {
                MessageToShow.$$$reportNull$$$0(0);
            }
            if (item == null) {
                MessageToShow.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        @NlsContexts.DialogMessage
        public String message() {
            String string = this.message;
            if (string == null) {
                MessageToShow.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public JSPsiElementBase item() {
            JSPsiElementBase jSPsiElementBase = this.item;
            if (jSPsiElementBase == null) {
                MessageToShow.$$$reportNull$$$0(3);
            }
            return jSPsiElementBase;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/findUsages/JSSuperMemberUtil$MessageToShow";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/findUsages/JSSuperMemberUtil$MessageToShow";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "message";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "item";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private record Method(@Nullable JSQualifiedNamedElement method) implements JSFindSuperMemberResult
    {
        public static final Method EMPTY = new Method(null);
    }
}

