/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.psi;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.library.node_modules.NodeModulesDirectoryManager;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.typescript.settings.exclude.TypeScriptExcludeManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.util.PsiUtilCore;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class TypeScriptExcludeUtil {
    private static final Set<String> NON_VUE_LIBRARIES = Set.of("rollup");
    private static final String[] VUE_LIBRARY_DEPS = new String[]{"vue", "vue-loader", "vue-latest", "vue-template-compiler"};

    public static boolean areSourcesExcluded(@NotNull PsiElement element) {
        VirtualFile file;
        if (element == null) {
            TypeScriptExcludeUtil.$$$reportNull$$$0(0);
        }
        if ((file = PsiUtilCore.getVirtualFile((PsiElement)element)) == null) {
            return false;
        }
        Project project = element.getProject();
        return TypeScriptExcludeUtil.areSourcesExcluded(project, file);
    }

    public static boolean areSourcesExcluded(@NotNull Project project, @NotNull VirtualFile file) {
        VirtualFile json;
        if (project == null) {
            TypeScriptExcludeUtil.$$$reportNull$$$0(1);
        }
        if (file == null) {
            TypeScriptExcludeUtil.$$$reportNull$$$0(2);
        }
        if ((json = TypeScriptExcludeUtil.findPackageJsonIfExcludingEnabled(project, file)) == null) {
            return false;
        }
        PackageJsonData packageJson = PackageJsonData.getOrCreateWithPreferredProject(project, json);
        return TypeScriptExcludeUtil.arePackageSourcesExcluded(project, packageJson);
    }

    @Nullable
    public static VirtualFile findPackageJsonIfExcludingEnabled(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            TypeScriptExcludeUtil.$$$reportNull$$$0(3);
        }
        if (file == null) {
            TypeScriptExcludeUtil.$$$reportNull$$$0(4);
        }
        if (!TypeScriptExcludeUtil.checkProject(project)) {
            return null;
        }
        VirtualFile json = PackageJsonUtil.findUpPackageJson(file);
        if (json == null || !TypeScriptUtil.isUnderNodeModules(json, project)) {
            return null;
        }
        return json;
    }

    public static boolean checkProject(@NotNull Project project) {
        if (project == null) {
            TypeScriptExcludeUtil.$$$reportNull$$$0(5);
        }
        return !project.isDisposed() && !project.isDefault();
    }

    public static boolean arePackageSourcesExcluded(@NotNull Project project, @NotNull PackageJsonData packageJson) {
        String name;
        if (project == null) {
            TypeScriptExcludeUtil.$$$reportNull$$$0(6);
        }
        if (packageJson == null) {
            TypeScriptExcludeUtil.$$$reportNull$$$0(7);
        }
        if ((name = packageJson.getName()) == null || name.startsWith("@types/")) {
            return false;
        }
        TypeScriptExcludeManager settings = TypeScriptExcludeManager.getInstance(project);
        Set<String> packages = settings.getIncludedJSSourcePackages();
        if (packages.contains(name)) {
            return false;
        }
        return TypeScriptExcludeUtil.canExcludedSources(packageJson);
    }

    public static void updateSourcesForPackage(@NotNull Project project, @NotNull String packageName, boolean include) {
        if (project == null) {
            TypeScriptExcludeUtil.$$$reportNull$$$0(8);
        }
        if (packageName == null) {
            TypeScriptExcludeUtil.$$$reportNull$$$0(9);
        }
        TypeScriptExcludeManager settings = TypeScriptExcludeManager.getInstance(project);
        if (StringUtil.isEmpty((String)packageName) || !TypeScriptExcludeUtil.checkProject(project)) {
            return;
        }
        TypeScriptExcludeUtil.updateSourceForPackage(settings, packageName, include);
    }

    private static void updateSourceForPackage(@NotNull TypeScriptExcludeManager settings, @NotNull String packageName, boolean include) {
        if (settings == null) {
            TypeScriptExcludeUtil.$$$reportNull$$$0(10);
        }
        if (packageName == null) {
            TypeScriptExcludeUtil.$$$reportNull$$$0(11);
        }
        HashSet<String> packages = new HashSet<String>(settings.getIncludedJSSourcePackages());
        if (include) {
            packages.add(packageName);
        } else {
            packages.remove(packageName);
        }
        settings.setIncludedJSSourcePackages(packages);
    }

    public static boolean canExcludedSources(@NotNull PackageJsonData data) {
        String packageName;
        if (data == null) {
            TypeScriptExcludeUtil.$$$reportNull$$$0(12);
        }
        if (!NON_VUE_LIBRARIES.contains(packageName = data.getName()) && (data.containsOneOfDependencyOfAnyType(VUE_LIBRARY_DEPS) || packageName != null && packageName.startsWith("@nuxt/")) && data.getWebTypes().isEmpty()) {
            return false;
        }
        return data.hasTypings();
    }

    @NotNull
    public static PsiElement createIncludeSourcesElement(final @NotNull PsiElement context2) {
        if (context2 == null) {
            TypeScriptExcludeUtil.$$$reportNull$$$0(13);
        }
        final Project project = context2.getProject();
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)context2);
        assert (virtualFile != null);
        final String name = TypeScriptExcludeUtil.getPackageName(virtualFile);
        assert (name != null);
        return new FakePsiElement(){

            public String getName() {
                return JavaScriptBundle.message("typescript.include.js.sources.element", new Object[0]);
            }

            public PsiElement getParent() {
                return context2;
            }

            public Icon getIcon(boolean open) {
                return AllIcons.FileTypes.JavaScript;
            }

            public void navigate(boolean requestFocus) {
                if (0 != Messages.showYesNoDialog((Project)project, (String)JavaScriptBundle.message("typescript.include.js.sources.dialog.message", name), (String)JavaScriptBundle.message("typescript.include.js.sources.dialog.title", name), null)) {
                    return;
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (project.isDisposed()) {
                        return;
                    }
                    TypeScriptExcludeUtil.updateSourcesAndRefresh(project, name, true);
                    TypeScriptExcludeUtil.runGoToImplementationInWhenSmart(project);
                }, project.getDisposed());
            }
        };
    }

    private static void runGoToImplementationInWhenSmart(@NotNull Project project) {
        if (project == null) {
            TypeScriptExcludeUtil.$$$reportNull$$$0(14);
        }
        DumbService.getInstance((Project)project).runWhenSmart(() -> {
            if (project.isDisposed()) {
                return;
            }
            String actionId = "GotoImplementation";
            AnAction implementation = ActionManager.getInstance().getAction(actionId);
            if (implementation == null) {
                Logger.getInstance(TypeScriptExcludeUtil.class).error("Cannot file go to implementation action by id " + actionId);
                return;
            }
            DataManager.getInstance().getDataContextFromFocusAsync().onSuccess(data -> {
                if (project.isDisposed()) {
                    return;
                }
                AnActionEvent event = new AnActionEvent(null, data, "", new DefaultActionGroup().getTemplatePresentation(), ActionManager.getInstance(), 0);
                implementation.actionPerformed(event);
            });
        });
    }

    @TestOnly
    public static void updateSourcesAndRestore(@NotNull Disposable parent, @NotNull Project project, @NotNull String name, boolean include) {
        TypeScriptExcludeManager settings;
        Set<String> packages;
        if (parent == null) {
            TypeScriptExcludeUtil.$$$reportNull$$$0(15);
        }
        if (project == null) {
            TypeScriptExcludeUtil.$$$reportNull$$$0(16);
        }
        if (name == null) {
            TypeScriptExcludeUtil.$$$reportNull$$$0(17);
        }
        if ((packages = (settings = TypeScriptExcludeManager.getInstance(project)).getIncludedJSSourcePackages()).contains(name) == include) {
            return;
        }
        TypeScriptExcludeUtil.updateSourcesAndRefresh(project, name, include);
        Disposer.register((Disposable)parent, () -> TypeScriptExcludeUtil.updateSourceForPackage(settings, name, !include));
    }

    public static void updateSourcesAndRefresh(@NotNull Project project, @NotNull String name, boolean include) {
        if (project == null) {
            TypeScriptExcludeUtil.$$$reportNull$$$0(18);
        }
        if (name == null) {
            TypeScriptExcludeUtil.$$$reportNull$$$0(19);
        }
        TypeScriptExcludeUtil.updateSourcesForPackage(project, name, include);
        NodeModulesDirectoryManager.getInstance(project).requestLibrariesUpdate();
    }

    public static String getPackageName(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            TypeScriptExcludeUtil.$$$reportNull$$$0(20);
        }
        VirtualFile json = PackageJsonUtil.findUpPackageJson(virtualFile);
        assert (json != null);
        PackageJsonData packageJson = PackageJsonData.getOrCreate(json);
        return packageJson.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/typescript/psi/TypeScriptExcludeUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "areSourcesExcluded";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findPackageJsonIfExcludingEnabled";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkProject";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "arePackageSourcesExcluded";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "updateSourcesForPackage";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "updateSourceForPackage";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "canExcludedSources";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "createIncludeSourcesElement";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "runGoToImplementationInWhenSmart";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "updateSourcesAndRestore";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[2] = "updateSourcesAndRefresh";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "getPackageName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

