/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.inspectjs.confusing;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.util.JSParenthesesUtils;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.BaseInspectionVisitor;
import com.sixrr.inspectjs.InspectionJSBundle;
import com.sixrr.inspectjs.InspectionJSFix;
import com.sixrr.inspectjs.JavaScriptInspection;
import com.sixrr.inspectjs.utils.BoolUtils;
import org.jetbrains.annotations.NotNull;

public final class NegatedConditionalExpressionJSInspection
extends JavaScriptInspection {
    private final NegatedConditionalFix fix = new NegatedConditionalFix();

    @Override
    @InspectionMessage
    @NotNull
    protected String buildErrorString(Object ... args) {
        String string = InspectionJSBundle.message("negated.conditional.expression.error.string", new Object[0]);
        if (string == null) {
            NegatedConditionalExpressionJSInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected InspectionJSFix buildFix(PsiElement location) {
        return this.fix;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new Visitor();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/confusing/NegatedConditionalExpressionJSInspection", "buildErrorString"));
    }

    private static class NegatedConditionalFix
    extends InspectionJSFix {
        private NegatedConditionalFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = InspectionJSBundle.message("invert.condition.fix", new Object[0]);
            if (string == null) {
                NegatedConditionalFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) throws IncorrectOperationException {
            JSConditionalExpression exp = (JSConditionalExpression)descriptor.getPsiElement();
            assert (exp != null);
            JSExpression elseBranch = (JSExpression)exp.getElseBranch();
            JSExpression thenBranch = (JSExpression)exp.getThenBranch();
            JSExpression condition = exp.getCondition();
            String negatedCondition = BoolUtils.getNegatedExpressionText(condition);
            assert (elseBranch != null);
            assert (thenBranch != null);
            String newStatement = negatedCondition + "?" + elseBranch.getText() + ":" + thenBranch.getText();
            NegatedConditionalFix.replaceExpression(exp, newStatement);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/sixrr/inspectjs/confusing/NegatedConditionalExpressionJSInspection$NegatedConditionalFix", "getFamilyName"));
        }
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitJSConditionalExpression(@NotNull JSConditionalExpression exp) {
            if (exp == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super.visitJSConditionalExpression(exp);
            JSExpression condition = exp.getCondition();
            condition = JSParenthesesUtils.stripParentheses(condition);
            if (condition == null || !BoolUtils.isNegation(condition) && !this.isNotEquals(condition)) {
                return;
            }
            this.registerError((PsiElement)exp);
        }

        private boolean isNotEquals(JSExpression expression) {
            if (!(expression instanceof JSBinaryExpression)) {
                return false;
            }
            JSBinaryExpression binaryExpression = (JSBinaryExpression)expression;
            IElementType sign = binaryExpression.getOperationSign();
            return JSTokenTypes.NE.equals(sign) || JSTokenTypes.NEQEQ.equals(sign);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exp", "com/sixrr/inspectjs/confusing/NegatedConditionalExpressionJSInspection$Visitor", "visitJSConditionalExpression"));
        }
    }
}

