/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.impl;

import com.github.dockerjava.api.model.PullResponseItem;
import com.github.dockerjava.api.model.ResponseItem;
import com.intellij.docker.agent.DockerAgentProgressCallback;
import com.intellij.docker.agent.i18n.DockerAgentBundle;
import com.intellij.docker.agent.impl.OngoingProcessResultCallbackBase;
import com.intellij.docker.agent.impl.ResponseItemAggregator;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;

class PullImageResultCallbackImpl
extends OngoingProcessResultCallbackBase<PullResponseItem> {
    private static final Supplier<@Nls String> DOWNLOADING_STATUS = DockerAgentBundle.messagePointer("PullImageResultCallbackImpl.status.downloading", new Object[0]);
    private static final Supplier<@Nls String> DOWNLOAD_COMPLETE_STATUS = DockerAgentBundle.messagePointer("PullImageResultCallbackImpl.status.download.complete", new Object[0]);
    private static final Supplier<@Nls String> EXTRACTING_STATUS = DockerAgentBundle.messagePointer("PullImageResultCallbackImpl.status.extracting", new Object[0]);
    private static final Supplier<@Nls String> PULL_COMPLETE_STATUS = DockerAgentBundle.messagePointer("PullImageResultCallbackImpl.status.pull.complete", new Object[0]);
    private static final Supplier<@Nls String> PULL_CANCELLED = DockerAgentBundle.messagePointer("PullImageResultCallbackImpl.status.pull.cancelled", new Object[0]);
    private final ResponseItemAggregator myDownloads = new ResponseItemAggregator();
    private final ResponseItemAggregator myExtractions = new ResponseItemAggregator();

    PullImageResultCallbackImpl(DockerAgentProgressCallback callback2) {
        super(callback2);
    }

    @Override
    public void onNext(PullResponseItem item) {
        if (item.isPullSuccessIndicated()) {
            this.setSuccessMessage(item.getStatus());
        }
        if (item.isErrorIndicated()) {
            this.setErrorMessage(item.getErrorDetail().getMessage());
        }
        String status2 = item.getStatus();
        String id2 = item.getId();
        if (id2 != null && status2 != null) {
            if (DOWNLOADING_STATUS.get().equals(status2)) {
                this.myDownloads.updateProgress(item);
            } else if (DOWNLOAD_COMPLETE_STATUS.get().equals(status2)) {
                this.myDownloads.completeProgress(id2);
            } else if (EXTRACTING_STATUS.get().equals(status2)) {
                this.myExtractions.updateProgress(item);
            } else if (PULL_COMPLETE_STATUS.get().equals(status2)) {
                this.myDownloads.completeProgress(id2);
                this.myExtractions.completeProgress(id2);
            }
        }
        this.updateIndicator(item);
    }

    @Override
    protected void onCancel() {
        this.setSuccessMessage(PULL_CANCELLED.get());
    }

    private void updateIndicator(PullResponseItem item) {
        ResponseItem.ProgressDetail progressDetail = item.getProgressDetail();
        if (progressDetail != null) {
            ResponseItemAggregator.ProgressInfo downloadProgress = this.myDownloads.computeAggregatedProgress();
            ResponseItemAggregator.ProgressInfo extractProgress = this.myExtractions.computeAggregatedProgress();
            if (!(downloadProgress == null || downloadProgress.isCompleted() && extractProgress != null)) {
                this.getAgentCallback().step(item.getStatus(), downloadProgress.getCurrent(), downloadProgress.getTotal());
            } else if (extractProgress != null && !extractProgress.isCompleted()) {
                this.getAgentCallback().step(item.getStatus(), extractProgress.getCurrent(), extractProgress.getTotal());
            }
        }
    }
}

