/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.before;

import com.intellij.docker.before.DockerBeforeRunKt;
import com.intellij.docker.runtimes.DockerRuntime;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.impl.RunConfigurationBeforeRunProviderDelegate;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.openapi.util.Key;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/docker/before/DockerBeforeRunEnabler;", "Lcom/intellij/execution/impl/RunConfigurationBeforeRunProviderDelegate;", "<init>", "()V", "beforeRun", "", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "Companion", "intellij.clouds.docker"})
public final class DockerBeforeRunEnabler
implements RunConfigurationBeforeRunProviderDelegate {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private static final String PREFIX = Reflection.getOrCreateKotlinClass(DockerBeforeRunEnabler.class).getQualifiedName();
    @NotNull
    private static final Key<CompletableFuture<DockerRuntime>> KEY_RUNTIME_PROMISE = new Key(PREFIX + ":promise");
    @NotNull
    private static final Key<Boolean> KEY_IS_FOR_BEFORE_RUN_MARKER = new Key(PREFIX + ":key");

    public void beforeRun(@NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        RunProfile runProfile = environment.getRunProfile();
        Intrinsics.checkNotNullExpressionValue((Object)runProfile, (String)"getRunProfile(...)");
        if (DockerBeforeRunKt.asDockerRunConfiguration(runProfile) != null) {
            Executor executor = environment.getExecutor();
            Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"getExecutor(...)");
            if (DockerBeforeRunKt.isDockerCompatible(executor)) {
                environment.putUserData(KEY_IS_FOR_BEFORE_RUN_MARKER, (Object)true);
                environment.putUserData(KEY_RUNTIME_PROMISE, new CompletableFuture());
            }
        }
    }

    @JvmStatic
    @JvmName(name="isDockerBeforeRun")
    public static final boolean isDockerBeforeRun(@NotNull ExecutionEnvironment environment) {
        return Companion.isDockerBeforeRun(environment);
    }

    @JvmStatic
    @JvmName(name="getDeploymentPromise")
    @Nullable
    public static final CompletableFuture<DockerRuntime> getDeploymentPromise(@NotNull ExecutionEnvironment environment) {
        return Companion.getDeploymentPromise(environment);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0001J\u0018\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\u0006\u0010\r\u001a\u00020\u000eH\u0001R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/docker/before/DockerBeforeRunEnabler$Companion;", "", "<init>", "()V", "PREFIX", "", "KEY_RUNTIME_PROMISE", "Lcom/intellij/openapi/util/Key;", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/docker/runtimes/DockerRuntime;", "KEY_IS_FOR_BEFORE_RUN_MARKER", "", "isDockerBeforeRun", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "getDeploymentPromise", "intellij.clouds.docker"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @JvmName(name="isDockerBeforeRun")
        public final boolean isDockerBeforeRun(@NotNull ExecutionEnvironment environment) {
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
            return environment.getUserData(KEY_IS_FOR_BEFORE_RUN_MARKER) != null;
        }

        @JvmStatic
        @JvmName(name="getDeploymentPromise")
        @Nullable
        public final CompletableFuture<DockerRuntime> getDeploymentPromise(@NotNull ExecutionEnvironment environment) {
            Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
            return (CompletableFuture)environment.getUserData(KEY_RUNTIME_PROMISE);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

