/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dataWrangler.impl.view;

import com.intellij.dataWrangler.DataWranglerSessionKt;
import com.intellij.dataWrangler.executor.DataWranglerContext;
import com.intellij.dataWrangler.impl.DWTableDataViewerImpl;
import com.intellij.dataWrangler.impl.DataWranglerBundle;
import com.intellij.dataWrangler.impl.DataWranglerUiSessionImpl;
import com.intellij.dataWrangler.impl.service.DataWranglerSessionImpl;
import com.intellij.dataWrangler.impl.ui.DataWranglerUiSession;
import com.intellij.dataWrangler.impl.view.DWMainPanelKt;
import com.intellij.dataWrangler.impl.view.steps.TransformationStepsPanel;
import com.intellij.dataWrangler.impl.view.transformation.TransformationsPanel;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridPanel;
import com.intellij.database.datagrid.RemovableView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.observable.util.RevertOnDisposeUtilKt;
import com.intellij.openapi.ui.OnePixelDivider;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !2\u00020\u00012\u00020\u0002:\u0001!B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0013H\u0002J\u0006\u0010\u0017\u001a\u00020\u0013J\u0006\u0010\u0018\u001a\u00020\u0013J\u0006\u0010\u0019\u001a\u00020\u0013J\b\u0010\u001e\u001a\u00020\u0013H\u0016J\b\u0010\u001f\u001a\u00020 H\u0002R\u0012\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\u0004\u0018\u00010\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\""}, d2={"Lcom/intellij/dataWrangler/impl/view/DWMainPanel;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "Lcom/intellij/database/datagrid/RemovableView;", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "backendSession", "Lcom/intellij/dataWrangler/impl/service/DataWranglerSessionImpl;", "<init>", "(Lcom/intellij/database/datagrid/DataGrid;Lcom/intellij/dataWrangler/impl/service/DataWranglerSessionImpl;)V", "session", "Lcom/intellij/dataWrangler/impl/ui/DataWranglerUiSession;", "splitter", "Lcom/intellij/ui/OnePixelSplitter;", "transformationStepsPanel", "Lcom/intellij/dataWrangler/impl/view/steps/TransformationStepsPanel;", "transformationsPanel", "Lcom/intellij/dataWrangler/impl/view/transformation/TransformationsPanel;", "Lcom/intellij/dataWrangler/executor/DataWranglerContext;", "uiDataSnapshot", "", "sink", "Lcom/intellij/openapi/actionSystem/DataSink;", "addPanel", "showPanel", "disposePanel", "hidePanel", "viewComponent", "Ljavax/swing/JComponent;", "getViewComponent", "()Ljavax/swing/JComponent;", "onRemoved", "createDWPanelHeader", "Ljavax/swing/JPanel;", "Companion", "intellij.dataWrangler.impl"})
public final class DWMainPanel
extends SimpleToolWindowPanel
implements RemovableView {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataWranglerUiSession<?> session;
    @NotNull
    private final OnePixelSplitter splitter;
    @NotNull
    private final TransformationStepsPanel transformationStepsPanel;
    @NotNull
    private final TransformationsPanel<? extends DataWranglerContext> transformationsPanel;

    public DWMainPanel(@NotNull DataGrid grid2, @NotNull DataWranglerSessionImpl<?> backendSession) {
        Intrinsics.checkNotNullParameter((Object)grid2, (String)"grid");
        Intrinsics.checkNotNullParameter(backendSession, (String)"backendSession");
        super(true, true);
        this.session = new DataWranglerUiSessionImpl(backendSession, new DWTableDataViewerImpl(grid2));
        this.splitter = new OnePixelSplitter(true, 0.66f);
        this.transformationStepsPanel = new TransformationStepsPanel(this.session);
        this.transformationsPanel = new TransformationsPanel(this.session);
        Disposer.register((Disposable)((Disposable)grid2), (Disposable)this.session);
        Disposer.register((Disposable)this.session, () -> DWMainPanel._init_$lambda$0(backendSession));
        JPanel main = new JPanel(new BorderLayout());
        JPanel panelHeader = this.createDWPanelHeader();
        main.add((Component)panelHeader, "North");
        this.setMinimumSize(new Dimension(DWMainPanelKt.access$getMinimalLength$p(), DWMainPanelKt.access$getMinimalLength$p()));
        this.splitter.getDivider().setBackground(OnePixelDivider.BACKGROUND);
        RevertOnDisposeUtilKt.addComponent$default((Container)((Container)this.splitter), (Component)((Component)((Object)this.transformationsPanel)), null, (int)2, null);
        RevertOnDisposeUtilKt.addComponent$default((Container)((Container)this.splitter), (Component)((Component)((Object)this.transformationStepsPanel)), null, (int)2, null);
        main.add((Component)this.splitter);
        this.setContent(main);
        this.addPanel();
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        super.uiDataSnapshot(sink);
        sink.set(DWMainPanelKt.DATA_WRANGLER_KEY, (Object)this);
        sink.set(DataWranglerSessionKt.getDW_SESSION(), this.session.getBackendSession());
    }

    private final void addPanel() {
        DataGrid grid2 = this.session.getTableViewer().getGrid();
        DWMainPanel dWMainPanel = DWMainPanelKt.findDWPanel(grid2);
        if (dWMainPanel != null) {
            dWMainPanel.disposePanel();
        }
        grid2.putUserData(DWMainPanelKt.DATA_WRANGLER_GRID_KEY, (Object)this);
        this.showPanel();
    }

    public final void showPanel() {
        this.session.getTableViewer().getGrid().getPanel().putSideView((RemovableView)this, GridPanel.ViewPosition.RIGHT, null);
        this.requestFocus();
    }

    public final void disposePanel() {
        this.hidePanel();
        this.session.getTableViewer().getGrid().putUserData(DWMainPanelKt.DATA_WRANGLER_GRID_KEY, null);
        Disposer.dispose((Disposable)this.session);
    }

    public final void hidePanel() {
        DataGrid grid2 = this.session.getTableViewer().getGrid();
        this.session.getTableViewer().setColumnHighlighted(null);
        grid2.getPanel().removeSideView((RemovableView)this);
    }

    @Nullable
    public JComponent getViewComponent() {
        return this.getComponent();
    }

    public void onRemoved() {
    }

    private final JPanel createDWPanelHeader() {
        JPanel topPanel;
        JPanel jPanel;
        ActionManager actionManager = ActionManager.getInstance();
        AnAction action = actionManager.getAction("DataWrangler.Hide.Panel");
        ActionToolbar actionToolbar = new ActionToolbar[]{action};
        ActionToolbar $this$createDWPanelHeader_u24lambda_u241 = actionToolbar = actionManager.createActionToolbar("TransformToolbar", (ActionGroup)new DefaultActionGroup((AnAction[])actionToolbar), true);
        boolean bl = false;
        $this$createDWPanelHeader_u24lambda_u241.getComponent().setBorder(IdeBorderFactory.createEmptyBorder((Insets)((Insets)JBUI.insets((int)10))));
        $this$createDWPanelHeader_u24lambda_u241.setLayoutPolicy(0);
        ActionToolbar actionToolbar2 = actionToolbar;
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar2, (String)"apply(...)");
        ActionToolbar toolbar = actionToolbar2;
        toolbar.setTargetComponent(this.getViewComponent());
        String topPanelName = "<html><b>" + DataWranglerBundle.message("DataWrangler.main.panel.name", new Object[0]) + "</b></html>";
        ActionToolbar $this$createDWPanelHeader_u24lambda_u242 = $this$createDWPanelHeader_u24lambda_u241 = new JBLabel(topPanelName);
        boolean bl2 = false;
        $this$createDWPanelHeader_u24lambda_u242.setBorder(IdeBorderFactory.createEmptyBorder((Insets)((Insets)JBUI.insets((int)10))));
        ActionToolbar topPanelLabel = $this$createDWPanelHeader_u24lambda_u241;
        JPanel $this$createDWPanelHeader_u24lambda_u243 = jPanel = new JPanel(new BorderLayout());
        boolean bl3 = false;
        $this$createDWPanelHeader_u24lambda_u243.setBorder(IdeBorderFactory.createBorder((int)8));
        JPanel $this$createDWPanelHeader_u24lambda_u244 = jPanel = (topPanel = jPanel);
        boolean bl4 = false;
        $this$createDWPanelHeader_u24lambda_u244.add((Component)toolbar.getComponent(), "East");
        $this$createDWPanelHeader_u24lambda_u244.add((Component)topPanelLabel, "West");
        return jPanel;
    }

    private static final void _init_$lambda$0(DataWranglerSessionImpl $backendSession) {
        $backendSession.dispose();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/dataWrangler/impl/view/DWMainPanel$Companion;", "", "<init>", "()V", "createPanel", "Ljavax/swing/JPanel;", "panelTitle", "", "toolbarPlaceName", "actionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "intellij.dataWrangler.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JPanel createPanel(@NlsContexts.Label @NotNull String panelTitle, @NotNull String toolbarPlaceName, @NotNull ActionGroup actionGroup) {
            ActionToolbar actionToolbar;
            Intrinsics.checkNotNullParameter((Object)panelTitle, (String)"panelTitle");
            Intrinsics.checkNotNullParameter((Object)toolbarPlaceName, (String)"toolbarPlaceName");
            Intrinsics.checkNotNullParameter((Object)actionGroup, (String)"actionGroup");
            JBLabel jBLabel = new JBLabel(panelTitle);
            Object $this$createPanel_u24lambda_u240 = jBLabel;
            boolean bl = false;
            $this$createPanel_u24lambda_u240.setForeground((Color)JBColor.GRAY);
            JBLabel topPanelTitle = jBLabel;
            Object $this$createPanel_u24lambda_u241 = $this$createPanel_u24lambda_u240 = new JPanel(new BorderLayout());
            boolean bl2 = false;
            ((JComponent)$this$createPanel_u24lambda_u241).setBorder((Border)new JBEmptyBorder(UIUtil.PANEL_REGULAR_INSETS));
            Object topPanel = $this$createPanel_u24lambda_u240;
            ActionToolbar $this$createPanel_u24lambda_u242 = actionToolbar = ActionManager.getInstance().createActionToolbar(toolbarPlaceName, actionGroup, true);
            boolean bl3 = false;
            $this$createPanel_u24lambda_u242.getComponent().setBorder(null);
            $this$createPanel_u24lambda_u242.setLayoutPolicy(0);
            ActionToolbar actionToolbar2 = actionToolbar;
            Intrinsics.checkNotNullExpressionValue((Object)actionToolbar2, (String)"apply(...)");
            ActionToolbar toolbar = actionToolbar2;
            ((Container)topPanel).add((Component)topPanelTitle, "West");
            toolbar.setTargetComponent((JComponent)topPanel);
            ((Container)topPanel).add((Component)toolbar.getComponent(), "East");
            return topPanel;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

