/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dataWrangler.jupyterPython.cell;

import com.intellij.dataWrangler.jupyterPython.cell.JupyterDataWranglerCellMetadata;
import com.intellij.dataWrangler.jupyterPython.cell.JupyterDataWranglerCellMetadataKt;
import com.intellij.dataWrangler.jupyterPython.cell.JupyterDataWranglerCellSettings;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterCell;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookConverter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.psi.jupyter.nbformat.JupyterCellType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/dataWrangler/jupyterPython/cell/JupyterNotebookDataWranglerCellConverter;", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebookConverter;", "<init>", "()V", "convertAfterLoading", "", "notebook", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "convertBeforeSave", "notebookCopy", "intellij.dataWrangler.jupyterPython"})
final class JupyterNotebookDataWranglerCellConverter
implements JupyterNotebookConverter {
    public void convertAfterLoading(@NotNull JupyterNotebook notebook) {
        Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
        if (!JupyterDataWranglerCellSettings.INSTANCE.isEnabled()) {
            return;
        }
        for (JupyterCell cell : notebook.computeCells()) {
            JupyterDataWranglerCellMetadata metadata;
            if (cell.getCellType() != JupyterCellType.CODE || JupyterDataWranglerCellMetadataKt.getDataWranglerMetadata(cell) == null) continue;
            String string = metadata.getSource();
            if (string == null) {
                string = "";
            }
            if (Intrinsics.areEqual((Object)string, (Object)cell.getSource())) {
                cell.setCellType(JupyterCellType.DATA_WRANGLER);
                cell.setSource("");
                continue;
            }
            JupyterDataWranglerCellMetadataKt.setDataWranglerMetadata(cell, null);
        }
    }

    public void convertBeforeSave(@NotNull JupyterNotebook notebookCopy) {
        Intrinsics.checkNotNullParameter((Object)notebookCopy, (String)"notebookCopy");
        if (!JupyterDataWranglerCellSettings.INSTANCE.isEnabled()) {
            return;
        }
        for (JupyterCell cell : notebookCopy.computeCells()) {
            if (cell.getCellType() != JupyterCellType.DATA_WRANGLER) continue;
            cell.setCellType(JupyterCellType.CODE);
            JupyterDataWranglerCellMetadata metadata = JupyterDataWranglerCellMetadataKt.getDataWranglerMetadataOrDefault(cell);
            String string = metadata.getSource();
            if (string == null) {
                string = "";
            }
            cell.setSource(string);
        }
    }
}

