/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.jba;

import com.intellij.CommonBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.RevealFileAction;
import com.intellij.ide.actions.ShowLogAction;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.settingsSync.core.SettingsSnapshot;
import com.intellij.settingsSync.core.SettingsSnapshotKt;
import com.intellij.settingsSync.core.SettingsSyncLocalSettings;
import com.intellij.settingsSync.core.SettingsSyncMainKt;
import com.intellij.settingsSync.core.SettingsSyncRemoteCommunicator;
import com.intellij.settingsSync.core.SettingsSyncSettings;
import com.intellij.settingsSync.core.communicator.RemoteCommunicatorHolder;
import com.intellij.settingsSync.core.communicator.SettingsSyncUserData;
import com.intellij.settingsSync.jba.CloudConfigServerCommunicator;
import com.intellij.settingsSync.jba.SettingsSyncJbaBundle;
import com.intellij.settingsSync.jba.SettingsSyncTroubleshootingActionKt;
import com.intellij.settingsSync.jba.auth.JBAAuthService;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ExtensionsKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowLayout;
import com.intellij.util.io.Compressor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.cloudconfig.CloudConfigFileClientV2;
import com.jetbrains.cloudconfig.FileVersionInfo;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0004\u0018\u0019\u001a\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0002J \u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u001c"}, d2={"Lcom/intellij/settingsSync/jba/SettingsSyncTroubleshootingAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "collectFileStructure", "Lcom/intellij/settingsSync/jba/SettingsSyncTroubleshootingAction$TreeNode$Root;", "remoteCommunicator", "Lcom/intellij/settingsSync/jba/CloudConfigServerCommunicator;", "processFileOrDir", "Lcom/intellij/settingsSync/jba/SettingsSyncTroubleshootingAction$TreeNode;", "path", "", "getVersion", "Lcom/intellij/settingsSync/jba/SettingsSyncTroubleshootingAction$Version;", "filePath", "version", "Lcom/jetbrains/cloudconfig/FileVersionInfo;", "Version", "TreeNode", "TroubleshootingDialog", "Companion", "intellij.settingsSync"})
@SourceDebugExtension(value={"SMAP\nSettingsSyncTroubleshootingAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsSyncTroubleshootingAction.kt\ncom/intellij/settingsSync/jba/SettingsSyncTroubleshootingAction\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,443:1\n15#2:444\n*S KotlinDebug\n*F\n+ 1 SettingsSyncTroubleshootingAction.kt\ncom/intellij/settingsSync/jba/SettingsSyncTroubleshootingAction\n*L\n405#1:444\n*E\n"})
public final class SettingsSyncTroubleshootingAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setEnabledAndVisible(SettingsSyncMainKt.isSettingsSyncEnabledInSettings() && RemoteCommunicatorHolder.INSTANCE.getAuthService() instanceof JBAAuthService);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            SettingsSyncRemoteCommunicator settingsSyncRemoteCommunicator = RemoteCommunicatorHolder.INSTANCE.getRemoteCommunicator();
            if (settingsSyncRemoteCommunicator == null) {
                SettingsSyncTroubleshootingAction $this$actionPerformed_u24lambda_u240 = this;
                boolean bl = false;
                Messages.showErrorDialog((Project)e.getProject(), (String)SettingsSyncJbaBundle.INSTANCE.message("troubleshooting.dialog.error.download.file.failed", new Object[0]), (String)SettingsSyncJbaBundle.INSTANCE.message("troubleshooting.dialog.title", new Object[0]));
                return;
            }
            SettingsSyncRemoteCommunicator remoteCommunicator = settingsSyncRemoteCommunicator;
            if (!(remoteCommunicator instanceof CloudConfigServerCommunicator)) {
                Object[] objectArray = new Object[]{Reflection.getOrCreateKotlinClass(remoteCommunicator.getClass())};
                Messages.showErrorDialog((Project)e.getProject(), (String)SettingsSyncJbaBundle.INSTANCE.message("troubleshooting.dialog.error.wrong.configuration", objectArray), (String)SettingsSyncJbaBundle.INSTANCE.message("troubleshooting.dialog.title", new Object[0]));
                return;
            }
            try {
                TreeNode.Root fileStructure = (TreeNode.Root)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> SettingsSyncTroubleshootingAction.actionPerformed$lambda$1(this, remoteCommunicator), SettingsSyncJbaBundle.INSTANCE.message("troubleshooting.loading.info.progress.dialog.title", new Object[0]), false, e.getProject());
                Project project = e.getProject();
                CloudConfigServerCommunicator cloudConfigServerCommunicator = (CloudConfigServerCommunicator)remoteCommunicator;
                Intrinsics.checkNotNull((Object)fileStructure);
                new TroubleshootingDialog(project, cloudConfigServerCommunicator, fileStructure).show();
            }
            catch (Exception ex) {
                LOG.error((Throwable)ex);
                if (Messages.showOkCancelDialog((Project)e.getProject(), (String)SettingsSyncJbaBundle.INSTANCE.message("troubleshooting.dialog.error.check.log.file.for.errors", new Object[0]), (String)SettingsSyncJbaBundle.INSTANCE.message("troubleshooting.dialog.error.loading.info.failed", new Object[0]), (String)ShowLogAction.getActionName(), (String)CommonBundle.getCancelButtonText(), null) != 0) break block4;
                ShowLogAction.showLog();
            }
        }
    }

    private final TreeNode.Root collectFileStructure(CloudConfigServerCommunicator remoteCommunicator) {
        TreeNode treeNode = this.processFileOrDir("/", remoteCommunicator);
        Intrinsics.checkNotNull((Object)treeNode, (String)"null cannot be cast to non-null type com.intellij.settingsSync.jba.SettingsSyncTroubleshootingAction.TreeNode.Root");
        return (TreeNode.Root)treeNode;
    }

    private final TreeNode processFileOrDir(String path, CloudConfigServerCommunicator remoteCommunicator) {
        CloudConfigFileClientV2 client = remoteCommunicator.getClient$intellij_settingsSync();
        try {
            List<String> children = client.list(path);
            if (children.isEmpty()) {
                if (Intrinsics.areEqual((Object)path, (Object)"/")) {
                    return new TreeNode.Root(CollectionsKt.emptyList());
                }
                FileVersionInfo fileVersion = client.getLatestVersion(path);
                Intrinsics.checkNotNull((Object)fileVersion);
                Version version = this.getVersion(path, fileVersion, remoteCommunicator);
                return new TreeNode.Leaf(version);
            }
            List childNodes = new ArrayList();
            for (String child : children) {
                Object object;
                if (Intrinsics.areEqual((Object)path, (Object)"/")) {
                    object = child;
                } else {
                    char[] cArray = new char[]{'/'};
                    object = StringsKt.trim((String)path, (char[])cArray) + "/" + child;
                }
                String childPath = object;
                Collection collection = childNodes;
                Intrinsics.checkNotNull((Object)childPath);
                collection.add(this.processFileOrDir(childPath, remoteCommunicator));
            }
            return Intrinsics.areEqual((Object)path, (Object)"/") ? (TreeNode)new TreeNode.Root(childNodes) : (TreeNode)new TreeNode.Branch(childNodes);
        }
        catch (FileNotFoundException e) {
            FileVersionInfo fileVersion = client.getLatestVersion(path);
            Intrinsics.checkNotNull((Object)fileVersion);
            Version version = this.getVersion(path, fileVersion, remoteCommunicator);
            return new TreeNode.Leaf(version);
        }
    }

    private final Version getVersion(String filePath, FileVersionInfo version, CloudConfigServerCommunicator remoteCommunicator) {
        InputStream inputStream = remoteCommunicator.downloadSnapshot(filePath, version);
        Intrinsics.checkNotNull((Object)inputStream);
        InputStream stream = inputStream;
        if (StringsKt.endsWith$default((String)filePath, (String)".zip", (boolean)false, (int)2, null)) {
            return new Version(filePath, version, SettingsSyncTroubleshootingActionKt.access$extractSnapshotFromZipStream(stream));
        }
        return new Version(filePath, version, null);
    }

    private static final TreeNode.Root actionPerformed$lambda$1(SettingsSyncTroubleshootingAction this$0, SettingsSyncRemoteCommunicator $remoteCommunicator) {
        return this$0.collectFileStructure((CloudConfigServerCommunicator)$remoteCommunicator);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SettingsSyncTroubleshootingAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/settingsSync/jba/SettingsSyncTroubleshootingAction$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.settingsSync"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLOG() {
            return LOG;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b2\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0007\b\u00a8\u0006\t"}, d2={"Lcom/intellij/settingsSync/jba/SettingsSyncTroubleshootingAction$TreeNode;", "", "<init>", "()V", "Branch", "Root", "Leaf", "Lcom/intellij/settingsSync/jba/SettingsSyncTroubleshootingAction$TreeNode$Branch;", "Lcom/intellij/settingsSync/jba/SettingsSyncTroubleshootingAction$TreeNode$Leaf;", "intellij.settingsSync"})
    private static abstract class TreeNode {
        private TreeNode() {
        }

        public /* synthetic */ TreeNode(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/settingsSync/jba/SettingsSyncTroubleshootingAction$TreeNode$Branch;", "Lcom/intellij/settingsSync/jba/SettingsSyncTroubleshootingAction$TreeNode;", "children", "", "<init>", "(Ljava/util/List;)V", "getChildren", "()Ljava/util/List;", "intellij.settingsSync"})
        public static class Branch
        extends TreeNode {
            @NotNull
            private final List<TreeNode> children;

            public Branch(@NotNull List<? extends TreeNode> children) {
                Intrinsics.checkNotNullParameter(children, (String)"children");
                super(null);
                this.children = children;
            }

            @NotNull
            public final List<TreeNode> getChildren() {
                return this.children;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/settingsSync/jba/SettingsSyncTroubleshootingAction$TreeNode$Leaf;", "Lcom/intellij/settingsSync/jba/SettingsSyncTroubleshootingAction$TreeNode;", "version", "Lcom/intellij/settingsSync/jba/SettingsSyncTroubleshootingAction$Version;", "<init>", "(Lcom/intellij/settingsSync/jba/SettingsSyncTroubleshootingAction$Version;)V", "getVersion", "()Lcom/intellij/settingsSync/jba/SettingsSyncTroubleshootingAction$Version;", "intellij.settingsSync"})
        public static final class Leaf
        extends TreeNode {
            @NotNull
            private final Version version;

            public Leaf(@NotNull Version version) {
                Intrinsics.checkNotNullParameter((Object)version, (String)"version");
                super(null);
                this.version = version;
            }

            @NotNull
            public final Version getVersion() {
                return this.version;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/intellij/settingsSync/jba/SettingsSyncTroubleshootingAction$TreeNode$Root;", "Lcom/intellij/settingsSync/jba/SettingsSyncTroubleshootingAction$TreeNode$Branch;", "children", "", "Lcom/intellij/settingsSync/jba/SettingsSyncTroubleshootingAction$TreeNode;", "<init>", "(Ljava/util/List;)V", "intellij.settingsSync"})
        public static final class Root
        extends Branch {
            public Root(@NotNull List<? extends TreeNode> children) {
                Intrinsics.checkNotNullParameter(children, (String)"children");
                super(children);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0002\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0013\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0014\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\f\u0010 \u001a\u00020!*\u00020\u001dH\u0002J\f\u0010\"\u001a\u00020!*\u00020\u001dH\u0002J\u0016\u0010#\u001a\u00020!*\u00020\u001d2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0016\u0010$\u001a\u00020!*\u00020\u001d2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\f\u0010%\u001a\u00020\u001b*\u00020\u001dH\u0002J\u0011\u0010&\u001a\u00070'\u00a2\u0006\u0002\b(*\u00020'H\u0002J$\u0010)\u001a\u00020!*\u00020\u001d2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-H\u0002J\u001a\u0010/\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020+2\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0002J\u001a\u00100\u001a\u00020\u001b2\u0006\u00101\u001a\u0002022\b\b\u0001\u00103\u001a\u00020'H\u0002J*\u00104\u001a\u00020\u001b2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u00105\u001a\u00020'2\u0006\u00106\u001a\u00020'H\u0002J0\u00107\u001a\u00020\u001b2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u00108\u001a\b\u0012\u0004\u0012\u00020+092\u0006\u00106\u001a\u00020'H\u0002J\"\u0010:\u001a\u00020\u001b2\b\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u00105\u001a\u00020'H\u0002J\u001e\u0010;\u001a\b\u0012\u0004\u0012\u00020=0<*\u00020!2\n\b\u0001\u0010>\u001a\u0004\u0018\u00010?H\u0002R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006@"}, d2={"Lcom/intellij/settingsSync/jba/SettingsSyncTroubleshootingAction$TroubleshootingDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "remoteCommunicator", "Lcom/intellij/settingsSync/jba/CloudConfigServerCommunicator;", "rootNode", "Lcom/intellij/settingsSync/jba/SettingsSyncTroubleshootingAction$TreeNode$Branch;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/settingsSync/jba/CloudConfigServerCommunicator;Lcom/intellij/settingsSync/jba/SettingsSyncTroubleshootingAction$TreeNode$Branch;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRemoteCommunicator", "()Lcom/intellij/settingsSync/jba/CloudConfigServerCommunicator;", "getRootNode", "()Lcom/intellij/settingsSync/jba/SettingsSyncTroubleshootingAction$TreeNode$Branch;", "userData", "Lcom/intellij/settingsSync/core/communicator/SettingsSyncUserData;", "getUserData", "()Lcom/intellij/settingsSync/core/communicator/SettingsSyncUserData;", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "createCenterPanel", "Ljavax/swing/JComponent;", "generateFileSubTree", "", "panel", "Lcom/intellij/ui/dsl/builder/Panel;", "node", "Lcom/intellij/settingsSync/jba/SettingsSyncTroubleshootingAction$TreeNode;", "statusRow", "Lcom/intellij/ui/dsl/builder/Row;", "serverUrlRow", "loginNameRow", "emailRow", "appInfoRow", "shorten", "", "Lorg/jetbrains/annotations/NotNull;", "versionRow", "version", "Lcom/intellij/settingsSync/jba/SettingsSyncTroubleshootingAction$Version;", "showHistoryButton", "", "showDeleteButton", "downloadVersion", "showFileDownloadedMessage", "file", "Ljava/io/File;", "message", "showHistoryDialog", "filePath", "loginName", "downloadFullHistory", "history", "", "deleteFile", "copyableLabel", "Lcom/intellij/ui/dsl/builder/Cell;", "Lcom/intellij/ui/components/JBLabel;", "text", "", "intellij.settingsSync"})
    @SourceDebugExtension(value={"SMAP\nSettingsSyncTroubleshootingAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SettingsSyncTroubleshootingAction.kt\ncom/intellij/settingsSync/jba/SettingsSyncTroubleshootingAction$TroubleshootingDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,443:1\n1#2:444\n1567#3:445\n1598#3,4:446\n*S KotlinDebug\n*F\n+ 1 SettingsSyncTroubleshootingAction.kt\ncom/intellij/settingsSync/jba/SettingsSyncTroubleshootingAction$TroubleshootingDialog\n*L\n318#1:445\n318#1:446,4\n*E\n"})
    private static final class TroubleshootingDialog
    extends DialogWrapper {
        @Nullable
        private final Project project;
        @NotNull
        private final CloudConfigServerCommunicator remoteCommunicator;
        @NotNull
        private final TreeNode.Branch rootNode;
        @Nullable
        private final SettingsSyncUserData userData;

        public TroubleshootingDialog(@Nullable Project project, @NotNull CloudConfigServerCommunicator remoteCommunicator, @NotNull TreeNode.Branch rootNode) {
            Intrinsics.checkNotNullParameter((Object)remoteCommunicator, (String)"remoteCommunicator");
            Intrinsics.checkNotNullParameter((Object)rootNode, (String)"rootNode");
            super(project, true);
            this.project = project;
            this.remoteCommunicator = remoteCommunicator;
            this.rootNode = rootNode;
            this.userData = RemoteCommunicatorHolder.INSTANCE.getCurrentUserData();
            this.setTitle(SettingsSyncJbaBundle.INSTANCE.message("troubleshooting.dialog.title", new Object[0]));
            this.init();
        }

        @Nullable
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final CloudConfigServerCommunicator getRemoteCommunicator() {
            return this.remoteCommunicator;
        }

        @NotNull
        public final TreeNode.Branch getRootNode() {
            return this.rootNode;
        }

        @Nullable
        public final SettingsSyncUserData getUserData() {
            return this.userData;
        }

        @NotNull
        protected Action[] createActions() {
            this.setCancelButtonText(CommonBundle.getCloseButtonText());
            this.getCancelAction().putValue("DefaultAction", true);
            Action[] actionArray = new Action[]{this.getCancelAction()};
            return actionArray;
        }

        @NotNull
        protected JComponent createCenterPanel() {
            return (JComponent)BuilderKt.panel(arg_0 -> TroubleshootingDialog.createCenterPanel$lambda$1(this, arg_0));
        }

        private final void generateFileSubTree(Panel panel, TreeNode node) {
            TreeNode treeNode = node;
            if (treeNode instanceof TreeNode.Root) {
                TroubleshootingDialog.generateFileSubTree$generateSubTreesForChildren(this, panel, (TreeNode.Branch)node);
                v0 = Unit.INSTANCE;
            } else if (treeNode instanceof TreeNode.Branch) {
                v0 = panel.indent(arg_0 -> TroubleshootingDialog.generateFileSubTree$lambda$2(node, this, panel, arg_0));
            } else if (treeNode instanceof TreeNode.Leaf) {
                boolean itIsSettingsSnapshotFile = StringsKt.endsWith$default((String)((TreeNode.Leaf)node).getVersion().getFilePath(), (String)".zip", (boolean)false, (int)2, null);
                v0 = this.versionRow(panel, ((TreeNode.Leaf)node).getVersion(), itIsSettingsSnapshotFile, true);
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }

        private final Row statusRow(Panel $this$statusRow) {
            return Panel.row$default((Panel)$this$statusRow, null, TroubleshootingDialog::statusRow$lambda$3, (int)1, null).layout(RowLayout.PARENT_GRID);
        }

        private final Row serverUrlRow(Panel $this$serverUrlRow) {
            return Panel.row$default((Panel)$this$serverUrlRow, null, arg_0 -> TroubleshootingDialog.serverUrlRow$lambda$4(this, arg_0), (int)1, null).layout(RowLayout.PARENT_GRID);
        }

        private final Row loginNameRow(Panel $this$loginNameRow, SettingsSyncUserData userData) {
            return Panel.row$default((Panel)$this$loginNameRow, null, arg_0 -> TroubleshootingDialog.loginNameRow$lambda$5(this, userData, arg_0), (int)1, null).layout(RowLayout.PARENT_GRID);
        }

        private final Row emailRow(Panel $this$emailRow, SettingsSyncUserData userData) {
            return Panel.row$default((Panel)$this$emailRow, null, arg_0 -> TroubleshootingDialog.emailRow$lambda$6(this, userData, arg_0), (int)1, null).layout(RowLayout.PARENT_GRID);
        }

        private final void appInfoRow(Panel $this$appInfoRow) {
            SettingsSnapshot.AppInfo appInfo = SettingsSnapshotKt.getLocalApplicationInfo();
            Panel.row$default((Panel)$this$appInfoRow, null, arg_0 -> TroubleshootingDialog.appInfoRow$lambda$7(this, appInfo, arg_0), (int)1, null).layout(RowLayout.PARENT_GRID);
            Panel.row$default((Panel)$this$appInfoRow, null, arg_0 -> TroubleshootingDialog.appInfoRow$lambda$8(this, appInfo, arg_0), (int)1, null).layout(RowLayout.PARENT_GRID);
            Panel.row$default((Panel)$this$appInfoRow, null, arg_0 -> TroubleshootingDialog.appInfoRow$lambda$9(this, appInfo, arg_0), (int)1, null).layout(RowLayout.PARENT_GRID);
            Panel.row$default((Panel)$this$appInfoRow, null, arg_0 -> TroubleshootingDialog.appInfoRow$lambda$10(this, appInfo, arg_0), (int)1, null).layout(RowLayout.PARENT_GRID);
        }

        private final String shorten(String $this$shorten) {
            String string = StringUtil.shortenTextWithEllipsis((String)$this$shorten, (int)12, (int)5, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenTextWithEllipsis(...)");
            return string;
        }

        private final Row versionRow(Panel $this$versionRow, Version version, boolean showHistoryButton, boolean showDeleteButton) {
            return Panel.row$default((Panel)$this$versionRow, null, arg_0 -> TroubleshootingDialog.versionRow$lambda$13(version, this, showHistoryButton, showDeleteButton, arg_0), (int)1, null);
        }

        private final void downloadVersion(Version version, Project project) {
            File file = (File)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> TroubleshootingDialog.downloadVersion$lambda$14(version, this), SettingsSyncJbaBundle.INSTANCE.message("troubleshooting.dialog.downloading.settings.from.server.progress.title", new Object[0]), false, project);
            if (file != null) {
                this.showFileDownloadedMessage(file, SettingsSyncJbaBundle.INSTANCE.message("troubleshooting.dialog.successfully.downloaded.message", new Object[0]));
            } else if (Messages.showOkCancelDialog((Component)this.getContentPane(), (String)SettingsSyncJbaBundle.INSTANCE.message("troubleshooting.dialog.error.check.log.file.for.errors", new Object[0]), (String)SettingsSyncJbaBundle.INSTANCE.message("troubleshooting.dialog.error.download.file.failed", new Object[0]), (String)ShowLogAction.getActionName(), (String)CommonBundle.getCancelButtonText(), null) == 0) {
                ShowLogAction.showLog();
            }
        }

        private final void showFileDownloadedMessage(File file, @Nls String message) {
            if (Messages.showOkCancelDialog((Component)this.getContentPane(), (String)message, (String)"", (String)RevealFileAction.getActionName(), (String)CommonBundle.getCancelButtonText(), null) == 0) {
                RevealFileAction.openFile((File)file);
            }
        }

        private final void showHistoryDialog(Project project, CloudConfigServerCommunicator remoteCommunicator, String filePath, String loginName) {
            List history = (List)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> TroubleshootingDialog.showHistoryDialog$lambda$16(remoteCommunicator, filePath), SettingsSyncJbaBundle.INSTANCE.message("troubleshooting.fetching.history.progress.title", new Object[0]), false, project);
            Object[] objectArray = new Object[]{filePath};
            DialogBuilder dialogBuilder = new DialogBuilder((Component)this.getContentPane()).title(SettingsSyncJbaBundle.INSTANCE.message("troubleshooting.settings.history.dialog.title", objectArray));
            Intrinsics.checkNotNullExpressionValue((Object)dialogBuilder, (String)"title(...)");
            DialogBuilder dialogBuilder2 = dialogBuilder;
            DialogPanel historyPanel = (DialogPanel)BuilderKt.panel(arg_0 -> TroubleshootingDialog.showHistoryDialog$lambda$17(history, this, arg_0)).withBorder((Border)JBUI.Borders.empty((int)4, (int)10, (int)4, (int)10));
            JButton button = new JButton(SettingsSyncJbaBundle.INSTANCE.message("troubleshooting.dialog.download.full.history.button", new Object[0]));
            button.addActionListener(arg_0 -> TroubleshootingDialog.showHistoryDialog$lambda$18(this, project, remoteCommunicator, history, loginName, arg_0));
            JBScrollPane scrollPanel = new JBScrollPane((Component)historyPanel, 20, 30);
            BorderLayoutPanel borderLayoutPanel = JBUI.Panels.simplePanel();
            Intrinsics.checkNotNullExpressionValue((Object)borderLayoutPanel, (String)"simplePanel(...)");
            BorderLayoutPanel mainPanel = borderLayoutPanel;
            mainPanel.add((Component)scrollPanel, (Object)"Center");
            mainPanel.add((Component)button, (Object)"South");
            dialogBuilder2.centerPanel((JComponent)mainPanel);
            dialogBuilder2.addCloseButton();
            dialogBuilder2.show();
        }

        private final void downloadFullHistory(Project project, CloudConfigServerCommunicator remoteCommunicator, List<Version> history, String loginName) {
            File compoundZip = (File)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> TroubleshootingDialog.downloadFullHistory$lambda$20(loginName, history, remoteCommunicator), SettingsSyncJbaBundle.INSTANCE.message("troubleshooting.fetching.history.progress.title", new Object[0]), true, project);
            Intrinsics.checkNotNull((Object)compoundZip);
            this.showFileDownloadedMessage(compoundZip, SettingsSyncJbaBundle.INSTANCE.message("troubleshooting.dialog.download.full.history.success.message", new Object[0]));
        }

        private final void deleteFile(Project project, CloudConfigServerCommunicator remoteCommunicator, String filePath) {
            int choice = Messages.showOkCancelDialog((Component)this.getContentPane(), (String)SettingsSyncJbaBundle.INSTANCE.message("troubleshooting.dialog.delete.confirmation.message", new Object[0]), (String)SettingsSyncJbaBundle.INSTANCE.message("troubleshooting.dialog.delete.confirmation.title", new Object[0]), (String)IdeBundle.message((String)"button.delete", (Object[])new Object[0]), (String)CommonBundle.getCancelButtonText(), null);
            if (choice == 0) {
                try {
                    Unit cfr_ignored_0 = (Unit)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> TroubleshootingDialog.deleteFile$lambda$21(remoteCommunicator, filePath), SettingsSyncJbaBundle.INSTANCE.message("troubleshooting.delete.file.from.server.progress.title", new Object[0]), false, project);
                }
                catch (Exception e) {
                    Companion.getLOG().warn("Couldn't delete " + filePath + " from server", (Throwable)e);
                    Messages.showErrorDialog((Component)this.getContentPane(), (String)e.getMessage(), (String)SettingsSyncJbaBundle.INSTANCE.message("troubleshooting.dialog.delete.confirmation.title", new Object[0]));
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final Cell<JBLabel> copyableLabel(Row $this$copyableLabel, @NlsSafe Object text) {
            void $this$copyableLabel_u24lambda_u2422;
            JBLabel jBLabel;
            JBLabel jBLabel2 = jBLabel = new JBLabel(String.valueOf(text));
            Row row = $this$copyableLabel;
            boolean bl = false;
            $this$copyableLabel_u24lambda_u2422.setCopyable(true);
            return row.cell((JComponent)jBLabel);
        }

        private static final Unit createCenterPanel$lambda$1$lambda$0(Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            return Unit.INSTANCE;
        }

        private static final Unit createCenterPanel$lambda$1(TroubleshootingDialog this$0, Panel $this$panel) {
            Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
            this$0.statusRow($this$panel);
            this$0.serverUrlRow($this$panel);
            this$0.loginNameRow($this$panel, this$0.userData);
            this$0.emailRow($this$panel, this$0.userData);
            this$0.appInfoRow($this$panel);
            $this$panel.row(SettingsSyncJbaBundle.INSTANCE.message("troubleshooting.dialog.files", new Object[0]), TroubleshootingDialog::createCenterPanel$lambda$1$lambda$0);
            this$0.generateFileSubTree($this$panel, this$0.rootNode);
            return Unit.INSTANCE;
        }

        private static final void generateFileSubTree$generateSubTreesForChildren(TroubleshootingDialog this$0, Panel $panel, TreeNode.Branch node) {
            for (TreeNode child : node.getChildren()) {
                this$0.generateFileSubTree($panel, child);
            }
        }

        private static final Unit generateFileSubTree$lambda$2(TreeNode $node, TroubleshootingDialog this$0, Panel $panel, Panel $this$indent) {
            Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
            TroubleshootingDialog.generateFileSubTree$generateSubTreesForChildren(this$0, $panel, (TreeNode.Branch)$node);
            return Unit.INSTANCE;
        }

        private static final Unit statusRow$lambda$3(Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            $this$row.label(SettingsSyncJbaBundle.INSTANCE.message("troubleshooting.dialog.local.status.label", new Object[0]));
            String string = SettingsSyncSettings.Companion.getInstance().getSyncEnabled() ? IdeBundle.message((String)"plugins.configurable.enabled", (Object[])new Object[0]) : IdeBundle.message((String)"plugins.configurable.disabled", (Object[])new Object[0]);
            Intrinsics.checkNotNull((Object)string);
            $this$row.label(string);
            return Unit.INSTANCE;
        }

        private static final Unit serverUrlRow$lambda$4(TroubleshootingDialog this$0, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            $this$row.label(SettingsSyncJbaBundle.INSTANCE.message("troubleshooting.dialog.server.url.label", new Object[0]));
            this$0.copyableLabel($this$row, CloudConfigServerCommunicator.Companion.getDefaultUrl$intellij_settingsSync());
            return Unit.INSTANCE;
        }

        private static final Unit loginNameRow$lambda$5(TroubleshootingDialog this$0, SettingsSyncUserData $userData, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            $this$row.label(SettingsSyncJbaBundle.INSTANCE.message("troubleshooting.dialog.login.label", new Object[0]));
            SettingsSyncUserData settingsSyncUserData = $userData;
            this$0.copyableLabel($this$row, settingsSyncUserData != null ? settingsSyncUserData.getName() : null);
            return Unit.INSTANCE;
        }

        private static final Unit emailRow$lambda$6(TroubleshootingDialog this$0, SettingsSyncUserData $userData, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            $this$row.label(SettingsSyncJbaBundle.INSTANCE.message("troubleshooting.dialog.email.label", new Object[0]));
            SettingsSyncUserData settingsSyncUserData = $userData;
            this$0.copyableLabel($this$row, settingsSyncUserData != null ? settingsSyncUserData.getEmail() : null);
            return Unit.INSTANCE;
        }

        private static final Unit appInfoRow$lambda$7(TroubleshootingDialog this$0, SettingsSnapshot.AppInfo $appInfo, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            $this$row.label(SettingsSyncJbaBundle.INSTANCE.message("troubleshooting.dialog.applicationId.label", new Object[0]));
            this$0.copyableLabel($this$row, $appInfo.getApplicationId());
            return Unit.INSTANCE;
        }

        private static final Unit appInfoRow$lambda$8(TroubleshootingDialog this$0, SettingsSnapshot.AppInfo $appInfo, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            $this$row.label(SettingsSyncJbaBundle.INSTANCE.message("troubleshooting.dialog.username.label", new Object[0]));
            this$0.copyableLabel($this$row, $appInfo.getUserName());
            return Unit.INSTANCE;
        }

        private static final Unit appInfoRow$lambda$9(TroubleshootingDialog this$0, SettingsSnapshot.AppInfo $appInfo, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            $this$row.label(SettingsSyncJbaBundle.INSTANCE.message("troubleshooting.dialog.hostname.label", new Object[0]));
            this$0.copyableLabel($this$row, $appInfo.getHostName());
            return Unit.INSTANCE;
        }

        private static final Unit appInfoRow$lambda$10(TroubleshootingDialog this$0, SettingsSnapshot.AppInfo $appInfo, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            $this$row.label(SettingsSyncJbaBundle.INSTANCE.message("troubleshooting.dialog.configFolder.label", new Object[0]));
            this$0.copyableLabel($this$row, $appInfo.getConfigFolder());
            return Unit.INSTANCE;
        }

        private static final Unit versionRow$lambda$13$lambda$12(TroubleshootingDialog this$0, Version $version, ActionEvent it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            this$0.deleteFile(this$0.project, this$0.remoteCommunicator, $version.getFilePath());
            return Unit.INSTANCE;
        }

        private static final Unit versionRow$lambda$13(Version $version, TroubleshootingDialog this$0, boolean $showHistoryButton, boolean $showDeleteButton, Row $this$row) {
            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
            String[] stringArray = new String[]{"/"};
            List split = StringsKt.split$default((CharSequence)$version.getFilePath(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            String $this$versionRow_u24lambda_u2413_u24lambda_u2411 = CollectionsKt.joinToString$default((Iterable)split.subList(0, split.size() - 1), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null);
            boolean bl = false;
            Object folder = ((CharSequence)$this$versionRow_u24lambda_u2413_u24lambda_u2411).length() > 0 ? $this$versionRow_u24lambda_u2413_u24lambda_u2411 + "/" : "";
            String file = (String)split.get(split.size() - 1);
            $this$row.label("<html><b>" + (String)folder + "</b>" + file + "</html>");
            Date date = $version.getFileVersion().getModifiedDate();
            Intrinsics.checkNotNullExpressionValue((Object)date, (String)"getModifiedDate(...)");
            this$0.copyableLabel($this$row, SettingsSyncTroubleshootingActionKt.access$formatDate(date));
            String string = $version.getFileVersion().getVersionId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getVersionId(...)");
            this$0.copyableLabel($this$row, this$0.shorten(string));
            SettingsSnapshot snapshot = $version.getSnapshot();
            if (snapshot != null) {
                Object object;
                $this$row.label(SettingsSyncJbaBundle.INSTANCE.message("troubleshooting.dialog.machineInfo.label", new Object[0]));
                SettingsSnapshot.AppInfo appInfo = snapshot.getMetaInfo().getAppInfo();
                if (appInfo != null) {
                    UUID appId = appInfo.getApplicationId();
                    String thisOrThat = Intrinsics.areEqual((Object)appId, (Object)SettingsSyncLocalSettings.Companion.getInstance().getApplicationId()) ? "[this]  " : "[other]";
                    String string2 = appId.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                    object = thisOrThat + " " + this$0.shorten(string2) + " - " + appInfo.getUserName() + " - " + appInfo.getHostName() + " - " + appInfo.getConfigFolder();
                } else {
                    object = "Unknown";
                }
                String text = object;
                this$0.copyableLabel($this$row, text);
            }
            Icon icon = AllIcons.Actions.Download;
            ExtensionsKt.actionButton$default((Row)$this$row, (AnAction)((AnAction)new DumbAwareAction(this$0, $version, icon){
                final /* synthetic */ TroubleshootingDialog this$0;
                final /* synthetic */ Version $version;
                {
                    this.this$0 = $receiver;
                    this.$version = $version;
                    super($super_call_param$1);
                }

                public void actionPerformed(AnActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    TroubleshootingDialog.access$downloadVersion(this.this$0, this.$version, e.getProject());
                }
            }), null, (int)2, null);
            if ($showHistoryButton) {
                icon = AllIcons.Vcs.History;
                ExtensionsKt.actionButton$default((Row)$this$row, (AnAction)((AnAction)new DumbAwareAction(this$0, $version, icon){
                    final /* synthetic */ TroubleshootingDialog this$0;
                    final /* synthetic */ Version $version;
                    {
                        this.this$0 = $receiver;
                        this.$version = $version;
                        super($super_call_param$1);
                    }

                    public void actionPerformed(AnActionEvent e) {
                        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                        Project project = this.this$0.getProject();
                        CloudConfigServerCommunicator cloudConfigServerCommunicator = this.this$0.getRemoteCommunicator();
                        String string = this.$version.getFilePath();
                        Object object = this.this$0.getUserData();
                        if (object == null || (object = ((SettingsSyncUserData)object).getName()) == null) {
                            object = "Unknown";
                        }
                        TroubleshootingDialog.access$showHistoryDialog(this.this$0, project, cloudConfigServerCommunicator, string, (String)object);
                    }
                }), null, (int)2, null);
            }
            if ($showDeleteButton) {
                $this$row.button(SettingsSyncJbaBundle.INSTANCE.message("troubleshooting.dialog.delete.button", new Object[0]), arg_0 -> TroubleshootingDialog.versionRow$lambda$13$lambda$12(this$0, $version, arg_0));
            }
            return Unit.INSTANCE;
        }

        private static final File downloadVersion$lambda$14(Version $version, TroubleshootingDialog this$0) {
            return SettingsSyncTroubleshootingActionKt.access$downloadToFile($version.getFilePath(), $version.getFileVersion(), this$0.remoteCommunicator);
        }

        /*
         * WARNING - void declaration
         */
        private static final List showHistoryDialog$lambda$16(CloudConfigServerCommunicator $remoteCommunicator, String $filePath) {
            void $this$mapIndexedTo$iv$iv;
            Iterable $this$mapIndexed$iv = $remoteCommunicator.fetchHistory($filePath);
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                SettingsSnapshot settingsSnapshot;
                void version;
                void index;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                FileVersionInfo fileVersionInfo = (FileVersionInfo)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if (index < 10 && StringsKt.endsWith$default((String)$filePath, (String)".zip", (boolean)false, (int)2, null)) {
                    InputStream stream;
                    Intrinsics.checkNotNull((Object)$remoteCommunicator.downloadSnapshot($filePath, (FileVersionInfo)version));
                    settingsSnapshot = SettingsSyncTroubleshootingActionKt.access$extractSnapshotFromZipStream(stream);
                } else {
                    settingsSnapshot = null;
                }
                SettingsSnapshot snapshot = settingsSnapshot;
                collection.add(new Version($filePath, (FileVersionInfo)version, snapshot));
            }
            return (List)destination$iv$iv;
        }

        private static final Unit showHistoryDialog$lambda$17(List $history, TroubleshootingDialog this$0, Panel $this$panel) {
            Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
            for (Version version : $history) {
                this$0.versionRow($this$panel, version, false, false).layout(RowLayout.PARENT_GRID);
            }
            return Unit.INSTANCE;
        }

        private static final void showHistoryDialog$lambda$18(TroubleshootingDialog this$0, Project $project, CloudConfigServerCommunicator $remoteCommunicator, List $history, String $loginName, ActionEvent it) {
            Intrinsics.checkNotNull((Object)$history);
            this$0.downloadFullHistory($project, $remoteCommunicator, $history, $loginName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final File downloadFullHistory$lambda$20(String $loginName, List $history, CloudConfigServerCommunicator $remoteCommunicator) {
            String historyFileName = "settings-server-history-" + FileUtil.sanitizeFileName((String)$loginName) + "-" + SettingsSyncTroubleshootingActionKt.access$formatDate(new Date()) + ".zip";
            File file = FileUtil.createTempFile((String)historyFileName, null);
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(...)");
            File zipFile = file;
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            indicator.setIndeterminate(false);
            Closeable closeable = (Closeable)new Compressor.Zip(zipFile);
            Throwable throwable = null;
            try {
                Compressor.Zip zip = (Compressor.Zip)closeable;
                boolean bl = false;
                Iterator iterator = ((Iterable)$history).iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    int step = n++;
                    Version version = (Version)iterator.next();
                    indicator.checkCanceled();
                    indicator.setFraction((double)step / (double)$history.size());
                    FileVersionInfo fileVersion = version.getFileVersion();
                    InputStream stream = $remoteCommunicator.downloadSnapshot(version.getFilePath(), fileVersion);
                    if (stream != null) {
                        Pair pair = SettingsSyncTroubleshootingActionKt.access$getSnapshotFileNameAndExtension(version.getFilePath(), fileVersion);
                        String fileName = (String)pair.component1();
                        String extension = (String)pair.component2();
                        zip.addFile(fileName + extension, stream);
                        continue;
                    }
                    Companion.getLOG().warn("Couldn't download snapshot for version made on " + fileVersion.getModifiedDate());
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            return zipFile;
        }

        private static final Unit deleteFile$lambda$21(CloudConfigServerCommunicator $remoteCommunicator, String $filePath) {
            SettingsSyncSettings.Companion.getInstance().setSyncEnabled(false);
            $remoteCommunicator.deleteFile($filePath);
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ void access$downloadVersion(TroubleshootingDialog $this, Version version, Project project) {
            $this.downloadVersion(version, project);
        }

        public static final /* synthetic */ void access$showHistoryDialog(TroubleshootingDialog $this, Project project, CloudConfigServerCommunicator remoteCommunicator, String filePath, String loginName) {
            $this.showHistoryDialog(project, remoteCommunicator, filePath, loginName);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B&\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u0011\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\bH\u00c6\u0003J.\u0010\u0014\u001a\u00020\u00002\r\b\u0002\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lcom/intellij/settingsSync/jba/SettingsSyncTroubleshootingAction$Version;", "", "filePath", "", "Lcom/intellij/openapi/util/NlsSafe;", "fileVersion", "Lcom/jetbrains/cloudconfig/FileVersionInfo;", "snapshot", "Lcom/intellij/settingsSync/core/SettingsSnapshot;", "<init>", "(Ljava/lang/String;Lcom/jetbrains/cloudconfig/FileVersionInfo;Lcom/intellij/settingsSync/core/SettingsSnapshot;)V", "getFilePath", "()Ljava/lang/String;", "getFileVersion", "()Lcom/jetbrains/cloudconfig/FileVersionInfo;", "getSnapshot", "()Lcom/intellij/settingsSync/core/SettingsSnapshot;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.settingsSync"})
    private static final class Version {
        @NotNull
        private final String filePath;
        @NotNull
        private final FileVersionInfo fileVersion;
        @Nullable
        private final SettingsSnapshot snapshot;

        public Version(@NotNull String filePath, @NotNull FileVersionInfo fileVersion, @Nullable SettingsSnapshot snapshot) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            Intrinsics.checkNotNullParameter((Object)fileVersion, (String)"fileVersion");
            this.filePath = filePath;
            this.fileVersion = fileVersion;
            this.snapshot = snapshot;
        }

        @NotNull
        public final String getFilePath() {
            return this.filePath;
        }

        @NotNull
        public final FileVersionInfo getFileVersion() {
            return this.fileVersion;
        }

        @Nullable
        public final SettingsSnapshot getSnapshot() {
            return this.snapshot;
        }

        @NotNull
        public final String component1() {
            return this.filePath;
        }

        @NotNull
        public final FileVersionInfo component2() {
            return this.fileVersion;
        }

        @Nullable
        public final SettingsSnapshot component3() {
            return this.snapshot;
        }

        @NotNull
        public final Version copy(@NotNull String filePath, @NotNull FileVersionInfo fileVersion, @Nullable SettingsSnapshot snapshot) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            Intrinsics.checkNotNullParameter((Object)fileVersion, (String)"fileVersion");
            return new Version(filePath, fileVersion, snapshot);
        }

        public static /* synthetic */ Version copy$default(Version version, String string, FileVersionInfo fileVersionInfo, SettingsSnapshot settingsSnapshot, int n, Object object) {
            if ((n & 1) != 0) {
                string = version.filePath;
            }
            if ((n & 2) != 0) {
                fileVersionInfo = version.fileVersion;
            }
            if ((n & 4) != 0) {
                settingsSnapshot = version.snapshot;
            }
            return version.copy(string, fileVersionInfo, settingsSnapshot);
        }

        @NotNull
        public String toString() {
            return "Version(filePath=" + this.filePath + ", fileVersion=" + this.fileVersion + ", snapshot=" + this.snapshot + ")";
        }

        public int hashCode() {
            int result = this.filePath.hashCode();
            result = result * 31 + this.fileVersion.hashCode();
            result = result * 31 + (this.snapshot == null ? 0 : this.snapshot.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Version)) {
                return false;
            }
            Version version = (Version)other;
            if (!Intrinsics.areEqual((Object)this.filePath, (Object)version.filePath)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.fileVersion, (Object)version.fileVersion)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.snapshot, (Object)version.snapshot);
        }
    }
}

