/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.scientific.action;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.images.editor.ImageDocument;
import org.intellij.images.scientific.ScientificUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/intellij/images/scientific/action/InvertChannelsAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "applyInvertChannels", "Ljava/awt/image/BufferedImage;", "image", "intellij.platform.images"})
public final class InvertChannelsAction
extends DumbAwareAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        VirtualFile imageFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        VirtualFile virtualFile = imageFile;
        e.getPresentation().setEnabledAndVisible((virtualFile != null ? (Unit)virtualFile.getUserData(ScientificUtils.INSTANCE.getSCIENTIFIC_MODE_KEY()) : null) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            return;
        }
        VirtualFile imageFile = virtualFile;
        BufferedImage bufferedImage = (BufferedImage)imageFile.getUserData(ScientificUtils.INSTANCE.getORIGINAL_IMAGE_KEY());
        if (bufferedImage == null) {
            return;
        }
        BufferedImage originalImage = bufferedImage;
        BufferedImage invertedImage = this.applyInvertChannels(originalImage);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)invertedImage, "png", byteArrayOutputStream);
        byte[] byArray = byteArrayOutputStream.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        VirtualFileUtil.writeBytes((VirtualFile)imageFile, (byte[])byArray);
        ImageDocument imageDocument = (ImageDocument)e.getData(ImageDocument.IMAGE_DOCUMENT_DATA_KEY);
        if (imageDocument == null) {
            return;
        }
        ImageDocument document = imageDocument;
        document.setValue(invertedImage);
    }

    private final BufferedImage applyInvertChannels(BufferedImage image) {
        boolean hasAlpha = image.getColorModel().hasAlpha();
        BufferedImage invertedImage = new BufferedImage(image.getWidth(), image.getHeight(), hasAlpha ? 2 : 1);
        int n = image.getWidth();
        for (int x = 0; x < n; ++x) {
            int n2 = image.getHeight();
            for (int y = 0; y < n2; ++y) {
                int rgba = image.getRGB(x, y);
                int alpha = rgba >> 24 & 0xFF;
                int red = rgba >> 16 & 0xFF;
                int green = rgba >> 8 & 0xFF;
                int blue = rgba & 0xFF;
                int invertedRed = 255 - red;
                int invertedGreen = 255 - green;
                int invertedBlue = 255 - blue;
                int invertedRgba = alpha << 24 | invertedRed << 16 | invertedGreen << 8 | invertedBlue;
                invertedImage.setRGB(x, y, invertedRgba);
            }
        }
        return invertedImage;
    }
}

