/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.welcomeScreen.toolbox;

import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.registry.Registry;
import com.jetbrains.gateway.actions.ToolboxDiscovery;
import com.jetbrains.gateway.welcomeScreen.toolbox.ToolboxStatus;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0001\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/gateway/welcomeScreen/toolbox/ToolboxStatusService;", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "toolboxStatus", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/jetbrains/gateway/welcomeScreen/toolbox/ToolboxStatus;", "getToolboxStatus", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "rememberAboutInstallationAttempt", "", "wasToolboxOpenedViaLink", "", "updateToolboxStatus", "Companion", "intellij.gateway.core"})
@SourceDebugExtension(value={"SMAP\nToolboxStatusService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolboxStatusService.kt\ncom/jetbrains/gateway/welcomeScreen/toolbox/ToolboxStatusService\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,87:1\n25#2:88\n*S KotlinDebug\n*F\n+ 1 ToolboxStatusService.kt\ncom/jetbrains/gateway/welcomeScreen/toolbox/ToolboxStatusService\n*L\n28#1:88\n*E\n"})
public final class ToolboxStatusService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final MutableStateFlow<ToolboxStatus> toolboxStatus;

    public ToolboxStatusService(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        this.toolboxStatus = StateFlowKt.MutableStateFlow((Object)((Object)ToolboxStatus.Unknown));
    }

    @NotNull
    public final CoroutineScope getCoroutineScope() {
        return this.coroutineScope;
    }

    @NotNull
    public final MutableStateFlow<ToolboxStatus> getToolboxStatus() {
        return this.toolboxStatus;
    }

    public final void rememberAboutInstallationAttempt() {
        PropertiesComponent.getInstance().setValue("toolbox.installation.attempt", true);
    }

    public final boolean wasToolboxOpenedViaLink() {
        boolean registryKeyEnabled = Registry.Companion.is("gateway.ssh.welcome.screen.toolbox.promo.enabled");
        boolean userHadClickedOnOpenToolboxLink = PropertiesComponent.getInstance().getBoolean("toolbox.installation.attempt", false);
        ToolboxStatus[] toolboxStatusArray = new ToolboxStatus[]{ToolboxStatus.UpToDateAndRunning, ToolboxStatus.UpToDateAndNotRunning};
        boolean isUpToDateToolboxInstallationConfirmed = SetsKt.setOf((Object[])toolboxStatusArray).contains(this.toolboxStatus.getValue());
        ToolboxStatusService $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(ToolboxStatusService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.warn("Previous toolbox opening data: registry key enabled: " + registryKeyEnabled + ", user had clicked on 'open' link: " + userHadClickedOnOpenToolboxLink + ", is up to date toolbox installed: " + isUpToDateToolboxInstallationConfirmed);
        return registryKeyEnabled && userHadClickedOnOpenToolboxLink && isUpToDateToolboxInstallationConfirmed;
    }

    public final void updateToolboxStatus() {
        if (!Registry.Companion.is("gateway.ssh.welcome.screen.toolbox.promo.enabled") && !Registry.Companion.is("gateway.welcome.screen.toolbox.promo.enabled")) {
            return;
        }
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ ToolboxStatusService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        installedToolboxBuildNumber = ToolboxDiscovery.INSTANCE.getInstalledBuild$intellij_gateway_core();
                        runningToolboxProcesses = ToolboxDiscovery.INSTANCE.listRunningToolboxProcesses();
                        this.L$0 = installedToolboxBuildNumber;
                        this.L$1 = runningToolboxProcesses;
                        this.label = 1;
                        v0 = ToolboxDiscovery.INSTANCE.discoverToolboxInstaller(false, (Continuation<? super Pair<? extends Path, BuildNumber>>)((Continuation)this));
                        if (v0 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl19
                    }
                    case 1: {
                        runningToolboxProcesses = (List<ProcessInfo>)this.L$1;
                        installedToolboxBuildNumber = (BuildNumber)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl19:
                        // 2 sources

                        v1 = (Pair)v0;
                        installerVersion = v1 != null ? (BuildNumber)v1.getSecond() : null;
                        $i$f$fileLogger = false;
                        $i$f$currentClassLogger = false;
                        clazz$iv$iv = MethodHandles.lookup().lookupClass();
                        v2 = Logger.getInstance(clazz$iv$iv);
                        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getInstance(...)");
                        v2.warn("Toolbox discovery status: existing toolbox build " + installedToolboxBuildNumber + ", running processes " + runningToolboxProcesses.size() + ",installer version " + installerVersion);
                        v3 = this.this$0.getToolboxStatus();
                        if (installedToolboxBuildNumber != null || !runningToolboxProcesses.isEmpty()) ** GOTO lbl32
                        v4 = ToolboxStatus.NotInstalled;
                        ** GOTO lbl50
lbl32:
                        // 1 sources

                        if (installedToolboxBuildNumber == null || installerVersion == null || installedToolboxBuildNumber.compareTo(installerVersion) >= 0) ** GOTO lbl36
                        v4 = runningToolboxProcesses.isEmpty() ? ToolboxStatus.OutdatedAndNotRunning : ToolboxStatus.OutdatedAndRunning;
                        ** GOTO lbl50
lbl36:
                        // 1 sources

                        if (installedToolboxBuildNumber == null) ** GOTO lbl-1000
                        if (installerVersion == null) ** GOTO lbl40
                        if (installedToolboxBuildNumber.compareTo(installerVersion) >= 0) {
lbl40:
                            // 2 sources

                            v4 = runningToolboxProcesses.isEmpty() ? ToolboxStatus.UpToDateAndNotRunning : ToolboxStatus.UpToDateAndRunning;
                        } else lbl-1000:
                        // 2 sources

                        {
                            $i$f$fileLogger = false;
                            $i$f$currentClassLogger = false;
                            clazz$iv$iv = MethodHandles.lookup().lookupClass();
                            v5 = Logger.getInstance(clazz$iv$iv);
                            Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getInstance(...)");
                            v5.warn("Toolbox discovery is unsure about installed version.Falling back to `not installed`");
                            v4 = ToolboxStatus.NotInstalled;
                        }
lbl50:
                        // 4 sources

                        v3.setValue((Object)v4);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/gateway/welcomeScreen/toolbox/ToolboxStatusService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/jetbrains/gateway/welcomeScreen/toolbox/ToolboxStatusService;", "intellij.gateway.core"})
    @SourceDebugExtension(value={"SMAP\nToolboxStatusService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolboxStatusService.kt\ncom/jetbrains/gateway/welcomeScreen/toolbox/ToolboxStatusService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,87:1\n40#2,3:88\n*S KotlinDebug\n*F\n+ 1 ToolboxStatusService.kt\ncom/jetbrains/gateway/welcomeScreen/toolbox/ToolboxStatusService$Companion\n*L\n74#1:88,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ToolboxStatusService getInstance() {
            boolean $i$f$service = false;
            Class<ToolboxStatusService> serviceClass$iv = ToolboxStatusService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (ToolboxStatusService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

