/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.client;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientKind;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSession;
import com.intellij.openapi.client.ClientSessionsManager;
import com.intellij.openapi.client.ClientSessionsManagerKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 \u001b*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001\u001bB\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\f2\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\u0015\u0010\u0011\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0012\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0013J\u001b\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\nH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/openapi/client/ClientSessionsManager;", "T", "Lcom/intellij/openapi/client/ClientSession;", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "sessions", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/codeWithMe/ClientId;", "getSessions", "", "kind", "Lcom/intellij/openapi/client/ClientKind;", "includeDisposed", "", "getSession", "clientId", "(Lcom/intellij/codeWithMe/ClientId;)Lcom/intellij/openapi/client/ClientSession;", "registerSession", "", "disposable", "Lcom/intellij/openapi/Disposable;", "session", "(Lcom/intellij/openapi/Disposable;Lcom/intellij/openapi/client/ClientSession;)V", "isValid", "Companion", "intellij.platform.core"})
@ApiStatus.Experimental
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nClientSessionsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientSessionsManager.kt\ncom/intellij/openapi/client/ClientSessionsManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,177:1\n774#2:178\n865#2,2:179\n774#2:181\n865#2,2:182\n62#3,5:184\n62#3,5:189\n*S KotlinDebug\n*F\n+ 1 ClientSessionsManager.kt\ncom/intellij/openapi/client/ClientSessionsManager\n*L\n120#1:178\n120#1:179,2\n123#1:181\n123#1:182,2\n150#1:184,5\n155#1:189,5\n*E\n"})
public class ClientSessionsManager<T extends ClientSession> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final ConcurrentHashMap<ClientId, T> sessions;
    private static final long disposedRemovalDelay = DurationKt.toDuration(1, DurationUnit.MINUTES);

    public ClientSessionsManager(@NotNull CoroutineScope scope) {
        Intrinsics.checkNotNullParameter(scope, "scope");
        this.scope = scope;
        this.sessions = new ConcurrentHashMap();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<T> getSessions(@NotNull ClientKind kind, boolean includeDisposed) {
        Intrinsics.checkNotNullParameter(kind, "kind");
        if (kind == ClientKind.ALL) {
            void $this$filterTo$iv$iv;
            Collection<T> collection = this.sessions.values();
            Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ClientSession it = (ClientSession)element$iv$iv;
                boolean bl = false;
                if (!(!((ComponentManager)it).isDisposed() || includeDisposed)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        Collection<T> collection = this.sessions.values();
        Intrinsics.checkNotNullExpressionValue(collection, "<get-values>(...)");
        Iterable $this$filter$iv = collection;
        boolean $i$f$filter = false;
        Iterable $this$filterTo$iv$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ClientSession it = (ClientSession)element$iv$iv;
            boolean bl = false;
            if (!((!((ComponentManager)it).isDisposed() || includeDisposed) && it.getType().matches(kind))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List getSessions$default(ClientSessionsManager clientSessionsManager, ClientKind clientKind, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getSessions");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        return clientSessionsManager.getSessions(clientKind, bl);
    }

    @Nullable
    public final T getSession(@NotNull ClientId clientId) {
        Intrinsics.checkNotNullParameter(clientId, "clientId");
        return (T)((ClientSession)this.sessions.get(clientId));
    }

    public final void registerSession(@NotNull Disposable disposable, @NotNull T session) {
        Intrinsics.checkNotNullParameter(disposable, "disposable");
        Intrinsics.checkNotNullParameter(session, "session");
        ClientId clientId = session.getClientId();
        ClientSession oldSession = (ClientSession)this.sessions.put(clientId, session);
        if (oldSession != null) {
            if (((ComponentManager)oldSession).isDisposed()) {
                ClientSessionsManagerKt.access$getLOG$p().info("A disposed session " + oldSession + " for " + clientId + " is replaced with a new " + session);
            } else {
                ClientSessionsManagerKt.access$getLOG$p().warn("Session " + oldSession + " with such clientId " + clientId + " is already registered and will be replaced with " + session);
                CoroutineContext coroutineContext = CoroutinesKt.getEDT(Dispatchers.INSTANCE);
                ModalityState modalityState = ModalityState.any();
                Intrinsics.checkNotNullExpressionValue(modalityState, "any(...)");
                BuildersKt.launch$default(this.scope, coroutineContext.plus(ModalityKt.asContextElement(modalityState)), null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(oldSession, null){
                    int label;
                    final /* synthetic */ T $oldSession;
                    {
                        this.$oldSession = $oldSession;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure(object);
                                this.label = 1;
                                Object object3 = CoroutinesKt.writeIntentReadAction(() -> registerSession.1.invokeSuspend$lambda$0(this.$oldSession), this);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure($result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }

                    private static final Unit invokeSuspend$lambda$0(ClientSession $oldSession) {
                        Disposer.dispose((Disposable)((Object)$oldSession));
                        return Unit.INSTANCE;
                    }
                }, 2, null);
            }
        }
        Logger $this$debug_u24default$iv = ClientSessionsManagerKt.access$getLOG$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Session added '" + session + '\'', e$iv);
        }
        Disposer.register(disposable, () -> ClientSessionsManager.registerSession$lambda$4(session, this, clientId));
    }

    @Deprecated(message="Use `!session.isDisposed` instead or better run coroutine from per-client scope that will be cancelled when a client has gone", replaceWith=@ReplaceWith(expression="!session.isDisposed", imports={}), level=DeprecationLevel.ERROR)
    @ApiStatus.Obsolete
    public final boolean isValid(@NotNull ClientId clientId) {
        Intrinsics.checkNotNullParameter(clientId, "clientId");
        T t = this.getSession(clientId);
        return t != null ? !((ComponentManager)t).isDisposed() : false;
    }

    private static final void registerSession$lambda$4(ClientSession $session, ClientSessionsManager this$0, ClientId $clientId) {
        Disposer.dispose((Disposable)((Object)$session));
        Logger $this$debug_u24default$iv = ClientSessionsManagerKt.access$getLOG$p();
        Throwable e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Session for '" + $clientId + "' will be removed after delay", e$iv);
        }
        BuildersKt.launch$default(this$0.scope, null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, $clientId, $session, null){
            int label;
            final /* synthetic */ ClientSessionsManager<T> this$0;
            final /* synthetic */ ClientId $clientId;
            final /* synthetic */ T $session;
            {
                this.this$0 = $receiver;
                this.$clientId = $clientId;
                this.$session = $session;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(var1_1);
                        this.label = 1;
                        v0 = DelayKt.delay-VtjQ1oo(ClientSessionsManager.access$getDisposedRemovalDelay$cp(), this);
                        if (v0 == var8_2) {
                            return var8_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure($result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if (ClientSessionsManager.access$getSessions$p(this.this$0).remove(this.$clientId, this.$session)) {
                            var2_3 = ClientSessionsManagerKt.access$getLOG$p();
                            var4_5 = this.$clientId;
                            e$iv = null;
                            $i$f$debug = false;
                            if ($this$debug_u24default$iv.isDebugEnabled()) {
                                var7_11 = $this$debug_u24default$iv;
                                $i$a$-debug$default-ClientSessionsManager$registerSession$3$2$1 = false;
                                var7_11.debug("Session for '" + var4_5 + "' removed from after " + Duration.toString-impl(ClientSessionsManager.access$getDisposedRemovalDelay$cp()), e$iv);
                            }
                        } else {
                            $this$debug_u24default$iv = ClientSessionsManagerKt.access$getLOG$p();
                            var4_6 = this.$clientId;
                            e$iv = null;
                            $i$f$debug = false;
                            if ($this$debug_u24default$iv.isDebugEnabled()) {
                                var7_12 = $this$debug_u24default$iv;
                                $i$a$-debug$default-ClientSessionsManager$registerSession$3$2$2 = false;
                                var7_12.debug("Session for '" + var4_6 + "' was skipped because another session with the same client id key was added", e$iv);
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    @JvmStatic
    @Nullable
    public static final ClientAppSession getAppSession(@NotNull ClientId clientId) {
        return Companion.getAppSession(clientId);
    }

    @JvmStatic
    @Nullable
    public static final ClientAppSession getAppSession(@Nullable Application application, @NotNull ClientId clientId) {
        return Companion.getAppSession(application, clientId);
    }

    @JvmStatic
    @NotNull
    public static final ClientAppSession getAppSessionOrThrow(@NotNull ClientId clientId) {
        return Companion.getAppSessionOrThrow(clientId);
    }

    @JvmStatic
    @NotNull
    public static final ClientAppSession getAppSessionOrThrow(@NotNull Application application, @NotNull ClientId clientId) {
        return Companion.getAppSessionOrThrow(application, clientId);
    }

    @JvmStatic
    @NotNull
    public static final List<ClientAppSession> getAppSessions(@NotNull ClientKind kind) {
        return Companion.getAppSessions(kind);
    }

    @JvmStatic
    @Nullable
    public static final ClientProjectSession getProjectSession(@NotNull Project project, @NotNull ClientId clientId) {
        return Companion.getProjectSession(project, clientId);
    }

    @JvmStatic
    @NotNull
    public static final ClientProjectSession getProjectSessionOrThrow(@NotNull Project project, @NotNull ClientId clientId) {
        return Companion.getProjectSessionOrThrow(project, clientId);
    }

    @JvmStatic
    @NotNull
    public static final List<ClientProjectSession> getProjectSessions(@NotNull Project project, @NotNull ClientKind kind) {
        return Companion.getProjectSessions(project, kind);
    }

    public static final /* synthetic */ long access$getDisposedRemovalDelay$cp() {
        return disposedRemovalDelay;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getSessions$p(ClientSessionsManager $this) {
        return $this.sessions;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u001e\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u0010\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/client/ClientSessionsManager$Companion;", "", "<init>", "()V", "getAppSession", "Lcom/intellij/openapi/client/ClientAppSession;", "clientId", "Lcom/intellij/codeWithMe/ClientId;", "application", "Lcom/intellij/openapi/application/Application;", "getAppSessionOrThrow", "getAppSessions", "", "kind", "Lcom/intellij/openapi/client/ClientKind;", "getProjectSession", "Lcom/intellij/openapi/client/ClientProjectSession;", "project", "Lcom/intellij/openapi/project/Project;", "getProjectSessionOrThrow", "getProjectSessions", "disposedRemovalDelay", "Lkotlin/time/Duration;", "J", "intellij.platform.core"})
    @SourceDebugExtension(value={"SMAP\nClientSessionsManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientSessionsManager.kt\ncom/intellij/openapi/client/ClientSessionsManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,177:1\n31#2,2:178\n31#2,2:180\n31#2,2:182\n31#2,2:184\n31#2,2:186\n31#2,2:188\n*S KotlinDebug\n*F\n+ 1 ClientSessionsManager.kt\ncom/intellij/openapi/client/ClientSessionsManager$Companion\n*L\n44#1:178,2\n66#1:180,2\n78#1:182,2\n88#1:184,2\n99#1:186,2\n110#1:188,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final ClientAppSession getAppSession(@NotNull ClientId clientId) {
            Intrinsics.checkNotNullParameter(clientId, "clientId");
            return this.getAppSession(ApplicationManager.getApplication(), clientId);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        @Nullable
        public final ClientAppSession getAppSession(@Nullable Application application, @NotNull ClientId clientId) {
            Intrinsics.checkNotNullParameter(clientId, "clientId");
            Application application2 = application;
            Object object = application2;
            if (application2 == null) return null;
            ComponentManager $this$service$iv = (ComponentManager)object;
            boolean $i$f$service = false;
            Class<ClientSessionsManager> serviceClass$iv = ClientSessionsManager.class;
            Object object2 = $this$service$iv.getService(serviceClass$iv);
            if (object2 == null) {
                throw ServicesKt.serviceNotFoundError($this$service$iv, serviceClass$iv);
            }
            ClientSessionsManager clientSessionsManager = (ClientSessionsManager)object2;
            object = clientSessionsManager;
            if (clientSessionsManager == null) return null;
            ClientAppSession clientAppSession = (ClientAppSession)((ClientSessionsManager)object).getSession(clientId);
            return clientAppSession;
        }

        @JvmStatic
        @NotNull
        public final ClientAppSession getAppSessionOrThrow(@NotNull ClientId clientId) {
            Intrinsics.checkNotNullParameter(clientId, "clientId");
            Application application = ApplicationManager.getApplication();
            if (application == null) {
                throw new IllegalStateException("ApplicationManager.getApplication() is null".toString());
            }
            return this.getAppSessionOrThrow(application, clientId);
        }

        @JvmStatic
        @NotNull
        public final ClientAppSession getAppSessionOrThrow(@NotNull Application application, @NotNull ClientId clientId) {
            ClientAppSession session;
            Intrinsics.checkNotNullParameter(application, "application");
            Intrinsics.checkNotNullParameter(clientId, "clientId");
            ComponentManager $this$service$iv = application;
            boolean $i$f$service = false;
            Class<ClientSessionsManager> serviceClass$iv = ClientSessionsManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError($this$service$iv, serviceClass$iv);
            }
            ClientAppSession clientAppSession = session = (ClientAppSession)((ClientSessionsManager)object).getSession(clientId);
            if (clientAppSession == null) {
                throw new IllegalStateException(("Application-level session is not set for " + clientId).toString());
            }
            return clientAppSession;
        }

        @JvmStatic
        @NotNull
        public final List<ClientAppSession> getAppSessions(@NotNull ClientKind kind) {
            Object object;
            block5: {
                block4: {
                    Intrinsics.checkNotNullParameter(kind, "kind");
                    object = ApplicationManager.getApplication();
                    if (object == null) break block4;
                    ComponentManager $this$service$iv = (ComponentManager)object;
                    boolean $i$f$service = false;
                    Class<ClientSessionsManager> serviceClass$iv = ClientSessionsManager.class;
                    Object object2 = $this$service$iv.getService(serviceClass$iv);
                    if (object2 == null) {
                        throw ServicesKt.serviceNotFoundError($this$service$iv, serviceClass$iv);
                    }
                    object = (ClientSessionsManager)object2;
                    if (object != null && (object = ClientSessionsManager.getSessions$default((ClientSessionsManager)object, kind, false, 2, null)) != null) break block5;
                }
                object = CollectionsKt.emptyList();
            }
            return object;
        }

        @JvmStatic
        @Nullable
        public final ClientProjectSession getProjectSession(@NotNull Project project, @NotNull ClientId clientId) {
            Intrinsics.checkNotNullParameter(project, "project");
            Intrinsics.checkNotNullParameter(clientId, "clientId");
            ComponentManager $this$service$iv = project;
            boolean $i$f$service = false;
            Class<ClientSessionsManager> serviceClass$iv = ClientSessionsManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError($this$service$iv, serviceClass$iv);
            }
            return (ClientProjectSession)((ClientSessionsManager)object).getSession(clientId);
        }

        @JvmStatic
        @NotNull
        public final ClientProjectSession getProjectSessionOrThrow(@NotNull Project project, @NotNull ClientId clientId) {
            ClientProjectSession session;
            Intrinsics.checkNotNullParameter(project, "project");
            Intrinsics.checkNotNullParameter(clientId, "clientId");
            ComponentManager $this$service$iv = project;
            boolean $i$f$service = false;
            Class<ClientSessionsManager> serviceClass$iv = ClientSessionsManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError($this$service$iv, serviceClass$iv);
            }
            ClientProjectSession clientProjectSession = session = (ClientProjectSession)((ClientSessionsManager)object).getSession(clientId);
            if (clientProjectSession == null) {
                throw new IllegalStateException(("Project-level session is not set for " + clientId).toString());
            }
            return clientProjectSession;
        }

        @JvmStatic
        @NotNull
        public final List<ClientProjectSession> getProjectSessions(@NotNull Project project, @NotNull ClientKind kind) {
            Intrinsics.checkNotNullParameter(project, "project");
            Intrinsics.checkNotNullParameter(kind, "kind");
            ComponentManager $this$service$iv = project;
            boolean $i$f$service = false;
            Class<ClientSessionsManager> serviceClass$iv = ClientSessionsManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError($this$service$iv, serviceClass$iv);
            }
            return ClientSessionsManager.getSessions$default((ClientSessionsManager)object, kind, false, 2, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

