/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.ui.visualization;

import com.intellij.icons.AllIcons;
import com.intellij.notebooks.ui.visualization.NotebookCellTagLabel;
import com.intellij.notebooks.ui.visualization.NotebookEditorAppearanceUtils;
import com.intellij.notebooks.ui.visualization.NotebookUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.toolbarLayout.ToolbarLayoutStrategy;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.components.JBBox;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.MatteBorder;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B]\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0016\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020&J\b\u0010'\u001a\u00020\u001bH\u0002J&\u0010(\u001a\u00070\u0006\u00a2\u0006\u0002\b)2\b\u0010\u000b\u001a\u0004\u0018\u00010\b2\b\u0010*\u001a\u0004\u0018\u00010\u0006H\u0002\u00a2\u0006\u0002\u0010+J\b\u0010,\u001a\u00020-H\u0002J\b\u0010.\u001a\u00020/H\u0002J\u0017\u00100\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0002\u00101J\u0017\u00102\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0002\u00103J7\u00104\u001a\u00020#2\n\b\u0001\u00105\u001a\u0004\u0018\u00010\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\b2\b\u00106\u001a\u0004\u0018\u00010\r2\n\b\u0001\u00107\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u00108J\u0012\u00109\u001a\u00020\u001b2\b\b\u0001\u0010:\u001a\u00020\u0006H\u0002J*\u0010;\u001a\u00020#2\b\u0010<\u001a\u0004\u0018\u00010\u001d2\u0018\u0010=\u001a\u0014\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00060>J\u0006\u0010?\u001a\u00020#J\b\u0010@\u001a\u00020\u001bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082D\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/intellij/notebooks/ui/visualization/NotebookBelowCellDelimiterPanel;", "Ljavax/swing/JPanel;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "cellTags", "", "", "cellIndex", "", "isRenderedMarkdown", "", "executionCount", "initStatusIcon", "Ljavax/swing/Icon;", "initTooltipText", "initExecutionDurationText", "scope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Ljava/util/List;IZLjava/lang/Integer;Ljavax/swing/Icon;Ljava/lang/String;Ljava/lang/String;Lkotlinx/coroutines/CoroutineScope;)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "getCellIndex", "()I", "tagsSpacing", "delimiterHeight", "executionLabel", "Ljavax/swing/JLabel;", "elapsedStartTime", "Ljava/time/ZonedDateTime;", "updateElapsedTimeDelay", "", "elapsedTimeJob", "Lkotlinx/coroutines/Job;", "setFrameVisible", "", "isVisible", "frameColor", "Ljava/awt/Color;", "createExecutionLabel", "getExecutionLabelText", "Lcom/intellij/openapi/util/NlsSafe;", "durationText", "(Ljava/lang/Integer;Ljava/lang/String;)Ljava/lang/String;", "createTagsRow", "Ljava/awt/Component;", "createAddTagButton", "Ljavax/swing/JComponent;", "getExecutionCountLabelText", "(Ljava/lang/Integer;)Ljava/lang/String;", "isExecutionCountDefined", "(Ljava/lang/Integer;)Z", "updateExecutionStatus", "tooltipText", "statusIcon", "executionDurationText", "(Ljava/lang/String;Ljava/lang/Integer;Ljavax/swing/Icon;Ljava/lang/String;)V", "updateElapsedTime", "elapsedText", "startElapsedTimeUpdate", "startTime", "diffFormatter", "Lkotlin/Function2;", "stopElapsedTimeUpdate", "getOrCreateExecutionLabel", "intellij.notebooks.ui"})
@SourceDebugExtension(value={"SMAP\nNotebookBelowCellDelimiterPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotebookBelowCellDelimiterPanel.kt\ncom/intellij/notebooks/ui/visualization/NotebookBelowCellDelimiterPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,174:1\n1863#2,2:175\n1#3:177\n*S KotlinDebug\n*F\n+ 1 NotebookBelowCellDelimiterPanel.kt\ncom/intellij/notebooks/ui/visualization/NotebookBelowCellDelimiterPanel\n*L\n95#1:175,2\n*E\n"})
public final class NotebookBelowCellDelimiterPanel
extends JPanel {
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final List<String> cellTags;
    private final int cellIndex;
    @NotNull
    private final CoroutineScope scope;
    private final int tagsSpacing;
    private final int delimiterHeight;
    @Nullable
    private JLabel executionLabel;
    @Nullable
    private ZonedDateTime elapsedStartTime;
    private final long updateElapsedTimeDelay;
    @Nullable
    private Job elapsedTimeJob;

    public NotebookBelowCellDelimiterPanel(@NotNull EditorImpl editor, @NotNull List<String> cellTags, int cellIndex, boolean isRenderedMarkdown, @Nullable Integer executionCount, @Nullable Icon initStatusIcon, @Nullable String initTooltipText, @Nullable String initExecutionDurationText, @NotNull CoroutineScope scope) {
        boolean addingTagsRow;
        int n;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(cellTags, (String)"cellTags");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        super(new BorderLayout());
        this.editor = editor;
        this.cellTags = cellTags;
        this.cellIndex = cellIndex;
        this.scope = scope;
        this.tagsSpacing = JBUI.scale((int)6);
        boolean bl = NotebookEditorAppearanceUtils.INSTANCE.isOrdinaryNotebookEditor((Editor)this.editor);
        if (bl) {
            n = NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this.editor).getCellBorderHeight() / 4;
        } else if (!bl) {
            n = NotebookEditorAppearanceUtils.INSTANCE.getJupyterCellSpacing((Editor)this.editor) / 2;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.delimiterHeight = n;
        this.updateElapsedTimeDelay = 100L;
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 1, 1), BorderFactory.createEmptyBorder(this.delimiterHeight, 0, this.delimiterHeight, 0)));
        this.setCursor(Cursor.getPredefinedCursor(0));
        boolean bl2 = addingTagsRow = !((Collection)this.cellTags).isEmpty() && !isRenderedMarkdown && Registry.Companion.is("jupyter.cell.metadata.tags", false);
        if (addingTagsRow) {
            this.add(this.createTagsRow(), "East");
        }
        this.updateExecutionStatus(initTooltipText, executionCount, initStatusIcon, initExecutionDurationText);
    }

    @NotNull
    public final EditorImpl getEditor() {
        return this.editor;
    }

    public final int getCellIndex() {
        return this.cellIndex;
    }

    public final void setFrameVisible(boolean isVisible, @NotNull Color frameColor) {
        Intrinsics.checkNotNullParameter((Object)frameColor, (String)"frameColor");
        MatteBorder frameBorder = isVisible ? BorderFactory.createMatteBorder(0, 0, 1, 1, frameColor) : BorderFactory.createMatteBorder(0, 0, 1, 1, this.getBackground());
        this.setBorder(BorderFactory.createCompoundBorder(frameBorder, BorderFactory.createEmptyBorder(this.delimiterHeight, 0, this.delimiterHeight, 0)));
        this.repaint();
    }

    private final JLabel createExecutionLabel() {
        JLabel jLabel;
        JLabel $this$createExecutionLabel_u24lambda_u240 = jLabel = new JLabel();
        boolean bl = false;
        $this$createExecutionLabel_u24lambda_u240.setFont(EditorUtil.getEditorFont().deriveFont(EditorUtil.getEditorFont().getSize2D() - 1.0f));
        $this$createExecutionLabel_u24lambda_u240.setForeground(UIUtil.getLabelInfoForeground());
        return jLabel;
    }

    private final String getExecutionLabelText(Integer executionCount, String durationText) {
        String executionCountText = this.getExecutionCountLabelText(executionCount);
        String string = durationText;
        if (string == null) {
            string = "";
        }
        String durationLabelText = string;
        String labelText = executionCountText + " " + durationLabelText;
        return labelText;
    }

    private final Component createTagsRow() {
        JBBox tagsRow = JBBox.createHorizontalBox();
        tagsRow.add((Component)this.createAddTagButton());
        Iterable $this$forEach$iv = this.cellTags;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String tag = (String)element$iv;
            boolean bl = false;
            tagsRow.add((Component)new NotebookCellTagLabel(tag, this.cellIndex));
            tagsRow.add(Box.createHorizontalStrut(this.tagsSpacing));
        }
        Intrinsics.checkNotNull((Object)tagsRow);
        return (Component)tagsRow;
    }

    private final JComponent createAddTagButton() {
        ActionToolbar actionToolbar;
        AnAction anAction = ActionManager.getInstance().getAction("JupyterCellAddTagInlayActionGroup");
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        ActionGroup actionGroup = (ActionGroup)anAction;
        ActionToolbar $this$createAddTagButton_u24lambda_u242 = actionToolbar = ActionManager.getInstance().createActionToolbar("NotebookTagsPanel", actionGroup, true);
        boolean bl = false;
        $this$createAddTagButton_u24lambda_u242.setLayoutStrategy(ToolbarLayoutStrategy.NOWRAP_STRATEGY);
        this.setBorder(BorderFactory.createEmptyBorder());
        $this$createAddTagButton_u24lambda_u242.setMinimumButtonSize((Dimension)JBUI.size((int)18, (int)18));
        $this$createAddTagButton_u24lambda_u242.setTargetComponent((JComponent)this);
        ActionToolbar actionToolbar2 = actionToolbar;
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar2, (String)"apply(...)");
        ActionToolbar toolbar = actionToolbar2;
        JComponent jComponent = toolbar.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    private final String getExecutionCountLabelText(Integer executionCount) {
        return !NotebookEditorAppearanceUtils.INSTANCE.isOrdinaryNotebookEditor((Editor)this.editor) ? "" : (executionCount == null ? "" : (executionCount == 0 ? "" : "[" + executionCount + "]"));
    }

    private final boolean isExecutionCountDefined(Integer executionCount) {
        boolean bl;
        Integer n = executionCount;
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl2 = false;
            bl = it > 0;
        } else {
            bl = false;
        }
        return bl;
    }

    public final void updateExecutionStatus(@NlsSafe @Nullable String tooltipText, @Nullable Integer executionCount, @Nullable Icon statusIcon, @NlsSafe @Nullable String executionDurationText) {
        boolean showStatus;
        boolean bl = showStatus = (this.isExecutionCountDefined(executionCount) || tooltipText != null && !Intrinsics.areEqual((Object)statusIcon, (Object)AllIcons.General.GreenCheckmark)) && !NotebookEditorAppearanceUtils.INSTANCE.isDiffKind((Editor)this.editor);
        if (showStatus) {
            JLabel jLabel;
            JLabel $this$updateExecutionStatus_u24lambda_u244 = jLabel = this.getOrCreateExecutionLabel();
            boolean bl2 = false;
            $this$updateExecutionStatus_u24lambda_u244.setText(this.getExecutionLabelText(executionCount, executionDurationText));
            $this$updateExecutionStatus_u24lambda_u244.setIcon(statusIcon);
            $this$updateExecutionStatus_u24lambda_u244.setToolTipText(tooltipText);
        } else {
            JLabel jLabel = this.executionLabel;
            if (jLabel != null) {
                JLabel it = jLabel;
                boolean bl3 = false;
                this.remove(it);
            }
            this.executionLabel = null;
        }
    }

    private final JLabel updateElapsedTime(@NlsSafe String elapsedText) {
        JLabel jLabel;
        JLabel $this$updateElapsedTime_u24lambda_u246 = jLabel = this.getOrCreateExecutionLabel();
        boolean bl = false;
        $this$updateElapsedTime_u24lambda_u246.setText(elapsedText);
        return jLabel;
    }

    public final void startElapsedTimeUpdate(@Nullable ZonedDateTime startTime, @NotNull Function2<? super ZonedDateTime, ? super ZonedDateTime, String> diffFormatter) {
        Intrinsics.checkNotNullParameter(diffFormatter, (String)"diffFormatter");
        if (startTime == null) {
            return;
        }
        this.elapsedStartTime = startTime;
        Job job = this.elapsedTimeJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.elapsedTimeJob = BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, diffFormatter, null){
            int label;
            final /* synthetic */ NotebookBelowCellDelimiterPanel this$0;
            final /* synthetic */ Function2<ZonedDateTime, ZonedDateTime, String> $diffFormatter;
            {
                this.this$0 = $receiver;
                this.$diffFormatter = $diffFormatter;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        Flow flow2 = FlowKt.flow((Function2)((Function2)new Function2<FlowCollector<? super String>, Continuation<? super Unit>, Object>(this.this$0, this.$diffFormatter, null){
                            int label;
                            private /* synthetic */ Object L$0;
                            final /* synthetic */ NotebookBelowCellDelimiterPanel this$0;
                            final /* synthetic */ Function2<ZonedDateTime, ZonedDateTime, String> $diffFormatter;
                            {
                                this.this$0 = $receiver;
                                this.$diffFormatter = $diffFormatter;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object var1_1) {
                                block8: {
                                    var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    block0 : switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)var1_1);
                                            $this$flow = (FlowCollector)this.L$0;
lbl7:
                                            // 2 sources

                                            while (true) {
                                                if (NotebookBelowCellDelimiterPanel.access$getElapsedStartTime$p(this.this$0) == null) break block0;
                                                var4_5 = this.$diffFormatter;
                                                startTime = var3_4;
                                                $i$a$-let-NotebookBelowCellDelimiterPanel$startElapsedTimeUpdate$1$flow$1$1 = false;
                                                var7_8 = ZonedDateTime.now();
                                                Intrinsics.checkNotNullExpressionValue((Object)var7_8, (String)"now(...)");
                                                this.L$0 = $this$flow;
                                                this.label = 1;
                                                v0 = $this$flow.emit(var4_5.invoke((Object)startTime, (Object)var7_8), (Continuation)this);
                                                if (v0 == var8_2) {
                                                    return var8_2;
                                                }
                                                break block8;
                                                break;
                                            }
                                        }
                                        case 1: {
                                            $i$a$-let-NotebookBelowCellDelimiterPanel$startElapsedTimeUpdate$1$flow$1$1 = false;
                                            $this$flow = (FlowCollector)this.L$0;
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
                                            break;
                                        }
                                    }
                                }
                                this.L$0 = $this$flow;
                                this.label = 2;
                                v1 = DelayKt.delay((long)NotebookBelowCellDelimiterPanel.access$getUpdateElapsedTimeDelay$p(this.this$0), (Continuation)((Continuation)this));
                                if (v1 == var8_2) {
                                    return var8_2;
                                }
                                ** GOTO lbl39
                                {
                                    case 2: {
                                        $this$flow = (FlowCollector)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
lbl39:
                                        // 2 sources

                                        ** continue;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(FlowCollector<? super String> p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }));
                        this.label = 1;
                        Object object3 = flow2.collect(new FlowCollector(this.this$0){
                            final /* synthetic */ NotebookBelowCellDelimiterPanel this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            public final Object emit(String elapsedText, Continuation<? super Unit> $completion) {
                                NotebookBelowCellDelimiterPanel.access$updateElapsedTime(this.this$0, elapsedText);
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void stopElapsedTimeUpdate() {
        Job job = this.elapsedTimeJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.elapsedTimeJob = null;
    }

    private final JLabel getOrCreateExecutionLabel() {
        JLabel jLabel = this.executionLabel;
        if (jLabel == null) {
            JLabel jLabel2;
            JLabel it = jLabel2 = this.createExecutionLabel();
            boolean bl = false;
            this.add((Component)it, "West");
            this.executionLabel = it;
            jLabel = jLabel2;
        }
        return jLabel;
    }

    public static final /* synthetic */ ZonedDateTime access$getElapsedStartTime$p(NotebookBelowCellDelimiterPanel $this) {
        return $this.elapsedStartTime;
    }

    public static final /* synthetic */ long access$getUpdateElapsedTimeDelay$p(NotebookBelowCellDelimiterPanel $this) {
        return $this.updateElapsedTimeDelay;
    }

    public static final /* synthetic */ JLabel access$updateElapsedTime(NotebookBelowCellDelimiterPanel $this, String elapsedText) {
        return $this.updateElapsedTime(elapsedText);
    }
}

