/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.ui.visualization.markerRenderers;

import com.intellij.notebooks.ui.visualization.NotebookEditorAppearance;
import com.intellij.notebooks.ui.visualization.NotebookUtil;
import com.intellij.notebooks.ui.visualization.markerRenderers.NotebookLineMarkerRenderer;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012 \b\u0002\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t0\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0006\u001a\u001a\u0012\u0004\u0012\u00020\b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/notebooks/ui/visualization/markerRenderers/NotebookMarkdownCellLeftBorderRenderer;", "Lcom/intellij/notebooks/ui/visualization/markerRenderers/NotebookLineMarkerRenderer;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "color", "Ljava/awt/Color;", "boundsProvider", "Lkotlin/Function1;", "Lcom/intellij/openapi/editor/Editor;", "Lkotlin/Pair;", "", "<init>", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;Ljava/awt/Color;Lkotlin/jvm/functions/Function1;)V", "paint", "", "editor", "g", "Ljava/awt/Graphics;", "r", "Ljava/awt/Rectangle;", "intellij.notebooks.ui"})
public final class NotebookMarkdownCellLeftBorderRenderer
extends NotebookLineMarkerRenderer {
    @NotNull
    private final RangeHighlighter highlighter;
    @NotNull
    private final Color color;
    @NotNull
    private final Function1<Editor, Pair<Integer, Integer>> boundsProvider;

    public NotebookMarkdownCellLeftBorderRenderer(@NotNull RangeHighlighter highlighter, @NotNull Color color, @NotNull Function1<? super Editor, Pair<Integer, Integer>> boundsProvider) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        Intrinsics.checkNotNullParameter(boundsProvider, (String)"boundsProvider");
        super(null, 1, null);
        this.highlighter = highlighter;
        this.color = color;
        this.boundsProvider = boundsProvider;
    }

    public /* synthetic */ NotebookMarkdownCellLeftBorderRenderer(RangeHighlighter rangeHighlighter, Color color, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = arg_0 -> NotebookMarkdownCellLeftBorderRenderer._init_$lambda$0(rangeHighlighter, arg_0);
        }
        this(rangeHighlighter, color, (Function1<? super Editor, Pair<Integer, Integer>>)function1);
    }

    public void paint(@NotNull Editor editor, @NotNull Graphics g, @NotNull Rectangle r) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        EditorImpl cfr_ignored_0 = (EditorImpl)editor;
        Pair pair = (Pair)this.boundsProvider.invoke((Object)editor);
        int top = ((Number)pair.component1()).intValue();
        int height = ((Number)pair.component2()).intValue();
        Graphics2D g2d = (Graphics2D)g;
        NotebookEditorAppearance appearance = NotebookUtil.INSTANCE.getNotebookAppearance(editor);
        int leftBorderX = r.x + r.width - appearance.getLeftBorderWidth();
        Stroke originalStroke = g2d.getStroke();
        RenderingHints originalHints = g2d.getRenderingHints();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2d.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        g2d.setColor(this.color);
        g2d.setStroke(new BasicStroke(1.0f));
        g2d.draw(new Line2D.Float(leftBorderX, top, leftBorderX, top + height));
        g2d.setStroke(originalStroke);
        g2d.setRenderingHints(originalHints);
    }

    private static final Pair _init_$lambda$0(RangeHighlighter $highlighter, Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        IntRange lines = new IntRange(editor.getDocument().getLineNumber($highlighter.getStartOffset()), editor.getDocument().getLineNumber($highlighter.getEndOffset()));
        int top = editor.offsetToXY((int)editor.getDocument().getLineStartOffset((int)lines.getFirst())).y;
        int height = editor.offsetToXY((int)editor.getDocument().getLineEndOffset((int)lines.getLast())).y + editor.getLineHeight() - top;
        return TuplesKt.to((Object)top, (Object)height);
    }
}

