/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.ui;

import com.intellij.notebooks.visualization.inlay.JupyterBoundsChangeHandler;
import com.intellij.notebooks.visualization.ui.NotebookEditorKt;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.ui.components.JBScrollPane;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0003)*+B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0006\u001a\u0004\u0018\u00010\u0013H\u0016J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0012\u0010\u0018\u001a\u00020\u00192\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0012\u0010\u001a\u001a\u00020\u00192\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u0012\u0010\u001b\u001a\u00020\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0016J\u001c\u0010\u000f\u001a\u00020\u00102\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0012\u0010\u001e\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0012\u0010\u001f\u001a\u00020\u00152\b\u0010 \u001a\u0004\u0018\u00010\u0017H\u0016J\u0012\u0010!\u001a\u00020\u00152\b\u0010 \u001a\u0004\u0018\u00010\u0017H\u0016J\u0010\u0010\"\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u0017H\u0016J \u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\n2\u0006\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020'H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006,"}, d2={"Lcom/intellij/notebooks/visualization/ui/EditorEmbeddedComponentLayoutManager;", "Ljava/awt/LayoutManager2;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "<init>", "(Lcom/intellij/openapi/editor/ex/EditorEx;)V", "constraints", "", "Lkotlin/Pair;", "Ljavax/swing/JComponent;", "Lcom/intellij/notebooks/visualization/ui/EditorEmbeddedComponentLayoutManager$Constraint;", "myEditorScrollPane", "Ljavax/swing/JScrollPane;", "getMyEditorScrollPane", "()Ljavax/swing/JScrollPane;", "addLayoutComponent", "", "comp", "Ljava/awt/Component;", "", "maximumLayoutSize", "Ljava/awt/Dimension;", "target", "Ljava/awt/Container;", "getLayoutAlignmentX", "", "getLayoutAlignmentY", "invalidateLayout", "name", "", "removeLayoutComponent", "preferredLayoutSize", "parent", "minimumLayoutSize", "layoutContainer", "synchronizeBoundsWithInlay", "constraint", "component", "visibleWidth", "", "verticalScrollbarLeftShift", "Constraint", "InlayConstraint", "CustomFoldingConstraint", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nEditorEmbeddedComponentLayoutManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorEmbeddedComponentLayoutManager.kt\ncom/intellij/notebooks/visualization/ui/EditorEmbeddedComponentLayoutManager\n+ 2 Collections.kt\nkotlin/collections/CollectionsKt__CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,142:1\n403#2,7:143\n1#3:150\n360#4,7:151\n*S KotlinDebug\n*F\n+ 1 EditorEmbeddedComponentLayoutManager.kt\ncom/intellij/notebooks/visualization/ui/EditorEmbeddedComponentLayoutManager\n*L\n20#1:143,7\n44#1:151,7\n*E\n"})
public final class EditorEmbeddedComponentLayoutManager
implements LayoutManager2 {
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final List<Pair<JComponent, Constraint>> constraints;

    public EditorEmbeddedComponentLayoutManager(@NotNull EditorEx editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.editor = editor;
        this.constraints = new ArrayList();
    }

    private final JScrollPane getMyEditorScrollPane() {
        JScrollPane jScrollPane = this.editor.getScrollPane();
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"getScrollPane(...)");
        return jScrollPane;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addLayoutComponent(@NotNull Component comp, @Nullable Object constraints) {
        void $this$binarySearchBy_u24default$iv;
        Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
        if (!(constraints instanceof Constraint)) {
            return;
        }
        List<Pair<JComponent, Constraint>> list = this.constraints;
        Comparable key$iv = Integer.valueOf(((Constraint)constraints).getOrder());
        int fromIndex$iv = 0;
        int toIndex$iv = $this$binarySearchBy_u24default$iv.size();
        boolean $i$f$binarySearchBy = false;
        int it = CollectionsKt.binarySearch((List)$this$binarySearchBy_u24default$iv, (int)fromIndex$iv, (int)toIndex$iv, (Function1)((Function1)new Function1<Pair<? extends JComponent, ? extends Constraint>, Integer>(key$iv){
            final /* synthetic */ Comparable $key;
            {
                this.$key = $key;
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            public final Integer invoke(Object it) {
                Pair pair = (Pair)it;
                boolean bl = false;
                return ComparisonsKt.compareValues((Comparable)Integer.valueOf(((Constraint)pair.getSecond()).getOrder()), (Comparable)this.$key);
            }
        }));
        boolean bl = false;
        int insertIndex = it < 0 ? -it - 1 : it;
        this.constraints.add(insertIndex, (Pair<JComponent, Constraint>)TuplesKt.to((Object)((JComponent)comp), (Object)constraints));
    }

    @Override
    @NotNull
    public Dimension maximumLayoutSize(@Nullable Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(@Nullable Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(@Nullable Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(@Nullable Container target) {
    }

    @Override
    public void addLayoutComponent(@Nullable String name, @Nullable Component comp) {
        throw new UnsupportedOperationException("Using string-based constraints is not supported.");
    }

    @Override
    public void removeLayoutComponent(@Nullable Component comp) {
        block3: {
            Integer n;
            int n2;
            block2: {
                List<Pair<JComponent, Constraint>> $this$indexOfFirst$iv = this.constraints;
                boolean $i$f$indexOfFirst = false;
                int index$iv = 0;
                Iterator<Pair<JComponent, Constraint>> iterator = $this$indexOfFirst$iv.iterator();
                while (iterator.hasNext()) {
                    Pair<JComponent, Constraint> item$iv;
                    Pair<JComponent, Constraint> it = item$iv = iterator.next();
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it.getSecond(), (Object)comp)) {
                        n2 = index$iv;
                        break block2;
                    }
                    ++index$iv;
                }
                n2 = -1;
            }
            Integer n3 = n2;
            int it = ((Number)n3).intValue();
            boolean bl = false;
            Integer n4 = n = it >= 0 ? n3 : null;
            if (n == null) break block3;
            it = ((Number)n).intValue();
            boolean bl2 = false;
            this.constraints.remove(it);
        }
    }

    @Override
    @NotNull
    public Dimension preferredLayoutSize(@Nullable Container parent) {
        return new Dimension(0, 0);
    }

    @Override
    @NotNull
    public Dimension minimumLayoutSize(@Nullable Container parent) {
        return new Dimension(0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(@NotNull Container parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Object object = parent.getTreeLock();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getTreeLock(...)");
        Object object2 = object;
        synchronized (object2) {
            boolean bl = false;
            NotebookEditorKt.getNotebookEditor((Editor)this.editor).getEditorPositionKeeper().keepScrollingPositionWhile(() -> EditorEmbeddedComponentLayoutManager.layoutContainer$lambda$6$lambda$5(this));
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void synchronizeBoundsWithInlay(Constraint constraint, JComponent component, int visibleWidth) {
        Rectangle inlayBounds = constraint.getBounds();
        if (inlayBounds != null) {
            inlayBounds.setLocation(inlayBounds.x + this.verticalScrollbarLeftShift(), inlayBounds.y);
            Dimension size = component.getPreferredSize();
            Rectangle newBounds = new Rectangle(inlayBounds.x, inlayBounds.y, Math.min(constraint.isFullWidth() ? visibleWidth : size.width, visibleWidth), size.height);
            if (!Intrinsics.areEqual((Object)newBounds, (Object)component.getBounds())) {
                component.setBounds(newBounds);
                constraint.update();
            }
        }
    }

    private final int verticalScrollbarLeftShift() {
        Object flipProperty = this.getMyEditorScrollPane().getClientProperty(JBScrollPane.Flip.class);
        if (flipProperty == JBScrollPane.Flip.HORIZONTAL || flipProperty == JBScrollPane.Flip.BOTH) {
            return this.getMyEditorScrollPane().getVerticalScrollBar().getWidth();
        }
        return 0;
    }

    private static final Unit layoutContainer$lambda$6$lambda$5(EditorEmbeddedComponentLayoutManager this$0) {
        int visibleWidth = Math.max(this$0.getMyEditorScrollPane().getViewport().getWidth() - this$0.getMyEditorScrollPane().getVerticalScrollBar().getWidth(), 0);
        for (Pair<JComponent, Constraint> entry : this$0.constraints) {
            JComponent component = (JComponent)entry.getFirst();
            this$0.synchronizeBoundsWithInlay((Constraint)entry.getSecond(), component, visibleWidth);
        }
        return Unit.INSTANCE;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001J\n\u0010\u0002\u001a\u0004\u0018\u00010\u0003H&J\b\u0010\u0004\u001a\u00020\u0005H&R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\bR\u0012\u0010\t\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u0082\u0001\u0002\r\u000e\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000f\u00c0\u0006\u0001"}, d2={"Lcom/intellij/notebooks/visualization/ui/EditorEmbeddedComponentLayoutManager$Constraint;", "", "getBounds", "Ljava/awt/Rectangle;", "update", "", "isFullWidth", "", "()Z", "order", "", "getOrder", "()I", "Lcom/intellij/notebooks/visualization/ui/EditorEmbeddedComponentLayoutManager$CustomFoldingConstraint;", "Lcom/intellij/notebooks/visualization/ui/EditorEmbeddedComponentLayoutManager$InlayConstraint;", "intellij.notebooks.visualization"})
    public static interface Constraint {
        @Nullable
        public Rectangle getBounds();

        public void update();

        public boolean isFullWidth();

        public int getOrder();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\bR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/notebooks/visualization/ui/EditorEmbeddedComponentLayoutManager$CustomFoldingConstraint;", "Lcom/intellij/notebooks/visualization/ui/EditorEmbeddedComponentLayoutManager$Constraint;", "customFoldRegion", "Lcom/intellij/openapi/editor/CustomFoldRegion;", "isFullWidth", "", "<init>", "(Lcom/intellij/openapi/editor/CustomFoldRegion;Z)V", "()Z", "getBounds", "Ljava/awt/Rectangle;", "update", "", "order", "", "getOrder", "()I", "intellij.notebooks.visualization"})
    @SourceDebugExtension(value={"SMAP\nEditorEmbeddedComponentLayoutManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorEmbeddedComponentLayoutManager.kt\ncom/intellij/notebooks/visualization/ui/EditorEmbeddedComponentLayoutManager$CustomFoldingConstraint\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,142:1\n1#2:143\n*E\n"})
    public static final class CustomFoldingConstraint
    implements Constraint {
        @NotNull
        private final CustomFoldRegion customFoldRegion;
        private final boolean isFullWidth;

        public CustomFoldingConstraint(@NotNull CustomFoldRegion customFoldRegion, boolean isFullWidth) {
            Intrinsics.checkNotNullParameter((Object)customFoldRegion, (String)"customFoldRegion");
            this.customFoldRegion = customFoldRegion;
            this.isFullWidth = isFullWidth;
        }

        @Override
        public boolean isFullWidth() {
            return this.isFullWidth;
        }

        @Override
        @Nullable
        public Rectangle getBounds() {
            Rectangle rectangle;
            Point point = this.customFoldRegion.getLocation();
            if (point != null) {
                Point it = point;
                boolean bl = false;
                rectangle = new Rectangle(it, new Dimension(this.customFoldRegion.getWidthInPixels(), this.customFoldRegion.getHeightInPixels()));
            } else {
                rectangle = null;
            }
            return rectangle;
        }

        @Override
        public void update() {
            this.customFoldRegion.update();
            Editor editor = this.customFoldRegion.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            JupyterBoundsChangeHandler.Companion.get(editor).boundsChanged();
        }

        @Override
        public int getOrder() {
            return this.customFoldRegion.getStartOffset();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u001d\b\u0000\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\bR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/notebooks/visualization/ui/EditorEmbeddedComponentLayoutManager$InlayConstraint;", "Lcom/intellij/notebooks/visualization/ui/EditorEmbeddedComponentLayoutManager$Constraint;", "inlay", "Lcom/intellij/openapi/editor/Inlay;", "isFullWidth", "", "<init>", "(Lcom/intellij/openapi/editor/Inlay;Z)V", "()Z", "getBounds", "Ljava/awt/Rectangle;", "update", "", "order", "", "getOrder", "()I", "intellij.notebooks.visualization"})
    public static final class InlayConstraint
    implements Constraint {
        @NotNull
        private final Inlay<?> inlay;
        private final boolean isFullWidth;

        public InlayConstraint(@NotNull Inlay<?> inlay, boolean isFullWidth) {
            Intrinsics.checkNotNullParameter(inlay, (String)"inlay");
            this.inlay = inlay;
            this.isFullWidth = isFullWidth;
        }

        @Override
        public boolean isFullWidth() {
            return this.isFullWidth;
        }

        @Override
        @Nullable
        public Rectangle getBounds() {
            return this.inlay.getBounds();
        }

        @Override
        public void update() {
            this.inlay.update();
        }

        @Override
        public int getOrder() {
            return this.inlay.getOffset();
        }
    }
}

