/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.ui.jupyterToolbars;

import com.intellij.notebooks.ui.visualization.NotebookUtil;
import com.intellij.notebooks.visualization.NotebookCellLines;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.jupyterToolbars.JupyterCellActionsToolbar;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\u000bJ\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0006\u0010\u000f\u001a\u00020\u000bJ\b\u0010\u0010\u001a\u00020\u000bH\u0002J\u000f\u0010\u0011\u001a\u0004\u0018\u00010\u000bH\u0002\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u000bH\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/intellij/notebooks/visualization/ui/jupyterToolbars/EditorCellActionsToolbarManager;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "cell", "Lcom/intellij/notebooks/visualization/ui/EditorCell;", "<init>", "(Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/intellij/notebooks/visualization/ui/EditorCell;)V", "toolbar", "Lcom/intellij/notebooks/visualization/ui/jupyterToolbars/JupyterCellActionsToolbar;", "showToolbar", "", "targetComponent", "Ljavax/swing/JComponent;", "updateToolbarPosition", "hideToolbar", "refreshUI", "removeToolbar", "()Lkotlin/Unit;", "dispose", "getActionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "cellType", "Lcom/intellij/notebooks/visualization/NotebookCellLines$CellType;", "hideDropdownIcon", "actionGroupId", "", "calculateToolbarBounds", "Ljava/awt/Rectangle;", "panel", "Ljavax/swing/JPanel;", "Companion", "intellij.notebooks.visualization"})
public final class EditorCellActionsToolbarManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final EditorCell cell;
    @Nullable
    private JupyterCellActionsToolbar toolbar;
    private static final double RELATIVE_Y_OFFSET_RATIO = 0.05;
    @Language(value="devkit-action-id")
    @NotNull
    private static final String ADDITIONAL_CODE_ACTION_GROUP_ID = "Jupyter.AboveCodeCellAdditionalToolbar";
    @Language(value="devkit-action-id")
    @NotNull
    private static final String ADDITIONAL_CODE_ELLIPSIS_ACTION_GROUP_ID = "Jupyter.AboveCodeCellAdditionalToolbar.Ellipsis";
    @Language(value="devkit-action-id")
    @NotNull
    private static final String ADDITIONAL_MARKDOWN_ACTION_GROUP_ID = "Jupyter.AboveMarkdownCellAdditionalToolbar";
    @Language(value="devkit-action-id")
    @NotNull
    private static final String ADDITIONAL_MARKDOWN_ELLIPSIS_ACTION_GROUP_ID = "Jupyter.AboveMarkdownCellAdditionalToolbar.Ellipsis";

    public EditorCellActionsToolbarManager(@NotNull EditorEx editor, @NotNull EditorCell cell) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)cell, (String)"cell");
        this.editor = editor;
        this.cell = cell;
    }

    public final void showToolbar(@NotNull JComponent targetComponent) {
        Intrinsics.checkNotNullParameter((Object)targetComponent, (String)"targetComponent");
        if (this.toolbar != null) {
            return;
        }
        ActionGroup actionGroup = this.getActionGroup(this.cell.getInterval().getType());
        if (actionGroup == null) {
            return;
        }
        ActionGroup actionGroup2 = actionGroup;
        this.toolbar = new JupyterCellActionsToolbar(actionGroup2, targetComponent, null, 4, null);
        this.editor.getContentComponent().add((Component)((Object)this.toolbar), 0);
        this.updateToolbarPosition(targetComponent);
        this.refreshUI();
    }

    public final void updateToolbarPosition() {
        Object object = this.toolbar;
        if (object == null || (object = object.getTargetComponent()) == null) {
            return;
        }
        this.updateToolbarPosition((JComponent)object);
    }

    private final void updateToolbarPosition(JComponent targetComponent) {
        block0: {
            JupyterCellActionsToolbar jupyterCellActionsToolbar = this.toolbar;
            if (jupyterCellActionsToolbar == null) break block0;
            JupyterCellActionsToolbar tb = jupyterCellActionsToolbar;
            boolean bl = false;
            tb.validate();
            tb.setBounds(this.calculateToolbarBounds(targetComponent, (JPanel)((Object)tb)));
        }
    }

    public final void hideToolbar() {
        this.removeToolbar();
        this.refreshUI();
    }

    private final void refreshUI() {
        this.editor.getContentComponent().revalidate();
        this.editor.getContentComponent().repaint();
    }

    private final Unit removeToolbar() {
        Unit unit;
        JupyterCellActionsToolbar jupyterCellActionsToolbar = this.toolbar;
        if (jupyterCellActionsToolbar != null) {
            JupyterCellActionsToolbar it = jupyterCellActionsToolbar;
            boolean bl = false;
            this.editor.getContentComponent().remove((Component)((Object)it));
            this.toolbar = null;
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    public void dispose() {
        this.hideToolbar();
    }

    private final ActionGroup getActionGroup(NotebookCellLines.CellType cellType) {
        return switch (WhenMappings.$EnumSwitchMapping$0[cellType.ordinal()]) {
            case 1 -> {
                this.hideDropdownIcon(ADDITIONAL_CODE_ELLIPSIS_ACTION_GROUP_ID);
                AnAction var2_2 = ActionManager.getInstance().getAction(ADDITIONAL_CODE_ACTION_GROUP_ID);
                if (var2_2 instanceof ActionGroup) {
                    yield (ActionGroup)var2_2;
                }
                yield null;
            }
            case 2 -> {
                this.hideDropdownIcon(ADDITIONAL_MARKDOWN_ELLIPSIS_ACTION_GROUP_ID);
                AnAction var2_3 = ActionManager.getInstance().getAction(ADDITIONAL_MARKDOWN_ACTION_GROUP_ID);
                if (var2_3 instanceof ActionGroup) {
                    yield (ActionGroup)var2_3;
                }
                yield null;
            }
            case 3 -> null;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final void hideDropdownIcon(String actionGroupId) {
        AnAction anAction = ActionManager.getInstance().getAction(actionGroupId);
        Intrinsics.checkNotNull((Object)anAction, (String)"null cannot be cast to non-null type com.intellij.openapi.actionSystem.ActionGroup");
        ((ActionGroup)anAction).getTemplatePresentation().putClientProperty(ActionUtil.HIDE_DROPDOWN_ICON, (Object)true);
    }

    private final Rectangle calculateToolbarBounds(JComponent panel, JPanel toolbar) {
        toolbar.doLayout();
        panel.doLayout();
        int toolbarHeight = toolbar.getPreferredSize().height;
        int toolbarWidth = toolbar.getPreferredSize().width;
        int panelHeight = panel.getHeight();
        int panelWidth = panel.getWidth();
        int delimiterSize = this.cell.getInterval().getOrdinal() == 0 ? NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this.editor).getAboveFirstCellDelimiterHeight() : NotebookUtil.INSTANCE.getNotebookAppearance((Editor)this.editor).getDistanceBetweenCells();
        int panelRoofHeight = panelHeight - delimiterSize;
        int xOffset = (int)((double)(panelWidth - toolbarWidth) - (double)panelWidth * 0.05);
        int yOffset = panelHeight - panelRoofHeight - toolbarHeight / 2;
        Point panelLocationInEditor = SwingUtilities.convertPoint(panel, new Point(0, 0), this.editor.getContentComponent());
        int xCoordinate = panelLocationInEditor.x + xOffset;
        int yCoordinate = panelLocationInEditor.y + yOffset;
        return new Rectangle(xCoordinate, yCoordinate, toolbarWidth, toolbarHeight);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00078\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00078\u0002X\u0083T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00078\u0002X\u0083T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/notebooks/visualization/ui/jupyterToolbars/EditorCellActionsToolbarManager$Companion;", "", "<init>", "()V", "RELATIVE_Y_OFFSET_RATIO", "", "ADDITIONAL_CODE_ACTION_GROUP_ID", "", "ADDITIONAL_CODE_ELLIPSIS_ACTION_GROUP_ID", "ADDITIONAL_MARKDOWN_ACTION_GROUP_ID", "ADDITIONAL_MARKDOWN_ELLIPSIS_ACTION_GROUP_ID", "intellij.notebooks.visualization"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[NotebookCellLines.CellType.values().length];
            try {
                nArray[NotebookCellLines.CellType.CODE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotebookCellLines.CellType.MARKDOWN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[NotebookCellLines.CellType.RAW.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

