/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.schema.parser.handlers.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.editorconfig.language.schema.descriptors.EditorConfigDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigNumberDescriptor;
import org.editorconfig.language.schema.descriptors.impl.EditorConfigStringDescriptor;
import org.editorconfig.language.schema.parser.EditorConfigJsonSchemaException;
import org.editorconfig.language.schema.parser.EditorConfigJsonSchemaParser;
import org.editorconfig.language.schema.parser.handlers.EditorConfigDescriptorParseHandlerBase;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lorg/editorconfig/language/schema/parser/handlers/impl/EditorConfigStandardTypeDescriptorParseHandler;", "Lorg/editorconfig/language/schema/parser/handlers/EditorConfigDescriptorParseHandlerBase;", "<init>", "()V", "requiredKeys", "", "", "getRequiredKeys", "()Ljava/util/List;", "doHandle", "Lorg/editorconfig/language/schema/descriptors/EditorConfigDescriptor;", "jsonObject", "Lcom/google/gson/JsonObject;", "parser", "Lorg/editorconfig/language/schema/parser/EditorConfigJsonSchemaParser;", "intellij.editorconfig"})
public final class EditorConfigStandardTypeDescriptorParseHandler
extends EditorConfigDescriptorParseHandlerBase {
    @NotNull
    private final List<String> requiredKeys = CollectionsKt.listOf((Object)"type");

    @Override
    @NotNull
    protected List<String> getRequiredKeys() {
        return this.requiredKeys;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    protected EditorConfigDescriptor doHandle(@NotNull JsonObject jsonObject, @NotNull EditorConfigJsonSchemaParser parser) {
        Intrinsics.checkNotNullParameter((Object)jsonObject, (String)"jsonObject");
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        String documentation = this.tryGetString(jsonObject, "documentation");
        String deprecation = this.tryGetString(jsonObject, "deprecated");
        String string = jsonObject.get("type").getAsString();
        if (string == null) throw new EditorConfigJsonSchemaException((JsonElement)jsonObject);
        int n = -1;
        switch (string.hashCode()) {
            case -1034364087: {
                if (string.equals("number")) {
                    n = 1;
                }
                break;
            }
            case -891985903: {
                if (string.equals("string")) {
                    n = 2;
                }
                break;
            }
            case 3556653: {
                if (string.equals("text")) {
                    n = 3;
                }
                break;
            }
        }
        switch (n) {
            case 1: {
                EditorConfigDescriptor editorConfigDescriptor = new EditorConfigNumberDescriptor(documentation, deprecation);
                return editorConfigDescriptor;
            }
            case 2: {
                EditorConfigDescriptor editorConfigDescriptor = new EditorConfigStringDescriptor(documentation, deprecation, null, 4, null);
                return editorConfigDescriptor;
            }
            case 3: {
                EditorConfigDescriptor editorConfigDescriptor = new EditorConfigStringDescriptor(documentation, deprecation, ".*");
                return editorConfigDescriptor;
            }
            default: {
                throw new EditorConfigJsonSchemaException((JsonElement)jsonObject);
            }
        }
    }
}

