/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.runner;

import com.intellij.execution.CommandLineUtil;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.terminal.ui.TerminalWidget;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.terminal.LocalTerminalDirectRunner;
import org.jetbrains.plugins.terminal.ShellStartupOptions;
import org.jetbrains.plugins.terminal.ShellStartupOptionsKt;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.shell_integration.CommandBlockIntegration;
import org.jetbrains.plugins.terminal.util.ShellIntegration;
import org.jetbrains.plugins.terminal.util.ShellNameUtil;
import org.jetbrains.plugins.terminal.util.ShellType;

@ApiStatus.Internal
public final class LocalShellIntegrationInjector {
    @VisibleForTesting
    public static final String IJ_ZSH_DIR = "JETBRAINS_INTELLIJ_ZSH_DIR";
    private static final Logger LOG = Logger.getInstance(LocalShellIntegrationInjector.class);
    private static final String LOGIN_SHELL = "LOGIN_SHELL";
    private static final String IJ_COMMAND_END_MARKER = "JETBRAINS_INTELLIJ_COMMAND_END_MARKER";
    private static final String JEDITERM_USER_RCFILE = "JEDITERM_USER_RCFILE";
    private static final String ZDOTDIR = "ZDOTDIR";
    private static final String IJ_COMMAND_HISTORY_FILE_ENV = "__INTELLIJ_COMMAND_HISTFILE__";

    @NotNull
    public static ShellStartupOptions injectShellIntegration(@NotNull ShellStartupOptions options, boolean isGenOneTerminal, boolean isGenTwoTerminal) {
        String commandEndMarker;
        if (options == null) {
            LocalShellIntegrationInjector.$$$reportNull$$$0(0);
        }
        List<String> shellCommand = options.getShellCommand();
        String shellExe = (String)ContainerUtil.getFirstItem(shellCommand);
        if (shellCommand == null || shellExe == null) {
            ShellStartupOptions shellStartupOptions = options;
            if (shellStartupOptions == null) {
                LocalShellIntegrationInjector.$$$reportNull$$$0(1);
            }
            return shellStartupOptions;
        }
        ArrayList<String> arguments = new ArrayList<String>(shellCommand.subList(1, shellCommand.size()));
        Map<String, String> envs = ShellStartupOptionsKt.createEnvVariablesMap(options.getEnvVariables());
        ShellIntegration integration = null;
        ArrayList<String> resultCommand = new ArrayList<String>();
        resultCommand.add(shellExe);
        String shellName = PathUtil.getFileName((String)shellExe);
        String rcFilePath = LocalShellIntegrationInjector.findRCFile(shellName);
        if (rcFilePath != null) {
            boolean isBlockTerminal = LocalTerminalDirectRunner.isBlockTerminalSupported(shellName);
            if (ShellNameUtil.isBash(shellName) || SystemInfo.isMac && shellName.equals("sh")) {
                LocalShellIntegrationInjector.addRcFileArgument(envs, arguments, resultCommand, rcFilePath, "--rcfile");
                boolean loginShell = arguments.removeAll(LocalTerminalDirectRunner.LOGIN_CLI_OPTIONS);
                LocalShellIntegrationInjector.setLoginShellEnv(envs, loginShell);
                LocalShellIntegrationInjector.setCommandHistoryFile(options, envs);
                integration = new ShellIntegration(ShellType.BASH, isBlockTerminal ? new CommandBlockIntegration() : null);
            } else if (ShellNameUtil.isZshName(shellName)) {
                String originalZDotDir = envs.get(ZDOTDIR);
                if (StringUtil.isNotEmpty((String)originalZDotDir)) {
                    envs.put("JETBRAINS_INTELLIJ_ORIGINAL_ZDOTDIR", originalZDotDir);
                }
                String intellijZDotDir = PathUtil.getParentPath((String)rcFilePath);
                envs.put(ZDOTDIR, intellijZDotDir);
                envs.put(IJ_ZSH_DIR, PathUtil.getParentPath((String)intellijZDotDir));
                integration = new ShellIntegration(ShellType.ZSH, isBlockTerminal ? new CommandBlockIntegration() : null);
            } else if (shellName.equals("fish")) {
                resultCommand.add("--init-command=source " + CommandLineUtil.posixQuote((String)rcFilePath));
                integration = new ShellIntegration(ShellType.FISH, isBlockTerminal ? new CommandBlockIntegration() : null);
            } else if (ShellNameUtil.isPowerShell(shellName)) {
                resultCommand.addAll(arguments);
                arguments.clear();
                resultCommand.addAll(List.of("-NoExit", "-ExecutionPolicy", "Bypass", "-File", rcFilePath));
                integration = new ShellIntegration(ShellType.POWERSHELL, isBlockTerminal ? new CommandBlockIntegration(true) : null);
            }
        }
        if ((isGenOneTerminal || isGenTwoTerminal) && integration != null && integration.getCommandBlockIntegration() != null) {
            String commandBlocksOption = isGenOneTerminal ? "INTELLIJ_TERMINAL_COMMAND_BLOCKS" : "INTELLIJ_TERMINAL_COMMAND_BLOCKS_REWORKED";
            envs.put(commandBlocksOption, "1");
            envs.put("FIG_TERM", "1");
            envs.put("PROCESS_LAUNCHED_BY_CW", "1");
            envs.put("PROCESS_LAUNCHED_BY_Q", "1");
        }
        CommandBlockIntegration commandIntegration = integration != null ? integration.getCommandBlockIntegration() : null;
        String string = commandEndMarker = commandIntegration != null ? commandIntegration.getCommandEndMarker() : null;
        if (commandEndMarker != null) {
            envs.put(IJ_COMMAND_END_MARKER, commandEndMarker);
        }
        resultCommand.addAll(arguments);
        ShellStartupOptions shellStartupOptions = options.builder().shellCommand(resultCommand).envVariables(envs).shellIntegration(integration).build();
        if (shellStartupOptions == null) {
            LocalShellIntegrationInjector.$$$reportNull$$$0(2);
        }
        return shellStartupOptions;
    }

    @Nullable
    private static String findRCFile(@NotNull String shellName) {
        String rcfile;
        if (shellName == null) {
            LocalShellIntegrationInjector.$$$reportNull$$$0(3);
        }
        switch (shellName) {
            case "bash": 
            case "sh": {
                String string = "shell-integrations/bash/bash-integration.bash";
                break;
            }
            case "zsh": {
                String string = "shell-integrations/zsh/zdotdir/.zshenv";
                break;
            }
            case "fish": {
                String string = "shell-integrations/fish/fish-integration.fish";
                break;
            }
            default: {
                String string = rcfile = null;
            }
        }
        if (rcfile == null && ShellNameUtil.isPowerShell(shellName)) {
            rcfile = "shell-integrations/powershell/powershell-integration.ps1";
        }
        if (rcfile != null) {
            try {
                return LocalShellIntegrationInjector.findAbsolutePath(rcfile);
            }
            catch (Exception e) {
                LOG.warn("Unable to find " + rcfile + " configuration file", (Throwable)e);
            }
        }
        return null;
    }

    @VisibleForTesting
    @NotNull
    static String findAbsolutePath(@NotNull String relativePath) throws IOException {
        File result;
        if (relativePath == null) {
            LocalShellIntegrationInjector.$$$reportNull$$$0(4);
        }
        Object jarPath = PathUtil.getJarPathForClass(LocalTerminalDirectRunner.class);
        if (PluginManagerCore.isRunningFromSources()) {
            result = Path.of(PathManager.getCommunityHomePath(), new String[0]).resolve("plugins/terminal/resources/").resolve(relativePath).toFile();
        } else if (((String)jarPath).endsWith(".jar")) {
            File jarFile = new File((String)jarPath);
            if (!jarFile.isFile()) {
                throw new IOException("Broken installation: " + (String)jarPath + " is not a file");
            }
            File pluginBaseDir = jarFile.getParentFile().getParentFile();
            result = new File(pluginBaseDir, relativePath);
        } else {
            String srcDir;
            Application application = ApplicationManager.getApplication();
            if (application != null && application.isInternal() && new File(srcDir = ((String)(jarPath = StringUtil.trimEnd((String)((String)jarPath).replace('\\', '/'), (char)'/') + "/")).replace("/out/classes/production/intellij.terminal/", "/community/plugins/terminal/resources/")).isDirectory()) {
                jarPath = srcDir;
            }
            result = new File((String)jarPath, relativePath);
        }
        if (!result.isFile()) {
            throw new IOException("Cannot find " + relativePath + ": " + result.getAbsolutePath() + " is not a file");
        }
        String string = result.getAbsolutePath();
        if (string == null) {
            LocalShellIntegrationInjector.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static void setLoginShellEnv(@NotNull Map<String, String> envs, boolean loginShell) {
        if (envs == null) {
            LocalShellIntegrationInjector.$$$reportNull$$$0(6);
        }
        if (loginShell) {
            envs.put(LOGIN_SHELL, "1");
        }
    }

    private static void addRcFileArgument(Map<String, String> envs, List<String> arguments, List<String> result, String rcFilePath, String rcfileOption) {
        result.add(rcfileOption);
        result.add(rcFilePath);
        int idx = arguments.indexOf(rcfileOption);
        if (idx >= 0) {
            arguments.remove(idx);
            if (idx < arguments.size()) {
                String userRcFile = FileUtil.expandUserHome((String)arguments.get(idx));
                if (!userRcFile.equals(rcFilePath)) {
                    envs.put(JEDITERM_USER_RCFILE, FileUtil.expandUserHome((String)arguments.get(idx)));
                }
                arguments.remove(idx);
            }
        }
    }

    private static void setCommandHistoryFile(@NotNull ShellStartupOptions startupOptions, @NotNull Map<String, String> envs) {
        Function0<Path> commandHistoryFileProvider;
        Path commandHistoryFile;
        if (startupOptions == null) {
            LocalShellIntegrationInjector.$$$reportNull$$$0(7);
        }
        if (envs == null) {
            LocalShellIntegrationInjector.$$$reportNull$$$0(8);
        }
        Path path = commandHistoryFile = (commandHistoryFileProvider = startupOptions.getCommandHistoryFileProvider()) != null ? (Path)commandHistoryFileProvider.invoke() : null;
        if (commandHistoryFile != null) {
            envs.put(IJ_COMMAND_HISTORY_FILE_ENV, commandHistoryFile.toString());
            ShellTerminalWidget widget = LocalShellIntegrationInjector.getShellTerminalWidget(startupOptions);
            if (widget != null) {
                widget.setCommandHistoryFilePath(commandHistoryFile.toString());
            }
        }
    }

    @Nullable
    private static ShellTerminalWidget getShellTerminalWidget(@Nullable ShellStartupOptions options) {
        TerminalWidget widget = options != null ? options.getWidget() : null;
        return widget != null ? ShellTerminalWidget.asShellJediTermWidget(widget) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/runner/LocalShellIntegrationInjector";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shellName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startupOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/runner/LocalShellIntegrationInjector";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "injectShellIntegration";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findAbsolutePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "injectShellIntegration";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findRCFile";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findAbsolutePath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setLoginShellEnv";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setCommandHistoryFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 5 -> new IllegalStateException(string);
        };
    }
}

