"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Operations = void 0;
var react_1 = __importDefault(require("react"));
var Operation_1 = require("./Operation");
var contexts_1 = require("../../contexts");
var helpers_1 = require("../../helpers");
var constants_1 = require("../../constants");
var types_1 = require("../../types");
var Operations = function () {
    var channels = (0, contexts_1.useSpec)().channels();
    var config = (0, contexts_1.useConfig)();
    if (!Object.keys(channels).length) {
        return null;
    }
    var operationsList = [];
    Object.entries(channels).forEach(function (_a) {
        var channelName = _a[0], channel = _a[1];
        if (channel.hasPublish()) {
            operationsList.push(react_1.default.createElement("li", { className: "mb-12", key: "pub-".concat(channelName), id: helpers_1.CommonHelpers.getIdentifier("operation-".concat(types_1.PayloadType.PUBLISH, "-").concat(channelName), config) },
                react_1.default.createElement(Operation_1.Operation, { type: types_1.PayloadType.PUBLISH, operation: channel.publish(), channelName: channelName, channel: channel })));
        }
        if (channel.hasSubscribe()) {
            operationsList.push(react_1.default.createElement("li", { className: "mb-12", key: "sub-".concat(channelName), id: helpers_1.CommonHelpers.getIdentifier("operation-".concat(types_1.PayloadType.SUBSCRIBE, "-").concat(channelName), config) },
                react_1.default.createElement(Operation_1.Operation, { type: types_1.PayloadType.SUBSCRIBE, operation: channel.subscribe(), channelName: channelName, channel: channel })));
        }
    });
    return (react_1.default.createElement("section", { id: "".concat(helpers_1.CommonHelpers.getIdentifier('operations', config)), className: "mt-16" },
        react_1.default.createElement("h2", { className: "2xl:w-7/12 text-3xl font-light mb-4 px-8" }, constants_1.OPERATIONS_TEXT),
        react_1.default.createElement("ul", null, operationsList)));
};
exports.Operations = Operations;
//# sourceMappingURL=Operations.js.map