import React from 'react';
import { Schema } from './Schema';
import { SchemaHelpers } from '../helpers';
export var Bindings = function (_a) {
    var _b = _a.name, name = _b === void 0 ? 'Binding specific information' : _b, bindings = _a.bindings;
    if (!bindings || !Object.keys(bindings).length) {
        return null;
    }
    var renderedBindings = Object.entries(bindings).map(function (_a) {
        var bindingName = _a[0], binding = _a[1];
        var schema = SchemaHelpers.jsonToSchema(binding);
        var schemaName = (React.createElement("div", { className: "inline-block text-sm" },
            React.createElement("span", null, name),
            React.createElement("span", { className: "bg-teal-500 font-bold no-underline text-white uppercase rounded mx-2 px-2 py-1 text-xs" }, bindingName)));
        return (schema && (React.createElement(Schema, { schemaName: schemaName, schema: schema, key: bindingName, onlyTitle: true })));
    });
    return React.createElement(React.Fragment, null, renderedBindings);
};
//# sourceMappingURL=Bindings.js.map