/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.dnd;

import java.nio.charset.Charset;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public abstract class LocalObjectTransfer<OBJECT_TYPE>
extends ByteArrayTransfer {
    private OBJECT_TYPE object;
    private long startTime;

    public OBJECT_TYPE getObject() {
        return this.object;
    }

    public void javaToNative(Object object, TransferData transferData) {
        this.setObject(object);
        this.startTime = System.currentTimeMillis();
        if (transferData != null) {
            super.javaToNative((Object)String.valueOf(this.startTime).getBytes(Charset.defaultCharset()), transferData);
        }
    }

    public Object nativeToJava(TransferData transferData) {
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        if (bytes == null) {
            return null;
        }
        long startTime = Long.parseLong(new String(bytes));
        return this.startTime == startTime ? this.getObject() : null;
    }

    public void setObject(OBJECT_TYPE obj) {
        this.object = obj;
    }
}

