"use strict";(self.webpackChunkinfluxdb_ui=self.webpackChunkinfluxdb_ui||[]).push([[324],{66349:e=>{e.exports='# Input plugin to collect Windows Event Log messages\n[[inputs.win_eventlog]]\n  ## Telegraf should have Administrator permissions to subscribe for some Windows Events channels\n  ## (System log, for example)\n\n  ## LCID (Locale ID) for event rendering\n  ## 1033 to force English language\n  ## 0 to use default Windows locale\n  # locale = 0\n\n  ## Name of eventlog, used only if xpath_query is empty\n  ## Example: "Application"\n  # eventlog_name = ""\n\n  ## xpath_query can be in defined short form like "Event/System[EventID=999]"\n  ## or you can form a XML Query. Refer to the Consuming Events article:\n  ## https://docs.microsoft.com/en-us/windows/win32/wes/consuming-events\n  ## XML query is the recommended form, because it is most flexible\n  ## You can create or debug XML Query by creating Custom View in Windows Event Viewer\n  ## and then copying resulting XML here\n  xpath_query = \'\'\'\n  <QueryList>\n    <Query Id="0" Path="Security">\n      <Select Path="Security">*</Select>\n      <Suppress Path="Security">*[System[( (EventID &gt;= 5152 and EventID &lt;= 5158) or EventID=5379 or EventID=4672)]]</Suppress>\n    </Query>\n    <Query Id="1" Path="Application">\n      <Select Path="Application">*[System[(Level &lt; 4)]]</Select>\n    </Query>\n    <Query Id="2" Path="Windows PowerShell">\n      <Select Path="Windows PowerShell">*[System[(Level &lt; 4)]]</Select>\n    </Query>\n    <Query Id="3" Path="System">\n      <Select Path="System">*</Select>\n    </Query>\n    <Query Id="4" Path="Setup">\n      <Select Path="Setup">*</Select>\n    </Query>\n  </QueryList>\n  \'\'\'\n\n  ## System field names:\n  ##   "Source", "EventID", "Version", "Level", "Task", "Opcode", "Keywords", "TimeCreated",\n  ##   "EventRecordID", "ActivityID", "RelatedActivityID", "ProcessID", "ThreadID", "ProcessName",\n  ##   "Channel", "Computer", "UserID", "UserName", "Message", "LevelText", "TaskText", "OpcodeText"\n\n  ## In addition to System, Data fields can be unrolled from additional XML nodes in event.\n  ## Human-readable representation of those nodes is formatted into event Message field,\n  ## but XML is more machine-parsable\n\n  # Process UserData XML to fields, if this node exists in Event XML\n  process_userdata = true\n\n  # Process EventData XML to fields, if this node exists in Event XML\n  process_eventdata = true\n\n  ## Separator character to use for unrolled XML Data field names\n  separator = "_"\n\n  ## Get only first line of Message field. For most events first line is usually more than enough\n  only_first_line_of_message = true\n\n  ## Parse timestamp from TimeCreated.SystemTime event field.\n  ## Will default to current time of telegraf processing on parsing error or if set to false\n  timestamp_from_event = true\n\n  ## Fields to include as tags. Globbing supported ("Level*" for both "Level" and "LevelText")\n  event_tags = ["Source", "EventID", "Level", "LevelText", "Task", "TaskText", "Opcode", "OpcodeText", "Keywords", "Channel", "Computer"]\n\n  ## Default list of fields to send. All fields are sent by default. Globbing supported\n  event_fields = ["*"]\n\n  ## Fields to exclude. Also applied to data fields. Globbing supported\n  exclude_fields = ["TimeCreated", "Binary", "Data_Address*"]\n\n  ## Skip those tags or fields if their value is empty or equals to zero. Globbing supported\n  exclude_empty = ["*ActivityID", "UserID"]\n'}}]);