/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.mrtg.client;

import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import javax.swing.ImageIcon;
import org.jrobin.mrtg.MrtgException;
import org.jrobin.mrtg.client.JarResources;
import org.jrobin.mrtg.client.Util;

class Resources {
    Resources() {
    }

    private static boolean runningFromJar() {
        String string = Resources.class.getName().replace('.', '/');
        String string2 = Util.class.getResource("/" + string + ".class").toString();
        return string2.startsWith("jar:");
    }

    private static String getJarPath() {
        if (Resources.runningFromJar()) {
            return System.getProperty("java.class.path");
        }
        return null;
    }

    static byte[] getResource(String string) throws MrtgException {
        try {
            int n;
            if (Resources.runningFromJar()) {
                String string2 = Resources.getJarPath();
                JarResources jarResources = new JarResources(string2);
                return jarResources.getResource(string);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            FileInputStream fileInputStream = new FileInputStream(string);
            while ((n = fileInputStream.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            fileInputStream.close();
            byteArrayOutputStream.close();
            return byArray;
        }
        catch (IOException iOException) {
            throw new MrtgException(iOException);
        }
    }

    static String getString(String string) throws MrtgException {
        byte[] byArray = Resources.getResource(string);
        return new String(byArray);
    }

    static ImageIcon getImageIcon(String string) throws MrtgException {
        byte[] byArray = Resources.getResource(string);
        return new ImageIcon(byArray);
    }

    static Image getImage(String string) throws MrtgException {
        ImageIcon imageIcon = Resources.getImageIcon(string);
        return imageIcon.getImage();
    }
}

