/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.mrtg.server;

import java.util.Date;
import java.util.Hashtable;
import org.jrobin.core.Util;
import org.jrobin.mrtg.Debug;
import org.jrobin.mrtg.MrtgException;
import org.jrobin.mrtg.server.RawSample;
import org.jrobin.mrtg.server.Server;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class Port {
    static final int DEFAULT_SAMPLING_INTERVAL = 300;
    private int ifIndex = -1;
    private String ifDescr = "";
    private String ifAlias = "";
    private String descr = "";
    private int samplingInterval = 300;
    private boolean active = true;
    private int sampleCount;
    private long lastSampleTime;
    private RawSample lastSample;
    private boolean sampling;

    Port() {
    }

    Port(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            Node node2 = nodeList.item(i);
            String string2 = node2.getNodeName();
            Node node3 = node2.getFirstChild();
            String string3 = string = node3 != null ? node3.getNodeValue().trim() : null;
            if (string2.equals("ifIndex")) {
                this.setIfIndex(Integer.parseInt(string));
                continue;
            }
            if (string2.equals("ifDescr")) {
                this.setIfDescr(string);
                continue;
            }
            if (string2.equals("ifAlias")) {
                this.setIfAlias(string);
                continue;
            }
            if (string2.equals("description")) {
                this.setDescr(string);
                continue;
            }
            if (string2.equals("samplingInterval")) {
                this.setSamplingInterval(Integer.parseInt(string));
                continue;
            }
            if (!string2.equals("active")) continue;
            this.setActive(new Boolean(string));
        }
    }

    int getIfIndex() {
        return this.ifIndex;
    }

    void setIfIndex(int n) {
        this.ifIndex = n;
    }

    String getIfDescr() {
        return this.ifDescr;
    }

    String getIfDescrCore() {
        int n = this.ifDescr.indexOf("#");
        if (n != -1) {
            return this.ifDescr.substring(0, n);
        }
        return this.ifDescr;
    }

    void setIfDescr(String string) {
        if (string != null) {
            this.ifDescr = string;
        }
    }

    String getIfAlias() {
        return this.ifAlias;
    }

    void setIfAlias(String string) {
        if (string != null) {
            this.ifAlias = string;
        }
    }

    int getSamplingInterval() {
        return this.samplingInterval;
    }

    void setSamplingInterval(int n) {
        this.samplingInterval = n;
    }

    boolean isActive() {
        return this.active;
    }

    boolean getActive() {
        return this.active;
    }

    void setActive(boolean bl) {
        this.active = bl;
    }

    String getDescr() {
        return this.descr;
    }

    void setDescr(String string) {
        if (string != null) {
            this.descr = string;
        }
    }

    public String toString() {
        return this.ifDescr + " [" + this.ifIndex + "] " + this.descr + ", " + this.ifAlias + " (each " + this.samplingInterval + "sec, active=" + this.active + ")";
    }

    long getLastSampleTime() {
        return this.lastSampleTime;
    }

    void setLastSampleTime(long l) {
        this.lastSampleTime = l;
    }

    boolean isSampling() {
        return this.sampling;
    }

    void setSampling(boolean bl) {
        this.sampling = bl;
    }

    boolean isDue() {
        if (this.lastSampleTime == 0L) {
            return true;
        }
        long l = Util.getTime() - this.lastSampleTime;
        return l >= (long)this.samplingInterval;
    }

    void switchToIfIndex(int n) throws MrtgException {
        this.ifIndex = n;
        Server.getInstance().saveHardware();
    }

    void deactivate() throws MrtgException {
        this.active = false;
        Server.getInstance().saveHardware();
    }

    void processSample(RawSample rawSample) throws MrtgException {
        if (!this.getIfDescrCore().equals(rawSample.getIfDescr())) {
            this.switchToIfIndex(-1);
            return;
        }
        rawSample.setIfDescr(this.ifDescr);
        if (this.lastSample != null && this.lastSample.getSysUpTime() >= rawSample.getSysUpTime()) {
            rawSample.setValid(false);
        }
        Debug.print("Saving sample: " + rawSample);
        Server.getInstance().getRrdWriter().store(rawSample);
        ++this.sampleCount;
        this.lastSample = rawSample;
        this.lastSampleTime = rawSample.getTimestamp();
    }

    Hashtable getLinkInfo() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("ifIndex", new Integer(this.ifIndex));
        hashtable.put("ifDescr", this.ifDescr);
        hashtable.put("ifAlias", this.ifAlias);
        hashtable.put("descr", this.descr);
        hashtable.put("samplingInterval", new Integer(this.samplingInterval));
        hashtable.put("active", new Boolean(this.active));
        hashtable.put("sampleCount", new Integer(this.sampleCount));
        if (this.lastSample != null) {
            hashtable.put("lastSampleTime", new Date(this.lastSampleTime * 1000L));
            hashtable.put("ifInOctets", String.valueOf(this.lastSample.getIfInOctets()));
            hashtable.put("ifOutOctets", String.valueOf(this.lastSample.getIfOutOctets()));
            hashtable.put("ifOperStatus", String.valueOf(this.lastSample.getIfOperStatus()));
        }
        return hashtable;
    }

    void appendXml(Element element) {
        Document document = element.getOwnerDocument();
        Element element2 = document.createElement("interface");
        element.appendChild(element2);
        Element element3 = document.createElement("ifIndex");
        element3.appendChild(document.createTextNode("" + this.ifIndex));
        element2.appendChild(element3);
        Element element4 = document.createElement("ifDescr");
        element4.appendChild(document.createTextNode(this.ifDescr));
        element2.appendChild(element4);
        Element element5 = document.createElement("ifAlias");
        element5.appendChild(document.createTextNode(this.ifAlias));
        element2.appendChild(element5);
        Element element6 = document.createElement("description");
        element6.appendChild(document.createTextNode(this.descr));
        element2.appendChild(element6);
        Element element7 = document.createElement("samplingInterval");
        element7.appendChild(document.createTextNode("" + this.samplingInterval));
        element2.appendChild(element7);
        Element element8 = document.createElement("active");
        element8.appendChild(document.createTextNode("" + this.active));
        element2.appendChild(element8);
    }
}

