/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.inspector;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jrobin.core.ArcDef;
import org.jrobin.core.DsDef;
import org.jrobin.core.RrdDb;
import org.jrobin.core.RrdException;
import org.jrobin.core.RrdToolkit;
import org.jrobin.inspector.EditArchiveDialog;
import org.jrobin.inspector.EditDatasourceDialog;
import org.jrobin.inspector.InspectorModel;
import org.jrobin.inspector.RrdNode;
import org.jrobin.inspector.Util;

class RrdInspector
extends JFrame {
    static final String TITLE = "RRD File Inspector";
    static final boolean SHOULD_FIX_ARCHIVED_VALUES = false;
    static final boolean SHOULD_CREATE_BACKUPS = true;
    static Dimension MAIN_TREE_SIZE = new Dimension(250, 400);
    static Dimension INFO_PANE_SIZE = new Dimension(450, 400);
    JTabbedPane tabbedPane = new JTabbedPane();
    private JTree mainTree = new JTree();
    private JTable generalTable = new JTable();
    private JTable datasourceTable = new JTable();
    private JTable archiveTable = new JTable();
    private JTable dataTable = new JTable();
    private InspectorModel inspectorModel = new InspectorModel();
    private String lastDirectory = null;

    private RrdInspector(String string) {
        super(TITLE);
        this.constructUI();
        this.showCentered();
        if (string == null) {
            this.selectFile();
        } else {
            this.loadFile(new File(string));
        }
    }

    private void showCentered() {
        this.pack();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = toolkit.getScreenSize();
        Dimension dimension2 = this.getPreferredSize();
        double d = (dimension.getWidth() - dimension2.getWidth()) / 2.0;
        double d2 = (dimension.getHeight() - dimension2.getHeight()) / 2.0;
        this.setLocation((int)d, (int)d2);
        this.setVisible(true);
    }

    private void constructUI() {
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.mainTree);
        jPanel2.add(jScrollPane);
        jPanel2.setPreferredSize(MAIN_TREE_SIZE);
        jPanel.add((Component)jPanel2, "West");
        this.mainTree.getSelectionModel().setSelectionMode(1);
        this.mainTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                RrdInspector.this.nodeChangedAction();
            }
        });
        this.mainTree.setModel(this.inspectorModel.getMainTreeModel());
        JScrollPane jScrollPane2 = new JScrollPane(this.generalTable);
        jScrollPane2.setPreferredSize(INFO_PANE_SIZE);
        this.tabbedPane.add("General info", jScrollPane2);
        this.generalTable.setModel(this.inspectorModel.getGeneralTableModel());
        this.generalTable.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.generalTable.getColumnModel().getColumn(0).setMaxWidth(150);
        JScrollPane jScrollPane3 = new JScrollPane(this.datasourceTable);
        jScrollPane3.setPreferredSize(INFO_PANE_SIZE);
        this.tabbedPane.add("Datasource info", jScrollPane3);
        this.datasourceTable.setModel(this.inspectorModel.getDatasourceTableModel());
        this.datasourceTable.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.datasourceTable.getColumnModel().getColumn(0).setMaxWidth(150);
        JScrollPane jScrollPane4 = new JScrollPane(this.archiveTable);
        this.archiveTable.setModel(this.inspectorModel.getArchiveTableModel());
        this.archiveTable.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.archiveTable.getColumnModel().getColumn(0).setMaxWidth(150);
        jScrollPane4.setPreferredSize(INFO_PANE_SIZE);
        this.tabbedPane.add("Archive info", jScrollPane4);
        JScrollPane jScrollPane5 = new JScrollPane(this.dataTable);
        this.dataTable.setModel(this.inspectorModel.getDataTableModel());
        this.dataTable.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.dataTable.getColumnModel().getColumn(0).setMaxWidth(100);
        this.dataTable.getColumnModel().getColumn(1).setPreferredWidth(150);
        jScrollPane5.setPreferredSize(INFO_PANE_SIZE);
        this.tabbedPane.add("Archive data", jScrollPane5);
        jPanel.add((Component)this.tabbedPane, "Center");
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        JMenuItem jMenuItem = new JMenuItem("Open RRD file...", 79);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RrdInspector.this.selectFile();
            }
        });
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        JMenuItem jMenuItem2 = new JMenuItem("Add datasource...");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RrdInspector.this.addDatasource();
            }
        });
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Edit datasource...");
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RrdInspector.this.editDatasource();
            }
        });
        jMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem("Remove datasource");
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RrdInspector.this.removeDatasource();
            }
        });
        jMenu.add(jMenuItem4);
        jMenu.addSeparator();
        JMenuItem jMenuItem5 = new JMenuItem("Add archive...");
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RrdInspector.this.addArchive();
            }
        });
        jMenu.add(jMenuItem5);
        JMenuItem jMenuItem6 = new JMenuItem("Edit archive...");
        jMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RrdInspector.this.editArchive();
            }
        });
        jMenu.add(jMenuItem6);
        JMenuItem jMenuItem7 = new JMenuItem("Remove archive...");
        jMenuItem7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RrdInspector.this.removeArchive();
            }
        });
        jMenu.add(jMenuItem7);
        jMenu.addSeparator();
        JMenuItem jMenuItem8 = new JMenuItem("Exit", 88);
        jMenuItem8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        jMenu.add(jMenuItem8);
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
    }

    private void nodeChangedAction() {
        RrdNode rrdNode = this.getSelectedRrdNode();
        if (rrdNode != null) {
            this.inspectorModel.selectModel(rrdNode.getDsIndex(), rrdNode.getArcIndex());
            if (rrdNode.getDsIndex() >= 0 && rrdNode.getArcIndex() >= 0) {
                if (this.tabbedPane.getSelectedIndex() < 2) {
                    this.tabbedPane.setSelectedIndex(2);
                }
            } else if (rrdNode.getDsIndex() >= 0) {
                this.tabbedPane.setSelectedIndex(1);
            } else {
                this.tabbedPane.setSelectedIndex(0);
            }
        }
    }

    private RrdNode getSelectedRrdNode() {
        DefaultMutableTreeNode defaultMutableTreeNode;
        Object object;
        TreePath treePath = this.mainTree.getSelectionPath();
        if (treePath != null && (object = (defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject()) instanceof RrdNode) {
            RrdNode rrdNode = (RrdNode)object;
            return rrdNode;
        }
        return null;
    }

    private void selectFile() {
        JFileChooser jFileChooser = new JFileChooser(this.lastDirectory);
        FileFilter fileFilter = new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() ? true : file.getAbsolutePath().toLowerCase().endsWith(".rrd");
            }

            public String getDescription() {
                return "JRobin RRD files";
            }
        };
        jFileChooser.setFileFilter(fileFilter);
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            this.lastDirectory = file.getParent();
            this.loadFile(file);
        }
    }

    private void loadFile(File file) {
        this.inspectorModel.setFile(file);
        this.tabbedPane.setSelectedIndex(0);
    }

    private void addDatasource() {
        if (!this.inspectorModel.isOk()) {
            Util.error(this, "Open a valid RRD file first.");
            return;
        }
        DsDef dsDef = new EditDatasourceDialog((Frame)this, null).getDsDef();
        if (dsDef != null) {
            RrdToolkit rrdToolkit = RrdToolkit.getInstance();
            try {
                String string = this.inspectorModel.getFile().getCanonicalPath();
                rrdToolkit.addDatasource(string, dsDef, true);
                this.inspectorModel.refresh();
                this.tabbedPane.setSelectedIndex(0);
            }
            catch (IOException iOException) {
                Util.error(this, iOException.toString());
            }
            catch (RrdException rrdException) {
                Util.error(this, rrdException.toString());
            }
        }
    }

    private void addArchive() {
        if (!this.inspectorModel.isOk()) {
            Util.error(this, "Open a valid RRD file first.");
            return;
        }
        ArcDef arcDef = new EditArchiveDialog((Frame)this, null).getArcDef();
        if (arcDef != null) {
            RrdToolkit rrdToolkit = RrdToolkit.getInstance();
            try {
                String string = this.inspectorModel.getFile().getCanonicalPath();
                rrdToolkit.addArchive(string, arcDef, true);
                this.inspectorModel.refresh();
                this.tabbedPane.setSelectedIndex(0);
            }
            catch (IOException iOException) {
                Util.error(this, iOException.toString());
            }
            catch (RrdException rrdException) {
                Util.error(this, rrdException.toString());
            }
        }
    }

    private void editDatasource() {
        if (!this.inspectorModel.isOk()) {
            Util.error(this, "Open a valid RRD file first.");
            return;
        }
        RrdNode rrdNode = this.getSelectedRrdNode();
        int n = -1;
        if (rrdNode == null || (n = rrdNode.getDsIndex()) < 0) {
            Util.error(this, "Select datasource first");
            return;
        }
        try {
            String string = this.inspectorModel.getFile().getCanonicalPath();
            RrdDb rrdDb = new RrdDb(string);
            DsDef dsDef = rrdDb.getRrdDef().getDsDefs()[n];
            rrdDb.close();
            DsDef dsDef2 = new EditDatasourceDialog((Frame)this, dsDef).getDsDef();
            if (dsDef2 != null) {
                RrdToolkit rrdToolkit = RrdToolkit.getInstance();
                rrdToolkit.setDsHeartbeat(string, dsDef2.getDsName(), dsDef2.getHeartbeat());
                rrdToolkit.setDsMinMaxValue(string, dsDef2.getDsName(), dsDef2.getMinValue(), dsDef2.getMaxValue(), false);
                this.inspectorModel.refresh();
                this.tabbedPane.setSelectedIndex(0);
            }
            rrdDb.close();
        }
        catch (IOException iOException) {
            Util.error(this, iOException.toString());
        }
        catch (RrdException rrdException) {
            Util.error(this, rrdException.toString());
        }
    }

    private void editArchive() {
        if (!this.inspectorModel.isOk()) {
            Util.error(this, "Open a valid RRD file first.");
            return;
        }
        RrdNode rrdNode = this.getSelectedRrdNode();
        int n = -1;
        if (rrdNode == null || (n = rrdNode.getArcIndex()) < 0) {
            Util.error(this, "Select archive first");
            return;
        }
        try {
            String string = this.inspectorModel.getFile().getCanonicalPath();
            RrdDb rrdDb = new RrdDb(string);
            ArcDef arcDef = rrdDb.getRrdDef().getArcDefs()[n];
            rrdDb.close();
            ArcDef arcDef2 = new EditArchiveDialog((Frame)this, arcDef).getArcDef();
            if (arcDef2 != null) {
                RrdToolkit rrdToolkit = RrdToolkit.getInstance();
                rrdToolkit.setArcXff(string, arcDef2.getConsolFun(), arcDef2.getSteps(), arcDef2.getXff());
                rrdToolkit.resizeArchive(string, arcDef2.getConsolFun(), arcDef2.getSteps(), arcDef2.getRows(), true);
                this.inspectorModel.refresh();
                this.tabbedPane.setSelectedIndex(0);
            }
            rrdDb.close();
        }
        catch (IOException iOException) {
            Util.error(this, iOException.toString());
        }
        catch (RrdException rrdException) {
            Util.error(this, rrdException.toString());
        }
    }

    private void removeDatasource() {
        if (!this.inspectorModel.isOk()) {
            Util.error(this, "Open a valid RRD file first.");
            return;
        }
        RrdNode rrdNode = this.getSelectedRrdNode();
        int n = -1;
        if (rrdNode == null || (n = rrdNode.getDsIndex()) < 0) {
            Util.error(this, "Select datasource first");
            return;
        }
        try {
            String string = this.inspectorModel.getFile().getCanonicalPath();
            RrdDb rrdDb = new RrdDb(string);
            String string2 = rrdDb.getRrdDef().getDsDefs()[n].getDsName();
            rrdDb.close();
            RrdToolkit rrdToolkit = RrdToolkit.getInstance();
            rrdToolkit.removeDatasource(string, string2, true);
            this.inspectorModel.refresh();
            this.tabbedPane.setSelectedIndex(0);
        }
        catch (IOException iOException) {
            Util.error(this, iOException.toString());
        }
        catch (RrdException rrdException) {
            Util.error(this, rrdException.toString());
        }
    }

    private void removeArchive() {
        if (!this.inspectorModel.isOk()) {
            Util.error(this, "Open a valid RRD file first.");
            return;
        }
        RrdNode rrdNode = this.getSelectedRrdNode();
        int n = -1;
        if (rrdNode == null || (n = rrdNode.getArcIndex()) < 0) {
            Util.error(this, "Select archive first");
            return;
        }
        try {
            String string = this.inspectorModel.getFile().getCanonicalPath();
            RrdDb rrdDb = new RrdDb(string);
            ArcDef arcDef = rrdDb.getRrdDef().getArcDefs()[n];
            String string2 = arcDef.getConsolFun();
            int n2 = arcDef.getSteps();
            rrdDb.close();
            RrdToolkit rrdToolkit = RrdToolkit.getInstance();
            rrdToolkit.removeArchive(string, string2, n2, true);
            this.inspectorModel.refresh();
            this.tabbedPane.setSelectedIndex(0);
        }
        catch (IOException iOException) {
            Util.error(this, iOException.toString());
        }
        catch (RrdException rrdException) {
            Util.error(this, rrdException.toString());
        }
    }

    private static void printUsageAndExit() {
        System.err.println("usage: " + RrdInspector.class.getName() + " [<filename>]");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length > 1) {
            RrdInspector.printUsageAndExit();
        }
        String string = stringArray.length == 1 ? stringArray[0] : null;
        new RrdInspector(string);
    }
}

