/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hibernate.model.manipulators;

import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.util.DasUtil;
import com.intellij.hibernate.model.manipulators.HibernateObjectManipulator;
import com.intellij.hibernate.model.xml.mapping.HbmClass;
import com.intellij.hibernate.model.xml.mapping.HbmColumnsHolderBase;
import com.intellij.hibernate.model.xml.mapping.HbmContainer;
import com.intellij.hibernate.model.xml.mapping.HbmIdbag;
import com.intellij.hibernate.model.xml.mapping.HbmJoin;
import com.intellij.hibernate.model.xml.mapping.HbmManyToOne;
import com.intellij.hibernate.model.xml.mapping.HbmMap;
import com.intellij.hibernate.model.xml.mapping.HbmPrimitiveArray;
import com.intellij.hibernate.model.xml.mapping.HbmRelationAttributeBase;
import com.intellij.jpa.model.manipulators.AttributeManipulatorBase;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.manipulators.PersistentRelationshipAttributeManipulator;
import com.intellij.util.xml.DomElement;
import java.util.Collections;
import java.util.Map;

public class HibernateRelationshipAttributeManipulator
extends AttributeManipulatorBase<HbmRelationAttributeBase>
implements PersistentRelationshipAttributeManipulator<HbmRelationAttributeBase> {
    public HibernateRelationshipAttributeManipulator(HbmRelationAttributeBase target) {
        super((PersistentAttribute)target);
    }

    public void setMappedByAndInverse(String name, boolean inverse) {
        HbmRelationAttributeBase attribute = (HbmRelationAttributeBase)this.getManipulatorTarget();
        HbmContainer attributeHolder = (HbmContainer)attribute.getParentOfType(HbmContainer.class, false);
        if (attributeHolder != null && !(attributeHolder instanceof HbmPrimitiveArray) && !(attributeHolder instanceof HbmIdbag)) {
            attributeHolder.getInverse().setValue((Object)inverse);
        }
        if (attribute instanceof HbmRelationAttributeBase.NonOneToManyBase) {
            ((HbmRelationAttributeBase.NonOneToManyBase)attribute).getPropertyRef().setStringValue(name);
        }
    }

    public void setMapKeyColumn(String attributeName, DasColumn columnInfo, boolean inverse) {
        assert (((HbmRelationAttributeBase)this.getManipulatorTarget()).getParent() instanceof HbmMap);
        HbmMap hbmMap = (HbmMap)((HbmRelationAttributeBase)this.getManipulatorTarget()).getParent();
        assert (hbmMap != null);
        HibernateObjectManipulator.setColumns(hbmMap.getMapKey(), Collections.singletonList(columnInfo), false, true);
    }

    public void setJoinTable(boolean inverse, DasTable joinTable, Map<DasColumn, DasColumn> sourceColumnsMap, Map<DasColumn, DasColumn> targetColumnsMap) {
        HbmRelationAttributeBase target = (HbmRelationAttributeBase)this.getManipulatorTarget();
        DomElement parent = target.getParent();
        if (parent instanceof HbmContainer) {
            HbmContainer hbmContainer = (HbmContainer)parent;
            hbmContainer.getTableName().setValue((Object)joinTable.getName());
            hbmContainer.getSchema().setValue((Object)DasUtil.getSchema((DasObject)joinTable));
            hbmContainer.getCatalog().setValue((Object)DasUtil.getCatalog((DasObject)joinTable));
            HibernateObjectManipulator.setColumns(hbmContainer.getKey(), sourceColumnsMap.keySet(), false, true);
            if (target instanceof HbmColumnsHolderBase) {
                HibernateObjectManipulator.setColumns((HbmColumnsHolderBase)((Object)target), targetColumnsMap.keySet(), false, true);
            }
        } else {
            assert (parent instanceof HbmClass);
            HbmJoin join = ((HbmClass)parent).addJoin();
            HbmManyToOne toOne = join.addManyToOne();
            join.getOptional().setValue((Object)Boolean.TRUE);
            toOne.getTargetMember().setStringValue(target.getTargetMember().getStringValue());
            toOne.getCascade().setStringValue(target.getCascade().getStringValue());
            toOne.getLazy().setStringValue(target.getLazy().getStringValue());
            toOne.getClazz().setStringValue(target.getClazz().getStringValue());
            join.getTableName().setValue((Object)joinTable.getName());
            join.getSchema().setValue((Object)DasUtil.getSchema((DasObject)joinTable));
            join.getCatalog().setValue((Object)DasUtil.getCatalog((DasObject)joinTable));
            HibernateObjectManipulator.setColumns(join.getKey(), sourceColumnsMap.keySet(), false, true);
            if (target instanceof HbmColumnsHolderBase) {
                HibernateObjectManipulator.setColumns((HbmColumnsHolderBase)((Object)target), targetColumnsMap.keySet(), false, true);
            }
            target.undefine();
        }
    }

    public void setJoinColumns(boolean inverse, Map<DasColumn, DasColumn> columnsMap) {
        DomElement parent = ((HbmRelationAttributeBase)this.getManipulatorTarget()).getParent();
        if (parent instanceof HbmContainer) {
            HbmContainer hbmContainer = (HbmContainer)parent;
            HibernateObjectManipulator.setColumns(hbmContainer.getKey(), columnsMap.values(), false, true);
        } else if (this.getManipulatorTarget() instanceof HbmColumnsHolderBase) {
            HibernateObjectManipulator.setColumns((HbmColumnsHolderBase)this.getManipulatorTarget(), columnsMap.keySet(), false, true);
        }
    }
}

