/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.sqlite;

import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0005\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0002X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0002X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"wslPrefixes", "", "", "isLockableSqliteUnderWSL", "", "Lcom/intellij/database/dataSource/LocalDataSource;", "NOLOCK", "FILE_URL_PREFIX", "intellij.database.dialects.sqlite"})
@SourceDebugExtension(value={"SMAP\nsqliteUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 sqliteUtils.kt\ncom/intellij/database/dialects/sqlite/SqliteUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,26:1\n1#2:27\n1761#3,3:28\n*S KotlinDebug\n*F\n+ 1 sqliteUtils.kt\ncom/intellij/database/dialects/sqlite/SqliteUtilsKt\n*L\n21#1:28,3\n*E\n"})
public final class SqliteUtilsKt {
    @NotNull
    private static final List<String> wslPrefixes;
    @NotNull
    public static final String NOLOCK = "NOLOCK";
    @NotNull
    public static final String FILE_URL_PREFIX = "file:";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isLockableSqliteUnderWSL(@NotNull LocalDataSource $this$isLockableSqliteUnderWSL) {
        String it;
        JdbcUrlParser jdbcUrlParser;
        Intrinsics.checkNotNullParameter((Object)$this$isLockableSqliteUnderWSL, (String)"<this>");
        if (!$this$isLockableSqliteUnderWSL.getDbms().isSqlite()) {
            return false;
        }
        String string = $this$isLockableSqliteUnderWSL.getUrl();
        if (string == null) {
            return false;
        }
        String url = string;
        DatabaseDriver databaseDriver = $this$isLockableSqliteUnderWSL.getDatabaseDriver();
        if (databaseDriver == null) {
            return false;
        }
        DatabaseDriver driver = databaseDriver;
        StatelessJdbcUrlParser statelessJdbcUrlParser = JdbcUrlParserUtil.select((Collection)driver.getJDBCUrlParsers(), (String)url);
        if (statelessJdbcUrlParser == null) {
            return false;
        }
        StatelessJdbcUrlParser parser = statelessJdbcUrlParser;
        JdbcUrlParser $this$isLockableSqliteUnderWSL_u24lambda_u240 = jdbcUrlParser = parser.createStateful();
        boolean bl = false;
        $this$isLockableSqliteUnderWSL_u24lambda_u240.setUrlText(url);
        JdbcUrlParser jdbcUrlParser2 = jdbcUrlParser;
        Intrinsics.checkNotNullExpressionValue((Object)jdbcUrlParser2, (String)"apply(...)");
        JdbcUrlParser sparser = jdbcUrlParser2;
        String string2 = sparser.getParameter("file");
        if (string2 == null) {
            return false;
        }
        String filePath = string2;
        boolean hasFilePrefix = StringsKt.startsWith$default((String)filePath, (String)FILE_URL_PREFIX, (boolean)false, (int)2, null);
        boolean isNoLock = Intrinsics.areEqual((Object)sparser.getParameter(NOLOCK), (Object)"1");
        if (hasFilePrefix) {
            if (isNoLock) return false;
        }
        Iterable $this$any$iv = wslPrefixes;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            it = (String)element$iv;
            boolean bl2 = false;
        } while (!StringsKt.startsWith$default((String)StringsKt.removePrefix((String)filePath, (CharSequence)FILE_URL_PREFIX), (String)it, (boolean)false, (int)2, null));
        return true;
    }

    static {
        Object[] objectArray = new String[]{"\\\\wsl$\\", "\\\\wsl.localhost\\"};
        wslPrefixes = CollectionsKt.listOf((Object[])objectArray);
    }
}

