/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.treeView;

import com.intellij.dupLocator.treeView.NodeMatcher;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTemplateStatement;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.ServerPageFile;
import com.intellij.psi.util.PsiUtilCore;
import java.util.ArrayList;
import java.util.List;

public abstract class PsiTreeView {
    public List<PsiElement> getChildren(PsiElement node) {
        ArrayList<PsiElement> selected = new ArrayList<PsiElement>();
        if (node instanceof PsiCodeBlock) {
            PsiStatement[] statements;
            for (PsiStatement statement : statements = ((PsiCodeBlock)node).getStatements()) {
                if (statement instanceof PsiDeclarationStatement) {
                    PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)statement;
                    PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
                    if (declaredElements.length == 1) {
                        selected.add(declaredElements[0]);
                        continue;
                    }
                    selected.add((PsiElement)declarationStatement);
                    continue;
                }
                if (statement instanceof PsiTemplateStatement) continue;
                if (PsiTreeView.isJspWhileStatement((PsiElement)statement)) {
                    selected.add(this.skipDummy((PsiElement)((PsiWhileStatement)statement).getBody()));
                    continue;
                }
                selected.add((PsiElement)statement);
            }
        } else {
            PsiElement[] elements;
            for (PsiElement element : elements = node.getChildren()) {
                if (!this.isAllowed(element)) continue;
                if (element instanceof PsiExpressionList) {
                    PsiExpression[] expressions;
                    PsiExpressionList expressionList = (PsiExpressionList)element;
                    for (PsiExpression expression : expressions = expressionList.getExpressions()) {
                        selected.add(this.skipDummy((PsiElement)expression));
                    }
                    continue;
                }
                if (element instanceof PsiTemplateStatement) continue;
                selected.add(this.skipDummy(element));
            }
        }
        return selected;
    }

    protected abstract boolean isAllowed(PsiElement var1);

    protected PsiElement skipDummy(PsiElement element) {
        if (element instanceof PsiExpressionStatement) {
            return ((PsiExpressionStatement)element).getExpression();
        }
        if (element instanceof PsiBlockStatement) {
            PsiCodeBlock cb = ((PsiBlockStatement)element).getCodeBlock();
            if (cb.getStatements().length == 1) {
                return this.skipDummy((PsiElement)cb.getStatements()[0]);
            }
            return cb;
        }
        if (PsiTreeView.isJspWhileStatement(element)) {
            return this.skipDummy((PsiElement)((PsiWhileStatement)element).getBody());
        }
        return element;
    }

    private static boolean isJspWhileStatement(PsiElement element) {
        return element instanceof PsiWhileStatement && PsiUtilCore.getTemplateLanguageFile((PsiElement)element) instanceof ServerPageFile;
    }

    public static NodeMatcher createMatcher(final PsiElement patternNode) {
        return new NodeMatcher(){
            Class myNodeClass;
            {
                this.myNodeClass = patternNode.getClass();
            }

            public boolean match(PsiElement node) {
                return node.getClass() == this.myNodeClass;
            }
        };
    }
}

