/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.env;

import com.google.common.collect.ImmutableList;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.env.NodeEnvironmentEntry;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonLiteral;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiManager;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcsUtil.VcsUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class DotEnvFileManager
implements Disposable {
    private static final Logger LOG = Logger.getInstance(DotEnvFileManager.class);
    private static final String DOT_ENV_NAME = ".env";
    private static final List<String> OTHER_DOT_ENV_NAMES = List.of(".env.development.local", ".env.test.local", ".env.production.local", ".env.development", ".env.test", ".env.production", ".env.local");
    private static final String NODEMON_JSON_NAME = "nodemon.json";
    private static final Set<CharSequence> NAMES = new HashSet<CharSequence>((Collection<CharSequence>)ImmutableList.builder().add((Object)"package.json").add((Object)".env").addAll(OTHER_DOT_ENV_NAMES).build());
    private static final String NODEMON_CONFIG = "nodemonConfig";
    private final Project myProject;
    private final ConcurrentMap<VirtualFile, List<EnvFileData>> myDirToEnvList;
    private final ConcurrentMap<VirtualFile, EnvFileData> myFileToEnv;

    public DotEnvFileManager(@NotNull Project project) {
        if (project == null) {
            DotEnvFileManager.$$$reportNull$$$0(0);
        }
        this.myDirToEnvList = new ConcurrentHashMap<VirtualFile, List<EnvFileData>>();
        this.myFileToEnv = new ConcurrentHashMap<VirtualFile, EnvFileData>(1);
        this.myProject = project;
        VirtualFileManager.getInstance().addAsyncFileListener((AsyncFileListener)new DotEnvFileListener(), (Disposable)this);
    }

    public void dispose() {
    }

    @NotNull
    public static DotEnvFileManager getInstance(@NotNull Project project) {
        if (project == null) {
            DotEnvFileManager.$$$reportNull$$$0(1);
        }
        DotEnvFileManager dotEnvFileManager = (DotEnvFileManager)project.getService(DotEnvFileManager.class);
        if (dotEnvFileManager == null) {
            DotEnvFileManager.$$$reportNull$$$0(2);
        }
        return dotEnvFileManager;
    }

    @NotNull
    public List<EnvFileData> findEnvs(@Nullable VirtualFile contextFileOrDir) {
        VirtualFile contextDir = DotEnvFileManager.getDirectory(contextFileOrDir);
        if (contextDir == null) {
            List<EnvFileData> list = Collections.emptyList();
            if (list == null) {
                DotEnvFileManager.$$$reportNull$$$0(3);
            }
            return list;
        }
        List<EnvFileData> envDataList = (List<EnvFileData>)this.myDirToEnvList.get(contextDir);
        if (envDataList != null) {
            List<EnvFileData> list = envDataList;
            if (list == null) {
                DotEnvFileManager.$$$reportNull$$$0(4);
            }
            return list;
        }
        VirtualFile[] files = JSProjectUtil.findAllFilesUpToContentRoot(this.myProject, contextDir, DOT_ENV_NAME, NODEMON_JSON_NAME, "package.json");
        EnvFileData dotEnvFileData = this.getOrParseEnvFile(files[0], (ThrowableNotNullFunction<? super VirtualFile, ? extends Map<String, String>, ? extends Exception>)((ThrowableNotNullFunction)DotEnvFileManager::parseDotEnvFile));
        EnvFileData nodemonJsonFileData = this.getOrParseEnvFile(files[1], (ThrowableNotNullFunction<? super VirtualFile, ? extends Map<String, String>, ? extends Exception>)((ThrowableNotNullFunction)this::parseNodemonJsonFile));
        EnvFileData packageJsonFileData = this.getOrParseEnvFile(files[2], (ThrowableNotNullFunction<? super VirtualFile, ? extends Map<String, String>, ? extends Exception>)((ThrowableNotNullFunction)this::parsePackageJsonFile));
        envDataList = this.createEnvDataList(dotEnvFileData, nodemonJsonFileData, packageJsonFileData);
        this.myDirToEnvList.put(contextDir, envDataList);
        List<EnvFileData> list = envDataList;
        if (list == null) {
            DotEnvFileManager.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    private List<EnvFileData> createEnvDataList(@Nullable EnvFileData dotEnvFileData, @Nullable EnvFileData nodemonJsonFileData, @Nullable EnvFileData packageJsonFileData) {
        if (dotEnvFileData == null && nodemonJsonFileData == null && packageJsonFileData == null) {
            List<EnvFileData> list = Collections.emptyList();
            if (list == null) {
                DotEnvFileManager.$$$reportNull$$$0(6);
            }
            return list;
        }
        SmartList envDataList = new SmartList();
        if (packageJsonFileData != null) {
            VirtualFile dir = packageJsonFileData.getEnvFile().getParent();
            for (String filename : OTHER_DOT_ENV_NAMES) {
                EnvFileData data2;
                VirtualFile file = dir != null ? dir.findChild(filename) : null;
                if (file == null || (data2 = this.getOrParseEnvFile(file, (ThrowableNotNullFunction<? super VirtualFile, ? extends Map<String, String>, ? extends Exception>)((ThrowableNotNullFunction)DotEnvFileManager::parseDotEnvFile))) == null) continue;
                envDataList.add(data2);
            }
        }
        ContainerUtil.addIfNotNull((Collection)envDataList, (Object)dotEnvFileData);
        ContainerUtil.addIfNotNull((Collection)envDataList, (Object)nodemonJsonFileData);
        ContainerUtil.addIfNotNull((Collection)envDataList, (Object)packageJsonFileData);
        SmartList smartList = envDataList;
        if (smartList == null) {
            DotEnvFileManager.$$$reportNull$$$0(7);
        }
        return smartList;
    }

    @NotNull
    private Map<String, String> parsePackageJsonFile(@NotNull VirtualFile packageJson) {
        PackageJsonData data2;
        if (packageJson == null) {
            DotEnvFileManager.$$$reportNull$$$0(8);
        }
        if (!(data2 = PackageJsonData.getOrCreate(packageJson)).getTopLevelProperties().contains(NODEMON_CONFIG)) {
            Map<String, String> map = Collections.emptyMap();
            if (map == null) {
                DotEnvFileManager.$$$reportNull$$$0(9);
            }
            return map;
        }
        JsonObject envObject = this.findNodemonEnvObject(packageJson, NODEMON_CONFIG, "env");
        Map<String, String> map = envObject != null ? DotEnvFileManager.convertObjectToMap(envObject) : Collections.emptyMap();
        if (map == null) {
            DotEnvFileManager.$$$reportNull$$$0(10);
        }
        return map;
    }

    @Nullable
    private static VirtualFile getDirectory(@Nullable VirtualFile fileOrDir) {
        return fileOrDir == null || fileOrDir.isDirectory() ? fileOrDir : fileOrDir.getParent();
    }

    @Nullable
    private EnvFileData getOrParseEnvFile(@Nullable VirtualFile envFile, @NotNull ThrowableNotNullFunction<? super VirtualFile, ? extends Map<String, String>, ? extends Exception> parser2) {
        Map<String, String> envs;
        if (parser2 == null) {
            DotEnvFileManager.$$$reportNull$$$0(11);
        }
        if (envFile == null) {
            return null;
        }
        EnvFileData envData = (EnvFileData)this.myFileToEnv.get(envFile);
        if (envData != null) {
            return envData;
        }
        try {
            envs = (Map<String, String>)parser2.fun((Object)envFile);
        }
        catch (Exception e) {
            LOG.info("Cannot parse environment from " + String.valueOf(envFile), (Throwable)e);
            envs = Collections.emptyMap();
        }
        envData = new EnvFileData(envFile, envs);
        this.myFileToEnv.put(envFile, envData);
        return envData;
    }

    @Nullable
    public Navigatable getNavigatable(@NotNull String envVarName, @NotNull VirtualFile contextFile) {
        if (envVarName == null) {
            DotEnvFileManager.$$$reportNull$$$0(12);
        }
        if (contextFile == null) {
            DotEnvFileManager.$$$reportNull$$$0(13);
        }
        List<EnvFileData> envFileDataList = this.findEnvs(contextFile);
        for (EnvFileData envFileData : envFileDataList) {
            if (!envFileData.getEnvs().containsKey(envVarName)) continue;
            String fileName = envFileData.getEnvFile().getName();
            if (StringUtil.equals((CharSequence)fileName, (CharSequence)DOT_ENV_NAME) || OTHER_DOT_ENV_NAMES.contains(fileName)) {
                return this.getDotEnvNavigatable(envVarName, envFileData.getEnvFile());
            }
            if (StringUtil.equals((CharSequence)fileName, (CharSequence)NODEMON_JSON_NAME)) {
                return this.getNodemonJsonNavigatable(envVarName, envFileData.getEnvFile());
            }
            if (!StringUtil.equals((CharSequence)fileName, (CharSequence)"package.json")) continue;
            return this.getPackageJsonNavigatable(envVarName, envFileData.getEnvFile());
        }
        return null;
    }

    @Nullable
    private Navigatable getDotEnvNavigatable(@NotNull String envVarName, @NotNull VirtualFile dotEnvFile) {
        Document document;
        if (envVarName == null) {
            DotEnvFileManager.$$$reportNull$$$0(14);
        }
        if (dotEnvFile == null) {
            DotEnvFileManager.$$$reportNull$$$0(15);
        }
        if ((document = FileDocumentManager.getInstance().getDocument(dotEnvFile)) != null) {
            int offset;
            CharSequence text = document.getImmutableCharSequence();
            if (StringUtil.startsWith((CharSequence)text, (CharSequence)(envVarName + "="))) {
                offset = 0;
            } else {
                offset = StringUtil.indexOf((CharSequence)text, (CharSequence)("\n" + envVarName + "="));
                if (offset >= 0) {
                    ++offset;
                }
            }
            if (offset >= 0) {
                return new OpenFileDescriptor(this.myProject, dotEnvFile, offset);
            }
        }
        return null;
    }

    @Nullable
    private Navigatable getNodemonJsonNavigatable(@NotNull String envVarName, @NotNull VirtualFile nodemonJsonFile) {
        JsonObject envObject;
        if (envVarName == null) {
            DotEnvFileManager.$$$reportNull$$$0(16);
        }
        if (nodemonJsonFile == null) {
            DotEnvFileManager.$$$reportNull$$$0(17);
        }
        return (envObject = this.findNodemonEnvObject(nodemonJsonFile, "env")) != null ? envObject.findProperty(envVarName) : null;
    }

    private Navigatable getPackageJsonNavigatable(@NotNull String envVarName, @NotNull VirtualFile packageJson) {
        JsonObject envObject;
        if (envVarName == null) {
            DotEnvFileManager.$$$reportNull$$$0(18);
        }
        if (packageJson == null) {
            DotEnvFileManager.$$$reportNull$$$0(19);
        }
        return (envObject = this.findNodemonEnvObject(packageJson, NODEMON_CONFIG, "env")) != null ? envObject.findProperty(envVarName) : null;
    }

    @NotNull
    private static Map<String, String> parseDotEnvFile(@NotNull VirtualFile dotEnvFile) throws IOException {
        if (dotEnvFile == null) {
            DotEnvFileManager.$$$reportNull$$$0(20);
        }
        String text = VfsUtilCore.loadText((VirtualFile)dotEnvFile);
        String[] lines = StringUtil.splitByLines((String)text, (boolean)true);
        HashMap<String, String> result2 = new HashMap<String, String>();
        for (String line : lines) {
            int sep = line.indexOf(61);
            if (sep <= 0 || line.startsWith("#")) continue;
            result2.put(line.substring(0, sep), line.substring(sep + 1));
        }
        HashMap<String, String> hashMap = result2;
        if (hashMap == null) {
            DotEnvFileManager.$$$reportNull$$$0(21);
        }
        return hashMap;
    }

    @NotNull
    private Map<String, String> parseNodemonJsonFile(@NotNull VirtualFile nodemonJsonFile) {
        JsonObject envObject;
        if (nodemonJsonFile == null) {
            DotEnvFileManager.$$$reportNull$$$0(22);
        }
        Map<String, String> map = (envObject = this.findNodemonEnvObject(nodemonJsonFile, "env")) != null ? DotEnvFileManager.convertObjectToMap(envObject) : Collections.emptyMap();
        if (map == null) {
            DotEnvFileManager.$$$reportNull$$$0(23);
        }
        return map;
    }

    @Nullable
    private JsonObject findNodemonEnvObject(@NotNull VirtualFile nodemonJsonFile, String ... envPath) {
        JsonFile jsonFile;
        if (nodemonJsonFile == null) {
            DotEnvFileManager.$$$reportNull$$$0(24);
        }
        if (envPath == null) {
            DotEnvFileManager.$$$reportNull$$$0(25);
        }
        if ((jsonFile = (JsonFile)ObjectUtils.tryCast((Object)PsiManager.getInstance((Project)this.myProject).findFile(nodemonJsonFile), JsonFile.class)) == null) {
            return null;
        }
        for (JsonValue root : jsonFile.getAllTopLevelValues()) {
            JsonObject obj = (JsonObject)ObjectUtils.tryCast((Object)root, JsonObject.class);
            for (String propName : envPath) {
                JsonProperty prop;
                if (obj == null || (prop = obj.findProperty(propName)) == null) continue;
                obj = (JsonObject)ObjectUtils.tryCast((Object)prop.getValue(), JsonObject.class);
            }
            if (obj == null) continue;
            return obj;
        }
        return null;
    }

    @NotNull
    private static Map<String, String> convertObjectToMap(@NotNull JsonObject obj) {
        if (obj == null) {
            DotEnvFileManager.$$$reportNull$$$0(26);
        }
        HashMap<String, String> result2 = new HashMap<String, String>();
        for (JsonProperty property : obj.getPropertyList()) {
            JsonLiteral value = (JsonLiteral)ObjectUtils.tryCast((Object)property.getValue(), JsonLiteral.class);
            if (value == null) continue;
            result2.put(property.getName(), StringUtil.unquoteString((String)value.getText()));
        }
        HashMap<String, String> hashMap = result2;
        if (hashMap == null) {
            DotEnvFileManager.$$$reportNull$$$0(27);
        }
        return hashMap;
    }

    @NotNull
    static List<NodeEnvironmentEntry> convert(@Nullable VirtualFile envFile, @NotNull Map<String, String> envs) {
        if (envs == null) {
            DotEnvFileManager.$$$reportNull$$$0(28);
        }
        List list = ContainerUtil.map(envs.entrySet(), entry -> new NodeEnvironmentEntry((String)entry.getKey(), (String)entry.getValue(), envFile));
        if (list == null) {
            DotEnvFileManager.$$$reportNull$$$0(29);
        }
        return list;
    }

    public static boolean isDotEnvFileWithSecrets(@NotNull Project project, @NotNull VirtualFile dotEnvFile) {
        if (project == null) {
            DotEnvFileManager.$$$reportNull$$$0(30);
        }
        if (dotEnvFile == null) {
            DotEnvFileManager.$$$reportNull$$$0(31);
        }
        if (!ProjectFileIndex.getInstance((Project)project).isInContent(dotEnvFile)) {
            return true;
        }
        return VcsUtil.getVcsFor((Project)project, (VirtualFile)dotEnvFile) == null || !ChangeListManager.getInstance((Project)project).isIgnoredFile(dotEnvFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 9, 10, 21, 23, 27, 29 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 21: 
            case 23: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/env/DotEnvFileManager";
                break;
            }
            case 8: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
            case 12: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envVarName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 15: 
            case 20: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dotEnvFile";
                break;
            }
            case 17: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodemonJsonFile";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envPath";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obj";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/env/DotEnvFileManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findEnvs";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createEnvDataList";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "parsePackageJsonFile";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "parseDotEnvFile";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "parseNodemonJsonFile";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "convertObjectToMap";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "convert";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 21: 
            case 23: 
            case 27: 
            case 29: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parsePackageJsonFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getOrParseEnvFile";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getNavigatable";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDotEnvNavigatable";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getNodemonJsonNavigatable";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getPackageJsonNavigatable";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "parseDotEnvFile";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "parseNodemonJsonFile";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findNodemonEnvObject";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "convertObjectToMap";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "convert";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isDotEnvFileWithSecrets";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 7, 9, 10, 21, 23, 27, 29 -> new IllegalStateException(string);
        };
    }

    private class DotEnvFileListener
    implements AsyncFileListener {
        private DotEnvFileListener() {
        }

        @Nullable
        public AsyncFileListener.ChangeApplier prepareChange(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
            if (events == null) {
                DotEnvFileListener.$$$reportNull$$$0(0);
            }
            for (VFileEvent vFileEvent : events) {
                if (!this.isRelevantEvent(vFileEvent)) continue;
                DotEnvFileManager.this.myDirToEnvList.clear();
                DotEnvFileManager.this.myFileToEnv.clear();
                break;
            }
            return null;
        }

        private boolean isRelevantEvent(@NotNull VFileEvent event) {
            if (event == null) {
                DotEnvFileListener.$$$reportNull$$$0(1);
            }
            if (event instanceof VFileCreateEvent) {
                VFileCreateEvent createEvent = (VFileCreateEvent)event;
                return !createEvent.isDirectory() && DotEnvFileListener.isDotEnvFileName(createEvent.getChildName());
            }
            if (event instanceof VFilePropertyChangeEvent) {
                VFilePropertyChangeEvent e = (VFilePropertyChangeEvent)event;
                return e.isRename() && (DotEnvFileListener.isDotEnvFileName((CharSequence)ObjectUtils.tryCast((Object)e.getOldValue(), CharSequence.class)) || DotEnvFileListener.isDotEnvFileName((CharSequence)ObjectUtils.tryCast((Object)e.getNewValue(), CharSequence.class)));
            }
            if (event instanceof VFileCopyEvent) {
                return DotEnvFileListener.isDotEnvFileName(((VFileCopyEvent)event).getNewChildName());
            }
            return this.isDotEnvFile(event.getFile());
        }

        @Contract(value="null -> false")
        private boolean isDotEnvFile(@Nullable VirtualFile file) {
            return file != null && !file.isDirectory() && DotEnvFileListener.isDotEnvFileName(file.getNameSequence());
        }

        @Contract(value="null -> false")
        private static boolean isDotEnvFileName(@Nullable CharSequence fileName) {
            return NAMES.contains(fileName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "events";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/javascript/nodejs/env/DotEnvFileManager$DotEnvFileListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "prepareChange";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isRelevantEvent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class EnvFileData {
        private final VirtualFile myEnvFile;
        private final Map<String, String> myEnvs;
        private final List<NodeEnvironmentEntry> myEnvEntries;

        private EnvFileData(@NotNull VirtualFile envFile, @NotNull Map<String, String> envs) {
            if (envFile == null) {
                EnvFileData.$$$reportNull$$$0(0);
            }
            if (envs == null) {
                EnvFileData.$$$reportNull$$$0(1);
            }
            this.myEnvFile = envFile;
            this.myEnvs = Map.copyOf(envs);
            this.myEnvEntries = DotEnvFileManager.convert(envFile, envs);
        }

        @NotNull
        public VirtualFile getEnvFile() {
            VirtualFile virtualFile = this.myEnvFile;
            if (virtualFile == null) {
                EnvFileData.$$$reportNull$$$0(2);
            }
            return virtualFile;
        }

        @NotNull
        public List<NodeEnvironmentEntry> getEnvEntries() {
            List<NodeEnvironmentEntry> list = this.myEnvEntries;
            if (list == null) {
                EnvFileData.$$$reportNull$$$0(3);
            }
            return list;
        }

        @NotNull
        public Map<String, String> getEnvs() {
            Map<String, String> map = this.myEnvs;
            if (map == null) {
                EnvFileData.$$$reportNull$$$0(4);
            }
            return map;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "envFile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "envs";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/env/DotEnvFileManager$EnvFileData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/env/DotEnvFileManager$EnvFileData";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEnvFile";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEnvEntries";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEnvs";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

