/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter;

import com.intellij.execution.ExecutionException;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterChangeListener;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterType;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
public final class NodeJsInterpreterManager {
    @NonNls
    private static final String NODEJS_INTERPRETER_PATH = "nodejs_interpreter_path";
    private final Project myProject;
    private volatile NodeJsInterpreterRef myInterpreterRef;
    private volatile Boolean myInterpreterAvailable;
    private final List<NodeJsInterpreterChangeListener> myChangeListeners;

    public NodeJsInterpreterManager(@NotNull Project project) {
        if (project == null) {
            NodeJsInterpreterManager.$$$reportNull$$$0(0);
        }
        this.myChangeListeners = new CopyOnWriteArrayList<NodeJsInterpreterChangeListener>();
        this.myProject = project;
    }

    @NotNull
    public static NodeJsInterpreterManager getInstance(@NotNull Project project) {
        if (project == null) {
            NodeJsInterpreterManager.$$$reportNull$$$0(1);
        }
        NodeJsInterpreterManager nodeJsInterpreterManager = (NodeJsInterpreterManager)project.getService(NodeJsInterpreterManager.class);
        if (nodeJsInterpreterManager == null) {
            NodeJsInterpreterManager.$$$reportNull$$$0(2);
        }
        return nodeJsInterpreterManager;
    }

    @NotNull
    public NodeJsInterpreterRef getInterpreterRef() {
        NodeJsInterpreterRef interpreterRef = this.myInterpreterRef;
        if (interpreterRef == null) {
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
            String reference = propertiesComponent.getValue(NODEJS_INTERPRETER_PATH);
            interpreterRef = StringUtil.isNotEmpty((String)reference) && !"project".equals(reference) ? NodeJsInterpreterRef.create(reference) : NodeJsLocalInterpreterType.createNodeFromPathRef();
            this.myInterpreterRef = interpreterRef;
        }
        NodeJsInterpreterRef nodeJsInterpreterRef = interpreterRef;
        if (nodeJsInterpreterRef == null) {
            NodeJsInterpreterManager.$$$reportNull$$$0(3);
        }
        return nodeJsInterpreterRef;
    }

    @TestOnly
    public void setInterpreterRef(@Nullable NodeJsInterpreterRef interpreterRef, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            NodeJsInterpreterManager.$$$reportNull$$$0(4);
        }
        NodeJsInterpreterRef oldInterpreterRef = this.myInterpreterRef;
        this.setInterpreterRef(interpreterRef);
        Disposer.register((Disposable)parentDisposable, () -> {
            this.myInterpreterRef = oldInterpreterRef;
        });
    }

    public void setInterpreterRef(@Nullable NodeJsInterpreterRef interpreterRef) {
        NodeJsInterpreterRef oldInterpreterRef = this.myInterpreterRef;
        this.myInterpreterRef = interpreterRef;
        this.myInterpreterAvailable = null;
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)this.myProject);
        if (interpreterRef == null) {
            propertiesComponent.unsetValue(NODEJS_INTERPRETER_PATH);
        } else {
            if (interpreterRef.isProjectRef()) {
                throw new IllegalStateException("Project interpreter cannot be set to itself");
            }
            propertiesComponent.setValue(NODEJS_INTERPRETER_PATH, interpreterRef.getReferenceName());
        }
        this.fireInterpreterChangedIfNeeded(oldInterpreterRef, interpreterRef);
    }

    private void fireInterpreterChangedIfNeeded(@Nullable NodeJsInterpreterRef oldInterpreterRef, @Nullable NodeJsInterpreterRef newInterpreterRef) {
        NodeJsInterpreter newInterpreter;
        if (this.myChangeListeners.isEmpty()) {
            return;
        }
        NodeJsInterpreter oldInterpreter = oldInterpreterRef != null ? oldInterpreterRef.resolveWithoutAliases(this.myProject) : null;
        NodeJsInterpreter nodeJsInterpreter = newInterpreter = newInterpreterRef != null ? newInterpreterRef.resolveWithoutAliases(this.myProject) : null;
        if (!Objects.equals(oldInterpreter, newInterpreter)) {
            for (NodeJsInterpreterChangeListener listener2 : this.myChangeListeners) {
                listener2.interpreterChanged(newInterpreter);
            }
        }
    }

    @Nullable
    public NodeJsInterpreter getInterpreter() {
        return this.getInterpreter(false);
    }

    @Nullable
    public NodeJsInterpreter getInterpreter(boolean showNotificationForUnresolved) {
        return this.getInterpreterRef().resolveWithoutAliases(this.myProject);
    }

    @NotNull
    public NodeJsInterpreter getInterpreterOrThrow() throws ExecutionException {
        NodeJsInterpreterRef interpreterRef = this.getInterpreterRef();
        NodeJsInterpreter interpreter2 = interpreterRef.resolveWithoutAliases(this.myProject);
        if (interpreter2 == null) {
            throw new ExecutionException(JavaScriptBundle.message((String)"node.interpreter.unresolved_reference.error.message", (Object[])new Object[]{interpreterRef.getReferenceName()}));
        }
        NodeJsInterpreter nodeJsInterpreter = interpreter2;
        if (nodeJsInterpreter == null) {
            NodeJsInterpreterManager.$$$reportNull$$$0(5);
        }
        return nodeJsInterpreter;
    }

    public void addChangeListener(@NotNull NodeJsInterpreterChangeListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            NodeJsInterpreterManager.$$$reportNull$$$0(6);
        }
        if (parentDisposable == null) {
            NodeJsInterpreterManager.$$$reportNull$$$0(7);
        }
        this.myChangeListeners.add(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.myChangeListeners.remove(listener2));
    }

    boolean isClonedFromDefaultProject() {
        if (this.myProject.isDefault()) {
            return false;
        }
        Project defaultProject = ProjectManager.getInstance().getDefaultProject();
        String defaultProjectInterpreterPath = PropertiesComponent.getInstance((Project)defaultProject).getValue(NODEJS_INTERPRETER_PATH);
        String interpreterPath = PropertiesComponent.getInstance((Project)this.myProject).getValue(NODEJS_INTERPRETER_PATH);
        return defaultProjectInterpreterPath != null && defaultProjectInterpreterPath.equals(interpreterPath);
    }

    public boolean isInterpreterAvailable() {
        Boolean available = this.myInterpreterAvailable;
        if (available == null) {
            this.myInterpreterAvailable = available = Boolean.valueOf(this.getInterpreter() != null);
        }
        return available;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterManager";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterRef";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterOrThrow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setInterpreterRef";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5 -> new IllegalStateException(string);
        };
    }
}

