/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.config.graph;

import com.intellij.lang.javascript.config.JSFileImports;
import com.intellij.lang.javascript.config.graph.JSConfigGraphCache;
import com.intellij.lang.javascript.config.graph.JSImportGraph;
import com.intellij.lang.javascript.config.graph.JSImportGraphKt;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.util.ApplicationKt;
import com.intellij.util.graph.Graph;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.ints.IntLists;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.TimeoutKt;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010(\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 <2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001<B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0014\u001a\u00020\u0000J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u001bJ\u000e\u0010\u001c\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u001dJ\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u001fH\u0016J\u001e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00022\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00020\u001fH\u0002J\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0002J\u0010\u0010$\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0002H\u0002J\u0010\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020!H\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010\u00022\u0006\u0010*\u001a\u00020'H\u0002J\u001e\u0010+\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00022\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00020\u001fH\u0002J\u0016\u0010+\u001a\u00020!2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00020\u001bH\u0002J\u001c\u0010-\u001a\u00020!2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00020\u001bH\u0082@\u00a2\u0006\u0002\u0010.J\u0006\u0010/\u001a\u00020\u0015J\u000e\u00100\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u0002J\u000e\u00101\u001a\u00020\u00152\u0006\u0010&\u001a\u00020'J\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020\u0002032\u0006\u0010\"\u001a\u00020\u0002H\u0016J\u0016\u00104\u001a\b\u0012\u0004\u0012\u00020\u0002032\u0006\u0010\"\u001a\u00020\u0002H\u0016J\u0006\u00105\u001a\u00020\u0004J$\u00106\u001a\b\u0012\u0004\u0012\u00020\u00020\u001f2\u0006\u0010\"\u001a\u00020\u00022\f\u00107\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u0006\u00108\u001a\u00020!J\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020\u00020\u001f2\u0006\u0010:\u001a\u00020;H\u0002J\u0016\u00109\u001a\b\u0012\u0004\u0012\u00020\u00020\u001f2\u0006\u0010:\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/intellij/lang/javascript/config/graph/JSImportGraph;", "Lcom/intellij/util/graph/Graph;", "Lcom/intellij/openapi/vfs/VirtualFile;", "searcher", "Lcom/intellij/lang/javascript/config/JSFileImports;", "<init>", "(Lcom/intellij/lang/javascript/config/JSFileImports;)V", "initializeCounter", "Ljava/util/concurrent/atomic/AtomicLong;", "rootNodes", "", "outEdges", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "Lit/unimi/dsi/fastutil/ints/IntList;", "inEdges", "ids", "initialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "initialize", "", "tryOnly", "runUnderWriteLock", "writeLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock$WriteLock;", "getRoots", "", "getAvailableFromRoots", "", "getNodes", "", "recalculateEdges", "", "file", "newOutFiles", "validate", "removeOutNodesRecursive", "fileId", "", "removeNotAvailableFromRoots", "getNode", "id", "add", "toProcess", "doAddAsync", "(Ljava/util/Collection;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "isInitialized", "containsFile", "containsId", "getIn", "", "getOut", "getFileImports", "getValueUnderLock", "mapFrom", "resetGraph", "copyAsFiles", "elements", "Lit/unimi/dsi/fastutil/ints/IntCollection;", "Companion", "intellij.javascript.backend"})
@SourceDebugExtension(value={"SMAP\nJSImportGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSImportGraph.kt\ncom/intellij/lang/javascript/config/graph/JSImportGraph\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n*L\n1#1,463:1\n1#2:464\n1#2:481\n1869#3,2:465\n1869#3,2:467\n1869#3,2:469\n1617#3,9:471\n1869#3:480\n1870#3:482\n1626#3:483\n11591#4:484\n11926#4,3:485\n116#5,11:488\n*S KotlinDebug\n*F\n+ 1 JSImportGraph.kt\ncom/intellij/lang/javascript/config/graph/JSImportGraph\n*L\n387#1:481\n227#1:465,2\n233#1:467,2\n246#1:469,2\n387#1:471,9\n387#1:480\n387#1:482\n387#1:483\n390#1:484\n390#1:485,3\n292#1:488,11\n*E\n"})
public final class JSImportGraph
implements Graph<VirtualFile> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JSFileImports searcher;
    @NotNull
    private final AtomicLong initializeCounter;
    @NotNull
    private int[] rootNodes;
    @NotNull
    private final Int2ObjectMap<IntList> outEdges;
    @NotNull
    private final Int2ObjectMap<IntList> inEdges;
    @NotNull
    private final Int2ObjectMap<VirtualFile> ids;
    @NotNull
    private final AtomicBoolean initialized;
    @NotNull
    private final ReentrantReadWriteLock lock;

    public JSImportGraph(@NotNull JSFileImports searcher) {
        Intrinsics.checkNotNullParameter((Object)searcher, (String)"searcher");
        this.searcher = searcher;
        this.initializeCounter = new AtomicLong();
        this.rootNodes = new int[0];
        this.outEdges = (Int2ObjectMap)new Int2ObjectOpenHashMap();
        this.inEdges = (Int2ObjectMap)new Int2ObjectOpenHashMap();
        this.ids = (Int2ObjectMap)new Int2ObjectOpenHashMap();
        this.initialized = new AtomicBoolean(false);
        this.lock = new ReentrantReadWriteLock();
    }

    @NotNull
    public final JSImportGraph initialize() {
        this.initialize(false);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean initialize(boolean tryOnly) {
        long counterValue = this.initializeCounter.incrementAndGet();
        try {
            if (this.initialized.get()) {
                boolean bl = true;
                return bl;
            }
            ReentrantReadWriteLock.WriteLock writeLock = this.lock.writeLock();
            if (tryOnly) {
                if (!writeLock.tryLock()) {
                    boolean bl = false;
                    return bl;
                }
                Intrinsics.checkNotNull((Object)writeLock);
                boolean bl = this.runUnderWriteLock(writeLock);
                return bl;
            }
            if (ApplicationKt.getApplication().isUnitTestMode() && JSImportGraphKt.access$getCheckInitializeCount$p() && counterValue >= 2L) {
                JSConfigGraphCache.LOG.error("Too many graph initializations: " + counterValue);
            }
            ProgressIndicatorUtils.awaitWithCheckCanceled((Lock)writeLock);
            Intrinsics.checkNotNull((Object)writeLock);
            boolean bl = this.runUnderWriteLock(writeLock);
            return bl;
        }
        finally {
            this.initializeCounter.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean runUnderWriteLock(ReentrantReadWriteLock.WriteLock writeLock) {
        boolean bl;
        this.searcher.startCaching();
        try {
            if (this.initialized.get()) {
                boolean bl2 = true;
                return bl2;
            }
            JSImportGraph.Companion.logStartGraphBuilding(this);
            Set rootFiles2 = this.searcher.getRootFiles();
            this.rootNodes = JSImportGraph.Companion.extractIdsForFiles(rootFiles2);
            ProgressManager.checkCanceled();
            this.add(rootFiles2);
            this.initialized.set(true);
            JSImportGraph.Companion.logEndGraphBuilding(this);
            bl = false;
        }
        catch (ProcessCanceledException e) {
            this.resetGraph();
            throw e;
        }
        finally {
            writeLock.unlock();
            this.searcher.stopCaching();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Collection<VirtualFile> getRoots() {
        Collection collection;
        this.initialize();
        ReentrantReadWriteLock.ReadLock $this$getRoots_u24lambda_u240 = this.lock.readLock();
        boolean bl = false;
        $this$getRoots_u24lambda_u240.lock();
        try {
            collection = this.copyAsFiles(this.rootNodes);
        }
        finally {
            $this$getRoots_u24lambda_u240.unlock();
        }
        return collection;
    }

    @NotNull
    public final Set<VirtualFile> getAvailableFromRoots() {
        this.initialize();
        Deque toCheck = new ArrayDeque(this.copyAsFiles(this.rootNodes));
        Set result2 = new HashSet();
        while (!toCheck.isEmpty()) {
            IntListIterator iterator;
            VirtualFile pop = (VirtualFile)toCheck.pop();
            if (!result2.add(pop)) continue;
            Intrinsics.checkNotNull((Object)pop);
            IntList out = JSImportGraph.Companion.getOrDefault((Int2ObjectMap<IntList>)this.outEdges, JSImportGraph.Companion.getFileId(pop));
            Intrinsics.checkNotNullExpressionValue((Object)out.iterator(), (String)"iterator(...)");
            while (iterator.hasNext()) {
                int el = iterator.nextInt();
                VirtualFile node = this.getNode(el);
                if (node == null) {
                    boolean bl = false;
                    String string = "Graph is inconsistent. Out edges are missing";
                    throw new IllegalStateException(string.toString());
                }
                toCheck.add(node);
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Set<VirtualFile> getNodes() {
        Set<VirtualFile> set;
        this.initialize();
        ReentrantReadWriteLock.ReadLock $this$getNodes_u24lambda_u240 = this.lock.readLock();
        boolean bl = false;
        $this$getNodes_u24lambda_u240.lock();
        try {
            Set set2 = this.ids.keySet();
            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"<get-keys>(...)");
            set = this.copyAsFiles((IntCollection)set2);
        }
        finally {
            $this$getNodes_u24lambda_u240.unlock();
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void recalculateEdges(VirtualFile file, Set<? extends VirtualFile> newOutFiles) {
        int fileId = Companion.getFileId(file);
        Set<VirtualFile> oldOutFiles = this.getValueUnderLock(file, this.outEdges);
        if (oldOutFiles.size() == newOutFiles.size() && newOutFiles.containsAll((Collection)oldOutFiles)) {
            return;
        }
        ReentrantReadWriteLock.WriteLock lock = this.lock.writeLock();
        lock.lock();
        try {
            boolean bl;
            this.removeOutNodesRecursive(fileId);
            this.add(file, newOutFiles);
            this.removeNotAvailableFromRoots();
            boolean bl2 = bl = this.ids.size() >= this.rootNodes.length;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
        }
        finally {
            lock.unlock();
        }
    }

    public final void recalculateEdges(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        boolean resetOnCancel = false;
        try {
            JSImportGraph.Companion.logStartGraphUpdating(this, file);
            this.validate(file);
            Set newFiles = CollectionsKt.toSet((Iterable)this.searcher.getOutFiles(file));
            resetOnCancel = true;
            this.recalculateEdges(file, newFiles);
            JSImportGraph.Companion.logEndGraphUpdating(this);
        }
        catch (ProcessCanceledException e) {
            if (resetOnCancel) {
                this.resetGraph();
            }
            throw e;
        }
        catch (IllegalStateException e) {
            this.resetGraph();
            JSConfigGraphCache.LOG.error((Throwable)e);
        }
    }

    private final void validate(VirtualFile file) {
        if (!this.initialized.get()) {
            throw new IllegalStateException("The graph is not initialized");
        }
        if (!this.ids.containsKey(Companion.getFileId(file))) {
            throw new IllegalStateException("No such node present in the graph");
        }
    }

    private final void removeOutNodesRecursive(int fileId) {
        IntList oldOut = JSImportGraph.Companion.getOrDefault((Int2ObjectMap<IntList>)this.outEdges, fileId);
        IntListIterator intListIterator = oldOut.iterator();
        Intrinsics.checkNotNullExpressionValue((Object)intListIterator, (String)"iterator(...)");
        IntListIterator iterator = intListIterator;
        while (iterator.hasNext()) {
            int oldDestination = iterator.nextInt();
            IntList inForOldValue = JSImportGraph.Companion.getOrDefault((Int2ObjectMap<IntList>)this.inEdges, oldDestination);
            int index = inForOldValue.indexOf(fileId);
            if (index == -1) {
                boolean bl;
                boolean bl2;
                VirtualFile node = this.getNode(oldDestination);
                boolean bl3 = bl2 = node != null;
                if (_Assertions.ENABLED && !bl2) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                VirtualFile fileNode = this.getNode(fileId);
                boolean bl4 = bl = fileNode != null;
                if (_Assertions.ENABLED && !bl) {
                    String string = "Assertion failed";
                    throw new AssertionError((Object)string);
                }
                VirtualFile virtualFile = fileNode;
                Intrinsics.checkNotNull((Object)virtualFile);
                String string = virtualFile.getPath();
                VirtualFile virtualFile2 = node;
                Intrinsics.checkNotNull((Object)virtualFile2);
                throw new IllegalStateException("Inconsistent graph in: " + string + " out: " + virtualFile2.getPath());
            }
            inForOldValue.removeInt(index);
        }
        if (!oldOut.isEmpty()) {
            oldOut.clear();
        }
    }

    private final void removeNotAvailableFromRoots() {
        VirtualFile el;
        Set<VirtualFile> availableFromRoot = this.getAvailableFromRoots();
        if (availableFromRoot.size() == this.ids.size()) {
            return;
        }
        Set set = this.ids.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        HashSet toRemove = new HashSet(this.copyAsFiles((IntCollection)set));
        toRemove.removeAll((Collection)availableFromRoot);
        Iterable $this$forEach$iv = toRemove;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            el = (VirtualFile)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)el);
            int elId = Companion.getFileId(el);
            this.outEdges.remove(elId);
            this.inEdges.remove(elId);
        }
        $this$forEach$iv = toRemove;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            el = (VirtualFile)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)el);
            this.ids.remove(Companion.getFileId(el));
        }
    }

    private final VirtualFile getNode(int id) {
        return (VirtualFile)this.ids.get(id);
    }

    private final void add(VirtualFile file, Set<? extends VirtualFile> newOutFiles) {
        int fileId = Companion.getFileId(file);
        this.ids.put(fileId, (Object)file);
        JSImportGraph.Companion.addEdges((Int2ObjectMap<IntList>)this.outEdges, file, newOutFiles);
        List toCheck = new ArrayList();
        Iterable $this$forEach$iv = newOutFiles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl = false;
            toCheck.add(it);
            JSImportGraph.Companion.addEdge((Int2ObjectMap<IntList>)this.inEdges, it, fileId);
        }
        ProgressManager.getInstance().executeNonCancelableSection(() -> JSImportGraph.add$lambda$1(this, toCheck));
    }

    private final void add(Collection<? extends VirtualFile> toProcess) {
        if (!this.lock.writeLock().isHeldByCurrentThread()) {
            throw new IllegalStateException("The method should be called under write lock");
        }
        if (ApplicationKt.getApplication().isUnitTestMode()) {
            com.intellij.openapi.progress.CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, toProcess, null){
                int label;
                final /* synthetic */ JSImportGraph this$0;
                final /* synthetic */ Collection<VirtualFile> $toProcess;
                {
                    this.this$0 = $receiver;
                    this.$toProcess = $toProcess;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = TimeoutKt.withTimeout-KLykuaI((long)DurationKt.toDuration((int)2, (DurationUnit)DurationUnit.MINUTES), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$toProcess, null){
                                int label;
                                final /* synthetic */ JSImportGraph this$0;
                                final /* synthetic */ Collection<VirtualFile> $toProcess;
                                {
                                    this.this$0 = $receiver;
                                    this.$toProcess = $toProcess;
                                    super(2, $completion);
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.label = 1;
                                            Object object2 = JSImportGraph.access$doAddAsync(this.this$0, this.$toProcess, (Continuation)this);
                                            if (object2 != object) return Unit.INSTANCE;
                                            return object;
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object2 = $result;
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        } else if (ApplicationKt.getApplication().isDispatchThread()) {
            if (!ApplicationKt.getApplication().isUnitTestMode() && (ApplicationKt.getApplication().isInternal() || ApplicationKt.getApplication().isEAP())) {
                JSConfigGraphCache.LOG.error("Graph building must not be done on EDT");
            }
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, toProcess, null){
                int label;
                final /* synthetic */ JSImportGraph this$0;
                final /* synthetic */ Collection<VirtualFile> $toProcess;
                {
                    this.this$0 = $receiver;
                    this.$toProcess = $toProcess;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = JSImportGraph.access$doAddAsync(this.this$0, this.$toProcess, (Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
        } else {
            com.intellij.openapi.progress.CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, toProcess, null){
                int label;
                final /* synthetic */ JSImportGraph this$0;
                final /* synthetic */ Collection<VirtualFile> $toProcess;
                {
                    this.this$0 = $receiver;
                    this.$toProcess = $toProcess;
                    super(2, $completion);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            this.label = 1;
                            Object object2 = JSImportGraph.access$doAddAsync(this.this$0, this.$toProcess, (Continuation)this);
                            if (object2 != object) return Unit.INSTANCE;
                            return object;
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            Object object2 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }
    }

    private final Object doAddAsync(Collection<? extends VirtualFile> toProcess, Continuation<? super Unit> $completion) {
        Mutex edgesMtx = MutexKt.Mutex$default((boolean)false, (int)1, null);
        Mutex idsMutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
        Object object = CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(toProcess, idsMutex, this, edgesMtx, null){
            Object L$1;
            Object L$2;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Collection<VirtualFile> $toProcess;
            final /* synthetic */ Mutex $idsMutex;
            final /* synthetic */ JSImportGraph this$0;
            final /* synthetic */ Mutex $edgesMtx;
            {
                this.$toProcess = $toProcess;
                this.$idsMutex = $idsMutex;
                this.this$0 = $receiver;
                this.$edgesMtx = $edgesMtx;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var5_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var3_4 = this.$toProcess.iterator();
lbl7:
                        // 3 sources

                        while (var3_4.hasNext()) {
                            file = (VirtualFile)var3_4.next();
                            this.L$0 = $this$coroutineScope;
                            this.L$1 = var3_4;
                            this.L$2 = SpillingKt.nullOutSpilledVariable((Object)file);
                            this.label = 1;
                            v0 = JSImportGraph.access$doAddAsync$processFile((CoroutineScope)$this$coroutineScope, this.$idsMutex, this.this$0, this.$edgesMtx, file, (Continuation)this);
                            if (v0 != var5_3) continue;
                            return var5_3;
                        }
                        break;
                    }
                    case 1: {
                        file = (VirtualFile)this.L$2;
                        var3_4 = (Iterator)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                        ** GOTO lbl7
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final boolean isInitialized() {
        return this.initialized.get();
    }

    public final boolean containsFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.containsId(Companion.getFileId(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean containsId(int fileId) {
        boolean bl;
        this.initialize();
        ReentrantReadWriteLock.ReadLock $this$containsId_u24lambda_u240 = this.lock.readLock();
        boolean bl2 = false;
        $this$containsId_u24lambda_u240.lock();
        try {
            bl = this.ids.containsKey(fileId);
        }
        finally {
            $this$containsId_u24lambda_u240.unlock();
        }
        return bl;
    }

    @NotNull
    public Iterator<VirtualFile> getIn(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.initialize();
        return this.getValueUnderLock(file, this.inEdges).iterator();
    }

    @NotNull
    public Iterator<VirtualFile> getOut(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.initialize();
        return this.getValueUnderLock(file, this.outEdges).iterator();
    }

    @NotNull
    public final JSFileImports getFileImports() {
        return this.searcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Set<VirtualFile> getValueUnderLock(VirtualFile file, Int2ObjectMap<IntList> mapFrom) {
        Set<VirtualFile> set;
        ReentrantReadWriteLock.ReadLock $this$getValueUnderLock_u24lambda_u240 = this.lock.readLock();
        boolean bl = false;
        $this$getValueUnderLock_u24lambda_u240.lock();
        try {
            set = this.copyAsFiles((IntCollection)JSImportGraph.Companion.getOrDefault((Int2ObjectMap<IntList>)mapFrom, JSImportGraph.Companion.getFileId(file)));
        }
        finally {
            $this$getValueUnderLock_u24lambda_u240.unlock();
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void resetGraph() {
        ReentrantReadWriteLock.WriteLock writeLock;
        ReentrantReadWriteLock.WriteLock $this$resetGraph_u24lambda_u240 = writeLock = this.lock.writeLock();
        boolean bl = false;
        $this$resetGraph_u24lambda_u240.lock();
        try {
            this.initialized.set(false);
            this.ids.clear();
            this.outEdges.clear();
            this.inEdges.clear();
            this.rootNodes = new int[0];
        }
        finally {
            $this$resetGraph_u24lambda_u240.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<VirtualFile> copyAsFiles(IntCollection elements) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = (Iterable)elements;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Integer it = (Integer)element$iv$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)it);
            if ((VirtualFile)this.ids.get(it.intValue()) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<VirtualFile> copyAsFiles(int[] elements) {
        void $this$mapTo$iv$iv;
        int[] $this$map$iv = elements;
        boolean $i$f$map = false;
        int[] nArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var10_10 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((VirtualFile)this.ids.get((int)it));
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private static final void add$lambda$1(JSImportGraph this$0, List $toCheck) {
        this$0.add($toCheck);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static final Object doAddAsync$processFile(CoroutineScope $this$doAddAsync_u24processFile, Mutex idsMutex, JSImportGraph this$0, Mutex edgesMtx, VirtualFile file, Continuation<? super Unit> $completion) {
        if (!($completion instanceof doAddAsync.processFile.1)) ** GOTO lbl-1000
        var15_6 = $completion;
        if ((var15_6.label & -2147483648) != 0) {
            var15_6.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return JSImportGraph.access$doAddAsync$processFile(null, null, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var16_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                fileId = JSImportGraph.Companion.getFileId(file);
                $this$withLock_u24default$iv = idsMutex;
                owner$iv = null;
                $i$f$withLock = 0;
                $continuation.L$0 = $this$doAddAsync_u24processFile;
                $continuation.L$1 = idsMutex;
                $continuation.L$2 = this$0;
                $continuation.L$3 = edgesMtx;
                $continuation.L$4 = file;
                $continuation.L$5 = $this$withLock_u24default$iv;
                $continuation.I$0 = fileId;
                $continuation.I$1 = $i$f$withLock;
                $continuation.label = 1;
                v0 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v0 == var16_8) {
                    return var16_8;
                }
                ** GOTO lbl41
            }
            case 1: {
                $i$f$withLock = $continuation.I$1;
                fileId = $continuation.I$0;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$5;
                file = (VirtualFile)$continuation.L$4;
                edgesMtx = (Mutex)$continuation.L$3;
                this$0 = (JSImportGraph)$continuation.L$2;
                idsMutex = (Mutex)$continuation.L$1;
                $this$doAddAsync_u24processFile = (CoroutineScope)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl41:
                // 2 sources

                try {
                    $i$a$-withLock$default-JSImportGraph$doAddAsync$processFile$previous$1 = false;
                    var12_15 = (VirtualFile)this$0.ids.putIfAbsent(fileId, (Object)file);
                }
                finally {
                    $this$withLock_u24default$iv.unlock(owner$iv);
                }
                previous = var12_15;
                if (previous != null) {
                    return Unit.INSTANCE;
                }
                BuildersKt.launch$default((CoroutineScope)$this$doAddAsync_u24processFile, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, file, edgesMtx, fileId, idsMutex, null){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    Object L$3;
                    int I$0;
                    int I$1;
                    int label;
                    final /* synthetic */ JSImportGraph this$0;
                    final /* synthetic */ VirtualFile $file;
                    final /* synthetic */ Mutex $edgesMtx;
                    final /* synthetic */ int $fileId;
                    final /* synthetic */ Mutex $idsMutex;
                    {
                        this.this$0 = $receiver;
                        this.$file = $file;
                        this.$edgesMtx = $edgesMtx;
                        this.$fileId = $fileId;
                        this.$idsMutex = $idsMutex;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        var19_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                if (!ApplicationKt.getApplication().isWriteAccessAllowed()) ** GOTO lbl8
                                v0 = JSImportGraph.access$getSearcher$p(this.this$0).getOutFiles(this.$file);
                                ** GOTO lbl17
lbl8:
                                // 1 sources

                                this.label = 1;
                                v1 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(com.intellij.lang.javascript.config.graph.JSImportGraph com.intellij.openapi.vfs.VirtualFile ), ()Ljava/util/List;)((JSImportGraph)this.this$0, (VirtualFile)this.$file), (Continuation)((Continuation)this));
                                if (v1 == var19_2) {
                                    return var19_2;
                                }
                                ** GOTO lbl16
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
lbl16:
                                // 2 sources

                                v0 = (List)v1;
lbl17:
                                // 2 sources

                                files = v0;
                                var3_5 = this.$edgesMtx;
                                var5_6 = this.this$0;
                                var6_7 = this.$file;
                                var7_8 = this.$fileId;
                                owner$iv = null;
                                $i$f$withLock = 0;
                                this.L$0 = files;
                                this.L$1 = $this$withLock_u24default$iv;
                                this.L$2 = var5_6;
                                this.L$3 = var6_7;
                                this.I$0 = var7_8;
                                this.I$1 = $i$f$withLock;
                                this.label = 2;
                                v2 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)this);
                                if (v2 == var19_2) {
                                    return var19_2;
                                }
                                ** GOTO lbl45
                            }
                            case 2: {
                                $i$f$withLock = this.I$1;
                                var7_8 = this.I$0;
                                var6_7 = (VirtualFile)this.L$3;
                                var5_6 = (JSImportGraph)this.L$2;
                                owner$iv = null;
                                $this$withLock_u24default$iv = (Mutex)this.L$1;
                                files = (List)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v2 = $result;
lbl45:
                                // 2 sources

                                try {
                                    $i$a$-withLock$default-JSImportGraph$doAddAsync$processFile$2$1 = false;
                                    arr = com.intellij.lang.javascript.config.graph.JSImportGraph$Companion.access$getOrInitMapFor(JSImportGraph.Companion, JSImportGraph.access$getOutEdges$p(var5_6), var6_7);
                                    $this$forEach$iv = files;
                                    $i$f$forEach = false;
                                    for (T element$iv : $this$forEach$iv) {
                                        importedFile = (VirtualFile)element$iv;
                                        $i$a$-forEach-JSImportGraph$doAddAsync$processFile$2$1$1 = false;
                                        arr.add(JSImportGraph.Companion.getFileId(importedFile));
                                        com.intellij.lang.javascript.config.graph.JSImportGraph$Companion.access$addEdge(JSImportGraph.Companion, JSImportGraph.access$getInEdges$p(var5_6), importedFile, var7_8);
                                    }
                                    var17_19 = Unit.INSTANCE;
                                }
                                finally {
                                    $this$withLock_u24default$iv.unlock(owner$iv);
                                }
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)files);
                                this.L$1 = null;
                                this.L$2 = null;
                                this.L$3 = null;
                                this.label = 3;
                                v3 = CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((List<? extends VirtualFile>)files, this.$idsMutex, this.this$0, this.$edgesMtx, null){
                                    Object L$1;
                                    Object L$2;
                                    int label;
                                    private /* synthetic */ Object L$0;
                                    final /* synthetic */ List<VirtualFile> $files;
                                    final /* synthetic */ Mutex $idsMutex;
                                    final /* synthetic */ JSImportGraph this$0;
                                    final /* synthetic */ Mutex $edgesMtx;
                                    {
                                        this.$files = $files;
                                        this.$idsMutex = $idsMutex;
                                        this.this$0 = $receiver;
                                        this.$edgesMtx = $edgesMtx;
                                        super(2, $completion);
                                    }

                                    /*
                                     * Unable to fully structure code
                                     */
                                    public final Object invokeSuspend(Object $result) {
                                        var2_2 = (CoroutineScope)this.L$0;
                                        var5_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                var3_4 = this.$files.iterator();
lbl7:
                                                // 3 sources

                                                while (var3_4.hasNext()) {
                                                    file = (VirtualFile)var3_4.next();
                                                    this.L$0 = $this$coroutineScope;
                                                    this.L$1 = var3_4;
                                                    this.L$2 = SpillingKt.nullOutSpilledVariable((Object)file);
                                                    this.label = 1;
                                                    v0 = JSImportGraph.access$doAddAsync$processFile((CoroutineScope)$this$coroutineScope, this.$idsMutex, this.this$0, this.$edgesMtx, file, (Continuation)this);
                                                    if (v0 != var5_3) continue;
                                                    return var5_3;
                                                }
                                                break;
                                            }
                                            case 1: {
                                                file = (VirtualFile)this.L$2;
                                                var3_4 = (Iterator)this.L$1;
                                                ResultKt.throwOnFailure((Object)$result);
                                                v0 = $result;
                                                ** GOTO lbl7
                                            }
                                        }
                                        return Unit.INSTANCE;
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                        var3_3.L$0 = value;
                                        return (Continuation)var3_3;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)((Continuation)this));
                                if (v3 == var19_2) {
                                    return var19_2;
                                }
                                ** GOTO lbl77
                            }
                            case 3: {
                                files = (List)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v3 = $result;
lbl77:
                                // 2 sources

                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }

                    private static final List invokeSuspend$lambda$0(JSImportGraph this$0, VirtualFile $file) {
                        return JSImportGraph.access$getSearcher$p(this$0).getOutFiles($file);
                    }
                }), (int)3, null);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @JvmStatic
    public static final int getFileId(@NotNull VirtualFile file) {
        return Companion.getFileId(file);
    }

    public static final /* synthetic */ Object access$doAddAsync(JSImportGraph $this, Collection toProcess, Continuation $completion) {
        return $this.doAddAsync(toProcess, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Object access$doAddAsync$processFile(CoroutineScope $receiver, Mutex idsMutex, JSImportGraph this$0, Mutex edgesMtx, VirtualFile file, Continuation $completion) {
        return JSImportGraph.doAddAsync$processFile($receiver, idsMutex, this$0, edgesMtx, file, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ JSFileImports access$getSearcher$p(JSImportGraph $this) {
        return $this.searcher;
    }

    public static final /* synthetic */ Int2ObjectMap access$getOutEdges$p(JSImportGraph $this) {
        return $this.outEdges;
    }

    public static final /* synthetic */ Int2ObjectMap access$getInEdges$p(JSImportGraph $this) {
        return $this.inEdges;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0007J&\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\nH\u0002J,\u0010\u0013\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\u0015H\u0002J\u001e\u0010\u0016\u001a\u00020\u00102\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\bH\u0002J\u001e\u0010\u0017\u001a\u00020\u00102\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0018\u001a\u00020\nH\u0002J\u0010\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001d\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u00a8\u0006 "}, d2={"Lcom/intellij/lang/javascript/config/graph/JSImportGraph$Companion;", "", "<init>", "()V", "extractIdsForFiles", "", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFileId", "", "file", "addEdge", "", "map", "Lit/unimi/dsi/fastutil/ints/Int2ObjectMap;", "Lit/unimi/dsi/fastutil/ints/IntList;", "key", "valueId", "addEdges", "values", "", "getOrInitMapFor", "getOrDefault", "value", "logStartGraphBuilding", "graph", "Lcom/intellij/lang/javascript/config/graph/JSImportGraph;", "logEndGraphBuilding", "logStartGraphUpdating", "logEndGraphUpdating", "logGraphState", "intellij.javascript.backend"})
    @SourceDebugExtension(value={"SMAP\nJSImportGraph.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSImportGraph.kt\ncom/intellij/lang/javascript/config/graph/JSImportGraph$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,463:1\n1563#2:464\n1634#2,3:465\n1563#2:468\n1634#2,3:469\n*S KotlinDebug\n*F\n+ 1 JSImportGraph.kt\ncom/intellij/lang/javascript/config/graph/JSImportGraph$Companion\n*L\n395#1:464\n395#1:465,3\n407#1:468\n407#1:469,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final int[] extractIdsForFiles(Collection<? extends VirtualFile> files) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = files;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Companion.getFileId((VirtualFile)it));
            }
            return CollectionsKt.toIntArray((Collection)((List)destination$iv$iv));
        }

        @JvmStatic
        public final int getFileId(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            VirtualFileWithId virtualFileWithId = file instanceof VirtualFileWithId ? (VirtualFileWithId)file : null;
            return virtualFileWithId != null ? virtualFileWithId.getId() : file.getPath().hashCode();
        }

        private final void addEdge(Int2ObjectMap<IntList> map, VirtualFile key, int valueId) {
            this.getOrInitMapFor(map, key).add(valueId);
        }

        /*
         * WARNING - void declaration
         */
        private final void addEdges(Int2ObjectMap<IntList> map, VirtualFile key, Set<? extends VirtualFile> values) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            IntList arr = this.getOrInitMapFor(map, key);
            Iterable iterable = values;
            IntList intList = arr;
            boolean $i$f$map = false;
            void var7_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Companion.getFileId((VirtualFile)it));
            }
            intList.addAll((IntList)IntArrayList.wrap((int[])CollectionsKt.toIntArray((Collection)((List)destination$iv$iv))));
        }

        private final IntList getOrInitMapFor(Int2ObjectMap<IntList> map, VirtualFile key) {
            Object object = map.computeIfAbsent(this.getFileId(key), Companion::getOrInitMapFor$lambda$0);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"computeIfAbsent(...)");
            return (IntList)object;
        }

        private final IntList getOrDefault(Int2ObjectMap<IntList> map, int value) {
            IntList list = (IntList)map.get(value);
            IntList intList = list;
            if (intList == null) {
                IntLists.EmptyList emptyList = IntLists.EMPTY_LIST;
                Intrinsics.checkNotNullExpressionValue((Object)emptyList, (String)"EMPTY_LIST");
                intList = (IntList)emptyList;
            }
            return intList;
        }

        private final void logStartGraphBuilding(JSImportGraph graph) {
            if (!JSConfigGraphCache.LOG.isTraceEnabled()) {
                return;
            }
            JSConfigGraphCache.LOG.trace("Start building tsconfig graph. Hash: " + graph.hashCode() + ", file_imports_hash: " + graph.getFileImports().hashCode() + ",thread:" + Thread.currentThread().getName());
        }

        private final void logEndGraphBuilding(JSImportGraph graph) {
            if (!JSConfigGraphCache.LOG.isTraceEnabled()) {
                return;
            }
            JSConfigGraphCache.LOG.trace("End building tsconfig graph. TypeScriptFileImports.hash:" + graph.getFileImports().hashCode() + ", thread: " + Thread.currentThread().getName());
            this.logGraphState(graph);
        }

        private final void logStartGraphUpdating(JSImportGraph graph, VirtualFile file) {
            if (!JSConfigGraphCache.LOG.isTraceEnabled()) {
                return;
            }
            JSConfigGraphCache.LOG.trace("Start updating tsconfig graph. Source: " + file.getName() + ". Nodes: " + graph.getNodes().size() + ", thread: " + Thread.currentThread().getName());
        }

        private final void logEndGraphUpdating(JSImportGraph graph) {
            if (!JSConfigGraphCache.LOG.isTraceEnabled()) {
                return;
            }
            JSConfigGraphCache.LOG.trace("End updating tsconfig graph. Thread: " + Thread.currentThread().getName());
            this.logGraphState(graph);
        }

        private final void logGraphState(JSImportGraph graph) {
            JSConfigGraphCache.LOG.trace("Graph (has:" + graph.hashCode() + ") roots: " + graph.getRoots().size() + ", nodes: " + graph.getNodes().size() + ", available from roots: " + graph.getAvailableFromRoots().size());
        }

        private static final IntArrayList getOrInitMapFor$lambda$0(int it) {
            return new IntArrayList();
        }

        public static final /* synthetic */ IntList access$getOrInitMapFor(Companion $this, Int2ObjectMap map, VirtualFile key) {
            return $this.getOrInitMapFor((Int2ObjectMap<IntList>)map, key);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

