/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.jsx.tsx;

import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.frameworks.jsx.JSXAttributeDescriptorImpl;
import com.intellij.lang.javascript.frameworks.jsx.JSXImplementation;
import com.intellij.lang.javascript.frameworks.jsx.JSXProp;
import com.intellij.lang.javascript.frameworks.jsx.JSXProps;
import com.intellij.lang.javascript.frameworks.jsx.references.JSXResolveUtil;
import com.intellij.lang.javascript.modules.JSNodeModuleStructure;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlAttributeDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptJSXTagUtil {
    private static final String DIV_TAG = "div";

    public static XmlAttributeDescriptor[] getXmlAttributeDescriptors(@NotNull JSXProps props) {
        if (props == null) {
            TypeScriptJSXTagUtil.$$$reportNull$$$0(0);
        }
        ArrayList<XmlAttributeDescriptor> members = new ArrayList<XmlAttributeDescriptor>();
        for (JSXProp prop : props.getValues()) {
            members.add(TypeScriptJSXTagUtil.createAttributeDescriptor(prop));
        }
        return members.toArray(XmlAttributeDescriptor.EMPTY);
    }

    @Nullable
    public static JSRecordType.PropertySignature resolveTag(@NotNull XmlTag tag) {
        if (tag == null) {
            TypeScriptJSXTagUtil.$$$reportNull$$$0(1);
        }
        if (JSXResolveUtil.isComponentName((String)tag.getName())) {
            return null;
        }
        return TypeScriptJSXTagUtil.findPropertySignature((PsiElement)tag, tag.getName());
    }

    @Nullable
    private static JSRecordType.PropertySignature findPropertySignature(PsiElement context2, String tagName) {
        return TypeScriptJSXTagUtil.getAllTags(context2).get(tagName);
    }

    @NotNull
    public static Map<String, JSRecordType.PropertySignature> getAllTags(@NotNull PsiElement _context) {
        JSElement scopeElement;
        if (_context == null) {
            TypeScriptJSXTagUtil.$$$reportNull$$$0(2);
        }
        if ((scopeElement = ES6PsiUtil.getNonStrictExportScope((PsiElement)_context)) == null) {
            Map<String, JSRecordType.PropertySignature> map = Collections.emptyMap();
            if (map == null) {
                TypeScriptJSXTagUtil.$$$reportNull$$$0(3);
            }
            return map;
        }
        Map map = (Map)CachedValuesManager.getCachedValue((PsiElement)scopeElement, () -> TypeScriptJSXTagUtil.lambda$getAllTags$0((PsiElement)scopeElement));
        if (map == null) {
            TypeScriptJSXTagUtil.$$$reportNull$$$0(4);
        }
        return map;
    }

    @NotNull
    private static Map<String, JSRecordType.PropertySignature> getAllTagsForScope(@NotNull PsiElement scopeElement) {
        if (scopeElement == null) {
            TypeScriptJSXTagUtil.$$$reportNull$$$0(5);
        }
        JSXImplementation implementation = JSXImplementation.getImplementation((PsiElement)scopeElement);
        JSType jsxType = implementation.getJsxChildInstance(scopeElement, "IntrinsicElements");
        Comparator<JSRecordType.PropertySignature> comparator = Comparator.comparing(TypeScriptJSXTagUtil.getSorter(scopeElement.getProject(), implementation.getLibraries()));
        JSRecordType recordType = jsxType.asRecordType();
        if (recordType.hasMembers()) {
            HashMap<String, JSRecordType.PropertySignature> map = new HashMap<String, JSRecordType.PropertySignature>();
            TypeScriptJSXTagUtil.fillFromRecordType(recordType, comparator, map);
            Map<String, JSRecordType.PropertySignature> map2 = Collections.unmodifiableMap(map);
            if (map2 == null) {
                TypeScriptJSXTagUtil.$$$reportNull$$$0(6);
            }
            return map2;
        }
        Map<String, JSRecordType.PropertySignature> map = Collections.emptyMap();
        if (map == null) {
            TypeScriptJSXTagUtil.$$$reportNull$$$0(7);
        }
        return map;
    }

    public static boolean hasClassAttribute(@NotNull PsiElement context2) {
        JSRecordType.PropertySignature div;
        if (context2 == null) {
            TypeScriptJSXTagUtil.$$$reportNull$$$0(8);
        }
        if ((div = TypeScriptJSXTagUtil.findPropertySignature(context2, DIV_TAG)) == null) {
            return false;
        }
        JSType type2 = div.getJSType();
        if (type2 == null) {
            return false;
        }
        return type2.asRecordType().findPropertySignature("class") != null;
    }

    private static void fillFromRecordType(@NotNull JSRecordType recordType, @NotNull Comparator<JSRecordType.PropertySignature> comparator, @NotNull Map<String, JSRecordType.PropertySignature> result2) {
        if (recordType == null) {
            TypeScriptJSXTagUtil.$$$reportNull$$$0(9);
        }
        if (comparator == null) {
            TypeScriptJSXTagUtil.$$$reportNull$$$0(10);
        }
        if (result2 == null) {
            TypeScriptJSXTagUtil.$$$reportNull$$$0(11);
        }
        ((StreamEx)StreamEx.of((Collection)recordType.getProperties()).sorted(comparator)).forEach(el -> result2.put(el.getMemberName(), (JSRecordType.PropertySignature)el));
    }

    @NotNull
    private static Function<JSRecordType.PropertySignature, String> getSorter(@NotNull Project project, @NotNull Set<VirtualFile> libraryFiles) {
        if (project == null) {
            TypeScriptJSXTagUtil.$$$reportNull$$$0(12);
        }
        if (libraryFiles == null) {
            TypeScriptJSXTagUtil.$$$reportNull$$$0(13);
        }
        Function<JSRecordType.PropertySignature, String> function = member -> {
            PsiElement el = member.getMemberSource().getSingleElement();
            if (el == null) {
                return "";
            }
            VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)el);
            if (virtualFile == null) {
                return "";
            }
            JSNodeModuleStructure structure = JSNodeModuleStructure.getStructure(project, virtualFile);
            return libraryFiles.contains(virtualFile) || structure != null && Objects.equals(structure.getPackageName(), "@types/react") ? "" : virtualFile.getPath();
        };
        if (function == null) {
            TypeScriptJSXTagUtil.$$$reportNull$$$0(14);
        }
        return function;
    }

    @Deprecated
    @NotNull
    public static XmlAttributeDescriptor createAttributeDescriptor(@NotNull JSRecordType.PropertySignature signature, boolean forceOptional) {
        if (signature == null) {
            TypeScriptJSXTagUtil.$$$reportNull$$$0(15);
        }
        boolean optional = forceOptional || signature.isOptional();
        JSRecordType.MemberSource source = signature.getMemberSource();
        XmlAttributeDescriptor xmlAttributeDescriptor = JSXAttributeDescriptorImpl.create(signature.getMemberName(), source.getSingleElement(), signature.getJSType(), optional);
        if (xmlAttributeDescriptor == null) {
            TypeScriptJSXTagUtil.$$$reportNull$$$0(16);
        }
        return xmlAttributeDescriptor;
    }

    @NotNull
    public static XmlAttributeDescriptor createAttributeDescriptor(@NotNull JSXProp prop) {
        if (prop == null) {
            TypeScriptJSXTagUtil.$$$reportNull$$$0(17);
        }
        XmlAttributeDescriptor xmlAttributeDescriptor = JSXAttributeDescriptorImpl.create(prop.getName(), prop.getSourceElement(), prop.getJsType(), prop.isOptional());
        if (xmlAttributeDescriptor == null) {
            TypeScriptJSXTagUtil.$$$reportNull$$$0(18);
        }
        return xmlAttributeDescriptor;
    }

    private static /* synthetic */ CachedValueProvider.Result lambda$getAllTags$0(PsiElement scopeElement) {
        return CachedValueProvider.Result.create(TypeScriptJSXTagUtil.getAllTagsForScope(scopeElement), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6, 7, 14, 16, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "props";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "_context";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/jsx/tsx/TypeScriptJSXTagUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recordType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryFiles";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prop";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/jsx/tsx/TypeScriptJSXTagUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTags";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTagsForScope";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSorter";
                break;
            }
            case 16: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createAttributeDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getXmlAttributeDescriptors";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resolveTag";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getAllTags";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 14: 
            case 16: 
            case 18: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAllTagsForScope";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasClassAttribute";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fillFromRecordType";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSorter";
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createAttributeDescriptor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6, 7, 14, 16, 18 -> new IllegalStateException(string);
        };
    }
}

