/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.Convertor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilesMirror {
    private static final Logger LOG = Logger.getInstance(FilesMirror.class);
    private final Key<ThreadLocalFile> myKey;
    private final String myTempDirName;

    public FilesMirror(@NotNull String name, @NotNull String tempDirName) {
        if (name == null) {
            FilesMirror.$$$reportNull$$$0(0);
        }
        if (tempDirName == null) {
            FilesMirror.$$$reportNull$$$0(1);
        }
        this.myTempDirName = tempDirName;
        this.myKey = Key.create((String)name);
    }

    @Nullable
    public File getOrCreateExactlyNamed(@NotNull Project project, @NotNull VirtualFile virtualFile, @Nullable String content) {
        if (project == null) {
            FilesMirror.$$$reportNull$$$0(2);
        }
        if (virtualFile == null) {
            FilesMirror.$$$reportNull$$$0(3);
        }
        return this.getOrCreate(project, virtualFile, content, (Convertor<VirtualFile, ThreadLocalFile>)((Convertor)o -> new ThreadLocalCertainFileInTmpDir(o.getName(), o.getNameWithoutExtension(), this.myTempDirName)));
    }

    @Nullable
    public File getOrCreateFileWithActualContent(@NotNull Project project, @NotNull VirtualFile virtualFile, @Nullable String content) {
        if (project == null) {
            FilesMirror.$$$reportNull$$$0(4);
        }
        if (virtualFile == null) {
            FilesMirror.$$$reportNull$$$0(5);
        }
        return this.getOrCreate(project, virtualFile, content, (Convertor<VirtualFile, ThreadLocalFile>)((Convertor)o -> new ThreadLocalTempFilePath((VirtualFile)o, this.myTempDirName)));
    }

    @Nullable
    private File getOrCreate(@NotNull Project project, @NotNull VirtualFile virtualFile, @Nullable String content, @NotNull Convertor<VirtualFile, ThreadLocalFile> convertor) {
        File file;
        FileDocumentManager fileDocumentManager;
        if (project == null) {
            FilesMirror.$$$reportNull$$$0(6);
        }
        if (virtualFile == null) {
            FilesMirror.$$$reportNull$$$0(7);
        }
        if (convertor == null) {
            FilesMirror.$$$reportNull$$$0(8);
        }
        if (!(fileDocumentManager = FileDocumentManager.getInstance()).isFileModified(virtualFile) && (file = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile)).isFile()) {
            return file;
        }
        file = this.getMirrorFile(virtualFile, convertor);
        if (file == null) {
            return null;
        }
        try {
            return FilesMirror.copyUnsavedFileText(project, virtualFile, content, file);
        }
        catch (IOException e) {
            LOG.warn("Can not write to " + file.getAbsolutePath(), (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static File copyUnsavedFileText(@NotNull Project project, VirtualFile virtualFile, @Nullable String content, File file) throws IOException {
        FileDocumentManager fileDocumentManager;
        Document document;
        if (project == null) {
            FilesMirror.$$$reportNull$$$0(9);
        }
        if ((document = (fileDocumentManager = FileDocumentManager.getInstance()).getCachedDocument(virtualFile)) == null) {
            return null;
        }
        if (content == null) {
            content = document.getText();
        }
        content = JSLanguageServiceUtil.convertLineSeparatorsToFileOriginal(project, content, virtualFile).toString();
        byte[] bom = virtualFile.getBOM();
        Charset charset = virtualFile.getCharset();
        if (bom != null) {
            byte[] withBom = FilesMirror.getBytesWithBom(content, bom, charset);
            FileUtil.writeToFile((File)file, (byte[])withBom);
        } else {
            FileUtil.writeToFile((File)file, (byte[])content.getBytes(charset));
        }
        return file;
    }

    private static byte[] getBytesWithBom(@NotNull String content, byte[] bom, Charset charset) {
        if (content == null) {
            FilesMirror.$$$reportNull$$$0(10);
        }
        byte[] contentBytes = content.getBytes(charset);
        byte[] withBom = new byte[contentBytes.length + bom.length];
        System.arraycopy(bom, 0, withBom, 0, bom.length);
        System.arraycopy(contentBytes, 0, withBom, bom.length, contentBytes.length);
        return withBom;
    }

    @Nullable
    private File getMirrorFile(@NotNull VirtualFile virtualFile, @NotNull Convertor<VirtualFile, ThreadLocalFile> convertor) {
        if (virtualFile == null) {
            FilesMirror.$$$reportNull$$$0(11);
        }
        if (convertor == null) {
            FilesMirror.$$$reportNull$$$0(12);
        }
        ThreadLocalFile threadLocal = (ThreadLocalFile)ConcurrencyUtil.computeIfAbsent((UserDataHolder)virtualFile, this.myKey, () -> (ThreadLocalFile)convertor.convert((Object)virtualFile));
        return threadLocal.getFile();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tempDirName";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "convertor";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/linter/FilesMirror";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getOrCreateExactlyNamed";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getOrCreateFileWithActualContent";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getOrCreate";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "copyUnsavedFileText";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getBytesWithBom";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "getMirrorFile";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static abstract class ThreadLocalFile
    extends ThreadLocal<String> {
        @Nullable
        public File getFile() {
            File file;
            String path2 = (String)super.get();
            if (path2 != null && (file = new File(path2)).isFile()) {
                return file;
            }
            file = this.createFile();
            if (file != null) {
                this.set(file.getAbsolutePath());
                return file;
            }
            return null;
        }

        protected abstract File createFile();
    }

    public static final class ThreadLocalTempFilePath
    extends ThreadLocalFile {
        private final String myBaseNameWithoutExtension;
        private final String myTempDirName;
        private final String myDotExtension;

        private ThreadLocalTempFilePath(@NotNull VirtualFile file, @NotNull String tempDirName) {
            if (file == null) {
                ThreadLocalTempFilePath.$$$reportNull$$$0(0);
            }
            if (tempDirName == null) {
                ThreadLocalTempFilePath.$$$reportNull$$$0(1);
            }
            this.myTempDirName = tempDirName;
            this.myBaseNameWithoutExtension = file.getNameWithoutExtension();
            String ext = file.getExtension();
            this.myDotExtension = ext != null ? "." + ext : null;
        }

        @Nullable
        private File getDir() {
            File tmpDir = new File(FileUtil.getTempDirectory());
            File dir = new File(tmpDir, this.myTempDirName);
            if (dir.isDirectory() || dir.mkdirs()) {
                return dir;
            }
            try {
                return FileUtil.createTempDirectory((File)tmpDir, (String)this.myTempDirName, null, (boolean)true);
            }
            catch (IOException e) {
                LOG.warn("Can't create '" + this.myTempDirName + "' temporary directory.", (Throwable)e);
                return null;
            }
        }

        @Override
        @Nullable
        protected File createFile() {
            File dir = this.getDir();
            if (dir == null) {
                return null;
            }
            try {
                return FileUtil.createTempFile((File)dir, (String)this.myBaseNameWithoutExtension, (String)this.myDotExtension, (boolean)true, (boolean)true);
            }
            catch (IOException e) {
                LOG.warn("Can not create temp file", (Throwable)e);
                return null;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tempDirName";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/linter/FilesMirror$ThreadLocalTempFilePath";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class ThreadLocalCertainFileInTmpDir
    extends ThreadLocalFile {
        private final String myExactFileName;
        @NotNull
        private final String myPrefix;
        @NotNull
        private final String myTempDirName;

        public ThreadLocalCertainFileInTmpDir(@NotNull String name, @NotNull String prefix, @NotNull String tempDirName) {
            if (name == null) {
                ThreadLocalCertainFileInTmpDir.$$$reportNull$$$0(0);
            }
            if (prefix == null) {
                ThreadLocalCertainFileInTmpDir.$$$reportNull$$$0(1);
            }
            if (tempDirName == null) {
                ThreadLocalCertainFileInTmpDir.$$$reportNull$$$0(2);
            }
            this.myTempDirName = tempDirName;
            assert (!StringUtil.isEmptyOrSpaces((String)name));
            assert (!StringUtil.isEmptyOrSpaces((String)prefix));
            this.myExactFileName = name;
            this.myPrefix = prefix;
        }

        @Nullable
        private File getDir() {
            File tmpDir = new File(FileUtil.getTempDirectory());
            File dir = new File(tmpDir, this.myTempDirName);
            try {
                if (!dir.isDirectory() && !dir.mkdirs()) {
                    dir = FileUtil.createTempDirectory((File)tmpDir, (String)this.myTempDirName, null);
                }
                dir = FileUtil.createTempDirectory((File)dir, (String)this.myPrefix, null);
                return dir;
            }
            catch (IOException ignored) {
                LOG.warn("Can't create '" + this.myTempDirName + "' temporary directory.");
                return null;
            }
        }

        @Override
        @Nullable
        protected File createFile() {
            File dir = this.getDir();
            if (dir == null) {
                return null;
            }
            File file = new File(dir, this.myExactFileName);
            if (!file.exists()) {
                try {
                    if (!file.createNewFile()) {
                        LOG.warn("Can not create " + file.getAbsolutePath());
                    }
                }
                catch (IOException ignored) {
                    LOG.warn("Can not create " + file.getAbsolutePath());
                }
            }
            file.deleteOnExit();
            return file;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "prefix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "tempDirName";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/linter/FilesMirror$ThreadLocalCertainFileInTmpDir";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

