/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler;

import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.service.JSLanguageServiceQueue;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.TypeScriptServiceHolder;
import com.intellij.lang.typescript.compiler.UpdateFileInfo;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptServiceCommandClean;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigFileType;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigLibraryUpdater;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigServiceImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.execution.ParametersListUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J<\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0002J\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u000fH\u0002J\u0010\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J \u0010\u001d\u001a\u00020\n2\u000e\u0010\u001e\u001a\n\u0012\u0006\b\u0000\u0012\u00020\f0\u001f2\u0006\u0010\u0015\u001a\u00020\bH\u0002J\u001e\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\"2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\f0\u0007H\u0002J\u0018\u0010$\u001a\u00020\n2\u0006\u0010!\u001a\u00020\"2\u0006\u0010%\u001a\u00020&H\u0002J \u0010'\u001a\u00020\n2\u0006\u0010!\u001a\u00020\"2\u000e\u0010(\u001a\n\u0012\u0006\b\u0000\u0012\u00020*0)H\u0002\u00a8\u0006+"}, d2={"Lcom/intellij/lang/typescript/compiler/TypeScriptCompilerServiceVfsListener;", "Lcom/intellij/openapi/vfs/AsyncFileListener;", "<init>", "()V", "prepareChange", "Lcom/intellij/openapi/vfs/AsyncFileListener$ChangeApplier;", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "afterProcessing", "", "filesToProcess", "Lcom/intellij/lang/typescript/compiler/UpdateFileInfo;", "changedConfigs", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "cleanAllCache", "", "hasCreateTsFileEvent", "shouldUpdateLibraries", "logTypeScriptEvent", "event", "file", "isConfigFile", "fileNameSequence", "", "hasConfigParameter", "settings", "Lcom/intellij/lang/typescript/compiler/TypeScriptCompilerSettings;", "fillCreateAndChangeFiles", "filesToUpdateState", "", "processVfsChangesForFiles", "project", "Lcom/intellij/openapi/project/Project;", "files", "sendCleanCommandToCompiler", "command", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/commands/TypeScriptServiceCommandClean;", "processForServices", "consumer", "Ljava/util/function/Consumer;", "Lcom/intellij/lang/typescript/compiler/TypeScriptCompilerService;", "intellij.javascript.backend"})
@SourceDebugExtension(value={"SMAP\nTypeScriptCompilerServiceVfsListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeScriptCompilerServiceVfsListener.kt\ncom/intellij/lang/typescript/compiler/TypeScriptCompilerServiceVfsListener\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,223:1\n30#2,2:224\n774#3:226\n865#3,2:227\n1869#3,2:229\n*S KotlinDebug\n*F\n+ 1 TypeScriptCompilerServiceVfsListener.kt\ncom/intellij/lang/typescript/compiler/TypeScriptCompilerServiceVfsListener\n*L\n125#1:224,2\n129#1:226\n129#1:227,2\n210#1:229,2\n*E\n"})
public final class TypeScriptCompilerServiceVfsListener
implements AsyncFileListener {
    @Nullable
    public AsyncFileListener.ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
        Collection collection;
        Intrinsics.checkNotNullParameter(events, (String)"events");
        List fileWithChangedContent = null;
        boolean cleanAllCache = false;
        boolean shouldUpdateLibraries = false;
        Collection changedConfigs = null;
        boolean hasCreateTsFileEvent = false;
        for (VFileEvent vFileEvent : events) {
            CharSequence sequence;
            boolean isStructureModification;
            ProgressManager.checkCanceled();
            if (!(vFileEvent.getFileSystem() instanceof LocalFileSystem)) continue;
            VirtualFile file = vFileEvent.getFile();
            if (file == null) {
                if (!(vFileEvent instanceof VFileCreateEvent) || !((VFileCreateEvent)vFileEvent).isDirectory() || ((VFileCreateEvent)vFileEvent).getChildren() != null) continue;
                shouldUpdateLibraries = true;
                continue;
            }
            boolean bl = isStructureModification = vFileEvent instanceof VFileDeleteEvent || vFileEvent instanceof VFileMoveEvent || vFileEvent instanceof VFileCopyEvent;
            if (isStructureModification && (Intrinsics.areEqual((Object)true, (Object)file.getUserData(JSLanguageServiceQueue.Holder.GENERATED_FILE_MARKER)) || file.isDirectory())) {
                cleanAllCache = true;
                continue;
            }
            if (file.isDirectory()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)file.getNameSequence(), (String)"getNameSequence(...)");
            if (TypeScriptUtil.isTypeScriptFile((CharSequence)sequence)) {
                this.logTypeScriptEvent(vFileEvent, file);
                hasCreateTsFileEvent |= vFileEvent instanceof VFileCreateEvent || vFileEvent instanceof VFileCopyEvent || vFileEvent instanceof VFileMoveEvent;
                if (fileWithChangedContent == null) {
                    fileWithChangedContent = (List)new SmartList();
                }
                this.fillCreateAndChangeFiles(fileWithChangedContent, vFileEvent);
                continue;
            }
            if (!this.isConfigFile(sequence)) continue;
            if (changedConfigs == null) {
                changedConfigs = new HashSet();
            }
            changedConfigs.add(file);
        }
        List list = fileWithChangedContent;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        if ((collection = changedConfigs) == null) {
            collection = CollectionsKt.emptyList();
        }
        this.afterProcessing(list, collection, cleanAllCache, hasCreateTsFileEvent, shouldUpdateLibraries);
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final void afterProcessing(List<UpdateFileInfo> filesToProcess, Collection<? extends VirtualFile> changedConfigs, boolean cleanAllCache, boolean hasCreateTsFileEvent, boolean shouldUpdateLibraries) {
        if (changedConfigs.isEmpty() && !cleanAllCache && !shouldUpdateLibraries && filesToProcess.isEmpty()) {
            return;
        }
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        for (Project project : projectArray) {
            void $this$filterTo$iv$iv;
            ProjectFileIndex fileIndex;
            Intrinsics.checkNotNull((Object)project);
            Project project2 = project;
            TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.Companion.getSettings(project2);
            Intrinsics.checkNotNullExpressionValue((Object)ProjectFileIndex.getInstance((Project)project2), (String)"getInstance(...)");
            if (cleanAllCache || hasCreateTsFileEvent && this.hasConfigParameter(settings)) {
                this.sendCleanCommandToCompiler(project2, new TypeScriptServiceCommandClean(true));
            } else if (!changedConfigs.isEmpty()) {
                TypeScriptConfigService configService;
                for (VirtualFile virtualFile : changedConfigs) {
                    if (!fileIndex.isInContent(virtualFile)) continue;
                    this.sendCleanCommandToCompiler(project2, new TypeScriptServiceCommandClean(TypeScriptCompilerConfigUtil.getConfigIdByConfig(virtualFile)));
                }
                Intrinsics.checkNotNullExpressionValue((Object)TypeScriptConfigService.Provider.get((Project)project2), (String)"get(...)");
                if (configService instanceof TypeScriptConfigServiceImpl) {
                    ((TypeScriptConfigServiceImpl)configService).afterUpdate(changedConfigs);
                }
            } else if (shouldUpdateLibraries) {
                ComponentManager $this$service$iv = (ComponentManager)project2;
                boolean bl = false;
                Class<TypeScriptConfigLibraryUpdater> serviceClass$iv = TypeScriptConfigLibraryUpdater.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                ((TypeScriptConfigLibraryUpdater)object).queueToUpdate();
            }
            if (!(!((Collection)filesToProcess).isEmpty())) continue;
            Iterable iterable = filesToProcess;
            boolean $i$f$filter = false;
            Iterable iterable2 = iterable;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                UpdateFileInfo el = (UpdateFileInfo)element$iv$iv;
                boolean bl = false;
                if (!fileIndex.isInContent(el.getFile())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List filtered = (List)destination$iv$iv;
            this.processVfsChangesForFiles(project2, filtered);
        }
    }

    private final void logTypeScriptEvent(VFileEvent event, VirtualFile file) {
        if (JSLanguageServiceQueue.Holder.LOGGER.isDebugEnabled()) {
            JSLanguageServiceQueue.Holder.LOGGER.debug("TypeScript Vfs Events Processing: " + event.getClass() + " file " + file + " " + event.getRequestor());
        }
    }

    private final boolean isConfigFile(CharSequence fileNameSequence) {
        if (!StringsKt.endsWith$default((CharSequence)fileNameSequence, (CharSequence)".json", (boolean)false, (int)2, null)) {
            return false;
        }
        return FileTypeManager.getInstance().getFileTypeByFileName(fileNameSequence) instanceof TypeScriptConfigFileType;
    }

    private final boolean hasConfigParameter(TypeScriptCompilerSettings settings) {
        if (!settings.getUseService()) {
            return true;
        }
        String params = settings.getDefaultServiceOptions();
        if (StringUtil.isEmpty((String)params)) {
            return false;
        }
        String string = params;
        Intrinsics.checkNotNull((Object)string);
        for (String s : ParametersListUtil.parse((String)string)) {
            String[] stringArray;
            if (StringUtil.isEmpty((String)s) || !ArrayUtil.contains((String)s, (String[])Arrays.copyOf(stringArray = TypeScriptLanguageServiceUtil.CONFIG_PARAMS, stringArray.length))) continue;
            return true;
        }
        return false;
    }

    private final void fillCreateAndChangeFiles(List<? super UpdateFileInfo> filesToUpdateState, VFileEvent event) {
        VirtualFile file = event.getFile();
        if (file == null) {
            return;
        }
        if (event instanceof VFileContentChangeEvent) {
            filesToUpdateState.add(new UpdateFileInfo(file, false));
        } else if (event instanceof VFileCreateEvent || event instanceof VFileCopyEvent || event instanceof VFileMoveEvent) {
            filesToUpdateState.add(new UpdateFileInfo(file, true));
        }
    }

    private final void processVfsChangesForFiles(Project project, List<UpdateFileInfo> files) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (project.isDisposed() || files.isEmpty()) {
            return;
        }
        MultiMap multiMap = MultiMap.create();
        Intrinsics.checkNotNullExpressionValue((Object)multiMap, (String)"create(...)");
        MultiMap map = multiMap;
        for (UpdateFileInfo update2 : files) {
            VirtualFile file = update2.getFile();
            if (!file.isValid()) continue;
            this.processForServices(project, arg_0 -> TypeScriptCompilerServiceVfsListener.processVfsChangesForFiles$lambda$1(arg_0 -> TypeScriptCompilerServiceVfsListener.processVfsChangesForFiles$lambda$0(file, map, update2, arg_0), arg_0));
        }
        for (Map.Entry entry : map.entrySet()) {
            Intrinsics.checkNotNull((Object)entry);
            TypeScriptCompilerService service = (TypeScriptCompilerService)entry.getKey();
            Collection toProcess = (Collection)entry.getValue();
            Intrinsics.checkNotNull((Object)toProcess);
            service.processVfsChangesForFiles(toProcess);
        }
    }

    private final void sendCleanCommandToCompiler(Project project, TypeScriptServiceCommandClean command) {
        this.processForServices(project, arg_0 -> TypeScriptCompilerServiceVfsListener.sendCleanCommandToCompiler$lambda$1(arg_0 -> TypeScriptCompilerServiceVfsListener.sendCleanCommandToCompiler$lambda$0(command, arg_0), arg_0));
    }

    private final void processForServices(Project project, Consumer<? super TypeScriptCompilerService> consumer) {
        if (project.isDisposed()) {
            return;
        }
        Iterable $this$forEach$iv = TypeScriptServiceHolder.getCompilerServicesForProject(project);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TypeScriptCompilerService service = (TypeScriptCompilerService)element$iv;
            boolean bl = false;
            consumer.accept(service);
        }
    }

    private static final Unit processVfsChangesForFiles$lambda$0(VirtualFile $file, MultiMap $map, UpdateFileInfo $update, TypeScriptCompilerService service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        if (service.isServiceCreated() && service.isServiceForFile($file)) {
            $map.putValue((Object)service, (Object)$update);
        }
        return Unit.INSTANCE;
    }

    private static final void processVfsChangesForFiles$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit sendCleanCommandToCompiler$lambda$0(TypeScriptServiceCommandClean $command, TypeScriptCompilerService service) {
        Intrinsics.checkNotNullParameter((Object)service, (String)"service");
        if (service.isServiceCreated()) {
            service.sendCleanCommandToCompiler($command);
        }
        return Unit.INSTANCE;
    }

    private static final void sendCleanCommandToCompiler$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

