/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.settings.exclude;

import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.typescript.settings.exclude.TypeScriptExcludeManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class TypeScriptGeneratedFilesExcludePolicy
implements DirectoryIndexExcludePolicy {
    private static boolean ourEnableForTests = false;
    private final TypeScriptExcludeManager myManager;

    public TypeScriptGeneratedFilesExcludePolicy(@NotNull Project project) {
        if (project == null) {
            TypeScriptGeneratedFilesExcludePolicy.$$$reportNull$$$0(0);
        }
        this.myManager = TypeScriptExcludeManager.getInstance(project);
    }

    public String @NotNull [] getExcludeUrlsForProject() {
        if (this.myManager == null) {
            if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
                TypeScriptGeneratedFilesExcludePolicy.$$$reportNull$$$0(1);
            }
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        if (!this.myManager.isExcludeGeneratedFiles() || !ourEnableForTests && ApplicationManager.getApplication().isUnitTestMode()) {
            if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
                TypeScriptGeneratedFilesExcludePolicy.$$$reportNull$$$0(2);
            }
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }
        String[] stringArray = (String[])ReadAction.compute(() -> {
            SmartList result2 = new SmartList();
            Collection<String> paths = this.myManager.getExcludedPaths();
            if (paths.isEmpty()) {
                return ArrayUtilRt.EMPTY_STRING_ARRAY;
            }
            result2.addAll(this.filterFilesToExclude(paths));
            return ArrayUtilRt.toStringArray((Collection)result2);
        });
        if (stringArray == null) {
            TypeScriptGeneratedFilesExcludePolicy.$$$reportNull$$$0(3);
        }
        return stringArray;
    }

    @NotNull
    private Collection<String> filterFilesToExclude(@NotNull Collection<String> allFiles) {
        if (allFiles == null) {
            TypeScriptGeneratedFilesExcludePolicy.$$$reportNull$$$0(4);
        }
        if (allFiles.isEmpty()) {
            Collection<String> collection = allFiles;
            if (collection == null) {
                TypeScriptGeneratedFilesExcludePolicy.$$$reportNull$$$0(5);
            }
            return collection;
        }
        assert (this.myManager != null);
        Collection collection = allFiles.stream().filter(el -> this.myManager.isExcludeDeclarationFiles() || !TypeScriptUtil.isDefinitionFile((CharSequence)el)).map(el -> VirtualFileManager.constructUrl((String)"file", (String)el)).collect(Collectors.toList());
        if (collection == null) {
            TypeScriptGeneratedFilesExcludePolicy.$$$reportNull$$$0(6);
        }
        return collection;
    }

    public static void enableForTests(@NotNull Disposable disposable) {
        if (disposable == null) {
            TypeScriptGeneratedFilesExcludePolicy.$$$reportNull$$$0(7);
        }
        ourEnableForTests = true;
        Disposer.register((Disposable)disposable, () -> {
            ourEnableForTests = false;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/settings/exclude/TypeScriptGeneratedFilesExcludePolicy";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allFiles";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/settings/exclude/TypeScriptGeneratedFilesExcludePolicy";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludeUrlsForProject";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "filterFilesToExclude";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "filterFilesToExclude";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "enableForTests";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 5, 6 -> new IllegalStateException(string);
        };
    }
}

