/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.hive.model;

import com.intellij.database.dialects.hive.model.HiveFunction;
import com.intellij.database.dialects.hive.model.HiveFunctionBase;
import com.intellij.database.dialects.hive.model.HiveIndex;
import com.intellij.database.dialects.hive.model.HiveMacro;
import com.intellij.database.dialects.hive.model.HiveMatView;
import com.intellij.database.dialects.hive.model.HiveTable;
import com.intellij.database.dialects.hivebase.model.HiveBaseDescriptionService;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DescriptionService;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicIndex;
import com.intellij.database.model.basic.BasicRoutine;
import com.intellij.database.model.basic.BasicView;
import com.intellij.database.model.properties.BasicReferenceInfo;
import com.intellij.database.view.structure.DvViewOptions;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\tH\u0002J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016\u00a8\u0006\u001e"}, d2={"Lcom/intellij/database/dialects/hive/model/HiveDescriptionService;", "Lcom/intellij/database/dialects/hivebase/model/HiveBaseDescriptionService;", "<init>", "()V", "content", "", "e", "Lcom/intellij/database/model/basic/BasicElement;", "context", "Lcom/intellij/database/model/DescriptionService$Context;", "describeTable", "Lcom/intellij/database/dialects/hive/model/HiveTable;", "describeIndex", "index", "Lcom/intellij/database/dialects/hive/model/HiveIndex;", "describeFunction", "f", "Lcom/intellij/database/dialects/hive/model/HiveFunctionBase;", "describeMatView", "Lcom/intellij/database/dialects/hive/model/HiveMatView;", "updatePresentation", "", "project", "Lcom/intellij/openapi/project/Project;", "o", "Lcom/intellij/database/model/DasObject;", "viewOptions", "Lcom/intellij/database/view/structure/DvViewOptions;", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "intellij.database.dialects.hive"})
@SourceDebugExtension(value={"SMAP\nHiveDescriptionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HiveDescriptionService.kt\ncom/intellij/database/dialects/hive/model/HiveDescriptionService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,74:1\n1#2:75\n*E\n"})
public final class HiveDescriptionService
extends HiveBaseDescriptionService {
    @Override
    @NotNull
    public String content(@NotNull BasicElement e, @NotNull DescriptionService.Context context) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BasicElement basicElement = e;
        return basicElement instanceof HiveMatView ? this.describeMatView((HiveMatView)e, context) : (basicElement instanceof HiveFunctionBase ? this.describeFunction((HiveFunctionBase)e, context) : (basicElement instanceof HiveIndex ? this.describeIndex((HiveIndex)e, context) : (basicElement instanceof HiveTable ? this.describeTable((HiveTable)e, context) : super.content(e, context))));
    }

    private final String describeTable(HiveTable e, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(HiveTable.EXTERNAL);
        ((Collection)context.getDescribed()).add(HiveTable.SKEWED_BY_COLUMNS);
        ((Collection)context.getDescribed()).add(HiveTable.SKEWED_BY_VALUES);
        ((Collection)context.getDescribed()).add(HiveTable.STORED_AS_DIRECTORIES);
        ((Collection)context.getDescribed()).add(HiveTable.LOCATION);
        Object res = null;
        res = "";
        if (e.isExternal()) {
            res = res + "external";
        }
        res = ((Object)StringsKt.trim((CharSequence)(res + " " + super.describeTable(e, context)))).toString();
        List<String> list = e.getSkewedByColumns();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getSkewedByColumns(...)");
        if (!((Collection)list).isEmpty()) {
            List<String> list2 = e.getSkewedByColumns();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getSkewedByColumns(...)");
            res = res + " skewed_by_columns: " + CollectionsKt.joinToString$default((Iterable)list2, null, null, null, (int)0, null, HiveDescriptionService::describeTable$lambda$0, (int)31, null);
        }
        String string = e.getSkewedByValues();
        if (string != null) {
            String it = string;
            boolean bl = false;
            res = res + " skewed_by_values: " + e.getSkewedByValues();
        }
        if (e.isStoredAsDirectories()) {
            res = res + " stored_as_directories";
        }
        return res;
    }

    private final String describeIndex(HiveIndex index, DescriptionService.Context context) {
        Object res;
        block1: {
            Object it;
            ((Collection)context.getDescribed()).add(HiveIndex.INDEX_TABLE_REF);
            ((Collection)context.getDescribed()).add(HiveIndex.TYPE);
            res = null;
            res = super.describeIndex((BasicIndex)index, context);
            BasicReferenceInfo<? extends HiveTable> basicReferenceInfo = index.getIndexTableRefInfo();
            if (basicReferenceInfo != null) {
                it = basicReferenceInfo;
                boolean bl = false;
                res = res + " table: " + it.getName();
            }
            String string = index.getType();
            if (string == null) break block1;
            it = string;
            boolean bl = false;
            res = res + " type: " + it;
        }
        return res;
    }

    private final String describeFunction(HiveFunctionBase f, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(HiveFunction.TEMPORARY);
        ((Collection)context.getDescribed()).add(HiveFunction.AUTO_CREATED);
        ((Collection)context.getDescribed()).add(HiveFunctionBase.CLASS_NAME);
        Object res = null;
        res = this.describeRoutine((BasicRoutine)f, context);
        HiveFunction hiveFunction = f instanceof HiveFunction ? (HiveFunction)f : null;
        if (hiveFunction != null) {
            HiveFunction hiveFunction2;
            HiveFunction $this$describeFunction_u24lambda_u240 = hiveFunction2 = hiveFunction;
            boolean bl = false;
            if ($this$describeFunction_u24lambda_u240.isTemporary()) {
                res = res + " temporary";
            }
            if ($this$describeFunction_u24lambda_u240.isAutoCreated()) {
                res = res + " autoCreated";
            }
        }
        if (f.getClassName() != null) {
            res = res + " class: " + f.getClassName();
        }
        return res;
    }

    private final String describeMatView(HiveMatView e, DescriptionService.Context context) {
        ((Collection)context.getDescribed()).add(HiveMatView.PROPERTIES);
        String desc = super.describeView((BasicView)e, context);
        return this.appendProperties(e, desc);
    }

    public void updatePresentation(@NotNull Project project, @NotNull DasObject o, @NotNull DvViewOptions viewOptions, @NotNull PresentationData presentation) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)o, (String)"o");
        Intrinsics.checkNotNullParameter((Object)viewOptions, (String)"viewOptions");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        DasObject dasObject = o;
        if (!(dasObject instanceof HiveFunctionBase) && !(dasObject instanceof HiveMacro)) {
            super.updatePresentation(project, o, viewOptions, presentation);
        }
    }

    private static final CharSequence describeTable$lambda$0(String it) {
        Intrinsics.checkNotNull((Object)it);
        return it;
    }
}

