/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui;

import com.intellij.icons.AllIcons;
import com.intellij.kubernetes.util.ContainerPhase;
import com.intellij.kubernetes.util.KubernetesPodStateKt;
import com.intellij.kubernetes.util.PodStatus;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesContainerObject;
import com.intellij.kubernetes.view.ui.KubernetesJLabelTableCellRenderer;
import com.intellij.ui.components.JBLabel;
import javax.swing.JTable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003JB\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/intellij/kubernetes/view/ui/KubernetesContainerStatusTableCellRenderer;", "Lcom/intellij/kubernetes/view/ui/KubernetesJLabelTableCellRenderer;", "<init>", "()V", "customize", "", "label", "Lcom/intellij/ui/components/JBLabel;", "table", "Ljavax/swing/JTable;", "value", "", "isSelected", "", "hasFocus", "row", "", "column", "intellij.clouds.kubernetes"})
public final class KubernetesContainerStatusTableCellRenderer
extends KubernetesJLabelTableCellRenderer {
    @Override
    public void customize(@NotNull JBLabel label, @NotNull JTable table, @Nullable Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        if ((value2 instanceof KubernetesContainerObject ? (KubernetesContainerObject)value2 : null) == null) {
            return;
        }
        ContainerPhase phase = KubernetesPodStateKt.detectContainerPhase(((KubernetesContainerObject)value2).getContainerStatus());
        PodStatus status = KubernetesPodStateKt.detectContainerStatus(((KubernetesContainerObject)value2).getContainerStatus());
        PodStatus podStatus = status;
        label.setText(phase.getLabel() + (String)((podStatus != null ? podStatus.getLabel() : null) != null ? " (" + status.getLabel() + ")" : ""));
        label.setHorizontalAlignment(2);
        if (phase == ContainerPhase.RUNNING) {
            label.setIcon(AllIcons.Debugger.ThreadRunning);
        }
        if (status != null) {
            label.setIcon(AllIcons.General.Warning);
        }
    }
}

