/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui;

import com.intellij.kubernetes.KubernetesIcons;
import com.intellij.kubernetes.api.Context;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesContainerObject;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesPodServiceViewContributorDescriptorKt;
import com.intellij.kubernetes.view.ui.LogContainerNodeLeafDescriptor;
import com.intellij.kubernetes.view.ui.LogGroupNodeDescriptor;
import com.intellij.kubernetes.view.ui.LogNodeDescriptor;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1Pod;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012&\u0010\u0004\u001a\"\u0012\u0004\u0012\u00020\u0006\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005j\u0002`\t0\u0005j\u0002`\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R4\u0010\u0004\u001a\"\u0012\u0004\u0012\u00020\u0006\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0005j\u0002`\t0\u0005j\u0002`\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00060\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001c\u00a8\u0006$"}, d2={"Lcom/intellij/kubernetes/view/ui/LogPodNodeDescriptor;", "Lcom/intellij/kubernetes/view/ui/LogGroupNodeDescriptor;", "pod", "Lio/kubernetes/client/openapi/models/V1Pod;", "registry", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerObject;", "Lcom/intellij/kubernetes/view/ui/LogContainerNodeLeafDescriptor;", "Lcom/intellij/ui/CheckedTreeNode;", "Lcom/intellij/kubernetes/view/ui/CheckedTreeNodeMap;", "Lcom/intellij/kubernetes/view/ui/ContainerNodeRegistry;", "context", "Lcom/intellij/kubernetes/api/Context;", "<init>", "(Lio/kubernetes/client/openapi/models/V1Pod;Ljava/util/concurrent/ConcurrentHashMap;Lcom/intellij/kubernetes/api/Context;)V", "getPod", "()Lio/kubernetes/client/openapi/models/V1Pod;", "getRegistry", "()Ljava/util/concurrent/ConcurrentHashMap;", "getContext", "()Lcom/intellij/kubernetes/api/Context;", "text", "", "getText", "()Ljava/lang/String;", "containers", "", "getContainers", "()Ljava/util/List;", "children", "Lcom/intellij/kubernetes/view/ui/LogNodeDescriptor;", "getChildren", "setTextPresentationForTextRenderer", "", "textRenderer", "Lcom/intellij/ui/ColoredTreeCellRenderer;", "intellij.clouds.kubernetes"})
@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nKubernetesLogSourcesTree.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesLogSourcesTree.kt\ncom/intellij/kubernetes/view/ui/LogPodNodeDescriptor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,455:1\n1563#2:456\n1634#2,3:457\n*S KotlinDebug\n*F\n+ 1 KubernetesLogSourcesTree.kt\ncom/intellij/kubernetes/view/ui/LogPodNodeDescriptor\n*L\n397#1:456\n397#1:457,3\n*E\n"})
public final class LogPodNodeDescriptor
extends LogGroupNodeDescriptor {
    @NotNull
    private final V1Pod pod;
    @NotNull
    private final ConcurrentHashMap<KubernetesContainerObject, ConcurrentHashMap<LogContainerNodeLeafDescriptor, CheckedTreeNode>> registry;
    @NotNull
    private final Context context;
    @NotNull
    private final List<KubernetesContainerObject> containers;
    @NotNull
    private final List<LogNodeDescriptor> children;

    /*
     * WARNING - void declaration
     */
    public LogPodNodeDescriptor(@NotNull V1Pod pod, @NotNull ConcurrentHashMap<KubernetesContainerObject, ConcurrentHashMap<LogContainerNodeLeafDescriptor, CheckedTreeNode>> registry, @NotNull Context context) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)pod, (String)"pod");
        Intrinsics.checkNotNullParameter(registry, (String)"registry");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        V1ObjectMeta v1ObjectMeta = pod.getMetadata();
        Intrinsics.checkNotNull((Object)v1ObjectMeta);
        String string = v1ObjectMeta.getName();
        Intrinsics.checkNotNull((Object)string);
        super(string, CollectionsKt.emptyList(), registry);
        this.pod = pod;
        this.registry = registry;
        this.context = context;
        this.containers = KubernetesPodServiceViewContributorDescriptorKt.getPodContainers(this.context, this.pod);
        Iterable iterable = this.containers;
        LogPodNodeDescriptor logPodNodeDescriptor = this;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KubernetesContainerObject kubernetesContainerObject = (KubernetesContainerObject)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new LogContainerNodeLeafDescriptor((KubernetesContainerObject)it, this.getRegistry()));
        }
        logPodNodeDescriptor.children = (List)destination$iv$iv;
    }

    @NotNull
    public final V1Pod getPod() {
        return this.pod;
    }

    @Override
    @NotNull
    public ConcurrentHashMap<KubernetesContainerObject, ConcurrentHashMap<LogContainerNodeLeafDescriptor, CheckedTreeNode>> getRegistry() {
        return this.registry;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @Override
    @NotNull
    public String getText() {
        V1ObjectMeta v1ObjectMeta = this.pod.getMetadata();
        Intrinsics.checkNotNull((Object)v1ObjectMeta);
        String string = v1ObjectMeta.getName();
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @NotNull
    public final List<KubernetesContainerObject> getContainers() {
        return this.containers;
    }

    @Override
    @NotNull
    public List<LogNodeDescriptor> getChildren() {
        return this.children;
    }

    @Override
    public void setTextPresentationForTextRenderer(@NotNull ColoredTreeCellRenderer textRenderer) {
        Intrinsics.checkNotNullParameter((Object)textRenderer, (String)"textRenderer");
        super.setTextPresentationForTextRenderer(textRenderer);
        textRenderer.setIcon(KubernetesIcons.Pod);
    }
}

