/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.inspections;

import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.javaee.constants.RestAnnotations;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.ws.rest.RSBundle;
import com.intellij.ws.rest.inspections.AbstractRestJavaInspection;
import com.intellij.ws.rest.model.jam.RSHttpMethod;
import com.intellij.ws.rest.model.jam.RSJamPsiMethodPath;
import com.intellij.ws.rest.model.jam.httpMethods.RSCustomHttpMethod;
import com.intellij.ws.rest.utils.RSUtils;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class RestResourceMethodInspection
extends AbstractRestJavaInspection {
    @Override
    protected void checkClass(PsiClass psiClass, ProblemsHolder holder, @NotNull Module module) {
        if (module == null) {
            RestResourceMethodInspection.$$$reportNull$$$0(0);
        }
        if (RSUtils.isResourceClass(psiClass) && !RestResourceMethodInspection.hasPublicResourceMethods(psiClass, module)) {
            PsiIdentifier identifier = psiClass.getNameIdentifier();
            holder.registerProblem((PsiElement)(identifier != null ? identifier : psiClass), RSBundle.message("resource.methods.inspection.class.has.no.public.methods", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
        super.checkClass(psiClass, holder, module);
    }

    private static boolean hasPublicResourceMethods(PsiClass psiClass, @NotNull Module module) {
        if (module == null) {
            RestResourceMethodInspection.$$$reportNull$$$0(1);
        }
        JamService jamService = JamService.getJamService((Project)module.getProject());
        List methods = jamService.getAnnotatedMembersList(psiClass, RSHttpMethod.RS_HTTP_METHOD_JAM_KEY, 10);
        for (RSHttpMethod method : methods) {
            if (!((PsiMethod)method.getPsiElement()).getModifierList().hasModifierProperty("public")) continue;
            return true;
        }
        for (RSJamPsiMethodPath path : jamService.getAnnotatedMembersList(psiClass, 10, new JamMemberMeta[]{RSJamPsiMethodPath.META})) {
            if (!((PsiMethod)path.getPsiElement()).getModifierList().hasModifierProperty("public")) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void checkMethod(@NotNull PsiMethod method, @NotNull ProblemsHolder holder, @NotNull Module module) {
        PsiClass c;
        if (method == null) {
            RestResourceMethodInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            RestResourceMethodInspection.$$$reportNull$$$0(3);
        }
        if (module == null) {
            RestResourceMethodInspection.$$$reportNull$$$0(4);
        }
        if ((c = method.getContainingClass()) == null) {
            return;
        }
        PsiIdentifier methodNameIdentifier = method.getNameIdentifier();
        if (!method.getModifierList().hasModifierProperty("public") && methodNameIdentifier != null) {
            String qualifiedName;
            ArrayList<String> annotations = new ArrayList<String>(RestAnnotations.HTTP_ANNOTATIONS);
            annotations.add(RestAnnotations.PATH.javax());
            annotations.add(RestAnnotations.PATH.jakarta());
            annotations.addAll(RSCustomHttpMethod.getMetaAnnotations(module));
            PsiClass annotationClass = MetaAnnotationUtil.findAnnotationsByMeta((PsiModifierListOwner)method, annotations).findFirst().orElse(null);
            if (annotationClass != null && (qualifiedName = annotationClass.getQualifiedName()) != null) {
                String shortName = "@" + StringUtil.getShortName((String)qualifiedName);
                holder.registerProblem((PsiElement)methodNameIdentifier, RSBundle.message("resource.methods.inspection.method.must.be.public", shortName), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ws/rest/inspections/RestResourceMethodInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "hasPublicResourceMethods";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMethod";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

