/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.model.audit;

import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.AnnotationDescriptor;
import com.intellij.jpa.jpb.model.backend.ed.annotation.attr.HibernateEnversAnnotation;
import com.intellij.jpa.jpb.model.model.AttributeOverride;
import com.intellij.jpa.jpb.model.model.Datatypes;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.model.EntityAttributeModel;
import com.intellij.jpa.jpb.model.model.EntityAttributePsi;
import com.intellij.jpa.jpb.model.model.EntityModel;
import com.intellij.jpa.jpb.model.model.EntityPsi;
import com.intellij.jpa.jpb.model.model.audit.AuditEntityAttribute;
import com.intellij.jpa.jpb.model.model.audit.EnversProperties;
import com.intellij.jpa.jpb.model.model.audit.RevAttribute;
import com.intellij.jpa.jpb.model.model.audit.RevTypeAttribute;
import com.intellij.jpa.jpb.model.service.EnversService;
import com.intellij.jpa.jpb.model.util.JpaUtils;
import com.intellij.jpa.jpb.model.util.SUastUtils;
import com.intellij.jpa.jpb.model.util.StudioAnnotationUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000 82\u00020\u0001:\u000289B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0016J\b\u0010\u0013\u001a\u00020\u0010H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0017H\u0016J\b\u0010\u0019\u001a\u00020\u0017H\u0016J\n\u0010\u001a\u001a\u0004\u0018\u00010\u0010H\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u0010H\u0016J\n\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\u0010H\u0016J\n\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00100\"H\u0016J\n\u0010#\u001a\u0004\u0018\u00010$H\u0016J\n\u0010%\u001a\u0004\u0018\u00010\u0000H\u0016J\n\u0010&\u001a\u0004\u0018\u00010\u0010H\u0016J\n\u0010'\u001a\u0004\u0018\u00010\u0010H\u0016J\n\u0010(\u001a\u0004\u0018\u00010\u0010H\u0016J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020$0\"H\u0016J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020$0\"H\u0016J\u0018\u0010+\u001a\u0012\u0012\u0004\u0012\u00020-0,j\b\u0012\u0004\u0012\u00020-`.H\u0016J\u001e\u0010/\u001a\u0002002\f\u00101\u001a\b\u0012\u0004\u0012\u00020$022\u0006\u00103\u001a\u00020$H\u0002J\u0017\u00104\u001a\u0004\u0018\u00010\u00172\u0006\u00105\u001a\u000206H\u0002\u00a2\u0006\u0002\u00107R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0019\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/intellij/jpa/jpb/model/model/audit/AuditEntity;", "Lcom/intellij/jpa/jpb/model/model/EntityModel;", "auditedEntity", "Lcom/intellij/jpa/jpb/model/model/EntityPsi;", "<init>", "(Lcom/intellij/jpa/jpb/model/model/EntityPsi;)V", "getAuditedEntity", "()Lcom/intellij/jpa/jpb/model/model/EntityPsi;", "project", "Lcom/intellij/openapi/project/Project;", "Lorg/jetbrains/annotations/NotNull;", "getProject", "()Lcom/intellij/openapi/project/Project;", "enversService", "Lcom/intellij/jpa/jpb/model/service/EnversService;", "getPackageName", "", "getClassName", "getFqn", "getLabel", "getModule", "Lcom/intellij/openapi/module/Module;", "isEmbeddable", "", "isMappedSuperclass", "isPersistentEntity", "getParentFqn", "getName", "getInheritanceType", "Lcom/intellij/jpa/jpb/model/model/Entity$InheritanceType;", "getDiscriminatorColumnName", "getDiscriminatorType", "Lcom/intellij/jpa/jpb/model/model/Entity$DiscriminatorType;", "getPrimaryKeyJoinColumnNames", "", "getIdAttributeOrNull", "Lcom/intellij/jpa/jpb/model/model/EntityAttribute;", "getParent", "getTable", "getCatalog", "getSchema", "getAttributes", "getInheritedAttributes", "getAttributeOverrides", "Ljava/util/LinkedHashSet;", "Lcom/intellij/jpa/jpb/model/model/AttributeOverride;", "Lkotlin/collections/LinkedHashSet;", "addAuditAttributesForEntityAttribute", "", "auditAttributes", "", "attribute", "getWithModifiedFlag", "owner", "Lcom/intellij/psi/PsiModifierListOwner;", "(Lcom/intellij/psi/PsiModifierListOwner;)Ljava/lang/Boolean;", "Companion", "ModAttribute", "intellij.javaee.jpa.jpb.model"})
@SourceDebugExtension(value={"SMAP\nAuditEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuditEntity.kt\ncom/intellij/jpa/jpb/model/model/audit/AuditEntity\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,192:1\n1#2:193\n295#3,2:194\n2746#3,3:196\n1761#3,3:199\n*S KotlinDebug\n*F\n+ 1 AuditEntity.kt\ncom/intellij/jpa/jpb/model/model/audit/AuditEntity\n*L\n79#1:194,2\n109#1:196,3\n109#1:199,3\n*E\n"})
public class AuditEntity
extends EntityModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EntityPsi auditedEntity;
    @NotNull
    private final Project project;
    @NotNull
    private final EnversService enversService;

    protected AuditEntity(@NotNull EntityPsi auditedEntity) {
        Intrinsics.checkNotNullParameter((Object)auditedEntity, (String)"auditedEntity");
        this.auditedEntity = auditedEntity;
        Project project = this.auditedEntity.getPsiClass().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.project = project;
        this.enversService = EnversService.Companion.getInstance(this.project);
        EntityPsi entityPsi = this.auditedEntity.getParent();
        boolean bl = entityPsi != null ? entityPsi.isPersistentEntity() : false;
        if (bl && this.getParent() == null) {
            throw new IllegalStateException("Parent entity must be audited too");
        }
    }

    @NotNull
    public final EntityPsi getAuditedEntity() {
        return this.auditedEntity;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public String getPackageName() {
        String string = this.auditedEntity.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPackageName(...)");
        return string;
    }

    @Override
    @NotNull
    public String getClassName() {
        return this.auditedEntity.getClassName() + "Audit";
    }

    @Override
    @NotNull
    public String getFqn() {
        return this.auditedEntity.getFqn() + "Audit";
    }

    @Override
    @NotNull
    public String getLabel() {
        String string = this.className;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"className");
        return string;
    }

    @Override
    @NotNull
    public Module getModule() {
        Module module = this.auditedEntity.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"getModule(...)");
        return module;
    }

    @Override
    public boolean isEmbeddable() {
        return this.auditedEntity.isEmbeddable();
    }

    @Override
    public boolean isMappedSuperclass() {
        return this.auditedEntity.isMappedSuperclass();
    }

    @Override
    public boolean isPersistentEntity() {
        return this.auditedEntity.isPersistentEntity();
    }

    @Override
    @Nullable
    public String getParentFqn() {
        Entity entity = this.parent;
        return entity != null ? entity.getFqn() : null;
    }

    @Override
    @Nullable
    public String getName() {
        String string;
        String string2 = this.auditedEntity.getName();
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            string = it + "Audit";
        } else {
            string = null;
        }
        return string;
    }

    @Override
    @Nullable
    public Entity.InheritanceType getInheritanceType() {
        return this.auditedEntity.getInheritanceType();
    }

    @Override
    @Nullable
    public String getDiscriminatorColumnName() {
        return this.auditedEntity.getDiscriminatorColumnName();
    }

    @Override
    @Nullable
    public Entity.DiscriminatorType getDiscriminatorType() {
        return this.auditedEntity.getDiscriminatorType();
    }

    @Override
    @NotNull
    public List<String> getPrimaryKeyJoinColumnNames() {
        List list;
        List auditedColumnNames = this.auditedEntity.getPrimaryKeyJoinColumnNames();
        if (auditedColumnNames.isEmpty()) {
            List list2 = auditedColumnNames;
            Intrinsics.checkNotNull(list2);
            list = list2;
        } else {
            Intrinsics.checkNotNull(auditedColumnNames);
            list = CollectionsKt.plus((Collection)auditedColumnNames, (Object)this.enversService.getActualEnversProperties().getRevisionFieldName());
        }
        return list;
    }

    @Override
    @Nullable
    public EntityAttribute getIdAttributeOrNull() {
        Object v1;
        block1: {
            List<EntityAttribute> list = super.getIdAttributes();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getIdAttributes(...)");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                EntityAttribute it = (EntityAttribute)element$iv;
                boolean bl = false;
                if (!(!(it instanceof RevAttribute))) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    @Override
    @Nullable
    public AuditEntity getParent() {
        AuditEntity auditEntity;
        EntityPsi entityPsi = this.auditedEntity.getParent();
        if (entityPsi != null) {
            EntityPsi it = entityPsi;
            boolean bl = false;
            auditEntity = Companion.getInstance(it);
        } else {
            auditEntity = null;
        }
        return auditEntity;
    }

    @Override
    @Nullable
    public String getTable() {
        EnversProperties enversProperties = this.enversService.getActualEnversProperties();
        Object object = StudioAnnotationUtil.getDeclaredStringAttributeValue((PsiModifierListOwner)this.auditedEntity.getPsiClass(), HibernateEnversAnnotation.AuditTable, "value");
        if (object == null) {
            String string = this.auditedEntity.getTable();
            if (string != null) {
                String it = string;
                boolean bl = false;
                object = enversProperties.getAuditTablePrefix() + it + enversProperties.getAuditTableSuffix();
            } else {
                object = null;
            }
        }
        return object;
    }

    @Override
    @Nullable
    public String getCatalog() {
        String string = StudioAnnotationUtil.getDeclaredStringAttributeValue((PsiModifierListOwner)this.auditedEntity.getPsiClass(), HibernateEnversAnnotation.AuditTable, "catalog");
        if (string == null && (string = this.enversService.getActualEnversProperties().getDefaultCatalog()) == null) {
            string = this.auditedEntity.getCatalog();
        }
        return string;
    }

    @Override
    @Nullable
    public String getSchema() {
        String string = StudioAnnotationUtil.getDeclaredStringAttributeValue((PsiModifierListOwner)this.auditedEntity.getPsiClass(), HibernateEnversAnnotation.AuditTable, "schema");
        if (string == null && (string = this.enversService.getActualEnversProperties().getDefaultSchema()) == null) {
            string = this.auditedEntity.getSchema();
        }
        return string;
    }

    @Override
    @NotNull
    public List<EntityAttribute> getAttributes() {
        Object object = CachedValuesManager.getCachedValue((PsiElement)((PsiElement)this.auditedEntity.getPsiClass()), () -> AuditEntity.getAttributes$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (List)object;
    }

    @Override
    @NotNull
    public List<EntityAttribute> getInheritedAttributes() {
        Object object;
        List parentAttributes;
        AuditEntity auditEntity = this.getParent();
        if (auditEntity == null) {
            return CollectionsKt.emptyList();
        }
        AuditEntity parent = auditEntity;
        List list = (List)RecursionManager.doPreventingRecursion((Object)this, (boolean)false, () -> AuditEntity.getInheritedAttributes$lambda$0(parent));
        List list2 = parentAttributes = list != null && (object = CollectionsKt.toMutableList((Collection)list)) != null ? object : (List)new ArrayList();
        if (parent.isPersistentEntity()) {
            return parentAttributes;
        }
        List<PsiAnnotation> auditOverridesAnnotations = StudioAnnotationUtil.findAllJpbAnnotationsWithContainer((PsiModifierListOwner)this.auditedEntity.getPsiClass(), HibernateEnversAnnotation.AuditOverrides, HibernateEnversAnnotation.AuditOverride);
        for (PsiAnnotation auditOverridesAnnotation : auditOverridesAnnotations) {
            String parentClassFqn;
            String fieldName = StudioAnnotationUtil.getStringAttributeValue(auditOverridesAnnotation, "name", "");
            if (StudioAnnotationUtil.getDeclaredReferenceFqnStringValue(auditOverridesAnnotation, "forClass") == null) continue;
            String[] stringArray = new String[]{"isAudited"};
            if (!Intrinsics.areEqual((Object)StudioAnnotationUtil.getDeclaredBooleanAttributeValue(auditOverridesAnnotation, stringArray), (Object)false)) {
                for (EntityAttribute attr : parent.auditedEntity.getAllAttributes()) {
                    PsiElement psiElement;
                    Intrinsics.checkNotNull((Object)fieldName);
                    if (!(((CharSequence)fieldName).length() == 0) && !Intrinsics.areEqual((Object)attr.getName(), (Object)fieldName) || !Intrinsics.areEqual((Object)((psiElement = attr.getPsiElement()) != null && (psiElement = SUastUtils.getContainingClass(psiElement)) != null ? psiElement.getQualifiedName() : null), (Object)parentClassFqn)) continue;
                    Intrinsics.checkNotNull((Object)attr);
                    this.addAuditAttributesForEntityAttribute(parentAttributes, attr);
                }
                continue;
            }
            parentAttributes.removeIf(arg_0 -> AuditEntity.getInheritedAttributes$lambda$2(arg_0 -> AuditEntity.getInheritedAttributes$lambda$1(fieldName, parentClassFqn, arg_0), arg_0));
        }
        return parentAttributes;
    }

    @Override
    @NotNull
    public LinkedHashSet<AttributeOverride> getAttributeOverrides() {
        LinkedHashSet<AttributeOverride> linkedHashSet = this.auditedEntity.getAttributeOverrides();
        Intrinsics.checkNotNullExpressionValue(linkedHashSet, (String)"getAttributeOverrides(...)");
        return linkedHashSet;
    }

    private final void addAuditAttributesForEntityAttribute(List<EntityAttribute> auditAttributes, EntityAttribute attribute) {
        block5: {
            EntityAttributePsi attributePsi;
            block6: {
                EntityAttributePsi entityAttributePsi = attribute instanceof EntityAttributePsi ? (EntityAttributePsi)attribute : null;
                if (entityAttributePsi == null) {
                    return;
                }
                attributePsi = entityAttributePsi;
                auditAttributes.add(AuditEntityAttribute.Companion.getInstance(attributePsi));
                if (attributePsi.isId()) break block5;
                if (this.enversService.getActualEnversProperties().getGlobalWithModifiedFlag()) break block6;
                PsiMember psiMember = attributePsi.getMember();
                Intrinsics.checkNotNullExpressionValue((Object)psiMember, (String)"getMember(...)");
                Boolean bl = this.getWithModifiedFlag((PsiModifierListOwner)psiMember);
                if (bl == null) {
                    PsiClass psiClass = this.auditedEntity.getPsiClass();
                    Intrinsics.checkNotNullExpressionValue((Object)psiClass, (String)"getPsiClass(...)");
                    bl = this.getWithModifiedFlag((PsiModifierListOwner)psiClass);
                }
                if (!Intrinsics.areEqual((Object)bl, (Object)true)) break block5;
            }
            auditAttributes.add(new ModAttribute(this, attributePsi));
        }
    }

    private final Boolean getWithModifiedFlag(PsiModifierListOwner owner) {
        AnnotationDescriptor[] annotationDescriptorArray = new AnnotationDescriptor[]{HibernateEnversAnnotation.Audited};
        PsiAnnotation psiAnnotation = StudioAnnotationUtil.findJpbAnnotation(owner, annotationDescriptorArray);
        if (psiAnnotation == null) {
            return null;
        }
        PsiAnnotation annotationPsi = psiAnnotation;
        String[] stringArray = new String[]{"withModifiedFlag"};
        return StudioAnnotationUtil.getDeclaredBooleanAttributeValue(annotationPsi, stringArray);
    }

    private static final CachedValueProvider.Result getAttributes$lambda$0(AuditEntity this$0) {
        List result;
        block15: {
            boolean bl;
            block13: {
                EntityAttribute it;
                block14: {
                    boolean bl2;
                    block12: {
                        AuditEntity parent;
                        result = new ArrayList();
                        EntityPsi entityPsi = this$0.auditedEntity.getParent();
                        if (entityPsi != null) {
                            EntityPsi it2 = entityPsi;
                            boolean bl3 = false;
                            v1 = Companion.getInstance(it2);
                        } else {
                            v1 = parent = null;
                        }
                        if (parent == null) break block14;
                        List list = parent.attributes;
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"attributes");
                        Iterable $this$none$iv = list;
                        boolean $i$f$none = false;
                        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                            bl2 = true;
                        } else {
                            for (Object element$iv : $this$none$iv) {
                                it = (EntityAttribute)element$iv;
                                boolean bl4 = false;
                                if (!it.isId()) continue;
                                bl2 = false;
                                break block12;
                            }
                            bl2 = true;
                        }
                    }
                    if (!bl2) break block15;
                }
                List<EntityAttribute> list = this$0.auditedEntity.getAttributes();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getAttributes(...)");
                Iterable $this$any$iv = list;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        it = (EntityAttribute)element$iv;
                        boolean bl5 = false;
                        if (!it.isId()) continue;
                        bl = true;
                        break block13;
                    }
                    bl = false;
                }
            }
            if (bl) {
                result.add(new RevAttribute(this$0.project));
                result.add(new RevTypeAttribute(this$0.project, false, 2, null));
            }
        }
        for (EntityAttribute attribute : this$0.auditedEntity.getAttributes()) {
            if (!attribute.isId() && !attribute.isHibernateEnversAudited() && (!this$0.auditedEntity.isAudited() || attribute.isHibernateEnversNotAudited()) || attribute.isVersion() && !this$0.enversService.getActualEnversProperties().isAuditVersion()) continue;
            Intrinsics.checkNotNull((Object)attribute);
            this$0.addAuditAttributesForEntityAttribute(result, attribute);
        }
        Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
        return CachedValueProvider.Result.create((Object)result, (Object[])objectArray);
    }

    private static final List getInheritedAttributes$lambda$0(AuditEntity $parent) {
        return CollectionsKt.plus((Collection)$parent.getAttributes(), (Iterable)$parent.getInheritedAttributes());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getInheritedAttributes$lambda$1(String $fieldName, String $parentClassFqn, EntityAttribute it) {
        PsiElement psiElement;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!Intrinsics.areEqual((Object)it.getName(), (Object)$fieldName)) {
            Intrinsics.checkNotNull((Object)$fieldName);
            if (((CharSequence)$fieldName).length() != 0) return false;
            boolean bl = true;
            if (!bl) return false;
        }
        if (!Intrinsics.areEqual((Object)((psiElement = it.getPsiElement()) != null && (psiElement = SUastUtils.getContainingClass(psiElement)) != null ? psiElement.getQualifiedName() : null), (Object)$parentClassFqn)) return false;
        return true;
    }

    private static final boolean getInheritedAttributes$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ EnversService access$getEnversService$p(AuditEntity $this) {
        return $this.enversService;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\n"}, d2={"Lcom/intellij/jpa/jpb/model/model/audit/AuditEntity$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/jpa/jpb/model/model/audit/AuditEntity;", "auditedEntity", "Lcom/intellij/jpa/jpb/model/model/EntityPsi;", "isNeedAuditTable", "", "intellij.javaee.jpa.jpb.model"})
    @SourceDebugExtension(value={"SMAP\nAuditEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuditEntity.kt\ncom/intellij/jpa/jpb/model/model/audit/AuditEntity$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,192:1\n1761#2,3:193\n*S KotlinDebug\n*F\n+ 1 AuditEntity.kt\ncom/intellij/jpa/jpb/model/model/audit/AuditEntity$Companion\n*L\n42#1:193,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final AuditEntity getInstance(@NotNull EntityPsi auditedEntity) {
            Intrinsics.checkNotNullParameter((Object)auditedEntity, (String)"auditedEntity");
            return (AuditEntity)CachedValuesManager.getCachedValue((PsiElement)((PsiElement)auditedEntity.getPsiClass()), () -> Companion.getInstance$lambda$0(auditedEntity));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isNeedAuditTable(EntityPsi auditedEntity) {
            EntityAttribute it;
            if (auditedEntity.isAudited()) return true;
            List<EntityAttribute> list = auditedEntity.getAttributes();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getAttributes(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                it = (EntityAttribute)element$iv;
                boolean bl = false;
            } while (!it.isHibernateEnversAudited());
            return true;
        }

        private static final CachedValueProvider.Result getInstance$lambda$0(EntityPsi $auditedEntity) {
            AuditEntity auditEntity = !JpaUtils.isHibernateEnversProject($auditedEntity.getPsiClass().getProject(), null) ? null : ($auditedEntity.isMappedSuperclass() || Companion.isNeedAuditTable($auditedEntity) ? new AuditEntity($auditedEntity) : null);
            Object[] objectArray = new Object[]{$auditedEntity.getPsiClass().getNavigationElement()};
            return CachedValueProvider.Result.create((Object)auditEntity, (Object[])objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Exception performing whole class analysis.
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0096\u0002J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/jpa/jpb/model/model/audit/AuditEntity$ModAttribute;", "Lcom/intellij/jpa/jpb/model/model/EntityAttributeModel;", "auditedAttribute", "Lcom/intellij/jpa/jpb/model/model/EntityAttributePsi;", "<init>", "(Lcom/intellij/jpa/jpb/model/model/audit/AuditEntity;Lcom/intellij/jpa/jpb/model/model/EntityAttributePsi;)V", "equals", "", "other", "", "hashCode", "", "intellij.javaee.jpa.jpb.model"})
    @SourceDebugExtension(value={"SMAP\nAuditEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AuditEntity.kt\ncom/intellij/jpa/jpb/model/model/audit/AuditEntity$ModAttribute\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,192:1\n1#2:193\n*E\n"})
    private final class ModAttribute
    extends EntityAttributeModel {
        final /* synthetic */ AuditEntity this$0;

        /*
         * Unable to fully structure code
         */
        public ModAttribute(@NotNull AuditEntity this$0, EntityAttributePsi auditedAttribute) {
            Intrinsics.checkNotNullParameter((Object)auditedAttribute, (String)"auditedAttribute");
            this.this$0 = this$0;
            super();
            v0 = this;
            var3_3 = StudioAnnotationUtil.getDeclaredStringAttributeValue((PsiModifierListOwner)auditedAttribute.getMember(), HibernateEnversAnnotation.Audited, "modifiedColumnName");
            if (var3_3 == null) ** GOTO lbl-1000
            var6_5 = var5_4 = var3_3;
            var8_6 = v0;
            $i$a$-takeIf-AuditEntity$ModAttribute$1 = false;
            var9_8 = ((CharSequence)it).length() > 0;
            v0 = var8_6;
            v1 = var4_9 = var9_8 != false ? var5_4 : null;
            if (var4_9 != null) {
                v2 = var4_9;
            } else lbl-1000:
            // 2 sources

            {
                it = auditedAttribute;
                var8_6 = v0;
                $i$a$-let-AuditEntity$ModAttribute$2 = false;
                v3 = it.getColumn();
                if (v3 == null) {
                    v3 = it.getName();
                }
                v0 = var8_6;
                v2 = v3 + AuditEntity.access$getEnversService$p(this.this$0).getActualEnversProperties().getModifiedFlagSuffix();
            }
            v0.setColumn((String)v2);
            this.name = this.getColumn();
            this.setMappingType(EntityAttribute.MappingType.DATATYPE);
            this.type = Datatypes.BasicDatatype.Boolean;
        }

        @Override
        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ModAttribute)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.name, (Object)((ModAttribute)other).name) && Intrinsics.areEqual((Object)this.type, (Object)((ModAttribute)other).type);
        }

        @Override
        public int hashCode() {
            return this.name.hashCode() + 31 * this.type.hashCode();
        }
    }
}

