/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.ui.validation;

import com.intellij.jpa.jpb.model.ui.validation.AbstractValueModelValidator;
import com.intellij.openapi.util.NlsContexts;
import javax.swing.JComponent;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class IntegerValidator
extends AbstractValueModelValidator<Object> {
    public IntegerValidator(@NlsContexts.DialogMessage String errorMessage, JComponent component) {
        super(errorMessage, component);
    }

    @Nullable
    protected Integer getIntegerValue(Object value) {
        if (value instanceof String) {
            String stringValue = (String)value;
            if (StringUtils.isBlank((CharSequence)stringValue)) {
                return null;
            }
            try {
                return Integer.valueOf(stringValue);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return value instanceof Integer ? (Integer)value : null;
    }

    @Override
    protected boolean isValidValue(Object value) {
        return this.getIntegerValue(value) != null;
    }

    @Override
    public Class<Object> getType() {
        return Object.class;
    }
}

